/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.apache.commons.vfs2.provider.ftp.JBFtpKeepAliveCommand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedOptionsForm {
    private JCheckBox myShowHiddenFilesCheckBox;
    private JPanel myContentPane;
    private JCheckBox myPassiveModeCheckBox;
    private JCheckBox myMaxConnectionsCheckBox;
    private JTextField myMaxConnectionsTextField;
    private JComboBox<String> myTimestampsCombo;
    private JLabel myTimestampsLabel;
    private JCheckBox myCompatibilityModeCheckBox;
    private JComboBox<AdvancedOptionsConfig.DataChannelProtectionLevel> myDataProtectionLevelComboBox;
    private JTextField myControlEncodingTextField;
    private JBCheckBox myMuteSftpMessagesCheckBox;
    private JBCheckBox myForceListCommandCheckBox;
    private JCheckBox myKeepAliveCheckbox;
    private JTextField myKeepAliveTimeoutField;
    private JComboBox<JBFtpKeepAliveCommand> myKeepAliveFtpCommandComboBox;
    private JBCheckBox myShareSslContextCheckbox;
    private JRadioButton myExplicitFTPSRadioButton;
    private JRadioButton myImplicitFTPSRadioButton;
    private JPanel myFtpPanel;
    private JPanel myFtpsPanel;
    private JPanel myKeepAliveFtpPanel;
    private int defaultKeepAliveTimeout;

    public AdvancedOptionsForm() {
        this.$$$setupUI$$$();
        ArrayList<String> timestampsComboValues = new ArrayList<String>();
        for (AdvancedOptionsConfig.AccurateTimestamps v : AdvancedOptionsConfig.AccurateTimestamps.values()) {
            timestampsComboValues.add(WDBundle.message("accurate.timestamps.option." + (Object)((Object)v), new Object[0]));
        }
        this.myTimestampsCombo.setModel(new DefaultComboBoxModel<String>(ArrayUtilRt.toStringArray(timestampsComboValues)));
        this.myDataProtectionLevelComboBox.setModel((ComboBoxModel<AdvancedOptionsConfig.DataChannelProtectionLevel>)new EnumComboBoxModel(AdvancedOptionsConfig.DataChannelProtectionLevel.class));
        this.myDataProtectionLevelComboBox.setRenderer((ListCellRenderer<AdvancedOptionsConfig.DataChannelProtectionLevel>)SimpleListCellRenderer.create((String)"", AdvancedOptionsConfig.DataChannelProtectionLevel::getPresentableValue));
        this.myKeepAliveFtpCommandComboBox.setModel((ComboBoxModel<JBFtpKeepAliveCommand>)new EnumComboBoxModel(JBFtpKeepAliveCommand.class));
        this.myKeepAliveFtpCommandComboBox.setRenderer((ListCellRenderer<JBFtpKeepAliveCommand>)SimpleListCellRenderer.create((String)"", JBFtpKeepAliveCommand::getCommand));
        this.myMaxConnectionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AdvancedOptionsForm.this.myMaxConnectionsCheckBox.isSelected()) {
                    AdvancedOptionsForm.this.myMaxConnectionsTextField.setEnabled(true);
                    IdeFocusManager.findInstanceByComponent((Component)AdvancedOptionsForm.this.myContentPane).requestFocus((Component)AdvancedOptionsForm.this.myMaxConnectionsTextField, false);
                } else {
                    AdvancedOptionsForm.this.myMaxConnectionsTextField.setText("");
                    AdvancedOptionsForm.this.myMaxConnectionsTextField.setEnabled(false);
                }
            }
        });
        this.myKeepAliveCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AdvancedOptionsForm.this.myKeepAliveCheckbox.isSelected()) {
                    AdvancedOptionsForm.this.myKeepAliveTimeoutField.setEnabled(true);
                    int timeout = AdvancedOptionsForm.this.defaultKeepAliveTimeout > 0 ? AdvancedOptionsForm.this.defaultKeepAliveTimeout : 300000;
                    AdvancedOptionsForm.this.myKeepAliveTimeoutField.setText(String.valueOf(timeout / 1000));
                    IdeFocusManager.findInstanceByComponent((Component)AdvancedOptionsForm.this.myContentPane).requestFocus((Component)AdvancedOptionsForm.this.myKeepAliveTimeoutField, false);
                } else {
                    AdvancedOptionsForm.this.myKeepAliveTimeoutField.setText("");
                    AdvancedOptionsForm.this.myKeepAliveTimeoutField.setEnabled(false);
                }
            }
        });
        ButtonGroup sftpButtonGroup = new ButtonGroup();
        sftpButtonGroup.add(this.myExplicitFTPSRadioButton);
        sftpButtonGroup.add(this.myImplicitFTPSRadioButton);
    }

    public void reset(@NotNull SettingsDeployable deployable) {
        if (deployable == null) {
            AdvancedOptionsForm.$$$reportNull$$$0(0);
        }
        this.updateOnAccessTypeChange(deployable.getAccessType());
        if (deployable.isFtpsExplicit()) {
            this.myExplicitFTPSRadioButton.setSelected(true);
        } else {
            this.myImplicitFTPSRadioButton.setSelected(true);
        }
        AdvancedOptionsConfig config = deployable.getAdvancedOptions();
        this.myShowHiddenFilesCheckBox.setSelected(config.isShowHiddenFiles());
        this.myPassiveModeCheckBox.setSelected(config.isPassiveMode());
        this.myTimestampsCombo.setSelectedIndex(config.getAccurateTimestamps().ordinal());
        if (config.getMaxConnections() != Integer.MAX_VALUE) {
            this.myMaxConnectionsCheckBox.setSelected(true);
            this.myMaxConnectionsTextField.setText(String.valueOf(config.getMaxConnections()));
            this.myMaxConnectionsTextField.setEnabled(true);
        } else {
            this.myMaxConnectionsCheckBox.setSelected(false);
            this.myMaxConnectionsTextField.setText("");
            this.myMaxConnectionsTextField.setEnabled(false);
        }
        this.myCompatibilityModeCheckBox.setSelected(config.isCompatibilityMode());
        this.myDataProtectionLevelComboBox.setSelectedIndex(config.getDataChannelProtectionLevel().ordinal());
        this.myControlEncodingTextField.setText(config.getControlEncoding());
        this.myMuteSftpMessagesCheckBox.setSelected(config.isMuteSftpMessages());
        this.myForceListCommandCheckBox.setSelected(config.isForceListCommand());
        int keepAliveTimeout = config.getKeepAliveTimeout();
        boolean keepAliveEnabled = keepAliveTimeout > 0;
        this.myKeepAliveCheckbox.setSelected(keepAliveEnabled);
        this.myKeepAliveTimeoutField.setEnabled(keepAliveEnabled);
        this.myKeepAliveTimeoutField.setText(keepAliveEnabled ? String.valueOf(keepAliveTimeout / 1000) : "");
        this.defaultKeepAliveTimeout = keepAliveTimeout;
        this.myKeepAliveFtpCommandComboBox.setSelectedItem(config.getKeepAliveFtpCommand());
        this.myShareSslContextCheckbox.setSelected(config.isShareSslContext());
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public void apply(@NotNull SettingsDeployable deployable) {
        if (deployable == null) {
            AdvancedOptionsForm.$$$reportNull$$$0(1);
        }
        deployable.setFtpsExplicit(this.myExplicitFTPSRadioButton.isSelected());
        AdvancedOptionsConfig config = deployable.getAdvancedOptions();
        config.setShowHiddenFiles(this.myShowHiddenFilesCheckBox.isSelected());
        config.setPassiveMode(this.myPassiveModeCheckBox.isSelected());
        config.setAccurateTimestamps(AdvancedOptionsConfig.AccurateTimestamps.values()[this.myTimestampsCombo.getSelectedIndex()]);
        String s = this.myMaxConnectionsTextField.getText();
        config.setMaxConnections(StringUtil.isEmpty((String)s) ? Integer.MAX_VALUE : AdvancedOptionsForm.parseInt(s, Integer.MAX_VALUE));
        config.setCompatibilityMode(this.myCompatibilityModeCheckBox.isSelected());
        config.setDataChannelProtectionLevel((AdvancedOptionsConfig.DataChannelProtectionLevel)((Object)this.myDataProtectionLevelComboBox.getSelectedItem()));
        config.setControlEncoding(this.myControlEncodingTextField.getText());
        config.setMuteSftpMessages(this.myMuteSftpMessagesCheckBox.isSelected());
        config.setForceListCommand(this.myForceListCommandCheckBox.isSelected());
        String timeout = this.myKeepAliveTimeoutField.getText();
        config.setKeepAliveTimeout(this.myKeepAliveCheckbox.isSelected() ? AdvancedOptionsForm.parseInt(timeout, 0) * 1000 : 0);
        config.setKeepAliveFtpCommand((JBFtpKeepAliveCommand)this.myKeepAliveFtpCommandComboBox.getSelectedItem());
        config.setShareSslContext(this.myShareSslContextCheckbox.isSelected());
    }

    public boolean isModified(@NotNull SettingsDeployable deployable) {
        int uiTimeout;
        int maxConnectionsValue;
        if (deployable == null) {
            AdvancedOptionsForm.$$$reportNull$$$0(2);
        }
        AdvancedOptionsConfig config = deployable.getAdvancedOptions();
        if (deployable.isFtpsExplicit() != this.myExplicitFTPSRadioButton.isSelected()) {
            return true;
        }
        if (config.isShowHiddenFiles() != this.myShowHiddenFilesCheckBox.isSelected()) {
            return true;
        }
        if (config.isPassiveMode() != this.myPassiveModeCheckBox.isSelected()) {
            return true;
        }
        if (config.getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.values()[this.myTimestampsCombo.getSelectedIndex()]) {
            return true;
        }
        String s = this.myMaxConnectionsTextField.getText();
        int n = maxConnectionsValue = StringUtil.isEmpty((String)s) ? Integer.MAX_VALUE : AdvancedOptionsForm.parseInt(s, Integer.MAX_VALUE);
        if (config.getMaxConnections() != maxConnectionsValue) {
            return true;
        }
        if (config.isCompatibilityMode() != this.myCompatibilityModeCheckBox.isSelected()) {
            return true;
        }
        if (config.getDataChannelProtectionLevel() != this.myDataProtectionLevelComboBox.getSelectedItem()) {
            return true;
        }
        if (!StringUtil.equals((CharSequence)config.getControlEncoding(), (CharSequence)this.myControlEncodingTextField.getText())) {
            return true;
        }
        if (config.isMuteSftpMessages() != this.myMuteSftpMessagesCheckBox.isSelected()) {
            return true;
        }
        if (config.isForceListCommand() != this.myForceListCommandCheckBox.isSelected()) {
            return true;
        }
        int keepAliveTimeout = config.getKeepAliveTimeout();
        if (this.myKeepAliveCheckbox.isSelected() ? keepAliveTimeout != (uiTimeout = AdvancedOptionsForm.parseInt(this.myKeepAliveTimeoutField.getText(), 0) * 1000) : keepAliveTimeout > 0) {
            return true;
        }
        String timeout = this.myKeepAliveTimeoutField.getText();
        config.setKeepAliveTimeout(this.myKeepAliveCheckbox.isSelected() ? AdvancedOptionsForm.parseInt(timeout, 0) * 1000 : 0);
        if (config.getKeepAliveFtpCommand() != this.myKeepAliveFtpCommandComboBox.getSelectedItem()) {
            return true;
        }
        return config.isShareSslContext() != this.myShareSslContextCheckbox.isSelected();
    }

    void updateOnAccessTypeChange(AccessType accessType) {
        this.myFtpsPanel.setVisible(accessType == AccessType.FTPS);
        this.myTimestampsLabel.setVisible(accessType == AccessType.FTP || accessType == AccessType.FTPS);
        this.myTimestampsCombo.setVisible(accessType == AccessType.FTP || accessType == AccessType.FTPS);
        this.myFtpPanel.setVisible(accessType == AccessType.FTP || accessType == AccessType.FTPS);
        this.myMuteSftpMessagesCheckBox.setVisible(accessType == AccessType.SFTP);
        this.myKeepAliveFtpPanel.setVisible(accessType == AccessType.FTP || accessType == AccessType.FTPS);
    }

    private static int parseInt(String timeout, int defaultUnparsedValue) {
        try {
            return Integer.parseInt(timeout);
        }
        catch (NumberFormatException e) {
            return defaultUnparsedValue;
        }
    }

    @Nullable
    public String getErrorMessage() {
        String text;
        if (this.myMaxConnectionsCheckBox.isSelected()) {
            text = this.myMaxConnectionsTextField.getText();
            if (StringUtil.isEmpty((String)text)) {
                return WDBundle.message("empty.max.connections", new Object[0]);
            }
            try {
                if (Integer.parseInt(text) < 0) {
                    return WDBundle.message("invalid.max.connections", new Object[0]);
                }
            }
            catch (NumberFormatException e) {
                return WDBundle.message("invalid.max.connections", new Object[0]);
            }
        }
        if (this.myKeepAliveCheckbox.isSelected()) {
            text = this.myKeepAliveTimeoutField.getText();
            if (StringUtil.isEmpty((String)text)) {
                return WDBundle.message("empty.keep.alive.timeout", new Object[0]);
            }
            try {
                if (Integer.parseInt(text) < 1) {
                    return WDBundle.message("invalid.keep.alive.timeout", new Object[0]);
                }
            }
            catch (NumberFormatException e) {
                return WDBundle.message("invalid.keep.alive.timeout", new Object[0]);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "deployable";
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/AdvancedOptionsForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel2;
        JLabel jLabel;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JBCheckBox jBCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel3;
        JTextField jTextField2;
        JTextField jTextField3;
        JCheckBox jCheckBox5;
        JPanel jPanel4;
        this.myContentPane = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(8, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myMaxConnectionsCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox5.setText("Concurrent connections limit:");
        jCheckBox5.setMnemonic('L');
        jCheckBox5.setDisplayedMnemonicIndex(23);
        jPanel4.add((Component)jCheckBox5, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMaxConnectionsTextField = jTextField3 = new JTextField();
        jPanel4.add((Component)jTextField3, new GridConstraints(2, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myControlEncodingTextField = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(5, 1, 1, 1, 8, 1, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Encoding for client-server communication:");
        jLabel2.setDisplayedMnemonic('E');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFtpPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Use  LIST command:");
        jPanel3.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCompatibilityModeCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setMargin(new Insets(1, 1, 0, 1));
        jCheckBox4.setText("Compatible with old version of listing children");
        jCheckBox4.setMnemonic('C');
        jCheckBox4.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jCheckBox4, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        this.myForceListCommandCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Instead of MLSD");
        jPanel3.add((Component)jBCheckBox3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myShowHiddenFilesCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox3.setText("Show and process hidden files");
        jCheckBox3.setMnemonic('S');
        jCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPassiveModeCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox2.setText("Passive mode");
        jCheckBox2.setMnemonic('P');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTimestampsLabel = jLabel = new JLabel();
        jLabel.setText("Retrieve files timestamps:");
        jLabel.setDisplayedMnemonic('R');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myTimestampsCombo = jComboBox;
        jPanel4.add(jComboBox, new GridConstraints(4, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myFtpsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Data channel protection level:");
        jLabel3.setDisplayedMnemonic('D');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("TLS:");
        jPanel5.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExplicitFTPSRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        jRadioButton2.setText("Explicit");
        jRadioButton2.setMnemonic('X');
        jRadioButton2.setDisplayedMnemonicIndex(1);
        ((Component)jRadioButton2).setVisible(true);
        jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myImplicitFTPSRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Implicit");
        jRadioButton.setMnemonic('I');
        jRadioButton.setDisplayedMnemonicIndex(0);
        ((Component)jRadioButton).setVisible(true);
        jPanel5.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.myDataProtectionLevelComboBox = jComboBox2;
        jPanel2.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(100, -1), null));
        this.myShareSslContextCheckbox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Reuse SSL session");
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(3, 0, 1, 4, 0, 3, 3, 3, null, null, null, 0, true));
        this.myKeepAliveCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox.setText("Send keep alive messages each:");
        jCheckBox.setMnemonic('K');
        jCheckBox.setDisplayedMnemonicIndex(5);
        jPanel6.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myKeepAliveTimeoutField = jTextField = new JTextField();
        jTextField.setMargin(new Insets(1, 5, 1, 5));
        jTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        jTextField.setMinimumSize(new Dimension(30, 27));
        jTextField.setPreferredSize(new Dimension(30, 27));
        jPanel6.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(" seconds");
        jPanel6.add((Component)jLabel4, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myKeepAliveFtpPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Keep alive command:");
        jLabel5.setDisplayedMnemonic('A');
        jLabel5.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox3 = new JComboBox();
        this.myKeepAliveFtpCommandComboBox = jComboBox3;
        jPanel.add(jComboBox3, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel4.add((Component)spacer4, new GridConstraints(2, 2, 1, 2, 0, 1, 6, 1, null, null, null));
        this.myMuteSftpMessagesCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Ignore info messages");
        jBCheckBox.setMnemonic('G');
        jBCheckBox.setDisplayedMnemonicIndex(1);
        jPanel4.add((Component)jBCheckBox, new GridConstraints(6, 0, 1, 4, 0, 1, 0, 0, null, null, null));
        jLabel2.setLabelFor(jTextField2);
        jLabel.setLabelFor(jComboBox);
        jLabel3.setLabelFor(jComboBox2);
        jLabel4.setLabelFor(jTextField);
        jLabel5.setLabelFor(jComboBox3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

