/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileContentInfo;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.FileContentThreadData;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.MonitorOutputStream;
import org.apache.commons.vfs2.util.MonitorRandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;

public final class DefaultFileContent
implements FileContent {
    private static final int WRITE_BUFFER_SIZE = 4096;
    private final AbstractFileObject fileObject;
    private FileContentInfo fileContentInfo;
    private final FileContentInfoFactory fileContentInfoFactory;
    private final ThreadLocal<FileContentThreadData> threadData = new ThreadLocal();
    private int openStreams;

    public DefaultFileContent(AbstractFileObject file, FileContentInfoFactory fileContentInfoFactory) {
        this.fileObject = file;
        this.fileContentInfoFactory = fileContentInfoFactory;
    }

    private FileContentThreadData getOrCreateThreadData() {
        FileContentThreadData data = this.threadData.get();
        if (data == null) {
            data = new FileContentThreadData();
            this.threadData.set(data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamOpened() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            ++this.openStreams;
        }
        ((AbstractFileSystem)this.fileObject.getFileSystem()).streamOpened();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamClosed() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            if (this.openStreams > 0) {
                --this.openStreams;
                if (this.openStreams < 1) {
                    this.fileObject.notifyAllStreamsClosed();
                }
            }
        }
        ((AbstractFileSystem)this.fileObject.getFileSystem()).streamClosed();
    }

    @Override
    public FileObject getFile() {
        return this.fileObject;
    }

    @Override
    public long getSize() throws FileSystemException {
        if (!this.fileObject.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/get-size-not-file.error", (Object)this.fileObject);
        }
        try {
            return this.fileObject.doGetContentSize();
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/get-size.error", (Throwable)exc, this.fileObject);
        }
    }

    @Override
    public long getLastModifiedTime(boolean accurate) throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/get-last-modified-no-exist.error", (Object)this.fileObject);
        }
        try {
            return this.fileObject.doGetLastModifiedTime(accurate);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/get-last-modified.error", (Object)this.fileObject, (Throwable)e);
        }
    }

    @Override
    public void setLastModifiedTime(long modTime) throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/set-last-modified-no-exist.error", (Object)this.fileObject);
        }
        try {
            if (!this.fileObject.doSetLastModifiedTime(modTime)) {
                throw new FileSystemException("vfs.provider/set-last-modified.error", (Object)this.fileObject);
            }
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/set-last-modified.error", (Object)this.fileObject, (Throwable)e);
        }
    }

    @Override
    public Certificate[] getCertificates() throws FileSystemException {
        if (!this.fileObject.exists()) {
            throw new FileSystemException("vfs.provider/get-certificates-no-exist.error", (Object)this.fileObject);
        }
        try {
            Certificate[] certs = this.fileObject.doGetCertificates();
            if (certs != null) {
                return certs;
            }
            return new Certificate[0];
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/get-certificates.error", (Object)this.fileObject, (Throwable)e);
        }
    }

    @Override
    public InputStream getInputStream() throws FileSystemException {
        InputStream instr = this.fileObject.getInputStream();
        FileContentInputStream wrappedInstr = new FileContentInputStream(this.fileObject, instr);
        this.getOrCreateThreadData().addInstr(wrappedInstr);
        this.streamOpened();
        return wrappedInstr;
    }

    @Override
    public RandomAccessContent getRandomAccessContent(RandomAccessMode mode) throws FileSystemException {
        RandomAccessContent rastr = this.fileObject.getRandomAccessContent(mode);
        FileRandomAccessContent rac = new FileRandomAccessContent(this.fileObject, rastr);
        this.getOrCreateThreadData().addRastr(rac);
        this.streamOpened();
        return rac;
    }

    @Override
    public OutputStream getOutputStream() throws FileSystemException {
        return this.getOutputStream(false);
    }

    @Override
    public OutputStream getOutputStream(boolean bAppend) throws FileSystemException {
        FileContentThreadData streams = this.getOrCreateThreadData();
        if (streams.getOutstr() != null) {
            throw new FileSystemException("vfs.provider/write-in-use.error", (Object)this.fileObject);
        }
        OutputStream outstr = this.fileObject.getOutputStream(bAppend);
        FileContentOutputStream wrapped = new FileContentOutputStream(this.fileObject, outstr);
        streams.setOutstr(wrapped);
        this.streamOpened();
        return wrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws FileSystemException {
        FileSystemException caught = null;
        try {
            FileContentThreadData streams = this.getOrCreateThreadData();
            while (streams.getInstrsSize() > 0) {
                FileContentInputStream instr = (FileContentInputStream)streams.removeInstr(0);
                try {
                    instr.close();
                }
                catch (FileSystemException ex) {
                    caught = ex;
                }
            }
            while (streams.getRastrsSize() > 0) {
                FileRandomAccessContent ra = (FileRandomAccessContent)streams.removeRastr(0);
                try {
                    ra.close();
                }
                catch (FileSystemException ex) {
                    caught = ex;
                }
            }
            FileContentOutputStream outstr = streams.getOutstr();
            if (outstr != null) {
                streams.setOutstr(null);
                try {
                    outstr.close();
                }
                catch (FileSystemException ex) {
                    caught = ex;
                }
            }
        }
        finally {
            this.threadData.remove();
        }
        if (caught != null) {
            throw caught;
        }
    }

    private void endInput(FileContentInputStream instr) {
        FileContentThreadData streams = this.threadData.get();
        if (streams != null) {
            streams.removeInstr(instr);
        }
        if (streams == null || !streams.hasStreams()) {
            this.threadData.remove();
        }
        this.streamClosed();
    }

    private void endRandomAccess(RandomAccessContent rac) {
        FileContentThreadData streams = this.threadData.get();
        if (streams != null) {
            streams.removeRastr(rac);
        }
        if (streams == null || !streams.hasStreams()) {
            this.threadData.remove();
        }
        this.streamClosed();
    }

    private void endOutput() throws Exception {
        FileContentThreadData streams = this.threadData.get();
        if (streams != null) {
            streams.setOutstr(null);
        }
        if (streams == null || !streams.hasStreams()) {
            this.threadData.remove();
        }
        this.streamClosed();
        this.fileObject.endOutput();
    }

    @Override
    public boolean isOpen() {
        FileContentThreadData streams = this.threadData.get();
        if (streams != null && streams.hasStreams()) {
            return true;
        }
        this.threadData.remove();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpenGlobal() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            return this.openStreams > 0;
        }
    }

    @Override
    public FileContentInfo getContentInfo() throws FileSystemException {
        if (this.fileContentInfo == null) {
            this.fileContentInfo = this.fileContentInfoFactory.create(this);
        }
        return this.fileContentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(FileContent fileContent) throws IOException {
        try (OutputStream output = fileContent.getOutputStream();){
            long l = this.write(output);
            return l;
        }
    }

    @Override
    public long write(FileObject file) throws IOException {
        return this.write(file.getContent());
    }

    @Override
    public long write(OutputStream output) throws IOException {
        return this.write(output, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(OutputStream output, int bufferSize) throws IOException {
        long count = 0L;
        try (InputStream input = this.getInputStream();){
            byte[] buffer = new byte[bufferSize];
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
        }
        return count;
    }

    final class FileContentOutputStream
    extends MonitorOutputStream {
        private final FileObject file;

        FileContentOutputStream(FileObject file, OutputStream outstr) {
            super(outstr);
            this.file = file;
        }

        @Override
        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/close-outstr.error", (Object)this.file, (Throwable)e);
            }
        }

        @Override
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                try {
                    DefaultFileContent.this.endOutput();
                }
                catch (Exception e) {
                    throw new FileSystemException("vfs.provider/close-outstr.error", (Object)this.file, (Throwable)e);
                }
            }
        }
    }

    private final class FileRandomAccessContent
    extends MonitorRandomAccessContent {
        private final FileObject file;

        FileRandomAccessContent(FileObject file, RandomAccessContent content) {
            super(content);
            this.file = file;
        }

        @Override
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                DefaultFileContent.this.endRandomAccess(this);
            }
        }

        @Override
        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/close-rac.error", (Object)this.file, (Throwable)e);
            }
        }
    }

    private final class FileContentInputStream
    extends MonitorInputStream {
        private final FileObject file;

        FileContentInputStream(FileObject file, InputStream instr) {
            super(instr);
            this.file = file;
        }

        @Override
        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/close-instr.error", (Object)this.file, (Throwable)e);
            }
        }

        @Override
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                DefaultFileContent.this.endInput(this);
            }
        }
    }
}

