/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.api;

import com.jetbrains.intellij.datalore.api.AbstractRequests;
import com.jetbrains.intellij.datalore.api.DataloreRequests;
import com.jetbrains.intellij.datalore.api.DataloreViewRequests$PrivacyRequest$;
import com.jetbrains.intellij.datalore.config.DataloreEndpointConfig;
import com.jetbrains.intellij.datalore.models.DatalorePublishingContext;
import com.jetbrains.intellij.datalore.models.DataloreUpdatePrivacyContext;
import com.jetbrains.intellij.datalore.models.DataloreUpdatePublishingContext;
import java.net.URI;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.CompositeEncoder;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.MissingFieldException;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationConstructorMarker;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001,B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0004H\u0002J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0004J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004J\u0006\u0010\u001f\u001a\u00020\u001bJ\u000e\u0010 \u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0004J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u0004J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020(J\u000e\u0010)\u001a\u00020*2\u0006\u0010%\u001a\u00020+R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0016\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000f\u00a8\u0006-"}, d2={"Lcom/jetbrains/intellij/datalore/api/DataloreViewRequests;", "Lcom/jetbrains/intellij/datalore/api/AbstractRequests;", "()V", "CONFIRM_TOKEN_PATH", "", "GET_NOTEBOOK_PATH", "META_PATH", "NOTEBOOKS_API_PATH", "PUBLISHING_MIME_PART_NAME", "SHARE_PATH", "TERMS_PATH", "TOKEN_PATH", "confirmTokenUrl", "Ljava/net/URI;", "getConfirmTokenUrl", "()Ljava/net/URI;", "getPublishedUrl", "getGetPublishedUrl", "notebooksApi", "getNotebooksApi", "termsUrl", "getTermsUrl", "tokenUrl", "getTokenUrl", "buildBasePublishingUrl", "confirmationToken", "getNotebookMeta", "Lorg/apache/http/client/methods/HttpGet;", "notebookId", "token", "getPublishedNotebookUrl", "getTokenRequest", "getTokenStatusRequest", "revokeTokenRequest", "Lorg/apache/http/client/methods/HttpDelete;", "updatePrivacy", "Lorg/apache/http/client/methods/HttpPost;", "context", "Lcom/jetbrains/intellij/datalore/models/DataloreUpdatePrivacyContext;", "updateRequest", "Lcom/jetbrains/intellij/datalore/models/DataloreUpdatePublishingContext;", "uploadRequest", "Lorg/apache/http/client/methods/HttpPut;", "Lcom/jetbrains/intellij/datalore/models/DatalorePublishingContext;", "PrivacyRequest", "datalore-intellij-plugin"})
public final class DataloreViewRequests
extends AbstractRequests {
    private static final String TOKEN_PATH = "/api/token";
    private static final String CONFIRM_TOKEN_PATH = "/confirm_token";
    private static final String NOTEBOOKS_API_PATH = "/api/notebooks";
    private static final String PUBLISHING_MIME_PART_NAME = "file";
    private static final String GET_NOTEBOOK_PATH = "/notebook";
    private static final String TERMS_PATH = "/terms";
    private static final String META_PATH = "meta";
    private static final String SHARE_PATH = "share";
    public static final DataloreViewRequests INSTANCE;

    private final URI getNotebooksApi() {
        return new URI(this.buildBasePublishingUrl() + NOTEBOOKS_API_PATH);
    }

    private final URI getGetPublishedUrl() {
        return new URI(this.buildBasePublishingUrl() + GET_NOTEBOOK_PATH);
    }

    private final URI getTokenUrl() {
        return new URI(this.buildBasePublishingUrl() + TOKEN_PATH);
    }

    private final URI getConfirmTokenUrl() {
        return new URI(this.buildBasePublishingUrl() + CONFIRM_TOKEN_PATH);
    }

    @NotNull
    public final URI getTermsUrl() {
        return new URI(this.buildBasePublishingUrl() + TERMS_PATH);
    }

    private final String buildBasePublishingUrl() {
        return DataloreRequests.INSTANCE.buildUrl(DataloreEndpointConfig.Companion.getInstance().getPublishingEndpoint());
    }

    @NotNull
    public final String getPublishedNotebookUrl(@NotNull String notebookId) {
        Intrinsics.checkParameterIsNotNull((Object)notebookId, (String)"notebookId");
        return this.getGetPublishedUrl() + '/' + notebookId;
    }

    @NotNull
    public final HttpGet getTokenRequest() {
        return new HttpGet(this.getTokenUrl());
    }

    @NotNull
    public final URI getConfirmTokenUrl(@NotNull String confirmationToken) {
        Intrinsics.checkParameterIsNotNull((Object)confirmationToken, (String)"confirmationToken");
        URI uRI = new URIBuilder(this.getConfirmTokenUrl()).addParameter("confirmationToken", confirmationToken).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URIBuilder(confirmTokenU\u2026Token)\n          .build()");
        return uRI;
    }

    @NotNull
    public final HttpGet getTokenStatusRequest(@NotNull String token) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        URI url = new URIBuilder(this.getTokenUrl()).addParameter("token", token).build();
        return new HttpGet(url);
    }

    @NotNull
    public final HttpPut uploadRequest(@NotNull DatalorePublishingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        URI url = new URIBuilder(this.getNotebooksApi()).addParameter("token", context.getToken()).addParameter(SHARE_PATH, String.valueOf(context.getPublic())).build();
        HttpPut putRequest = new HttpPut(url);
        putRequest.setEntity(this.getBinaryMultipartEntity(PUBLISHING_MIME_PART_NAME, context.getContent(), context.getFilename()));
        return putRequest;
    }

    @NotNull
    public final HttpPost updateRequest(@NotNull DataloreUpdatePublishingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        URI url = new URIBuilder(this.getNotebooksApi() + '/' + context.getId()).addParameter("token", context.getToken()).build();
        HttpPost postRequest = new HttpPost(url);
        postRequest.setEntity(this.getBinaryMultipartEntity(PUBLISHING_MIME_PART_NAME, context.getContent(), context.getFilename()));
        return postRequest;
    }

    @NotNull
    public final HttpGet getNotebookMeta(@NotNull String notebookId, @NotNull String token) {
        Intrinsics.checkParameterIsNotNull((Object)notebookId, (String)"notebookId");
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        URI url = new URIBuilder(this.getNotebooksApi() + '/' + notebookId + "/meta").addParameter("token", token).build();
        return new HttpGet(url);
    }

    @NotNull
    public final HttpPost updatePrivacy(@NotNull DataloreUpdatePrivacyContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        URI url = new URIBuilder(this.getNotebooksApi() + '/' + context.getNotebookId() + "/share").addParameter("token", context.getToken()).build();
        HttpPost postRequest = new HttpPost(url);
        postRequest.setEntity(this.getJsonEntity(new Json(JsonConfiguration.Companion.getStable(), null, 2, null).stringify((SerializationStrategy)PrivacyRequest.Companion.serializer(), (Object)new PrivacyRequest(context.getPublic()))));
        return postRequest;
    }

    @NotNull
    public final HttpDelete revokeTokenRequest(@NotNull String token) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        URI url = new URIBuilder(this.getTokenUrl()).addParameter("token", token).build();
        return new HttpDelete(url);
    }

    private DataloreViewRequests() {
    }

    static {
        DataloreViewRequests dataloreViewRequests;
        INSTANCE = dataloreViewRequests = new DataloreViewRequests();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Serializable
    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0083\b\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B!\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/intellij/datalore/api/DataloreViewRequests$PrivacyRequest;", "", "seen1", "", "public", "", "serializationConstructorMarker", "Lkotlinx/serialization/SerializationConstructorMarker;", "(IZLkotlinx/serialization/SerializationConstructorMarker;)V", "(Z)V", "getPublic", "()Z", "component1", "copy", "equals", "other", "hashCode", "toString", "", "$serializer", "Companion", "datalore-intellij-plugin"})
    private static final class PrivacyRequest {
        private final boolean public;
        public static final Companion Companion = new Companion(null);

        public final boolean getPublic() {
            return this.public;
        }

        public PrivacyRequest(boolean bl) {
            this.public = bl;
        }

        public final boolean component1() {
            return this.public;
        }

        @NotNull
        public final PrivacyRequest copy(boolean bl) {
            return new PrivacyRequest(bl);
        }

        public static /* synthetic */ PrivacyRequest copy$default(PrivacyRequest privacyRequest, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = privacyRequest.public;
            }
            return privacyRequest.copy(bl);
        }

        @NotNull
        public String toString() {
            return "PrivacyRequest(public=" + this.public + ")";
        }

        public int hashCode() {
            int n = this.public ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PrivacyRequest)) break block3;
                    PrivacyRequest privacyRequest = (PrivacyRequest)object;
                    if (!(this.public == privacyRequest.public)) break block3;
                }
                return true;
            }
            return false;
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ PrivacyRequest(int seen1, boolean bl, @Nullable SerializationConstructorMarker serializationConstructorMarker) {
            if ((seen1 & 1) == 0) {
                throw (Throwable)new MissingFieldException("public");
            }
            this.public = bl;
        }

        @JvmStatic
        public static final void write$Self(@NotNull PrivacyRequest self, @NotNull CompositeEncoder output, @NotNull SerialDescriptor serialDesc) {
            Intrinsics.checkParameterIsNotNull((Object)self, (String)"self");
            Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
            Intrinsics.checkParameterIsNotNull((Object)serialDesc, (String)"serialDesc");
            output.encodeBooleanElement(serialDesc, 0, self.public);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/intellij/datalore/api/DataloreViewRequests$PrivacyRequest$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/jetbrains/intellij/datalore/api/DataloreViewRequests$PrivacyRequest;", "datalore-intellij-plugin"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @NotNull
            public final KSerializer<PrivacyRequest> serializer() {
                return (KSerializer)PrivacyRequest$$serializer.INSTANCE;
            }
        }
    }
}

