/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.PluginManagerConfigurableNew;
import com.intellij.ide.plugins.newui.CellPluginComponent;
import com.intellij.ide.plugins.newui.ComponentCache;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.UIPluginGroup;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PluginsGridLayout
extends AbstractLayoutManager {
    private final int myFirstVOffset = JBUIScale.scale((int)10);
    private final int myMiddleVOffset = JBUIScale.scale((int)20);
    private final int myLastVOffset = JBUIScale.scale((int)30);
    private final int myMiddleHOffset = JBUIScale.scale((int)1);
    private final Dimension myCellSize = new Dimension();
    private final ComponentCache myCache = new ComponentCache();

    public Dimension preferredLayoutSize(@NotNull Container parent) {
        int cellWidth;
        int columns;
        if (parent == null) {
            PluginsGridLayout.$$$reportNull$$$0(0);
        }
        this.calculateCellSize(parent);
        int width = PluginManagerConfigurableNew.getParentWidth(parent);
        if (width == 0) {
            width = JBUIScale.scale((int)740);
        }
        if ((columns = width / ((cellWidth = this.myCellSize.width) + this.myMiddleHOffset)) < 2) {
            columns = 2;
        }
        width = columns * (cellWidth + this.myMiddleHOffset) - this.myMiddleHOffset;
        int height = 0;
        int cellHeight = this.myCellSize.height;
        List<UIPluginGroup> groups = ((PluginsGroupComponent)((Object)parent)).getGroups();
        for (UIPluginGroup group : groups) {
            int rows;
            height += group.panel.getPreferredSize().height;
            int plugins2 = group.plugins.size();
            if (plugins2 <= columns) {
                rows = 1;
            } else {
                rows = plugins2 / columns;
                if (plugins2 > rows * columns) {
                    ++rows;
                }
            }
            height += this.myFirstVOffset + rows * (cellHeight + this.myMiddleVOffset) - this.myMiddleVOffset + this.myLastVOffset;
        }
        return new Dimension(width, height);
    }

    public void layoutContainer(@NotNull Container parent) {
        if (parent == null) {
            PluginsGridLayout.$$$reportNull$$$0(1);
        }
        this.calculateCellSize(parent);
        List<UIPluginGroup> groups = ((PluginsGroupComponent)((Object)parent)).getGroups();
        int width = parent.getWidth();
        int y = 0;
        int columns = Math.max(1, width / (this.myCellSize.width + this.myMiddleHOffset));
        for (UIPluginGroup group : groups) {
            Component component = group.panel;
            int height = component.getPreferredSize().height;
            component.setBounds(0, y, width, height);
            y += height + this.myFirstVOffset;
            y += this.layoutPlugins(group.plugins, y, columns);
        }
    }

    private void calculateCellSize(@NotNull Container parent) {
        if (parent == null) {
            PluginsGridLayout.$$$reportNull$$$0(2);
        }
        if (this.myCache.isCached(parent)) {
            return;
        }
        this.myCellSize.width = 0;
        this.myCellSize.height = 0;
        List<UIPluginGroup> groups = ((PluginsGroupComponent)((Object)parent)).getGroups();
        for (UIPluginGroup group : groups) {
            for (CellPluginComponent plugin : group.plugins) {
                plugin.doLayout();
                Dimension size = plugin.getPreferredSize();
                this.myCellSize.width = Math.max(this.myCellSize.width, size.width);
                this.myCellSize.height = Math.max(this.myCellSize.height, size.height);
            }
        }
    }

    private int layoutPlugins(@NotNull List<CellPluginComponent> plugins2, int startY, int columns) {
        if (plugins2 == null) {
            PluginsGridLayout.$$$reportNull$$$0(3);
        }
        int x = 0;
        int y = 0;
        int width = this.myCellSize.width;
        int height = this.myCellSize.height;
        int column = 0;
        int size = plugins2.size();
        int last = size - 1;
        for (int i = 0; i < size; ++i) {
            plugins2.get(i).setBounds(x, startY + y, width, height);
            x += width + this.myMiddleHOffset;
            if (++column != columns && i != last) continue;
            x = 0;
            y += height + this.myMiddleVOffset;
            column = 0;
        }
        return y += this.myLastVOffset - this.myMiddleVOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/newui/PluginsGridLayout";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preferredLayoutSize";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "layoutContainer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateCellSize";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "layoutPlugins";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

