/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.diagnostic.ParallelActivity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporter;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.ui.ConfigurableOptionsTopHitProvider;
import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PreloadingActivity;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionsTopHitProvider
implements OptionsSearchTopHitProvider,
SearchTopHitProvider {
    private static final Logger LOG = Logger.getInstance(OptionsTopHitProvider.class);
    private static final ExtensionPointName<OptionsSearchTopHitProvider.ProjectLevelProvider> PROJECT_LEVEL_EP = new ExtensionPointName("com.intellij.search.projectOptionsTopHitProvider");

    @Deprecated
    @NotNull
    public abstract Collection<OptionDescription> getOptions(@Nullable Project var1);

    @NotNull
    private static Collection<OptionDescription> getCachedOptions(@NotNull OptionsSearchTopHitProvider provider, @Nullable Project project, @Nullable PluginDescriptor pluginDescriptor) {
        Application manager;
        if (provider == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(0);
        }
        Object object = manager = project == null || provider instanceof OptionsSearchTopHitProvider.ApplicationLevelProvider ? ApplicationManager.getApplication() : project;
        if (manager == null || manager.isDisposed()) {
            List<OptionDescription> list2 = Collections.emptyList();
            if (list2 == null) {
                OptionsTopHitProvider.$$$reportNull$$$0(1);
            }
            return list2;
        }
        CachedOptions cache = (CachedOptions)manager.getUserData(CachedOptions.KEY);
        if (cache == null) {
            cache = new CachedOptions((ComponentManager)manager);
        }
        Class<?> clazz = provider.getClass();
        Collection<OptionDescription> result2 = (Collection<OptionDescription>)cache.map.get(clazz);
        if (result2 != null) {
            Collection<OptionDescription> collection = result2;
            if (collection == null) {
                OptionsTopHitProvider.$$$reportNull$$$0(2);
            }
            return collection;
        }
        long startTime = StartUpMeasurer.getCurrentTime();
        result2 = provider instanceof OptionsSearchTopHitProvider.ProjectLevelProvider ? ((OptionsSearchTopHitProvider.ProjectLevelProvider)provider).getOptions(project) : (provider instanceof OptionsSearchTopHitProvider.ApplicationLevelProvider ? ((OptionsSearchTopHitProvider.ApplicationLevelProvider)provider).getOptions() : ((OptionsTopHitProvider)provider).getOptions(project));
        (project == null ? ParallelActivity.APP_OPTIONS_TOP_HIT_PROVIDER : ParallelActivity.PROJECT_OPTIONS_TOP_HIT_PROVIDER).record(startTime, clazz, pluginDescriptor == null ? null : pluginDescriptor.getPluginId().getIdString());
        Collection<OptionDescription> prevValue = cache.map.putIfAbsent(clazz, result2);
        Collection<OptionDescription> collection = prevValue == null ? result2 : prevValue;
        if (collection == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public final void consumeTopHits(@NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project project) {
        if (pattern == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(4);
        }
        if (collector == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(5);
        }
        OptionsTopHitProvider.consumeTopHits(this, pattern, collector, project);
    }

    static void consumeTopHits(@NotNull OptionsSearchTopHitProvider provider, @NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project project) {
        if (provider == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(6);
        }
        if (pattern == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(7);
        }
        if (collector == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(8);
        }
        if ((pattern = OptionsTopHitProvider.checkPattern(pattern)) == null) {
            return;
        }
        List parts = StringUtil.split((String)pattern, (String)" ");
        if (!parts.isEmpty()) {
            OptionsTopHitProvider.doConsumeTopHits(provider, pattern, (String)parts.get(0), collector, project);
        }
    }

    private static void doConsumeTopHits(@NotNull OptionsSearchTopHitProvider provider, @NotNull String pattern, @NotNull String id, @NotNull Consumer<Object> collector, @Nullable Project project) {
        if (provider == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(9);
        }
        if (pattern == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(10);
        }
        if (id == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(11);
        }
        if (collector == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(12);
        }
        if (provider.getId().startsWith(id) || pattern.startsWith(" ")) {
            pattern = pattern.startsWith(" ") ? pattern.trim() : StringUtil.toLowerCase((String)pattern.substring(id.length()).trim());
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + pattern), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
            OptionsTopHitProvider.consumeTopHitsForApplicableProvider(provider, matcher, collector, project);
        }
    }

    private static void consumeTopHitsForApplicableProvider(@NotNull OptionsSearchTopHitProvider provider, @NotNull MinusculeMatcher matcher, @NotNull Consumer<Object> collector, @Nullable Project project) {
        if (provider == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(13);
        }
        if (matcher == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(14);
        }
        if (collector == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(15);
        }
        for (OptionDescription option : OptionsTopHitProvider.getCachedOptions(provider, project, null)) {
            if (!matcher.matches(option.getOption())) continue;
            collector.accept(option);
        }
    }

    @Nullable
    private static String checkPattern(@NotNull String pattern) {
        if (pattern == null) {
            OptionsTopHitProvider.$$$reportNull$$$0(16);
        }
        if (!pattern.startsWith(SearchTopHitProvider.getTopHitAccelerator())) {
            return null;
        }
        pattern = pattern.substring(1);
        return pattern;
    }

    @Override
    @NotNull
    public abstract String getId();

    public static String messageApp(String property) {
        return StringUtil.stripHtml((String)ApplicationBundle.message((String)property, (Object[])new Object[0]), (boolean)false);
    }

    public static String messageIde(String property) {
        return StringUtil.stripHtml((String)IdeBundle.message((String)property, (Object[])new Object[0]), (boolean)false);
    }

    public static String messageKeyMap(String property) {
        return StringUtil.stripHtml((String)KeyMapBundle.message((String)property, (Object[])new Object[0]), (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/OptionsTopHitProvider";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/OptionsTopHitProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCachedOptions";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "consumeTopHits";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doConsumeTopHits";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "consumeTopHitsForApplicableProvider";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkPattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class Activity
    extends PreloadingActivity
    implements StartupActivity,
    DumbAware {
        Activity() {
        }

        @Override
        public void preload(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                Activity.$$$reportNull$$$0(0);
            }
            Activity.cacheAll(indicator, null);
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                Activity.$$$reportNull$$$0(1);
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> Activity.cacheAll(null, project));
        }

        private static void cacheAll(@Nullable ProgressIndicator indicator, @Nullable Project project) {
            Application app = ApplicationManager.getApplication();
            if (app == null || app.isUnitTestMode()) {
                return;
            }
            long millis = System.currentTimeMillis();
            String name = project == null ? "application" : "project";
            ArrayDeque<Pair<ConfigurableOptionsTopHitProvider, PluginDescriptor>> edtProviders = new ArrayDeque<Pair<ConfigurableOptionsTopHitProvider, PluginDescriptor>>();
            SearchTopHitProvider.EP_NAME.processWithPluginDescriptor((provider, pluginDescriptor) -> {
                if (provider instanceof ConfigurableOptionsTopHitProvider) {
                    edtProviders.add(new Pair((Object)((ConfigurableOptionsTopHitProvider)provider), pluginDescriptor));
                } else if (provider instanceof OptionsSearchTopHitProvider) {
                    if (project != null && provider instanceof OptionsSearchTopHitProvider.ApplicationLevelProvider) {
                        return;
                    }
                    Activity.cache((OptionsSearchTopHitProvider)provider, indicator, project, pluginDescriptor);
                }
            });
            if (project != null) {
                PROJECT_LEVEL_EP.processWithPluginDescriptor((provider, pluginDescriptor) -> {
                    if (indicator != null) {
                        indicator.checkCanceled();
                    }
                    OptionsTopHitProvider.getCachedOptions(provider, project, pluginDescriptor);
                });
            }
            Activity.scheduleEdtTasks(edtProviders, indicator, project);
            long delta = System.currentTimeMillis() - millis;
            LOG.info(delta + " ms spent to cache options in " + name);
        }

        private static void scheduleEdtTasks(@NotNull Deque<Pair<ConfigurableOptionsTopHitProvider, PluginDescriptor>> edtProviders, @Nullable ProgressIndicator indicator, @Nullable Project project) {
            if (edtProviders == null) {
                Activity.$$$reportNull$$$0(2);
            }
            if (edtProviders.isEmpty()) {
                StartUpPerformanceReporter startUpPerformanceReporter;
                if (project != null && (startUpPerformanceReporter = (StartUpPerformanceReporter)StartupActivity.POST_STARTUP_ACTIVITY.findExtension(StartUpPerformanceReporter.class)) != null) {
                    startUpPerformanceReporter.lastEdtOptionTopHitProviderFinishedForProject();
                }
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                Pair providerAndPluginDescriptor = (Pair)edtProviders.pollFirst();
                if (providerAndPluginDescriptor != null && Activity.cache((OptionsSearchTopHitProvider)providerAndPluginDescriptor.first, indicator, project, (PluginDescriptor)providerAndPluginDescriptor.second)) {
                    Activity.scheduleEdtTasks(edtProviders, indicator, project);
                }
            }, ((ComponentManager)ObjectUtils.chooseNotNull((Object)project, (Object)ApplicationManager.getApplication())).getDisposed());
        }

        private static boolean cache(@NotNull OptionsSearchTopHitProvider provider, @Nullable ProgressIndicator indicator, @Nullable Project project, @Nullable PluginDescriptor pluginDescriptor) {
            if (provider == null) {
                Activity.$$$reportNull$$$0(3);
            }
            if (indicator != null && indicator.isCanceled()) {
                return false;
            }
            if (project != null && project.isDisposed()) {
                return false;
            }
            OptionsTopHitProvider.getCachedOptions(provider, project, pluginDescriptor);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "edtProviders";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/ui/OptionsTopHitProvider$Activity";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preload";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runActivity";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "scheduleEdtTasks";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cache";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ProjectLevelProvidersAdapter
    implements SearchTopHitProvider {
        public void consumeTopHits(@NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project project) {
            if (pattern == null) {
                ProjectLevelProvidersAdapter.$$$reportNull$$$0(0);
            }
            if (collector == null) {
                ProjectLevelProvidersAdapter.$$$reportNull$$$0(1);
            }
            if (project == null) {
                return;
            }
            if ((pattern = OptionsTopHitProvider.checkPattern(pattern)) == null) {
                return;
            }
            List parts = StringUtil.split((String)pattern, (String)" ");
            if (parts.isEmpty()) {
                return;
            }
            for (OptionsSearchTopHitProvider.ProjectLevelProvider provider : PROJECT_LEVEL_EP.getExtensionList()) {
                OptionsTopHitProvider.doConsumeTopHits(provider, pattern, (String)parts.get(0), collector, project);
            }
        }

        public void consumeAllTopHits(@NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project project) {
            if (pattern == null) {
                ProjectLevelProvidersAdapter.$$$reportNull$$$0(2);
            }
            if (collector == null) {
                ProjectLevelProvidersAdapter.$$$reportNull$$$0(3);
            }
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + pattern), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
            for (OptionsSearchTopHitProvider.ProjectLevelProvider provider : PROJECT_LEVEL_EP.getExtensionList()) {
                OptionsTopHitProvider.consumeTopHitsForApplicableProvider(provider, matcher, collector, project);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collector";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/ui/OptionsTopHitProvider$ProjectLevelProvidersAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "consumeTopHits";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "consumeAllTopHits";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class CachedOptions
    implements Disposable {
        private static final Key<CachedOptions> KEY = Key.create((String)"cached top hits");
        private final ConcurrentMap<Class<?>, Collection<OptionDescription>> map = ContainerUtil.newConcurrentMap();
        private final ComponentManager manager;

        private CachedOptions(ComponentManager manager) {
            this.manager = manager;
            Disposer.register((Disposable)manager, (Disposable)this);
            manager.putUserData(KEY, (Object)this);
        }

        public void dispose() {
            this.manager.putUserData(KEY, null);
            this.map.values().forEach(CachedOptions::dispose);
        }

        private static void dispose(Collection<? extends OptionDescription> options) {
            if (options != null) {
                options.forEach(CachedOptions::dispose);
            }
        }

        private static void dispose(OptionDescription option) {
            if (option instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)option));
            }
        }
    }

    @Deprecated
    public static interface CoveredByToggleActions {
    }
}

