/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.facet.frameworks.SettingsConnectionService;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogSettingsService;
import com.intellij.internal.statistic.eventLog.LogEventCompositeFilter;
import com.intellij.internal.statistic.eventLog.LogEventFilter;
import com.intellij.internal.statistic.eventLog.LogEventSnapshotBuildFilter;
import com.intellij.internal.statistic.eventLog.LogEventWhitelistFilter;
import com.intellij.internal.statistic.service.fus.FUSWhitelist;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogExternalSettingsService
extends SettingsConnectionService
implements EventLogSettingsService {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.statistic.eventLog.EventLogExternalSettingsService");
    private static final String APPROVED_GROUPS_SERVICE = "white-list-service";
    private static final String DICTIONARY_SERVICE = "dictionary-service";
    private static final String PERCENT_TRAFFIC = "percent-traffic";

    @Deprecated
    public static EventLogExternalSettingsService getInstance() {
        return EventLogExternalSettingsService.getFeatureUsageSettings();
    }

    @NotNull
    public static EventLogExternalSettingsService getFeatureUsageSettings() {
        EventLogExternalSettingsService eventLogExternalSettingsService = new EventLogExternalSettingsService("FUS");
        if (eventLogExternalSettingsService == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(0);
        }
        return eventLogExternalSettingsService;
    }

    public EventLogExternalSettingsService(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(1);
        }
        super(EventLogExternalSettingsService.getConfigUrl(recorderId, false), null);
    }

    public EventLogExternalSettingsService(@NotNull String recorderId, boolean isTest) {
        if (recorderId == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(2);
        }
        super(EventLogExternalSettingsService.getConfigUrl(recorderId, isTest), null);
    }

    @NotNull
    private static String getConfigUrl(@NotNull String recorderId, boolean isTest) {
        if (recorderId == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(3);
        }
        String templateUrl = ((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getEventLogSettingsUrl();
        if (isTest) {
            String string = String.format(templateUrl, "test/" + recorderId);
            if (string == null) {
                EventLogExternalSettingsService.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = String.format(templateUrl, recorderId);
        if (string == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String[] getAttributeNames() {
        String[] stringArray = ArrayUtil.mergeArrays((String[])super.getAttributeNames(), (String[])new String[]{PERCENT_TRAFFIC, APPROVED_GROUPS_SERVICE, DICTIONARY_SERVICE});
        if (stringArray == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    @Override
    public int getPermittedTraffic() {
        String permitted = this.getSettingValue(PERCENT_TRAFFIC);
        if (permitted != null) {
            try {
                return Integer.parseInt(permitted);
            }
            catch (NumberFormatException e) {
                LOG.trace("Permitted traffic is not defined or has invalid format: '" + permitted + "'");
            }
        }
        return 0;
    }

    @Override
    @Nullable
    public String getDictionaryServiceUrl() {
        return this.getSettingValue(DICTIONARY_SERVICE);
    }

    @Override
    @NotNull
    public LogEventFilter getEventFilter() {
        FUSWhitelist whitelist = (FUSWhitelist)ObjectUtils.notNull((Object)this.getWhitelistedGroups(), (Object)FUSWhitelist.empty());
        LogEventCompositeFilter logEventCompositeFilter = new LogEventCompositeFilter(new LogEventWhitelistFilter(whitelist), LogEventSnapshotBuildFilter.INSTANCE);
        if (logEventCompositeFilter == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(7);
        }
        return logEventCompositeFilter;
    }

    @Override
    public boolean isInternal() {
        return StatisticsUploadAssistant.isTestStatisticsEnabled();
    }

    @Nullable
    protected FUSWhitelist getWhitelistedGroups() {
        String productUrl = this.getWhiteListProductUrl();
        if (productUrl == null) {
            return null;
        }
        return FUStatisticsWhiteListGroupsService.getApprovedGroups(productUrl);
    }

    @Nullable
    public String getWhiteListProductUrl() {
        String approvedGroupsServiceUrl = this.getSettingValue(APPROVED_GROUPS_SERVICE);
        if (approvedGroupsServiceUrl == null) {
            return null;
        }
        return approvedGroupsServiceUrl + ApplicationInfo.getInstance().getBuild().getProductCode() + ".json";
    }

    @NotNull
    private static BuildNumber getCurrentBuild() {
        BuildNumber buildNumber = BuildNumber.fromString((String)EventLogConfiguration.INSTANCE.getBuild());
        if (buildNumber == null) {
            EventLogExternalSettingsService.$$$reportNull$$$0(8);
        }
        return buildNumber;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/EventLogExternalSettingsService";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatureUsageSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogExternalSettingsService";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigUrl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeNames";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventFilter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBuild";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConfigUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

