/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.persistence;

import com.intellij.internal.statistic.eventLog.validator.persistence.EventLogWhitelistSettingsPersistence;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogWhitelistPersistence {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.statistic.eventLog.validator.persistence.EventLogWhitelistPersistence");
    private static final String WHITE_LIST_DATA_FILE = "white-list.json";
    public static final String FUS_WHITELIST_PATH = "event-log-whitelist";
    @NotNull
    private final String myRecorderId;

    public EventLogWhitelistPersistence(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogWhitelistPersistence.$$$reportNull$$$0(0);
        }
        this.myRecorderId = recorderId;
    }

    @NotNull
    private File getWhiteListCacheDirectory() {
        File file2 = Paths.get(PathManager.getConfigPath(), new String[0]).resolve("event-log-whitelist/" + StringUtil.toLowerCase((String)this.myRecorderId) + "/").toFile();
        if (file2 == null) {
            EventLogWhitelistPersistence.$$$reportNull$$$0(1);
        }
        return file2;
    }

    @NotNull
    private File getFileInWhiteListCacheDirectory(@NotNull String fileName2) {
        if (fileName2 == null) {
            EventLogWhitelistPersistence.$$$reportNull$$$0(2);
        }
        File file2 = new File(this.getWhiteListCacheDirectory(), "/" + fileName2);
        if (file2 == null) {
            EventLogWhitelistPersistence.$$$reportNull$$$0(3);
        }
        return file2;
    }

    @NotNull
    File getWhiteListFile() {
        File file2 = this.getFileInWhiteListCacheDirectory(WHITE_LIST_DATA_FILE);
        if (file2 == null) {
            EventLogWhitelistPersistence.$$$reportNull$$$0(4);
        }
        return file2;
    }

    public void cacheWhiteList(@NotNull String gsonWhiteListContent, long lastModified) {
        if (gsonWhiteListContent == null) {
            EventLogWhitelistPersistence.$$$reportNull$$$0(5);
        }
        File file2 = this.getWhiteListFile();
        try {
            FileUtil.writeToFile((File)file2, (String)gsonWhiteListContent);
            EventLogWhitelistSettingsPersistence.getInstance().setLastModified(this.myRecorderId, lastModified);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    public String getCachedWhiteList() {
        File file2 = this.getWhiteListFile();
        try {
            if (!file2.exists()) {
                this.initBuiltinWhiteList(file2);
            }
            if (file2.exists()) {
                return FileUtil.loadFile((File)file2);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    private void initBuiltinWhiteList(File file2) throws IOException {
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.builtinWhiteListPath());){
            if (stream == null) {
                return;
            }
            if (!file2.getParentFile().mkdirs()) {
                throw new IOException("Unable to create " + file2.getParentFile().getAbsolutePath());
            }
            Files.copy(stream, file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private String builtinWhiteListPath() {
        return "resources/event-log-whitelist/" + this.myRecorderId + "/" + WHITE_LIST_DATA_FILE;
    }

    public long getLastModified() {
        return EventLogWhitelistSettingsPersistence.getInstance().getLastModified(this.myRecorderId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/persistence/EventLogWhitelistPersistence";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gsonWhiteListContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/persistence/EventLogWhitelistPersistence";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhiteListCacheDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileInWhiteListCacheDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhiteListFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileInWhiteListCacheDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "cacheWhiteList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

