/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.PerformanceTrace;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.DeduplicateVisitorsSupplier;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectDataManagerImpl
implements ProjectDataManager {
    private static final Logger LOG = Logger.getInstance(ProjectDataManagerImpl.class);
    @NotNull
    private final NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>> myServices;

    public static ProjectDataManagerImpl getInstance() {
        ProjectDataManager service = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
        return (ProjectDataManagerImpl)service;
    }

    public ProjectDataManagerImpl() {
        this(() -> (ProjectDataService[])ProjectDataService.EP_NAME.getExtensions());
    }

    @Nullable
    public List<ProjectDataService<?, ?>> findService(@NotNull Key<?> key) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(0);
        }
        return (List)((Map)this.myServices.getValue()).get(key);
    }

    ProjectDataManagerImpl(ProjectDataService ... dataServices) {
        this(() -> dataServices);
    }

    private ProjectDataManagerImpl(final Supplier<ProjectDataService[]> supplier) {
        this.myServices = new NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>>(){

            @NotNull
            protected Map<Key<?>, List<ProjectDataService<?, ?>>> compute() {
                HashMap result2 = new HashMap();
                for (ProjectDataService service : (ProjectDataService[])supplier.get()) {
                    ArrayList<ProjectDataService> services = (ArrayList<ProjectDataService>)result2.get(service.getTargetDataKey());
                    if (services == null) {
                        services = new ArrayList<ProjectDataService>();
                        result2.put(service.getTargetDataKey(), services);
                    }
                    services.add(service);
                }
                for (List services : result2.values()) {
                    ExternalSystemApiUtil.orderAwareSort((List)services);
                }
                HashMap hashMap = result2;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(0);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl$1", "compute"));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(@NotNull Collection<DataNode<?>> nodes, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        PerformanceTrace trace;
        ProjectSystemId projectSystemId;
        ProjectData projectData;
        if (nodes == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(3);
        }
        if (project.isDisposed()) {
            return;
        }
        MultiMap grouped = ExternalSystemApiUtil.recursiveGroup(nodes);
        Collection projects = grouped.get((Object)ProjectKeys.PROJECT);
        assert (projects.size() == 1 || projects.isEmpty());
        DataNode projectNode = (DataNode)ContainerUtil.getFirstItem((Collection)projects);
        if (projectNode != null) {
            projectData = (ProjectData)projectNode.getData();
            projectSystemId = ((ProjectData)projectNode.getData()).getOwner();
            ExternalProjectsDataStorage.getInstance(project).saveInclusionSettings((DataNode<ProjectData>)projectNode);
        } else {
            projectData = null;
            DataNode aModuleNode = (DataNode)ContainerUtil.getFirstItem((Collection)grouped.get((Object)ProjectKeys.MODULE));
            ProjectSystemId projectSystemId2 = projectSystemId = aModuleNode != null ? ((ModuleData)aModuleNode.getData()).getOwner() : null;
        }
        if (projectSystemId != null) {
            ExternalSystemUtil.scheduleExternalViewStructureUpdate(project, projectSystemId);
        }
        List onSuccessImportTasks = ContainerUtil.newSmartList();
        List onFailureImportTasks = ContainerUtil.newSmartList();
        Collection traceNodes = grouped.get(PerformanceTrace.TRACE_NODE_KEY);
        if (traceNodes.size() > 0) {
            trace = (PerformanceTrace)((DataNode)traceNodes.iterator().next()).getData();
        } else {
            trace = new PerformanceTrace();
            grouped.putValue(PerformanceTrace.TRACE_NODE_KEY, (Object)new DataNode(PerformanceTrace.TRACE_NODE_KEY, (Object)trace, null));
        }
        long allStartTime = System.currentTimeMillis();
        try {
            TreeSet allKeys = new TreeSet(grouped.keySet());
            allKeys.addAll(((Map)this.myServices.getValue()).keySet());
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setIndeterminate(false);
            }
            int size = allKeys.size();
            int count = 0;
            List postImportTasks = ContainerUtil.newSmartList();
            for (Key key : allKeys) {
                if (indicator != null) {
                    String message = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{projectSystemId != null ? projectSystemId.getReadableName() : "", ExternalSystemBundle.message((String)"progress.update.refresh", (Object[])new Object[]{ProjectDataManagerImpl.getReadableText(key)})});
                    indicator.setText(message);
                    indicator.setFraction((double)count++ / (double)size);
                }
                long startTime = System.currentTimeMillis();
                this.doImportData(key, grouped.get((Object)key), projectData, project, modelsProvider, postImportTasks, onSuccessImportTasks, onFailureImportTasks);
                trace.logPerformance("Data import by " + key.toString(), System.currentTimeMillis() - startTime);
            }
            for (Runnable postImportTask : postImportTasks) {
                postImportTask.run();
            }
            ProjectDataManagerImpl.commit(modelsProvider, project, synchronous, "Imported data");
            if (indicator != null) {
                indicator.setIndeterminate(true);
            }
            ((ProjectDataImportListener)project.getMessageBus().syncPublisher(ProjectDataImportListener.TOPIC)).onImportFinished(projectData != null ? projectData.getLinkedExternalProjectPath() : null);
            trace.logPerformance("Data import total", System.currentTimeMillis() - allStartTime);
        }
        catch (Throwable t) {
            try {
                ProjectDataManagerImpl.runFinalTasks(project, synchronous, onFailureImportTasks);
                ProjectDataManagerImpl.dispose(modelsProvider, project, synchronous);
            }
            finally {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
            }
        }
        ProjectDataManagerImpl.runFinalTasks(project, synchronous, onSuccessImportTasks);
    }

    private static void runFinalTasks(@NotNull Project project, boolean synchronous, final List<Runnable> tasks) {
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(4);
        }
        DisposeAwareProjectChange runnable2 = new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                for (Runnable task2 : ContainerUtil.reverse((List)tasks)) {
                    task2.run();
                }
            }
        };
        if (synchronous) {
            try {
                runnable2.run();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        } else {
            ApplicationManager.getApplication().invokeLater((Runnable)runnable2);
        }
    }

    @NotNull
    private static String getReadableText(@NotNull Key key) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(5);
        }
        StringBuilder buffer = new StringBuilder();
        String s = key.toString();
        for (int i = 0; i < s.length(); ++i) {
            char currChar = s.charAt(i);
            if (Character.isUpperCase(currChar)) {
                if (i != 0) {
                    buffer.append(' ');
                }
                buffer.append(StringUtil.toLowerCase((char)currChar));
                continue;
            }
            buffer.append(currChar);
        }
        String string = buffer.toString();
        if (string == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    public <T> void importData(@NotNull Collection<DataNode<T>> nodes, @NotNull Project project, boolean synchronous) {
        if (nodes == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(7);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(8);
        }
        List dummy = ContainerUtil.newSmartList();
        dummy.addAll(nodes);
        this.importData(dummy, project, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project), synchronous);
    }

    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        if (node == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(9);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(10);
        }
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(11);
        }
        List dummy = ContainerUtil.newSmartList();
        dummy.add(node);
        this.importData(dummy, project, modelsProvider, synchronous);
    }

    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project, boolean synchronous) {
        if (node == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(12);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(13);
        }
        this.importData(node, project, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project), synchronous);
    }

    private <T> void doImportData(@NotNull Key<T> key, @NotNull Collection<DataNode<?>> nodes, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modifiableModelsProvider2, @NotNull List<Runnable> postImportTasks, @NotNull List<Runnable> onSuccessImportTasks, @NotNull List<Runnable> onFailureImportTasks) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(14);
        }
        if (nodes == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(15);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(16);
        }
        if (modifiableModelsProvider2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(17);
        }
        if (postImportTasks == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(18);
        }
        if (onSuccessImportTasks == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(19);
        }
        if (onFailureImportTasks == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(20);
        }
        if (project.isDisposed()) {
            return;
        }
        if (project instanceof ComponentManagerImpl) assert (((ComponentManagerImpl)project).isComponentsCreated());
        List toImport = ContainerUtil.newSmartList();
        List toIgnore = ContainerUtil.newSmartList();
        for (DataNode<?> node : nodes) {
            if (!key.equals((Object)node.getKey())) continue;
            if (node.isIgnored()) {
                toIgnore.add(node);
                continue;
            }
            toImport.add(node);
        }
        this.ensureTheDataIsReadyToUse(toImport);
        List services = (List)((Map)this.myServices.getValue()).get(key);
        if (services == null) {
            LOG.debug(String.format("No data service is registered for %s", key));
        } else {
            for (ProjectDataService service : services) {
                long importStartTime = System.currentTimeMillis();
                service.importData((Collection)toImport, projectData, project, modifiableModelsProvider2);
                if (LOG.isDebugEnabled()) {
                    long importTimeInMs = System.currentTimeMillis() - importStartTime;
                    LOG.debug(String.format("Service %s imported data in %d ms", service.getClass().getSimpleName(), importTimeInMs));
                }
                if (projectData == null) continue;
                this.ensureTheDataIsReadyToUse(toIgnore);
                long removeStartTime = System.currentTimeMillis();
                Computable orphanIdeDataComputable = service.computeOrphanData((Collection)toImport, projectData, project, modifiableModelsProvider2);
                service.removeData(orphanIdeDataComputable, (Collection)toIgnore, projectData, project, modifiableModelsProvider2);
                if (!LOG.isDebugEnabled()) continue;
                long removeTimeInMs = System.currentTimeMillis() - removeStartTime;
                LOG.debug(String.format("Service %s computed and removed data in %d ms", service.getClass().getSimpleName(), removeTimeInMs));
            }
        }
        if (services != null && projectData != null) {
            postImportTasks.add(() -> {
                for (ProjectDataService service : services) {
                    if (!(service instanceof AbstractProjectDataService)) continue;
                    long taskStartTime = System.currentTimeMillis();
                    ((AbstractProjectDataService)service).postProcess((Collection)toImport, projectData, project, modifiableModelsProvider2);
                    if (!LOG.isDebugEnabled()) continue;
                    long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                    LOG.debug(String.format("Service %s run post import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                }
            });
            onFailureImportTasks.add(() -> {
                for (ProjectDataService service : services) {
                    if (!(service instanceof AbstractProjectDataService)) continue;
                    long taskStartTime = System.currentTimeMillis();
                    ((AbstractProjectDataService)service).onFailureImport(project);
                    if (!LOG.isDebugEnabled()) continue;
                    long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                    LOG.debug(String.format("Service %s run failure import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                }
            });
            onSuccessImportTasks.add(() -> {
                IdeModelsProviderImpl modelsProvider = new IdeModelsProviderImpl(project);
                for (ProjectDataService service : services) {
                    if (!(service instanceof AbstractProjectDataService)) continue;
                    long taskStartTime = System.currentTimeMillis();
                    ((AbstractProjectDataService)service).onSuccessImport((Collection)toImport, projectData, project, (IdeModelsProvider)modelsProvider);
                    if (!LOG.isDebugEnabled()) continue;
                    long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                    LOG.debug(String.format("Service %s run success import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                }
            });
        }
    }

    public void ensureTheDataIsReadyToUse(@Nullable DataNode startNode) {
        if (startNode == null || startNode.isReady()) {
            return;
        }
        DeduplicateVisitorsSupplier supplier = new DeduplicateVisitorsSupplier();
        startNode.visit(dataNode -> {
            if (dataNode.validateData()) {
                dataNode.visitData(supplier.getVisitor(dataNode.getKey()));
            }
        });
    }

    public <E, I> void removeData(@NotNull Key<E> key, @NotNull Collection<I> toRemove2, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(21);
        }
        if (toRemove2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(22);
        }
        if (toIgnore == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(23);
        }
        if (projectData == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(24);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(25);
        }
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(26);
        }
        try {
            List services = (List)((Map)this.myServices.getValue()).get(key);
            for (ProjectDataService service : services) {
                long removeStartTime = System.currentTimeMillis();
                service.removeData((Computable)new Computable.PredefinedValueComputable(toRemove2), toIgnore, projectData, project, modelsProvider);
                if (!LOG.isDebugEnabled()) continue;
                long removeTimeInMs = System.currentTimeMillis() - removeStartTime;
                LOG.debug(String.format("Service %s removed data in %d ms", service.getClass().getSimpleName(), removeTimeInMs));
            }
            ProjectDataManagerImpl.commit(modelsProvider, project, synchronous, "Removed data");
        }
        catch (Throwable t) {
            ProjectDataManagerImpl.dispose(modelsProvider, project, synchronous);
            ExceptionUtil.rethrow((Throwable)t);
        }
    }

    public <E, I> void removeData(@NotNull Key<E> key, @NotNull Collection<I> toRemove2, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project, boolean synchronous) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(27);
        }
        if (toRemove2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(28);
        }
        if (toIgnore == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(29);
        }
        if (projectData == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(30);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(31);
        }
        this.removeData(key, toRemove2, toIgnore, projectData, project, new IdeModifiableModelsProviderImpl(project), synchronous);
    }

    public void updateExternalProjectData(@NotNull Project project, @NotNull ExternalProjectInfo externalProjectInfo) {
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(32);
        }
        if (externalProjectInfo == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(33);
        }
        if (!project.isDisposed()) {
            ExternalProjectsManagerImpl.getInstance(project).updateExternalProjectData(externalProjectInfo);
        }
    }

    @Nullable
    public ExternalProjectInfo getExternalProjectData(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(34);
        }
        if (projectSystemId == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(35);
        }
        if (externalProjectPath == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(36);
        }
        return !project.isDisposed() ? ExternalProjectsDataStorage.getInstance(project).get(projectSystemId, externalProjectPath) : null;
    }

    @NotNull
    public Collection<ExternalProjectInfo> getExternalProjectsData(@NotNull Project project, @NotNull ProjectSystemId projectSystemId) {
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(37);
        }
        if (projectSystemId == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(38);
        }
        if (!project.isDisposed()) {
            Collection<ExternalProjectInfo> collection = ExternalProjectsDataStorage.getInstance(project).list(projectSystemId);
            if (collection == null) {
                ProjectDataManagerImpl.$$$reportNull$$$0(39);
            }
            return collection;
        }
        List list2 = ContainerUtil.emptyList();
        if (list2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(40);
        }
        return list2;
    }

    private void ensureTheDataIsReadyToUse(@NotNull Collection<DataNode<?>> nodes) {
        if (nodes == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(41);
        }
        for (DataNode<?> node : nodes) {
            this.ensureTheDataIsReadyToUse(node);
        }
    }

    private static void commit(final @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project, boolean synchronous, final @NotNull String commitDesc) {
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(42);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(43);
        }
        if (commitDesc == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(44);
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                long startTime = System.currentTimeMillis();
                modelsProvider.commit();
                long timeInMs = System.currentTimeMillis() - startTime;
                LOG.debug(String.format("%s committed in %d ms", commitDesc, timeInMs));
            }
        });
    }

    private static void dispose(final @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project, boolean synchronous) {
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(45);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(46);
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                modelsProvider.dispose();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 39: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 39: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 7: 
            case 15: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 25: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 11: 
            case 26: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 6: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModelsProvider";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postImportTasks";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccessImportTasks";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFailureImportTasks";
                break;
            }
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectInfo";
                break;
            }
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitDesc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadableText";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProjectsData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findService";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runFinalTasks";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReadableText";
                break;
            }
            case 6: 
            case 39: 
            case 40: {
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doImportData";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "removeData";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "updateExternalProjectData";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectData";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectsData";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "ensureTheDataIsReadyToUse";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

