/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.console.ConsoleMessage;
import com.intellij.javascript.debugger.console.ConsoleMessageBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.debugger.wip.WipLogEntry$WhenMappings;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.wip.RequestInfo;
import org.jetbrains.wip.protocol.log.LogEntryValue;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/debugger/wip/WipLogEntry;", "Lcom/intellij/javascript/debugger/console/ConsoleMessage;", "message", "Lorg/jetbrains/wip/protocol/log/LogEntryValue;", "request", "Lorg/jetbrains/wip/RequestInfo;", "(Lorg/jetbrains/wip/protocol/log/LogEntryValue;Lorg/jetbrains/wip/RequestInfo;)V", "print", "", "printer", "Lcom/intellij/javascript/debugger/console/ConsoleMessageBuilder;", "printFailedNetworkRequestMessage", "intellij.javascript.chrome.connector"})
public final class WipLogEntry
implements ConsoleMessage {
    private final LogEntryValue message;
    private final RequestInfo request;

    /*
     * Unable to fully structure code
     */
    public void print(@NotNull ConsoleMessageBuilder printer) {
        block25: {
            Intrinsics.checkParameterIsNotNull((Object)printer, (String)"printer");
            url = this.message.getUrl();
            line = this.message.getLineNumber();
            v0 = this.message.getStackTrace();
            stackTrace = v0 != null ? v0.callFrames() : null;
            switch (WipLogEntry$WhenMappings.$EnumSwitchMapping$0[this.message.level().ordinal()]) {
                case 1: {
                    v1 = ConsoleViewContentType.LOG_ERROR_OUTPUT;
                    break;
                }
                case 2: {
                    v1 = ConsoleViewContentType.LOG_WARNING_OUTPUT;
                    break;
                }
                case 3: {
                    v1 = ConsoleViewContentType.LOG_INFO_OUTPUT;
                    break;
                }
                case 4: {
                    v1 = ConsoleViewContentType.LOG_DEBUG_OUTPUT;
                    break;
                }
                default: {
                    v1 = ConsoleViewContentType.NORMAL_OUTPUT;
                }
            }
            v2 = contentType = v1;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"contentType");
            printer.startMessage(v2, this.message.source().toString());
            v3 = isFromNetwork = this.message.source() == LogEntryValue.Source.NETWORK;
            if (isFromNetwork) {
                if (this.request == null) {
                    ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)this.message.text(), null, null, (int)6, null);
                    v4 = this.message.getUrl();
                    if (v4 == null) {
                        Intrinsics.throwNpe();
                    }
                    ConsoleMessageBuilder.addMessageLink$default((ConsoleMessageBuilder)printer, (String)v4, (int)-1, (int)-1, null, (boolean)false, null, (int)32, null);
                } else {
                    if (this.request.getInitiator() != null) {
                        v5 = this.request.getInitiator();
                        if (v5 == null) {
                            Intrinsics.throwNpe();
                        }
                        v6 = v5.getStack();
                        stackTrace = v6 != null ? v6.callFrames() : null;
                        v7 = this.request.getInitiator();
                        if (v7 == null) {
                            Intrinsics.throwNpe();
                        }
                        if (!StringUtil.isEmpty((String)v7.getUrl())) {
                            v8 = this.request.getInitiator();
                            if (v8 == null) {
                                Intrinsics.throwNpe();
                            }
                            url = v8.getUrl();
                            v9 = this.request.getInitiator();
                            if (v9 == null) {
                                Intrinsics.throwNpe();
                            }
                            line = (int)v9.getLineNumber();
                        }
                    }
                    if (this.message.level() == LogEntryValue.Level.ERROR) {
                        this.printFailedNetworkRequestMessage(printer);
                    } else {
                        ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)this.message.text(), null, null, (int)6, null);
                    }
                }
            } else {
                ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)this.message.text(), null, null, (int)6, null);
            }
            if (isFromNetwork && this.request == null) break block25;
            v10 = stackTrace;
            v11 = callFrame = v10 != null ? (CallFrameValue)CollectionsKt.firstOrNull(v10) : null;
            if (callFrame == null) ** GOTO lbl-1000
            var8_9 = callFrame.url();
            var9_10 = false;
            if (!(var8_9.length() == 0) && Intrinsics.areEqual((Object)callFrame.url(), (Object)"undefined") ^ true) {
                ConsoleMessageBuilder.addMessageLink$default((ConsoleMessageBuilder)printer, (String)callFrame.url(), (int)callFrame.getLineNumber(), (int)callFrame.getColumnNumber(), (String)callFrame.functionName(), (boolean)(isFromNetwork == false), null, (int)32, null);
            } else lbl-1000:
            // 2 sources

            {
                var8_9 = url;
                var9_10 = false;
                var10_11 = false;
                if (!(var8_9 == null || var8_9.length() == 0) && Intrinsics.areEqual((Object)url, (Object)"undefined") ^ true) {
                    ConsoleMessageBuilder.addMessageLink$default((ConsoleMessageBuilder)printer, (String)url, (int)line, (int)0, null, (boolean)(isFromNetwork == false), null, (int)32, null);
                }
            }
        }
        if (!isFromNetwork && this.message.level() != LogEntryValue.Level.ERROR) ** GOTO lbl-1000
        v12 = stackTrace;
        if (!(v12 != null ? v12.isEmpty() : true)) {
            v13 = true;
        } else lbl-1000:
        // 2 sources

        {
            v13 = willPrintStackTrace = false;
        }
        if (willPrintStackTrace) {
            printer.printStackTrace(contentType, this.message.getStackTrace());
        }
        printer.endMessage();
    }

    private final void printFailedNetworkRequestMessage(ConsoleMessageBuilder printer) {
        RequestInfo requestInfo = this.request;
        if (requestInfo == null) {
            Intrinsics.throwNpe();
        }
        printer.appendError(requestInfo.getValue().method());
        printer.appendError(" ");
        printer.printBrowserLink(this.request.getValue().url());
        printer.appendError(" ");
        if (this.request.isFailed()) {
            String string = this.request.getFailDescription();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            printer.appendError(string);
        } else {
            printer.appendError(String.valueOf(this.request.getStatusCode()));
            if (!StringUtil.isEmpty((String)this.request.getStatusText())) {
                printer.appendError(" (");
                String string = this.request.getStatusText();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                printer.appendError(string);
                printer.appendError(")");
            }
        }
    }

    public WipLogEntry(@NotNull LogEntryValue message, @Nullable RequestInfo request) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.message = message;
        this.request = request;
    }
}

