/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip.extension;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.http.DefaultRemoteContentProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.UriUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.intellij.util.net.NetUtils;
import com.jetbrains.debugger.wip.extension.ScriptSourceUrlAppender;
import com.jetbrains.debugger.wip.extension.ScriptSourceUrlAppenderKt;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.Responses;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.wip.WipVm;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/debugger/wip/extension/ScriptSourceUrlAppender;", "Lorg/jetbrains/ide/HttpRequestHandler;", "()V", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "inRequest", "context", "Lio/netty/channel/ChannelHandlerContext;", "intellij.javascript.chrome.connector"})
final class ScriptSourceUrlAppender
extends HttpRequestHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        if (!super.isSupported(request)) return false;
        String string = request.uri();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.uri()");
        if (!HttpRequestHandler.Companion.checkPrefix(string, "FDFA6052-1C12-4655-B658-0DBF2414422D")) return false;
        return true;
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest inRequest, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkParameterIsNotNull((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkParameterIsNotNull((Object)inRequest, (String)"inRequest");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int index = 38;
        String string = inRequest.uri();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"inRequest.uri()");
        int endIndex = StringsKt.indexOf$default((CharSequence)string, (char)'/', (int)(index + 1), (boolean)false, (int)4, null);
        Channel channel = context.channel();
        String string2 = inRequest.uri();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"inRequest.uri()");
        String string3 = string2;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(index, endIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        WipVm vm = ScriptSourceUrlAppenderKt.access$findVm(Integer.parseInt(string5));
        if (vm == null) {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.INTERNAL_SERVER_ERROR");
            Channel channel2 = channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)channel2, (String)"channel");
            Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel2, (HttpRequest)((HttpRequest)inRequest), null, null, (int)12, null);
            return true;
        }
        Base64.Decoder decoder = Base64.getDecoder();
        String string6 = inRequest.uri();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"inRequest.uri()");
        Object object = string6;
        int n = endIndex + 1;
        Base64.Decoder decoder2 = decoder;
        boolean bl2 = false;
        String string7 = object;
        if (string7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string8 = string7.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
        String string9 = string8;
        byte[] byArray = decoder2.decode(string9);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.getDecoder().deco\u2026.substring(endIndex + 1))");
        object = byArray;
        n = 0;
        String originalUrl = new String((byte[])object, Charsets.UTF_8);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(originalUrl, channel, inRequest){
            final /* synthetic */ String $originalUrl;
            final /* synthetic */ Channel $channel;
            final /* synthetic */ FullHttpRequest $inRequest;

            public final void run() {
                try {
                    DefaultRemoteContentProvider.addRequestTuner((Url)Urls.newFromEncoded((String)this.$originalUrl), (RequestBuilder)HttpRequests.request((String)this.$originalUrl)).connect(new HttpRequests.RequestProcessor(this){
                        final /* synthetic */ process.1 this$0;

                        @Nullable
                        public final Void process(@NotNull HttpRequests.Request request) {
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            URLConnection uRLConnection = request.getConnection();
                            Intrinsics.checkExpressionValueIsNotNull((Object)uRLConnection, (String)"request.connection");
                            URLConnection connection2 = uRLConnection;
                            int contentLength = connection2.getContentLength();
                            BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(contentLength > 0 ? contentLength : 16384);
                            NetUtils.copyStreamContent(null, (InputStream)request.getInputStream(), (OutputStream)((OutputStream)out), (int)contentLength);
                            byte[] byArray = out.getInternalBuffer();
                            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"out.internalBuffer");
                            byte[] byArray2 = byArray;
                            int n = 0;
                            int n2 = out.size();
                            Charset charset = Charsets.UTF_8;
                            boolean bl = false;
                            String content = new String(byArray2, n, n2, charset);
                            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, ByteBufUtil.encodeString((ByteBufAllocator)ByteBufAllocator.DEFAULT, (CharBuffer)CharBuffer.wrap(content + "\n//# sourceURL=" + UriUtil.trimParameters((String)this.this$0.$originalUrl)), (Charset)CharsetUtil.UTF_8));
                            Responses.addNoCache((HttpResponse)((HttpResponse)response));
                            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)connection2.getHeaderField("Content-Type"));
                            String sourceMapHeader = (String)ObjectUtils.chooseNotNull((Object)connection2.getHeaderField("X-SourceMap"), (Object)connection2.getHeaderField("SourceMap"));
                            if (!StringUtil.isEmpty((String)sourceMapHeader)) {
                                response.headers().set("X-SourceMap", (Object)sourceMapHeader);
                                response.headers().set("SourceMap", (Object)sourceMapHeader);
                            }
                            HttpResponse httpResponse = (HttpResponse)response;
                            Channel channel = this.this$0.$channel;
                            Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"channel");
                            Responses.send$default((HttpResponse)httpResponse, (Channel)channel, (HttpRequest)((HttpRequest)this.this$0.$inRequest), null, (int)4, null);
                            return null;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                catch (IOException e) {
                    CommandProcessorKt.getLOG().error((Throwable)e);
                }
            }
            {
                this.$originalUrl = string;
                this.$channel = channel;
                this.$inRequest = fullHttpRequest;
            }
        });
        return true;
    }
}

