/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries;

import com.intellij.ProjectTopics;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.LanguagePerFileMappings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.webcore.ModuleHelper;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ScriptingLibraryMappings
extends LanguagePerFileMappings<ScriptingLibraryModel> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.webcore.libraries.ScriptingLibraryMappings");
    private final Map<VirtualFile, CompoundLibrary> myCompoundLibMap;
    private CompoundLibrary myProjectLibs;
    private volatile MultiMap<String, VirtualFile> myMappingsByLibraryNameMap;

    public ScriptingLibraryMappings(@NotNull Project project) {
        if (project == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(0);
        }
        super(project);
        this.myCompoundLibMap = new HashMap<VirtualFile, CompoundLibrary>();
        this.myProjectLibs = new CompoundLibrary();
        this.registerLibraryTableListener(new MyLibraryTableListener(), (Disposable)this);
        MessageBusConnection conn = project.getMessageBus().connect((Disposable)project);
        conn.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ScriptingLibraryMappings.this.myMappingsByLibraryNameMap = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/webcore/libraries/ScriptingLibraryMappings$1", "rootsChanged"));
            }
        });
    }

    @NotNull
    protected abstract ScriptingLibraryManager getLibraryManager();

    public void registerLibraryTableListener(LibraryTable.Listener listener, Disposable parentDisposable) {
        LibraryTable libTable = this.getLibraryManager().getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL);
        libTable.addListener(listener, parentDisposable);
        libTable = this.getLibraryManager().getLibraryTable(ScriptingLibraryModel.LibraryLevel.PROJECT);
        libTable.addListener(listener, parentDisposable);
    }

    public void setMappings(@NotNull Map<VirtualFile, ScriptingLibraryModel> mappings) {
        if (mappings == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(1);
        }
        super.setMappings(mappings);
        this.myMappingsByLibraryNameMap = null;
    }

    public void setMapping(@Nullable VirtualFile file, @Nullable ScriptingLibraryModel dialect) {
        super.setMapping(file, (Object)dialect);
        this.myMappingsByLibraryNameMap = null;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(2);
        }
        super.loadState(state);
        this.myMappingsByLibraryNameMap = null;
    }

    public void cleanupForNextTest() {
        super.cleanupForNextTest();
        this.myMappingsByLibraryNameMap = null;
    }

    protected String serialize(ScriptingLibraryModel library) {
        if (library instanceof CompoundLibrary) {
            return ((CompoundLibrary)library).serialize();
        }
        return this.getLibrarySerializationName(library);
    }

    @NotNull
    private String getLibrarySerializationName(@NotNull ScriptingLibraryModel library) {
        if (library == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(3);
        }
        if (library.isPredefined()) {
            String string = this.getPredefinedLibrarySerializationName(library.getName());
            if (string == null) {
                ScriptingLibraryMappings.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = library.getName();
        if (string == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    protected String getPredefinedLibraryPresentationName(@NotNull String serializationName) {
        if (serializationName == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(6);
        }
        String string = serializationName;
        if (string == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    protected String getPredefinedLibrarySerializationName(@NotNull String presentationName) {
        if (presentationName == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(8);
        }
        String string = presentationName;
        if (string == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void reset() {
        this.getLibraryManager().reset();
        for (CompoundLibrary container : this.myCompoundLibMap.values()) {
            container.reset();
        }
        this.myProjectLibs.reset();
        this.myMappingsByLibraryNameMap = null;
    }

    public void updateMappings() {
        this.myCompoundLibMap.clear();
        this.myProjectLibs = new CompoundLibrary();
        HashMap<VirtualFile, ScriptingLibraryModel> newMappings = new HashMap<VirtualFile, ScriptingLibraryModel>();
        Map mappings = this.getMappings();
        for (Map.Entry entry : mappings.entrySet()) {
            VirtualFile file = (VirtualFile)entry.getKey();
            CompoundLibrary container = (CompoundLibrary)ObjectUtils.tryCast(entry.getValue(), CompoundLibrary.class);
            if (container == null) continue;
            CompoundLibrary newContainer = new CompoundLibrary();
            for (ScriptingLibraryModel libraryModel : container.getLibraries()) {
                String libName = libraryModel.getName();
                ScriptingLibraryModel updatedModel = this.getLibraryManager().getLibraryByName(libName);
                if (updatedModel == null) continue;
                newContainer.addLibrary(updatedModel);
            }
            if (newContainer.isEmpty()) continue;
            newMappings.put(file, newContainer);
            if (file == null) {
                this.myProjectLibs = newContainer;
                continue;
            }
            this.myCompoundLibMap.put(file, newContainer);
        }
        this.setMappings(newMappings);
        this.myMappingsByLibraryNameMap = null;
    }

    @NotNull
    private MultiMap<String, VirtualFile> getMappingsByLibraryNameMap() {
        MultiMap result = this.myMappingsByLibraryNameMap;
        if (result != null) {
            MultiMap multiMap = result;
            if (multiMap == null) {
                ScriptingLibraryMappings.$$$reportNull$$$0(10);
            }
            return multiMap;
        }
        result = MultiMap.create();
        Map mappings = this.getMappings();
        for (Map.Entry entry : mappings.entrySet()) {
            VirtualFile file = (VirtualFile)entry.getKey();
            CompoundLibrary container = (CompoundLibrary)ObjectUtils.tryCast(entry.getValue(), CompoundLibrary.class);
            if (container == null) continue;
            for (ScriptingLibraryModel libraryModel : container.getLibraries()) {
                String libName = libraryModel.getName();
                result.putValue((Object)libName, (Object)file);
            }
        }
        this.myMappingsByLibraryNameMap = result;
        MultiMap multiMap = result;
        if (multiMap == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(11);
        }
        return multiMap;
    }

    public void associate(@Nullable VirtualFile file, String libName, boolean isPredefined) {
        ScriptingLibraryModel libraryModel = this.getLibraryManager().getLibraryByName(libName);
        if (libraryModel == null) {
            return;
        }
        ScriptingLibraryModel container = (ScriptingLibraryModel)this.getImmediateMapping(file);
        if (!(container instanceof CompoundLibrary)) {
            container = new CompoundLibrary();
        }
        ((CompoundLibrary)container).addLibrary(libraryModel);
        this.setMapping(file, container);
        if (libraryModel.isPredefined() != isPredefined) {
            LOG.error("Library " + libName + " is incorrectly treated as " + (isPredefined ? "predefined" : "normal") + " while it is created as " + (libraryModel.isPredefined() ? "predefined" : "normal"));
        }
        this.myMappingsByLibraryNameMap = null;
    }

    public void associateWithProject(String libName) {
        this.associate(null, libName);
    }

    public void disassociateWithProject(@NotNull String libraryName) {
        if (libraryName == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(12);
        }
        this.disassociate(null, libraryName);
    }

    public void associate(@Nullable VirtualFile file, String libName) {
        this.associate(file, libName, false);
    }

    public void disassociate(@Nullable VirtualFile file, String libName) {
        ScriptingLibraryModel libraryModel = this.getLibraryManager().getLibraryByName(libName);
        if (libraryModel == null) {
            return;
        }
        ScriptingLibraryModel container = (ScriptingLibraryModel)this.getImmediateMapping(file);
        if (container == null) {
            return;
        }
        if (container instanceof CompoundLibrary && ((CompoundLibrary)container).containsLibrary(libName)) {
            ((CompoundLibrary)container).toggleLibrary(libraryModel);
            ((CompoundLibrary)container).applyChanges();
        }
        this.myMappingsByLibraryNameMap = null;
    }

    public boolean isAssociatedWithProject(String libName) {
        return this.isAssociatedWith(null, libName);
    }

    public boolean isAssociatedWith(@Nullable VirtualFile file, String libName) {
        ScriptingLibraryModel libraryModel = this.getLibraryManager().getLibraryByName(libName);
        if (libraryModel == null) {
            return false;
        }
        ScriptingLibraryModel container = (ScriptingLibraryModel)this.getImmediateMapping(file);
        return this.containsLibraryName(container, libName);
    }

    public final void updateAssociations(@NotNull Runnable update) {
        if (update == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(13);
        }
        update.run();
        this.onAssociationsUpdated();
    }

    protected abstract void onAssociationsUpdated();

    public boolean isLibraryInScopeFor(@NotNull VirtualFile file, @NotNull String libraryName) {
        ScriptingLibraryModel libraryModel;
        if (file == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(14);
        }
        if (libraryName == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(15);
        }
        if ((libraryModel = this.getLibraryManager().getLibraryByName(libraryName)) == null) {
            return false;
        }
        Ref found = Ref.create((Object)false);
        ScriptingLibraryMappings.iterateUp(file, (Processor<VirtualFile>)((Processor)virtualFile -> {
            ScriptingLibraryModel model = (ScriptingLibraryModel)this.getImmediateMapping((VirtualFile)virtualFile);
            if (this.containsLibraryName(model, libraryName)) {
                found.set((Object)true);
                return false;
            }
            return true;
        }));
        return (Boolean)found.get();
    }

    private boolean containsLibraryName(@Nullable ScriptingLibraryModel container, @NotNull String libraryName) {
        if (libraryName == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(16);
        }
        if (container == null) {
            return false;
        }
        if (container instanceof CompoundLibrary) {
            return ((CompoundLibrary)container).containsLibrary(libraryName);
        }
        return container.getName().equals(libraryName);
    }

    @NotNull
    protected String getValueAttribute() {
        if ("libraries" == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(17);
        }
        return "libraries";
    }

    protected ScriptingLibraryModel handleUnknownMapping(VirtualFile file, String value) {
        if (value == null || !value.contains("{")) {
            return null;
        }
        String[] libNames = value.replace('{', ' ').replace('}', ' ').split(",");
        CompoundLibrary compoundLib = new CompoundLibrary();
        for (String libName : libNames) {
            String presentationName = this.getPredefinedLibraryPresentationName(libName.trim());
            ScriptingLibraryModel libraryModel = this.getLibraryManager().getLibraryByName(presentationName);
            if (libraryModel == null) continue;
            compoundLib.addLibrary(libraryModel);
        }
        if (file == null) {
            this.myProjectLibs = compoundLib;
        } else {
            this.myCompoundLibMap.put(file, compoundLib);
        }
        return compoundLib;
    }

    @NotNull
    public Collection<ScriptingLibraryModel> getValueVariants(@Nullable VirtualFile file) {
        List<ScriptingLibraryModel> libraries = this.getSingleLibraries();
        if (this.myCompoundLibMap.containsKey(file)) {
            libraries.add(this.myCompoundLibMap.get(file));
            List<ScriptingLibraryModel> list = libraries;
            if (list == null) {
                ScriptingLibraryMappings.$$$reportNull$$$0(18);
            }
            return list;
        }
        CompoundLibrary compoundLib = new CompoundLibrary();
        this.myCompoundLibMap.put(file, compoundLib);
        libraries.add(compoundLib);
        List<ScriptingLibraryModel> list = libraries;
        if (list == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Nullable
    public ScriptingLibraryModel adjustChosenValue(VirtualFile file, ScriptingLibraryModel value) {
        CompoundLibrary compoundLib;
        if (value instanceof CompoundLibrary) {
            return value;
        }
        CompoundLibrary compoundLibrary = compoundLib = file == null ? this.myProjectLibs : this.myCompoundLibMap.get(file);
        if (value == null) {
            if (compoundLib != null) {
                compoundLib.clearLibraries();
                this.myCompoundLibMap.remove(file);
                compoundLib = null;
            }
        } else {
            if (compoundLib == null) {
                compoundLib = new CompoundLibrary();
                this.myCompoundLibMap.put(file, compoundLib);
            }
            compoundLib.toggleLibrary(value);
            if (compoundLib.isEmpty()) {
                this.myCompoundLibMap.remove(file);
                compoundLib = null;
            }
        }
        return compoundLib;
    }

    public List<ScriptingLibraryModel> getAvailableValues() {
        return this.getSingleLibraries();
    }

    public ScriptingLibraryModel getDefaultMapping(@Nullable VirtualFile file) {
        return null;
    }

    public List<ScriptingLibraryModel> getSingleLibraries() {
        return new ArrayList<ScriptingLibraryModel>(Arrays.asList(this.getLibraryManager().getAllLibraries()));
    }

    public static boolean isAssociatedWithProject(@NotNull List<VirtualFile> mappings) {
        if (mappings == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(20);
        }
        return mappings.contains(null);
    }

    public boolean isApplicable(VirtualFile libFile, VirtualFile srcFile) {
        if (!this.getLibraryManager().isLibraryFile(libFile)) {
            return true;
        }
        return this.isRecursivelyApplicable(libFile, srcFile);
    }

    private boolean isRecursivelyApplicable(VirtualFile libFile, VirtualFile srcFile) {
        if (srcFile == null) {
            return false;
        }
        ScriptingLibraryModel libraryModel = (ScriptingLibraryModel)this.getMapping(srcFile);
        if (libraryModel != null && libraryModel.containsFile(libFile)) {
            return true;
        }
        return this.isApplicable(libFile, srcFile.getParent());
    }

    private static void iterateUp(@Nullable VirtualFile file, @NotNull Processor<VirtualFile> processor) {
        if (processor == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(21);
        }
        if (!processor.process(null)) {
            return;
        }
        while (file != null) {
            if (!processor.process((Object)file)) {
                return;
            }
            file = file instanceof VirtualFileWindow ? ((VirtualFileWindow)file).getDelegate() : file.getParent();
        }
    }

    public void forEachLibraryInScopeForFile(@NotNull VirtualFile file, @NotNull Consumer<ScriptingLibraryModel> consumer) {
        if (file == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(22);
        }
        if (consumer == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(23);
        }
        ScriptingLibraryMappings.iterateUp(file, (Processor<VirtualFile>)((Processor)virtualFile -> {
            ScriptingLibraryModel model = (ScriptingLibraryModel)this.getImmediateMapping((VirtualFile)virtualFile);
            if (model instanceof CompoundLibrary) {
                for (ScriptingLibraryModel child : ((CompoundLibrary)model).getLibraries()) {
                    consumer.consume((Object)child);
                }
            } else if (model != null) {
                consumer.consume((Object)model);
            }
            return true;
        }));
    }

    protected boolean shouldReparseFiles() {
        return false;
    }

    private boolean containsProjectLibraryName(@NotNull String libName) {
        if (libName == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(24);
        }
        return this.containsLibraryName((ScriptingLibraryModel)this.getImmediateMapping(null), libName);
    }

    public boolean containsLibrary(@NotNull ScriptingLibraryModel libModel) {
        if (libModel == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(25);
        }
        return !this.getMappingsByLibraryName(libModel.getName()).isEmpty();
    }

    public boolean dependsOn(@NotNull Module module, @NotNull ScriptingLibraryModel libModel, int moduleCount) {
        String libName;
        if (module == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(26);
        }
        if (libModel == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(27);
        }
        if (this.containsProjectLibraryName(libName = libModel.getName())) {
            return moduleCount == 1 || libModel.isAssociatedWith(module);
        }
        for (VirtualFile file : this.getMappings().keySet()) {
            ScriptingLibraryModel container = (ScriptingLibraryModel)this.getMapping(file);
            if (!(container instanceof CompoundLibrary) || !((CompoundLibrary)container).containsLibrary(libName) || !ModuleHelper.isSuitableModule(libModel, module, moduleCount, file)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<VirtualFile> getMappingsByLibraryName(@NotNull String libraryName) {
        if (libraryName == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(28);
        }
        MultiMap<String, VirtualFile> mappings = this.getMappingsByLibraryNameMap();
        List list = (List)mappings.get((Object)libraryName);
        if (list == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    public GlobalSearchScope getLibraryScopeForFile(@NotNull VirtualFile file) {
        if (file == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(30);
        }
        HashSet files = new HashSet();
        this.forEachLibraryInScopeForFile(file, (Consumer<ScriptingLibraryModel>)((Consumer)model -> model.addSignificantFiles(files)));
        GlobalSearchScope globalSearchScope = ScriptingLibraryUtil.getFilesAndDirectoriesScope(this.getProject(), files);
        if (globalSearchScope == null) {
            ScriptingLibraryMappings.$$$reportNull$$$0(31);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 29: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 29: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/libraries/ScriptingLibraryMappings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializationName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationName";
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 14: 
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libName";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libModel";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/libraries/ScriptingLibraryMappings";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrarySerializationName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibraryPresentationName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibrarySerializationName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingsByLibraryNameMap";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAttribute";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueVariants";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingsByLibraryName";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryScopeForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setMappings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLibrarySerializationName";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 29: 
            case 31: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibraryPresentationName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibrarySerializationName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "disassociateWithProject";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateAssociations";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryInScopeFor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "containsLibraryName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isAssociatedWithProject";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "iterateUp";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "forEachLibraryInScopeForFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "containsProjectLibraryName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "containsLibrary";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "dependsOn";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsByLibraryName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryScopeForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 29: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyLibraryTableListener
    implements LibraryTable.Listener {
        private MyLibraryTableListener() {
        }

        public void afterLibraryAdded(@NotNull Library newLibrary) {
            if (newLibrary == null) {
                MyLibraryTableListener.$$$reportNull$$$0(0);
            }
            ScriptingLibraryMappings.this.updateMappings();
        }

        public void afterLibraryRenamed(@NotNull Library library) {
            if (library == null) {
                MyLibraryTableListener.$$$reportNull$$$0(1);
            }
            ScriptingLibraryMappings.this.updateMappings();
        }

        public void afterLibraryRemoved(@NotNull Library library) {
            if (library == null) {
                MyLibraryTableListener.$$$reportNull$$$0(2);
            }
            ScriptingLibraryMappings.this.updateMappings();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newLibrary";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/webcore/libraries/ScriptingLibraryMappings$MyLibraryTableListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryRenamed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class CompoundLibrary
    extends ScriptingLibraryModel {
        private final Map<String, ScriptingLibraryModel> myLibraries;
        private final Map<String, ScriptingLibraryModel> myOldLibraries;

        public CompoundLibrary() {
            super(null, null);
            this.myLibraries = new TreeMap<String, ScriptingLibraryModel>();
            this.myOldLibraries = new TreeMap<String, ScriptingLibraryModel>();
        }

        public void clearLibraries() {
            this.myOldLibraries.clear();
            this.myOldLibraries.putAll(this.myLibraries);
            this.myLibraries.clear();
        }

        public void toggleLibrary(@NotNull ScriptingLibraryModel library) {
            String libName;
            if (library == null) {
                CompoundLibrary.$$$reportNull$$$0(0);
            }
            if (this.myLibraries.containsKey(libName = library.getName())) {
                this.myLibraries.remove(libName);
                return;
            }
            this.myLibraries.put(libName, library);
        }

        private void addLibrary(@NotNull ScriptingLibraryModel library) {
            if (library == null) {
                CompoundLibrary.$$$reportNull$$$0(1);
            }
            String libName = library.getName();
            this.myLibraries.put(libName, library);
            this.applyChanges();
        }

        public boolean containsLibrary(String libName) {
            return this.myLibraries.containsKey(libName);
        }

        @Nullable
        public String serialize() {
            ArrayList<String> names = new ArrayList<String>();
            for (ScriptingLibraryModel library : this.myLibraries.values()) {
                if (this.isPredefinedLibraryWithDefaultMappingsOrIncluded(library)) continue;
                names.add(ScriptingLibraryMappings.this.getLibrarySerializationName(library));
            }
            if (names.isEmpty()) {
                return null;
            }
            return "{" + StringUtil.join(names, (String)", ") + "}";
        }

        private boolean isPredefinedLibraryWithDefaultMappingsOrIncluded(@NotNull ScriptingLibraryModel model) {
            List<VirtualFile> mappings;
            if (model == null) {
                CompoundLibrary.$$$reportNull$$$0(2);
            }
            if (!model.isPredefined()) {
                return false;
            }
            List<VirtualFile> defaultMappings = model.getDefaultMappings();
            return defaultMappings.equals(mappings = ScriptingLibraryMappings.this.getMappingsByLibraryName(model.getName())) || defaultMappings.isEmpty() && ScriptingLibraryMappings.isAssociatedWithProject(mappings);
        }

        @Override
        @NotNull
        public String getName() {
            StringBuilder allNames = new StringBuilder();
            boolean isFirst = true;
            for (ScriptingLibraryModel library : this.myLibraries.values()) {
                allNames.append(isFirst ? "" : ", ");
                allNames.append(library.getName());
                isFirst = false;
            }
            String string = allNames.toString();
            if (string == null) {
                CompoundLibrary.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public boolean containsFile(VirtualFile file) {
            for (ScriptingLibraryModel library : this.myLibraries.values()) {
                if (!library.containsFile(file)) continue;
                return true;
            }
            return false;
        }

        public Collection<ScriptingLibraryModel> getLibraries() {
            return this.myLibraries.values();
        }

        @Override
        public boolean isEmpty() {
            return this.myLibraries.isEmpty();
        }

        public int getLibraryCount() {
            return this.myLibraries.size();
        }

        public void applyChanges() {
            this.myOldLibraries.clear();
            this.myOldLibraries.putAll(this.myLibraries);
        }

        public boolean isModified() {
            if (this.myOldLibraries == null) {
                return false;
            }
            for (String libName : this.myLibraries.keySet()) {
                if (this.myOldLibraries.containsKey(libName)) continue;
                return true;
            }
            for (String libName : ArrayUtilRt.toStringArray(this.myOldLibraries.keySet())) {
                if (this.myLibraries.containsKey(libName)) continue;
                return true;
            }
            return false;
        }

        public void reset() {
            this.myLibraries.clear();
            this.myLibraries.putAll(this.myOldLibraries);
        }

        @Override
        @NotNull
        public Set<VirtualFile> getSourceFiles() {
            HashSet<VirtualFile> sourceFiles = new HashSet<VirtualFile>();
            for (ScriptingLibraryModel libModel : this.myLibraries.values()) {
                sourceFiles.addAll(libModel.getSourceFiles());
            }
            HashSet<VirtualFile> hashSet = sourceFiles;
            if (hashSet == null) {
                CompoundLibrary.$$$reportNull$$$0(4);
            }
            return hashSet;
        }

        @Override
        public Set<VirtualFile> getCompactFiles() {
            HashSet<VirtualFile> compactFiles = new HashSet<VirtualFile>();
            for (ScriptingLibraryModel libModel : this.myLibraries.values()) {
                compactFiles.addAll(libModel.getCompactFiles());
            }
            return compactFiles;
        }

        @Override
        public void addSignificantFiles(Collection<VirtualFile> result) {
            for (ScriptingLibraryModel libModel : this.myLibraries.values()) {
                libModel.addSignificantFiles(result);
            }
        }

        @Override
        public void collectFilesWithGlobalDefinitions(@NotNull Collection<VirtualFile> result) {
            if (result == null) {
                CompoundLibrary.$$$reportNull$$$0(5);
            }
            for (ScriptingLibraryModel libModel : this.myLibraries.values()) {
                libModel.collectFilesWithGlobalDefinitions(result);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/webcore/libraries/ScriptingLibraryMappings$CompoundLibrary";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/webcore/libraries/ScriptingLibraryMappings$CompoundLibrary";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "toggleLibrary";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addLibrary";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isPredefinedLibraryWithDefaultMappingsOrIncluded";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "collectFilesWithGlobalDefinitions";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

