/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.concurrency.tool;

import com.jetbrains.python.debugger.concurrency.model.ConcurrencyGraphBlock;
import com.jetbrains.python.debugger.concurrency.model.ConcurrencyRelation;
import com.jetbrains.python.debugger.concurrency.model.ConcurrencyThreadState;
import com.jetbrains.python.debugger.concurrency.tool.ConcurrencyGraphSettings;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ConcurrencyRenderingUtil {
    private static Color makeDarker(Color color, boolean isLockSelected) {
        if (isLockSelected) {
            float[] hsv = new float[3];
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsv);
            hsv[2] = hsv[2] * 0.6f;
            return new Color(Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]));
        }
        return color;
    }

    private static void prepareStroke(@NotNull Graphics g, @NotNull ConcurrencyThreadState threadState, boolean isLockSelected) {
        if (g == null) {
            ConcurrencyRenderingUtil.$$$reportNull$$$0(0);
        }
        if (threadState == null) {
            ConcurrencyRenderingUtil.$$$reportNull$$$0(1);
        }
        Graphics2D g2 = (Graphics2D)g;
        switch (threadState) {
            case Run: {
                g2.setStroke(new BasicStroke(2.0f));
                g2.setColor(ConcurrencyRenderingUtil.makeDarker(ConcurrencyGraphSettings.BASIC_COLOR, isLockSelected));
                break;
            }
            case Stopped: {
                break;
            }
            case LockWait: {
                g2.setStroke(new BasicStroke(2.0f));
                g2.setColor(ConcurrencyRenderingUtil.makeDarker(ConcurrencyGraphSettings.LOCK_WAIT_COLOR, isLockSelected));
                break;
            }
            case LockWaitSelected: {
                g2.setStroke(new BasicStroke(2.0f));
                g2.setColor(ConcurrencyGraphSettings.LOCK_WAIT_COLOR);
                break;
            }
            case LockOwn: {
                g2.setStroke(new BasicStroke(2.0f));
                g2.setColor(ConcurrencyRenderingUtil.makeDarker(ConcurrencyGraphSettings.LOCK_OWNING_COLOR, isLockSelected));
                break;
            }
            case Deadlock: {
                g2.setStroke(new BasicStroke(2.0f));
                g2.setColor(ConcurrencyRenderingUtil.makeDarker(ConcurrencyGraphSettings.DEADLOCK_COLOR, isLockSelected));
            }
        }
    }

    public static void paintRow(@NotNull Image img, int externalPadding, @NotNull ConcurrencyGraphBlock[] drawingElements, int row, boolean isSelected, boolean isLockSelected) {
        if (img == null) {
            ConcurrencyRenderingUtil.$$$reportNull$$$0(2);
        }
        if (drawingElements == null) {
            ConcurrencyRenderingUtil.$$$reportNull$$$0(3);
        }
        if (img instanceof BufferedImage) {
            BufferedImage bufImage = (BufferedImage)img;
            Graphics2D g2 = bufImage.createGraphics();
            if (isSelected) {
                g2.setColor(ConcurrencyGraphSettings.BACKGROUND_SELECTED);
            } else {
                g2.setColor(ConcurrencyGraphSettings.BACKGOUND_COLOR);
            }
            g2.fillRect(0, 0, bufImage.getWidth(), bufImage.getHeight());
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int paddingInsideBlock = 0;
            for (ConcurrencyGraphBlock block : drawingElements) {
                if (block == null) continue;
                if (row < block.getElements().size()) {
                    int padding = 1 * (externalPadding + paddingInsideBlock);
                    ConcurrencyThreadState drawElement = block.getElements().get(row).getThreadState();
                    if (drawElement != ConcurrencyThreadState.Stopped) {
                        ConcurrencyRenderingUtil.prepareStroke(g2, drawElement, isLockSelected);
                        g2.fillRect(padding, ConcurrencyGraphSettings.INTERVAL / 2, 1 * block.getNumberOfCells(), ConcurrencyGraphSettings.CELL_HEIGHT);
                    }
                }
                paddingInsideBlock += block.getNumberOfCells();
            }
        }
    }

    public static void paintRelations(@NotNull Graphics g, int externalPadding, @NotNull ArrayList<? extends ConcurrencyRelation> relations, boolean isLockSelected) {
        if (g == null) {
            ConcurrencyRenderingUtil.$$$reportNull$$$0(4);
        }
        if (relations == null) {
            ConcurrencyRenderingUtil.$$$reportNull$$$0(5);
        }
        for (ConcurrencyRelation concurrencyRelation : relations) {
            if (concurrencyRelation.getParent() == concurrencyRelation.getChild() || concurrencyRelation.getThreadState() == null) continue;
            ConcurrencyRenderingUtil.prepareStroke(g, concurrencyRelation.getThreadState(), isLockSelected);
            Graphics2D g2 = (Graphics2D)g;
            int padding = externalPadding + concurrencyRelation.getPadding() * 1;
            g2.drawLine(padding, (ConcurrencyGraphSettings.CELL_HEIGHT + ConcurrencyGraphSettings.INTERVAL) * concurrencyRelation.getParent() + ConcurrencyGraphSettings.INTERVAL / 2 + 2 - 1, padding, (ConcurrencyGraphSettings.CELL_HEIGHT + ConcurrencyGraphSettings.INTERVAL) * (concurrencyRelation.getChild() + 1) - ConcurrencyGraphSettings.INTERVAL / 2 - 2 + 1);
        }
    }

    public static int getElementIndex(int externalPadding, @NotNull ConcurrencyGraphBlock[] drawingElements, int x) {
        if (drawingElements == null) {
            ConcurrencyRenderingUtil.$$$reportNull$$$0(6);
        }
        x = x / 1 - externalPadding;
        int paddingInsideBlock = 0;
        for (int i = 0; i < drawingElements.length; ++i) {
            ConcurrencyGraphBlock block = drawingElements[i];
            int blockWidth = block.getNumberOfCells();
            if (paddingInsideBlock < x && paddingInsideBlock + blockWidth >= x) {
                return i;
            }
            paddingInsideBlock += block.getNumberOfCells();
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "img";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawingElements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relations";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/concurrency/tool/ConcurrencyRenderingUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareStroke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "paintRow";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "paintRelations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementIndex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

