/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.LineMapData;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.DictionaryLookup;
import com.intellij.rt.coverage.util.ErrorReporter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassData
implements CoverageData {
    private final String myClassName;
    private LineData[] myLinesArray;
    private Map<String, Integer> myStatus;
    private int[] myLineMask;
    private String mySource;

    public ClassData(String name) {
        this.myClassName = name;
    }

    public String getName() {
        return this.myClassName;
    }

    public void save(DataOutputStream os, DictionaryLookup dictionaryLookup) throws IOException {
        CoverageIOUtil.writeINT(os, dictionaryLookup.getDictionaryIndex(this.myClassName));
        Map<String, List<LineData>> sigLines = this.prepareSignaturesMap(dictionaryLookup);
        Set<String> sigs = sigLines.keySet();
        CoverageIOUtil.writeINT(os, sigs.size());
        Iterator<String> iterator = sigs.iterator();
        while (iterator.hasNext()) {
            String sig1;
            String sig = sig1 = iterator.next();
            CoverageIOUtil.writeUTF(os, sig);
            List<LineData> lines = sigLines.get(sig);
            CoverageIOUtil.writeINT(os, lines.size());
            for (LineData line : lines) {
                line.save(os);
            }
        }
    }

    private Map<String, List<LineData>> prepareSignaturesMap(DictionaryLookup dictionaryLookup) {
        HashMap<String, List<LineData>> sigLines = new HashMap<String, List<LineData>>();
        if (this.myLinesArray == null) {
            return sigLines;
        }
        for (LineData lineData : this.myLinesArray) {
            String sig;
            ArrayList<LineData> lines;
            if (lineData == null) continue;
            if (this.myLineMask != null) {
                lineData.setHits(this.myLineMask[lineData.getLineNumber()]);
            }
            if ((lines = (ArrayList<LineData>)sigLines.get(sig = CoverageIOUtil.collapse(lineData.getMethodSignature(), dictionaryLookup))) == null) {
                lines = new ArrayList<LineData>();
                sigLines.put(sig, lines);
            }
            lines.add(lineData);
        }
        return sigLines;
    }

    @Override
    public void merge(CoverageData data) {
        ClassData classData = (ClassData)data;
        this.mergeLines(classData.myLinesArray);
        for (String o : this.getMethodSigs()) {
            this.myStatus.put(o, null);
        }
        if (this.mySource == null && classData.mySource != null) {
            this.mySource = classData.mySource;
        }
    }

    private void mergeLines(LineData[] dLines) {
        if (dLines == null) {
            return;
        }
        if (this.myLinesArray == null || this.myLinesArray.length < dLines.length) {
            LineData[] lines = new LineData[dLines.length];
            if (this.myLinesArray != null) {
                System.arraycopy(this.myLinesArray, 0, lines, 0, this.myLinesArray.length);
            }
            this.myLinesArray = lines;
        }
        for (int i = 0; i < dLines.length; ++i) {
            LineData mergedData = dLines[i];
            if (mergedData == null) continue;
            LineData lineData = this.myLinesArray[i];
            if (lineData == null) {
                lineData = new LineData(mergedData.getLineNumber(), mergedData.getMethodSignature());
                this.registerMethodSignature(lineData);
                this.myLinesArray[i] = lineData;
            }
            lineData.merge(mergedData);
        }
    }

    public void touchLine(int line) {
        int n = line;
        this.myLineMask[n] = this.myLineMask[n] + 1;
    }

    public void touch(int line) {
        LineData lineData = this.getLineData(line);
        if (lineData != null) {
            lineData.touch();
        }
    }

    public void touch(int line, int jump, boolean hit) {
        LineData lineData = this.getLineData(line);
        if (lineData != null) {
            lineData.touchBranch(jump, hit);
        }
    }

    public void touch(int line, int switchNumber, int key) {
        LineData lineData = this.getLineData(line);
        if (lineData != null) {
            lineData.touchBranch(switchNumber, key);
        }
    }

    public void registerMethodSignature(LineData lineData) {
        this.initStatusMap();
        this.myStatus.put(lineData.getMethodSignature(), null);
    }

    public LineData getLineData(int line) {
        return this.myLinesArray[line];
    }

    public Object[] getLines() {
        return this.myLinesArray;
    }

    public boolean containsLine(int line) {
        return this.myLinesArray[line] != null;
    }

    public Collection<String> getMethodSigs() {
        this.initStatusMap();
        return this.myStatus.keySet();
    }

    private void initStatusMap() {
        if (this.myStatus == null) {
            this.myStatus = new HashMap<String, Integer>();
        }
    }

    public Integer getStatus(String methodSignature) {
        Integer methodStatus = this.myStatus.get(methodSignature);
        if (methodStatus == null) {
            for (LineData lineData : this.myLinesArray) {
                if (lineData == null || !methodSignature.equals(lineData.getMethodSignature()) || lineData.getStatus() == 0) continue;
                methodStatus = 1;
                break;
            }
            if (methodStatus == null) {
                methodStatus = 0;
            }
            this.myStatus.put(methodSignature, methodStatus);
        }
        return methodStatus;
    }

    public String toString() {
        return this.myClassName;
    }

    public void initLineMask(LineData[] lines) {
        block4: {
            block3: {
                if (this.myLineMask != null) break block3;
                this.myLineMask = new int[this.myLinesArray != null ? Math.max(lines.length, this.myLinesArray.length) : lines.length];
                if (this.myLinesArray == null) break block4;
                for (int i = 0; i < this.myLinesArray.length; ++i) {
                    LineData data = this.myLinesArray[i];
                    if (data == null) continue;
                    this.myLineMask[i] = data.getHits();
                }
                break block4;
            }
            if (this.myLineMask.length < lines.length) {
                int[] lineMask = new int[lines.length];
                System.arraycopy(this.myLineMask, 0, lineMask, 0, this.myLineMask.length);
                this.myLineMask = lineMask;
            }
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i] == null) continue;
                int n = i;
                this.myLineMask[n] = this.myLineMask[n] + lines[i].getHits();
            }
        }
    }

    public void setLines(LineData[] lines) {
        if (this.myLinesArray == null) {
            this.myLinesArray = lines;
        } else {
            this.mergeLines(lines);
        }
    }

    public void checkLineMappings(LineMapData[] linesMap, ClassData classData) {
        if (linesMap != null) {
            LineData[] result;
            try {
                result = new LineData[linesMap.length];
                for (LineMapData mapData : linesMap) {
                    if (mapData == null) continue;
                    result[mapData.getSourceLineNumber()] = classData.createSourceLineData(mapData);
                }
            }
            catch (Throwable e) {
                ErrorReporter.reportError("Error creating line mappings for " + classData.getName(), e);
                return;
            }
            this.myLinesArray = result;
            this.myLineMask = null;
        }
    }

    private LineData createSourceLineData(LineMapData lineMapData) {
        for (int i = lineMapData.getTargetMinLine(); i <= lineMapData.getTargetMaxLine() && i < this.myLinesArray.length; ++i) {
            LineData targetLineData = this.getLineData(i);
            if (targetLineData == null) continue;
            LineData lineData = new LineData(lineMapData.getSourceLineNumber(), targetLineData.getMethodSignature());
            lineData.merge(targetLineData);
            if (this.myLineMask != null) {
                lineData.setHits(this.myLineMask[i]);
            }
            return lineData;
        }
        return null;
    }

    public void setSource(String source) {
        this.mySource = source;
    }

    public String getSource() {
        return this.mySource;
    }

    public int[] touchLines(int[] lines) {
        this.myLineMask = lines;
        return lines;
    }
}

