/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.history.FileHistoryKt;
import com.intellij.vcs.log.history.FileHistoryUtil;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.MergedChange;
import com.intellij.vcs.log.impl.MergedChangeDiffRequestProvider;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogChangesBrowser
extends ChangesBrowserBase
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogChangesBrowser.class);
    @NotNull
    public static final DataKey<Boolean> HAS_AFFECTED_FILES = DataKey.create((String)"VcsLogChangesBrowser.HasAffectedFiles");
    @NotNull
    private final Project myProject;
    @NotNull
    private static final String EMPTY_SELECTION_TEXT = "Select commit to view details";
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final Function<? super CommitId, ? extends VcsShortCommitDetails> myDataGetter;
    @NotNull
    private final VcsLogUiProperties.PropertiesChangeListener myListener;
    @NotNull
    private final Set<VirtualFile> myRoots;
    @NotNull
    private final List<Change> myChanges;
    @NotNull
    private final Map<CommitId, Set<Change>> myChangesToParents;
    @Nullable
    private Collection<FilePath> myAffectedPaths;
    @NotNull
    private final Wrapper myToolbarWrapper;
    @NotNull
    private final EventDispatcher<Listener> myDispatcher;

    VcsLogChangesBrowser(@NotNull Project project, @NotNull MainVcsLogUiProperties uiProperties, @NotNull Function<? super CommitId, ? extends VcsShortCommitDetails> getter, @NotNull Disposable parent) {
        if (project == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(0);
        }
        if (uiProperties == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(1);
        }
        if (getter == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(3);
        }
        super(project, false, false);
        this.myRoots = new HashSet<VirtualFile>();
        this.myChanges = new ArrayList<Change>();
        this.myChangesToParents = new LinkedHashMap<CommitId, Set<Change>>();
        this.myDispatcher = EventDispatcher.create(Listener.class);
        this.myProject = project;
        this.myUiProperties = uiProperties;
        this.myDataGetter = getter;
        this.myListener = new VcsLogUiProperties.PropertiesChangeListener(){

            @Override
            public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
                if (property == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS.equals(property) || MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES.equals(property)) {
                    VcsLogChangesBrowser.this.myViewer.rebuildTree();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser$1", "onPropertyChanged"));
            }
        };
        this.myUiProperties.addChangeListener(this.myListener);
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myToolbarWrapper = new Wrapper(this.getToolbar().getComponent());
        this.init();
        this.myViewer.setEmptyText(EMPTY_SELECTION_TEXT);
        this.myViewer.rebuildTree();
    }

    @Override
    @NotNull
    protected JComponent createToolbarComponent() {
        Wrapper wrapper = this.myToolbarWrapper;
        if (wrapper == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(4);
        }
        return wrapper;
    }

    @Override
    @NotNull
    protected Border createViewerBorder() {
        Border border = IdeBorderFactory.createBorder((int)2);
        if (border == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(5);
        }
        return border;
    }

    public void setToolbarHeightReferent(@NotNull JComponent referent) {
        if (referent == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(6);
        }
        this.myToolbarWrapper.setVerticalSizeReferent(referent);
    }

    public void addListener(@NotNull Listener listener, @NotNull Disposable disposable) {
        if (listener == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(7);
        }
        if (disposable == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(8);
        }
        this.myDispatcher.addListener((EventListener)listener, disposable);
    }

    public void dispose() {
        this.myUiProperties.removeChangeListener(this.myListener);
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        List list = ContainerUtil.append(super.createToolbarActions(), (Object[])new AnAction[]{CustomActionsSchema.getInstance().getCorrectedAction("Vcs.Log.ChangesBrowser.Toolbar")});
        if (list == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupMenuActions() {
        List list = ContainerUtil.append(super.createPopupMenuActions(), (Object[])new AnAction[]{ActionManager.getInstance().getAction("Vcs.Log.ChangesBrowser.Popup")});
        if (list == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(10);
        }
        return list;
    }

    private void updateModel(@NotNull Runnable update) {
        if (update == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(11);
        }
        this.myChanges.clear();
        this.myChangesToParents.clear();
        this.myRoots.clear();
        update.run();
        this.myViewer.rebuildTree();
        ((Listener)this.myDispatcher.getMulticaster()).onModelUpdated();
    }

    public void resetSelectedDetails() {
        this.updateModel(() -> this.myViewer.setEmptyText(""));
    }

    public void showText(@NotNull Consumer<StatusText> statusTextConsumer) {
        if (statusTextConsumer == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(12);
        }
        this.updateModel(() -> statusTextConsumer.accept(this.myViewer.getEmptyText()));
    }

    public void setAffectedPaths(@Nullable Collection<FilePath> paths) {
        this.myAffectedPaths = paths;
        this.myViewer.rebuildTree();
    }

    public void setSelectedDetails(@NotNull List<? extends VcsFullCommitDetails> detailsList) {
        if (detailsList == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(13);
        }
        this.updateModel(() -> {
            if (detailsList.isEmpty()) {
                this.myViewer.setEmptyText(EMPTY_SELECTION_TEXT);
            } else {
                this.myRoots.addAll(ContainerUtil.map((Collection)detailsList, detail -> detail.getRoot()));
                if (detailsList.size() == 1) {
                    VcsFullCommitDetails detail2 = (VcsFullCommitDetails)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((List)detailsList));
                    this.myChanges.addAll(detail2.getChanges());
                    if (detail2.getParents().size() > 1) {
                        for (int i = 0; i < detail2.getParents().size(); ++i) {
                            THashSet changesSet = ContainerUtil.newIdentityTroveSet((Collection)detail2.getChanges(i));
                            this.myChangesToParents.put(new CommitId((Hash)detail2.getParents().get(i), detail2.getRoot()), (Set<Change>)changesSet);
                        }
                    }
                    if (this.myChanges.isEmpty() && detail2.getParents().size() > 1) {
                        this.myViewer.getEmptyText().setText("No merged conflicts.").appendSecondaryText("Show changes to parents", VcsLogUiUtil.getLinkAttributes(), e -> this.myUiProperties.set(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS, true));
                    } else {
                        this.setEmptyAffectedText();
                    }
                } else {
                    this.myChanges.addAll(VcsLogUtil.collectChanges(detailsList, (Function<? super VcsFullCommitDetails, ? extends Collection<Change>>)((Function)VcsFullCommitDetails::getChanges)));
                    this.setEmptyAffectedText();
                }
            }
        });
    }

    private void setEmptyAffectedText() {
        if (!this.isShowOnlyAffectedSelected() || this.myAffectedPaths == null) {
            this.myViewer.setEmptyText("");
        } else {
            this.myViewer.getEmptyText().setText("No changes that affect selected filters.").appendSecondaryText("Show all changes", VcsLogUiUtil.getLinkAttributes(), e -> this.myUiProperties.set(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES, false));
        }
    }

    @Override
    @NotNull
    protected ChangesBrowserBase.ChangesBrowserTreeList createTreeList(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
        if (project == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(14);
        }
        MyChangesTree myChangesTree = new MyChangesTree(project, showCheckboxes, highlightProblems);
        if (myChangesTree == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(15);
        }
        return myChangesTree;
    }

    @Override
    @NotNull
    protected DefaultTreeModel buildTreeModel() {
        Collection<Change> changes2 = this.collectAffectedChanges(this.myChanges);
        LinkedHashMap<CommitId, Collection<Change>> changesToParents = new LinkedHashMap<CommitId, Collection<Change>>();
        for (Map.Entry<CommitId, Set<Change>> entry : this.myChangesToParents.entrySet()) {
            changesToParents.put(entry.getKey(), this.collectAffectedChanges((Collection<Change>)entry.getValue()));
        }
        MyTreeModelBuilder builder = new MyTreeModelBuilder();
        builder.setChanges(changes2, null);
        if (this.isShowChangesFromParents() && !changesToParents.isEmpty()) {
            if (changes2.isEmpty()) {
                builder.addEmptyTextNode("No merged conflicts");
            }
            for (CommitId commitId : changesToParents.keySet()) {
                Collection changesFromParent = (Collection)changesToParents.get(commitId);
                if (changesFromParent.isEmpty()) continue;
                builder.addChangesFromParentNode(changesFromParent, commitId);
            }
        }
        DefaultTreeModel defaultTreeModel = builder.build();
        if (defaultTreeModel == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(16);
        }
        return defaultTreeModel;
    }

    @NotNull
    private Collection<Change> collectAffectedChanges(@NotNull Collection<Change> changes2) {
        if (changes2 == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(17);
        }
        if (!this.isShowOnlyAffectedSelected() || this.myAffectedPaths == null) {
            Collection<Change> collection = changes2;
            if (collection == null) {
                VcsLogChangesBrowser.$$$reportNull$$$0(18);
            }
            return collection;
        }
        List list = ContainerUtil.filter(changes2, change -> ContainerUtil.or(this.myAffectedPaths, filePath -> {
            if (filePath.isDirectory()) {
                return FileHistoryUtil.affectsDirectory(change, filePath);
            }
            return FileHistoryUtil.affectsFile(change, filePath, false) || FileHistoryUtil.affectsFile(change, filePath, true);
        }));
        if (list == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(19);
        }
        return list;
    }

    private boolean isShowChangesFromParents() {
        return this.myUiProperties.exists(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS) && this.myUiProperties.get(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS) != false;
    }

    private boolean isShowOnlyAffectedSelected() {
        return this.myUiProperties.exists(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES) && this.myUiProperties.get(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES) != false;
    }

    @NotNull
    public List<Change> getDirectChanges() {
        List<Change> list = this.myChanges;
        if (list == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    public List<Change> getSelectedChanges() {
        List<Change> list = VcsTreeModelData.selected((JTree)((Object)this.myViewer)).userObjects(Change.class);
        if (list == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    public List<Change> getAllChanges() {
        List<Change> list = VcsTreeModelData.all((JTree)((Object)this.myViewer)).userObjects(Change.class);
        if (list == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(22);
        }
        return list;
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(23);
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            AbstractVcs vcs = this.getVcs();
            if (vcs == null) {
                return null;
            }
            return vcs.getKeyInstanceMethod();
        }
        if (HAS_AFFECTED_FILES.is(dataId)) {
            return this.myAffectedPaths != null;
        }
        return super.getData(dataId);
    }

    @Nullable
    private AbstractVcs getVcs() {
        List allVcs = ContainerUtil.mapNotNull(this.myRoots, root -> ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(root));
        if (allVcs.size() == 1) {
            return (AbstractVcs)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((List)allVcs));
        }
        Set selectedVcs = ChangesUtil.getAffectedVcses(this.getSelectedChanges(), (Project)this.myProject);
        if (selectedVcs.size() == 1) {
            return (AbstractVcs)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((Collection)selectedVcs));
        }
        return null;
    }

    @Override
    public ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object userObject) {
        if (userObject == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(24);
        }
        return this.getDiffRequestProducer(userObject, false);
    }

    @Nullable
    public ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object userObject, boolean forDiffPreview) {
        if (userObject == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(25);
        }
        if (!(userObject instanceof Change)) {
            return null;
        }
        Change change = (Change)userObject;
        HashMap<Key, Object> context = new HashMap<Key, Object>();
        if (!(change instanceof MergedChange)) {
            this.putRootTagIntoChangeContext(change, context);
        }
        return VcsLogChangesBrowser.createDiffRequestProducer(this.myProject, change, context, forDiffPreview);
    }

    @Nullable
    public static ChangeDiffRequestChain.Producer createDiffRequestProducer(@NotNull Project project, @NotNull Change change, @NotNull Map<Key, Object> context, boolean forDiffPreview) {
        MergedChange mergedChange;
        if (project == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(26);
        }
        if (change == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(27);
        }
        if (context == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(28);
        }
        if (change instanceof MergedChange && (mergedChange = (MergedChange)change).getSourceChanges().size() == 2) {
            if (forDiffPreview) {
                VcsLogChangesBrowser.putFilePathsIntoMergedChangeContext(mergedChange, context);
            }
            return new MergedChangeDiffRequestProvider.MyProducer(project, mergedChange, context);
        }
        if (forDiffPreview) {
            VcsLogChangesBrowser.putFilePathsIntoChangeContext(change, context);
        }
        return ChangeDiffRequestProducer.create(project, change, context);
    }

    private void putRootTagIntoChangeContext(@NotNull Change change, @NotNull Map<Key, Object> context) {
        if (change == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(29);
        }
        if (context == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(30);
        }
        CommitId parentId = null;
        for (CommitId commitId : this.myChangesToParents.keySet()) {
            if (!this.myChangesToParents.get(commitId).contains(change)) continue;
            parentId = commitId;
            break;
        }
        if (parentId != null) {
            RootTag tag = new RootTag(parentId.getHash(), this.getText(parentId));
            context.put(ChangeDiffRequestProducer.TAG_KEY, tag);
        }
    }

    private static void putFilePathsIntoMergedChangeContext(@NotNull MergedChange change, @NotNull Map<Key, Object> context) {
        if (change == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(31);
        }
        if (context == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(32);
        }
        ContentRevision centerRevision = change.getAfterRevision();
        ContentRevision leftRevision = change.getSourceChanges().get(0).getBeforeRevision();
        ContentRevision rightRevision = change.getSourceChanges().get(1).getBeforeRevision();
        FilePath centerFile = centerRevision == null ? null : centerRevision.getFile();
        FilePath leftFile = leftRevision == null ? null : leftRevision.getFile();
        FilePath rightFile = rightRevision == null ? null : rightRevision.getFile();
        context.put(DiffUserDataKeysEx.VCS_DIFF_CENTER_CONTENT_TITLE, VcsLogChangesBrowser.getRevisionTitle(centerRevision, centerFile, null));
        context.put(DiffUserDataKeysEx.VCS_DIFF_RIGHT_CONTENT_TITLE, VcsLogChangesBrowser.getRevisionTitle(rightRevision, rightFile, centerFile));
        context.put(DiffUserDataKeysEx.VCS_DIFF_LEFT_CONTENT_TITLE, VcsLogChangesBrowser.getRevisionTitle(leftRevision, leftFile, centerFile == null ? rightFile : centerFile));
    }

    private static void putFilePathsIntoChangeContext(@NotNull Change change, @NotNull Map<Key, Object> context) {
        if (change == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(33);
        }
        if (context == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(34);
        }
        ContentRevision afterRevision = change.getAfterRevision();
        ContentRevision beforeRevision = change.getBeforeRevision();
        FilePath aFile = afterRevision == null ? null : afterRevision.getFile();
        FilePath bFile = beforeRevision == null ? null : beforeRevision.getFile();
        context.put(DiffUserDataKeysEx.VCS_DIFF_RIGHT_CONTENT_TITLE, VcsLogChangesBrowser.getRevisionTitle(afterRevision, aFile, null));
        context.put(DiffUserDataKeysEx.VCS_DIFF_LEFT_CONTENT_TITLE, VcsLogChangesBrowser.getRevisionTitle(beforeRevision, bFile, aFile));
    }

    @NotNull
    private static String getRevisionTitle(@Nullable ContentRevision revision, @Nullable FilePath file, @Nullable FilePath baseFile) {
        String string = VcsLogChangesBrowser.getShortHash(revision) + (file == null || FileHistoryKt.FILE_PATH_HASHING_STRATEGY.equals((Object)baseFile, (Object)file) ? "" : " (" + VcsLogChangesBrowser.getRelativeFileName(baseFile, file) + ")");
        if (string == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    private static String getShortHash(@Nullable ContentRevision revision) {
        if (revision == null) {
            if ("" == null) {
                VcsLogChangesBrowser.$$$reportNull$$$0(36);
            }
            return "";
        }
        VcsRevisionNumber revisionNumber = revision.getRevisionNumber();
        if (revisionNumber instanceof ShortVcsRevisionNumber) {
            String string = ((ShortVcsRevisionNumber)revisionNumber).toShortString();
            if (string == null) {
                VcsLogChangesBrowser.$$$reportNull$$$0(37);
            }
            return string;
        }
        String string = revisionNumber.asString();
        if (string == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    private static String getRelativeFileName(@Nullable FilePath baseFile, @NotNull FilePath file) {
        if (file == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(39);
        }
        if (baseFile == null || !baseFile.getName().equals(file.getName())) {
            String string = file.getName();
            if (string == null) {
                VcsLogChangesBrowser.$$$reportNull$$$0(40);
            }
            return string;
        }
        FilePath aParentPath = baseFile.getParentPath();
        if (aParentPath == null) {
            String string = file.getName();
            if (string == null) {
                VcsLogChangesBrowser.$$$reportNull$$$0(41);
            }
            return string;
        }
        String string = VcsFileUtil.relativePath(aParentPath.getIOFile(), file.getIOFile());
        if (string == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    private String getText(@NotNull CommitId commitId) {
        if (commitId == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(43);
        }
        String text = "Changes to " + commitId.getHash().toShortString();
        VcsShortCommitDetails detail = (VcsShortCommitDetails)this.myDataGetter.fun((Object)commitId);
        if (!(detail instanceof LoadingDetails) || detail instanceof IndexedDetails) {
            text = text + " " + StringUtil.shortenTextWithEllipsis((String)detail.getSubject(), (int)50, (int)0);
        }
        String string = text;
        if (string == null) {
            VcsLogChangesBrowser.$$$reportNull$$$0(44);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusTextConsumer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsList";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 27: 
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 28: 
            case 30: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewerBorder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupMenuActions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreeList";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTreeModel";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAffectedChanges";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectChanges";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChanges";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionTitle";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortHash";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeFileName";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 44: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setToolbarHeightReferent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateModel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedDetails";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createTreeList";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedChanges";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDiffRequestProducer";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createDiffRequestProducer";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "putRootTagIntoChangeContext";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "putFilePathsIntoMergedChangeContext";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "putFilePathsIntoChangeContext";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeFileName";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class MyChangesTree
    extends ChangesBrowserBase.ChangesBrowserTreeList {
        MyChangesTree(Project project, boolean showCheckboxes, boolean highlightProblems) {
            if (project == null) {
                MyChangesTree.$$$reportNull$$$0(0);
            }
            super(VcsLogChangesBrowser.this, project, showCheckboxes, highlightProblems);
        }

        @Override
        protected void resetTreeState() {
            long start = System.currentTimeMillis();
            if (VcsLogChangesBrowser.this.isShowChangesFromParents()) {
                TreeUtil.expand((JTree)((Object)this), path -> {
                    if (path.getLastPathComponent() instanceof ChangesBrowserParentNode) {
                        return TreeVisitor.Action.SKIP_CHILDREN;
                    }
                    return TreeVisitor.Action.CONTINUE;
                }, path -> {});
            } else {
                TreeUtil.expandAll((JTree)((Object)this));
            }
            LOG.debug("Resetting changes tree state took " + StopWatch.formatTime(System.currentTimeMillis() - start));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser$MyChangesTree", "<init>"));
        }
    }

    private static class RootTag {
        @NotNull
        private final Hash myCommit;
        @NotNull
        private final String myText;

        RootTag(@NotNull Hash commit2, @NotNull String text) {
            if (commit2 == null) {
                RootTag.$$$reportNull$$$0(0);
            }
            if (text == null) {
                RootTag.$$$reportNull$$$0(1);
            }
            this.myCommit = commit2;
            this.myText = text;
        }

        public String toString() {
            return this.myText;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RootTag tag = (RootTag)o;
            return Objects.equals(this.myCommit, tag.myCommit);
        }

        public int hashCode() {
            return Objects.hash(this.myCommit);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "commit";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser$RootTag";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Listener
    extends EventListener {
        public void onModelUpdated();
    }

    private class ChangesBrowserParentNode
    extends ChangesBrowserNode<String> {
        protected ChangesBrowserParentNode(CommitId commitId) {
            if (commitId == null) {
                ChangesBrowserParentNode.$$$reportNull$$$0(0);
            }
            super(VcsLogChangesBrowser.this.getText(commitId));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitId", "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser$ChangesBrowserParentNode", "<init>"));
        }
    }

    private static class ChangesBrowserEmptyTextNode
    extends ChangesBrowserNode<String> {
        protected ChangesBrowserEmptyTextNode(@NotNull String text) {
            if (text == null) {
                ChangesBrowserEmptyTextNode.$$$reportNull$$$0(0);
            }
            super(text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser$ChangesBrowserEmptyTextNode", "<init>"));
        }
    }

    private class MyTreeModelBuilder
    extends TreeModelBuilder {
        MyTreeModelBuilder() {
            super(VcsLogChangesBrowser.this.myProject, VcsLogChangesBrowser.this.getGrouping());
        }

        public void addEmptyTextNode(@NotNull String text) {
            if (text == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(0);
            }
            ChangesBrowserEmptyTextNode textNode = new ChangesBrowserEmptyTextNode(text);
            textNode.markAsHelperNode();
            this.myModel.insertNodeInto(textNode, this.myRoot, this.myRoot.getChildCount());
        }

        public void addChangesFromParentNode(@NotNull Collection<? extends Change> changes2, @NotNull CommitId commitId) {
            if (changes2 == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(1);
            }
            if (commitId == null) {
                MyTreeModelBuilder.$$$reportNull$$$0(2);
            }
            ChangesBrowserParentNode parentNode = new ChangesBrowserParentNode(commitId);
            parentNode.markAsHelperNode();
            this.myModel.insertNodeInto(parentNode, this.myRoot, this.myRoot.getChildCount());
            for (Change change : changes2) {
                this.insertChangeNode(change, parentNode, this.createChangeNode(change, null));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/frame/VcsLogChangesBrowser$MyTreeModelBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addEmptyTextNode";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChangesFromParentNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

