/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.docker.compose;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.compose.cli.DockerComposeCliCmd;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.configuration.beans.common.DockerComposePort;
import com.intellij.docker.compose.configuration.beans.common.RestartPolicy;
import com.intellij.docker.compose.remote.process.DockerComposeProcessUtil;
import com.intellij.docker.compose.service.DockerComposeServiceClient;
import com.intellij.docker.compose.service.commands.AbstractServiceCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceRunCmd;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerProcessUtil;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.remote.run.runtime.WrappedInternalServerErrorException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.remotesdk.RemoteProcessUtil;
import com.jetbrains.python.docker.PyDockerProcessUtil;
import com.jetbrains.python.docker.compose.PyDockerComposeProcessConnectionData;
import com.jetbrains.python.docker.remote.PyDockerComposeProcessHandler;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.remote.PyCommandLineStateUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PySshCommandLineStateUtil;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.PythonEnvUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDockerComposeProcessUtil {
    private PyDockerComposeProcessUtil() {
    }

    @NotNull
    public static ProcessOutput executeRemoteProcess(@Nullable Project project, @NotNull String[] command, @Nullable String workingDir, @NotNull PyRemoteSdkAdditionalDataBase sdkAdditionalData, @NotNull PyRemotePathMapper pathMapper) throws ExecutionException, InterruptedException {
        ProcessOutput processOutput;
        if (command == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(0);
        }
        if (sdkAdditionalData == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(1);
        }
        if (pathMapper == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(2);
        }
        PyDockerComposeProcessConnectionData data = PyDockerProcessUtil.getPyDockerComposeProcessConnectionData(sdkAdditionalData);
        Pair commandWithWorkingDir = RemoteProcessUtil.buildRemoteCommandLine((AbstractPathMapper)pathMapper, (String[])command, (String)workingDir, (String)data.getInterpreterPath());
        HashMap env = new HashMap();
        PythonEnvUtil.setPythonUnbuffered(env);
        try {
            RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)data.getAccount(), (Project)project);
            SharedVolume helpersSharedVolume = PyDockerProcessUtil.getPyCharmHelpersSharedVolume(dockerRuntime);
            DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
            ComposeServiceRunCmd runServiceCmd = (ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)serviceClient.runServiceCmd().withConfigurationPath(data.getComposeFilePaths())).withEnvs(data.getEnvs())).withRemove(true).withServiceName(data.getComposeServiceName())).withCommand((String[])commandWithWorkingDir.getFirst())).withWorkingDir((String)commandWithWorkingDir.getSecond())).withEnvironment(env)).withSharedVolume(helpersSharedVolume)).withRestartPolicy((RestartPolicy)RestartPolicy.noRestart());
            KillableColoredProcessHandler processHandler = runServiceCmd.execute();
            String[] dockerCliCommandLine = ParametersList.parse((String)processHandler.getCommandLine());
            processOutput = PyDockerComposeProcessUtil.assertSuccessfulExecution(dockerCliCommandLine, new CapturingProcessRunner((BaseProcessHandler)processHandler).runProcess());
        }
        catch (ProcessNotCreatedException e) {
            DockerComposeCliUtil.notifyDockerComposeExecutionFailed((Project)project, (ProcessNotCreatedException)e);
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        catch (WrappedInternalServerErrorException e) {
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
        }
        catch (ServerRuntimeException | IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        catch (UndeclaredThrowableException e) {
            throw (UndeclaredThrowableException)DockerUtil.propagateRuntimeExceptionCause((RuntimeException)e, InterruptedException.class);
        }
        if (processOutput == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(3);
        }
        return processOutput;
    }

    @NotNull
    private static ProcessOutput assertSuccessfulExecution(@NotNull String[] command, @NotNull ProcessOutput processOutput) throws ExecutionException {
        if (command == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(4);
        }
        if (processOutput == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(5);
        }
        if (processOutput.isExitCodeSet() && processOutput.getExitCode() == 0) {
            ProcessOutput processOutput2 = processOutput;
            if (processOutput2 == null) {
                PyDockerComposeProcessUtil.$$$reportNull$$$0(6);
            }
            return processOutput2;
        }
        List<String> commandList = Arrays.asList(command);
        String executable = (String)ContainerUtil.getFirstItem(commandList, (Object)"");
        List args = commandList.isEmpty() ? Collections.emptyList() : ContainerUtil.subList(commandList, (int)1);
        throw new PyExecutionException("docker-compose finished with exit code " + processOutput.getExitCode(), executable, args, processOutput);
    }

    @NotNull
    public static ProcessHandler startRemoteProcess(@Nullable Project project, @NotNull GeneralCommandLine commandLine, @NotNull PyRemoteSdkAdditionalDataBase sdkAdditionalData, @NotNull PyRemotePathMapper pathMapper) throws RemoteSdkException {
        if (commandLine == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(7);
        }
        if (sdkAdditionalData == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(8);
        }
        if (pathMapper == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(9);
        }
        ProcessHandler processHandler = PyDockerComposeProcessUtil.startRemoteProcess(project, commandLine, sdkAdditionalData, pathMapper, null);
        if (processHandler == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(10);
        }
        return processHandler;
    }

    @NotNull
    public static ProcessHandler startRemoteProcess(@Nullable Project project, @NotNull GeneralCommandLine commandLine, @NotNull PyRemoteSdkAdditionalDataBase sdkAdditionalData, @NotNull PyRemotePathMapper pathMapper, @Nullable List<DockerComposePort> debuggerPorts) throws RemoteSdkException {
        PyDockerComposeProcessHandler pyDockerComposeProcessHandler;
        block11: {
            ParamsGroup coverageParams;
            ParamsGroup profileParams;
            if (commandLine == null) {
                PyDockerComposeProcessUtil.$$$reportNull$$$0(11);
            }
            if (sdkAdditionalData == null) {
                PyDockerComposeProcessUtil.$$$reportNull$$$0(12);
            }
            if (pathMapper == null) {
                PyDockerComposeProcessUtil.$$$reportNull$$$0(13);
            }
            DockerComposeCliCmd dockerComposeCliCmd = DockerComposeProcessUtil.getComposeCommandOptions((GeneralCommandLine)commandLine);
            PathMappingSettings additionalMappings = (PathMappingSettings)commandLine.getUserData(PythonRemoteInterpreterManager.ADDITIONAL_MAPPINGS);
            PyDockerComposeProcessConnectionData data = PyDockerProcessUtil.getPyDockerComposeProcessConnectionData(sdkAdditionalData);
            ParamsGroup exeGroup = commandLine.getParametersList().getParamsGroup("Exe Options");
            if (exeGroup != null) {
                PythonRemoteInterpreterManager.addUnbuffered((ParamsGroup)exeGroup);
            }
            PyRemoteSocketToLocalHostProvider dockerSocketProvider = data.getPyRemoteSocketToLocalHostProvider();
            ParamsGroup debugParams = commandLine.getParametersList().getParamsGroup("Debugger");
            if (debugParams != null && debugParams.getParameters().size() > 0) {
                PyDockerProcessUtil.patchDebugParams(data.getHelpersPath(), debugParams);
            }
            if ((profileParams = commandLine.getParametersList().getParamsGroup("Profiler")) != null && profileParams.getParameters().size() > 0) {
                PySshCommandLineStateUtil.patchProfileParams((String)data.getInterpreterPath(), (PyRemoteSocketToLocalHostProvider)dockerSocketProvider, (ParamsGroup)profileParams, (File)commandLine.getWorkDirectory(), (PathMapper)pathMapper);
            }
            if ((coverageParams = commandLine.getParametersList().getParamsGroup("Coverage")) != null && coverageParams.getParameters().size() > 0) {
                PySshCommandLineStateUtil.patchCoverageParams((String)data.getInterpreterPath(), (ParamsGroup)coverageParams, (File)commandLine.getWorkDirectory(), (PathMapper)pathMapper);
            }
            PyCommandLineStateUtil.remap((String)data.getInterpreterPath(), (GeneralCommandLine)commandLine, (PathMapper)pathMapper);
            if (commandLine.getWorkDirectory() != null) {
                commandLine.setWorkDirectory(pathMapper.convertToRemote(commandLine.getWorkDirectory().getPath()));
            }
            String[] command = ArrayUtilRt.toStringArray((Collection)commandLine.getCommandLineList(null));
            String workingDir = commandLine.getWorkDirectory() != null ? commandLine.getWorkDirectory().getPath() : null;
            VolumesBuilder volumesBinds = PyDockerComposeProcessUtil.setupVolumeBinds(project, additionalMappings);
            Pair commandWithWorkingDir = RemoteProcessUtil.buildRemoteCommandLine((AbstractPathMapper)pathMapper, (String[])command, (String)workingDir, (String)data.getInterpreterPath());
            HashMap env = new HashMap(commandLine.getEnvironment());
            PythonEnvUtil.setPythonUnbuffered(env);
            try {
                RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)data.getAccount(), (Project)project);
                SharedVolume helpersSharedVolume = PyDockerProcessUtil.getPyCharmHelpersSharedVolume(dockerRuntime);
                DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
                AbstractServiceCmd serviceCmd = DockerComposeProcessUtil.createComposeServiceCmd((DockerComposeServiceClient)serviceClient, (DockerComposeCliCmd)dockerComposeCliCmd, debuggerPorts).withConfigurationPath(ContainerUtil.concat(data.getComposeFilePaths(), (List)dockerComposeCliCmd.getFiles())).withEnvs(data.getEnvs()).withServiceName(data.getComposeServiceName()).withEnvironment(env).withCommand((String[])commandWithWorkingDir.getFirst()).withWorkingDir((String)commandWithWorkingDir.getSecond()).withSharedVolume(helpersSharedVolume).withVolumes(PyDockerComposeProcessUtil.removeRepeatedContainerPaths(volumesBinds.build()));
                pyDockerComposeProcessHandler = new PyDockerComposeProcessHandler(serviceCmd.buildCommandLine(), pathMapper, dockerSocketProvider);
                if (pyDockerComposeProcessHandler != null) break block11;
            }
            catch (WrappedInternalServerErrorException e) {
                throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
            }
            catch (ServerRuntimeException | IOException e) {
                throw DockerUtil.propagateRemoteSdkException((Throwable)e);
            }
            PyDockerComposeProcessUtil.$$$reportNull$$$0(14);
        }
        return pyDockerComposeProcessHandler;
    }

    @NotNull
    public static VolumesBuilder setupVolumeBinds(@Nullable Project project, @Nullable PathMappingSettings additionalMappings) throws RemoteSdkException {
        DockerContainerSettings containerSettings = project != null ? DockerContainerSettings.defaultSettings((Project)project) : null;
        VolumesBuilder volumesBuilder = DockerProcessUtil.setupVolumesBinds((PathMappingSettings)additionalMappings, (DockerContainerSettings)containerSettings);
        if (volumesBuilder == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(15);
        }
        return volumesBuilder;
    }

    @NotNull
    public static DockerVolumeBinding[] removeRepeatedContainerPaths(@NotNull DockerVolumeBinding[] bindings) {
        if (bindings == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(16);
        }
        ArrayList<DockerVolumeBinding> filtered = new ArrayList<DockerVolumeBinding>();
        HashSet<String> containerPaths = new HashSet<String>();
        for (DockerVolumeBinding binding : bindings) {
            if (containerPaths.contains(binding.getContainerPath())) continue;
            filtered.add(binding);
            containerPaths.add(binding.getContainerPath());
        }
        DockerVolumeBinding[] dockerVolumeBindingArray = filtered.toArray(new DockerVolumeBinding[0]);
        if (dockerVolumeBindingArray == null) {
            PyDockerComposeProcessUtil.$$$reportNull$$$0(17);
        }
        return dockerVolumeBindingArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAdditionalData";
                break;
            }
            case 2: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/docker/compose/PyDockerComposeProcessUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOutput";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/docker/compose/PyDockerComposeProcessUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "executeRemoteProcess";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "assertSuccessfulExecution";
                break;
            }
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "startRemoteProcess";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "setupVolumeBinds";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "removeRepeatedContainerPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeRemoteProcess";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "assertSuccessfulExecution";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "startRemoteProcess";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeRepeatedContainerPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

