/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.docker.console;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.DockerCredentialsType;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteProcess;
import com.intellij.util.net.NetUtils;
import com.jetbrains.python.console.PydevConsoleCli;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleCommunicationClient;
import com.jetbrains.python.console.PythonConsoleRemoteProcessCreator;
import com.jetbrains.python.console.RemoteConsoleProcessData;
import com.jetbrains.python.debugger.PySourcePosition;
import com.jetbrains.python.docker.DockerNetworkUtilKt;
import com.jetbrains.python.docker.PyDockerProcessConnectionData;
import com.jetbrains.python.docker.PyDockerProcessUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteProcessHandler;
import com.jetbrains.python.remote.PyRemoteProcessHandlerBase;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J8\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/python/docker/console/PythonConsoleDockerProcessCreator;", "Lcom/jetbrains/python/console/PythonConsoleRemoteProcessCreator;", "Lcom/intellij/docker/remote/DockerCredentialsHolder;", "()V", "credentialsType", "Lcom/intellij/remote/CredentialsType;", "getCredentialsType", "()Lcom/intellij/remote/CredentialsType;", "createDefaultVolumeBindings", "Ljava/util/ArrayList;", "Lcom/intellij/docker/agent/settings/DockerVolumeBindingImpl;", "Lkotlin/collections/ArrayList;", "project", "Lcom/intellij/openapi/project/Project;", "createPythonConsolePortBindings", "", "Lcom/intellij/docker/agent/settings/DockerPortBindingImpl;", "pythonConsolePort", "", "createRemoteConsoleProcess", "Lcom/jetbrains/python/console/RemoteConsoleProcessData;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "pathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "data", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "runnerFileFromHelpers", "", "credentials", "Companion", "intellij.python.docker"})
public final class PythonConsoleDockerProcessCreator
implements PythonConsoleRemoteProcessCreator<DockerCredentialsHolder> {
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public CredentialsType<DockerCredentialsHolder> getCredentialsType() {
        DockerCredentialsType dockerCredentialsType = DockerCredentialsType.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)dockerCredentialsType, (String)"DockerCredentialsType.getInstance()");
        return (CredentialsType)dockerCredentialsType;
    }

    @NotNull
    public RemoteConsoleProcessData createRemoteConsoleProcess(@NotNull GeneralCommandLine commandLine, @NotNull PyRemotePathMapper pathMapper, @NotNull Project project, @NotNull PyRemoteSdkAdditionalDataBase data, @NotNull String runnerFileFromHelpers, @NotNull DockerCredentialsHolder credentials) throws ExecutionException {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull((Object)pathMapper, (String)"pathMapper");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)runnerFileFromHelpers, (String)"runnerFileFromHelpers");
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        int clientPort = NetUtils.findAvailableSocketPort();
        PydevConsoleCli.setupPythonConsoleScriptInServerMode((GeneralCommandLine)commandLine, (SdkAdditionalData)((SdkAdditionalData)data), (Integer)clientPort);
        ParametersList parametersList = commandLine.getParametersList();
        Intrinsics.checkExpressionValueIsNotNull((Object)parametersList, (String)"commandLine.parametersList");
        String[] stringArray = parametersList.getArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"commandLine.parametersList.array");
        String[] command = stringArray;
        Map map = commandLine.getEnvironment();
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"commandLine.environment");
        Map env = map;
        File workDirectory = commandLine.getWorkDirectory();
        GeneralCommandLine patchedCommandLine = new GeneralCommandLine();
        patchedCommandLine.setWorkDirectory(workDirectory);
        patchedCommandLine.withParameters(Arrays.copyOf(command, command.length));
        patchedCommandLine.getEnvironment().putAll(env);
        patchedCommandLine.getParametersList().set(0, PythonRemoteInterpreterManager.toSystemDependent((String)new File(data.getHelpersPath(), runnerFileFromHelpers).getPath(), (boolean)PySourcePosition.isWindowsPath((String)data.getInterpreterPath())));
        try {
            String dockerHost;
            PyRemoteProcessHandler remoteProcessHandlerBase;
            DockerCloudConfiguration configuration = DockerNetworkUtilKt.getDockerCloudConfiguration(credentials);
            DockerContainerSettings dockerContainerSettings = new DockerContainerSettings();
            dockerContainerSettings.setVolumeBindings((List)this.createDefaultVolumeBindings(project));
            dockerContainerSettings.setPortBindings(this.createPythonConsolePortBindings(clientPort));
            patchedCommandLine.putUserData(DockerContainerSettings.KEY, (Object)dockerContainerSettings);
            PyDockerProcessConnectionData pyDockerProcessConnectionData = PyDockerProcessUtil.getPyDockerProcessConnectionData(data);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyDockerProcessConnectionData), (String)"PyDockerProcessUtil.getP\u2026ocessConnectionData(data)");
            PyDockerProcessConnectionData connectionData = pyDockerProcessConnectionData;
            PyRemoteProcessHandler pyRemoteProcessHandler = remoteProcessHandlerBase = PyDockerProcessUtil.startDockerProcess(project, connectionData, patchedCommandLine, pathMapper);
            Intrinsics.checkExpressionValueIsNotNull((Object)pyRemoteProcessHandler, (String)"remoteProcessHandlerBase");
            RemoteProcess remoteProcess = (RemoteProcess)pyRemoteProcessHandler.getProcess();
            Intrinsics.checkExpressionValueIsNotNull((Object)remoteProcess, (String)"remoteProcessHandlerBase.process");
            RemoteProcess remoteProcess2 = remoteProcess;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using communication for Python console: port " + clientPort + " on pydevconsole.py side");
            }
            PydevConsoleCli.waitForPythonConsoleServerToBeStarted((Process)((Process)remoteProcess2));
            String string = DockerNetworkUtilKt.getDockerEngineAddress(configuration);
            if (string == null) {
                string = dockerHost = "localhost";
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using " + dockerHost + " address to connect to pydevconsole.py side");
            }
            PydevConsoleCommunicationClient pydevConsoleCommunication = new PydevConsoleCommunicationClient(project, dockerHost, clientPort, (Process)remoteProcess2);
            pydevConsoleCommunication.connect();
            return new RemoteConsoleProcessData((PyRemoteProcessHandlerBase)remoteProcessHandlerBase, (PydevConsoleCommunication)pydevConsoleCommunication);
        }
        catch (Exception e) {
            throw (Throwable)new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private final List<DockerPortBindingImpl> createPythonConsolePortBindings(int pythonConsolePort) {
        DockerPortBindingImpl portBinding = new DockerPortBindingImpl();
        portBinding.setHostIp("0.0.0.0");
        portBinding.setHostPort(Integer.valueOf(pythonConsolePort));
        portBinding.setContainerPort(pythonConsolePort);
        return CollectionsKt.arrayListOf((Object[])new DockerPortBindingImpl[]{portBinding});
    }

    private final ArrayList<DockerVolumeBindingImpl> createDefaultVolumeBindings(Project project) {
        return CollectionsKt.arrayListOf((Object[])new DockerVolumeBindingImpl[]{new DockerVolumeBindingImpl("/opt/project", project.getBasePath(), false)});
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance((String)PythonConsoleDockerProcessCreator.class.getName());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Pytho\u2026Creator::class.java.name)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/python/docker/console/PythonConsoleDockerProcessCreator$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.docker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

