/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.vagrant.VagrantBox;
import com.jetbrains.plugins.vagrant.VagrantBoxManager;
import com.jetbrains.plugins.vagrant.VagrantItemListPanel;
import com.jetbrains.plugins.vagrant.VagrantItemsModel;
import com.jetbrains.plugins.vagrant.VagrantManager;
import com.jetbrains.plugins.vagrant.VagrantPlugin;
import com.jetbrains.plugins.vagrant.VagrantPluginManager;
import com.jetbrains.plugins.vagrant.VagrantProjectSettings;
import com.jetbrains.plugins.vagrant.VagrantProviders;
import com.jetbrains.plugins.vagrant.VagrantService;
import com.jetbrains.plugins.vagrant.VagrantSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NonNls
    public static final String HELP_TOPIC = "reference.settingsdialog.project.vagrant";
    private final Project myProject;
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myVagrantPathField;
    private TextFieldWithBrowseButton myInstanceFolderField;
    private JPanel myBoxesPanel;
    private JPanel myPluginsPanel;
    private JPanel myErrorPanel;
    private JBLabel myErrorLabel;
    private JPanel myProviderPanel;
    private EnvironmentVariablesComponent myEnvsEditor;
    private final VagrantBoxManager myBoxManager;
    private final VagrantPluginManager myPluginManager;
    private ComboBox myProviderField;

    public VagrantConfigurable(@NotNull Project project) {
        if (project == null) {
            VagrantConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myBoxManager = new VagrantBoxManager(project);
        this.myPluginManager = new VagrantPluginManager(project);
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            VagrantConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    public String getDisplayName() {
        return "Vagrant";
    }

    public JComponent createComponent() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false);
        this.myVagrantPathField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener("Select Vagrant executable", "", (ComponentWithBrowseButton)this.myVagrantPathField, null, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
        FileChooserDescriptor folderDescriptor = new FileChooserDescriptor(false, true, false, false, false, false);
        this.myInstanceFolderField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener("Select Vagrant folder", "", (ComponentWithBrowseButton)this.myInstanceFolderField, null, folderDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
        this.myBoxesPanel.setLayout(new BorderLayout());
        this.myBoxesPanel.add((Component)((Object)new VagrantBoxPanel(this.myProject, this.myBoxManager)), "Center");
        this.myPluginsPanel.setLayout(new BorderLayout());
        this.myPluginsPanel.add((Component)((Object)new VagrantPluginsPanel(this.myProject, this.myPluginManager)), "Center");
        this.myVagrantPathField.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent event) {
                VagrantConfigurable.this.vagrantPathUpdated();
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                VagrantConfigurable.this.vagrantPathUpdated();
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
                VagrantConfigurable.this.vagrantPathUpdated();
            }
        });
        this.myProviderPanel.setLayout(new BorderLayout());
        this.myProviderField = this.createProviderCombo();
        this.myProviderField.setToolTipText("Enter here a name of the provider to use by vagrant up command. Leave it empty to use default provider");
        this.myProviderPanel.add((Component)this.myProviderField, "Center");
        return this.myMainPanel;
    }

    private List<String> providersList() {
        List plugins = this.myPluginManager.listItems();
        ArrayList result = Lists.newArrayList((Object[])new String[]{""});
        if (plugins != null) {
            Function f = input -> VagrantProviders.providerForPlugin(input.getName());
            result.addAll(Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.transform(plugins, (Function)f), (Predicate)Predicates.notNull())));
        }
        return result;
    }

    private ComboBox createProviderCombo() {
        final ArrayList providers = Lists.newArrayList();
        ComboBox combo = new ComboBox((ComboBoxModel)new MutableCollectionComboBoxModel((List)providers));
        combo.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                providers.clear();
                providers.addAll(VagrantConfigurable.this.providersList());
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        combo.setEditable(true);
        combo.setEditor((ComboBoxEditor)new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                JBTextField editor = new JBTextField();
                editor.getEmptyText().setText("Default");
                editor.setBorder(null);
                return editor;
            }
        });
        return combo;
    }

    private void vagrantPathUpdated() {
        this.myBoxManager.setVagrantPath(this.myVagrantPathField.getText());
        this.myPluginManager.setVagrantPath(this.myVagrantPathField.getText());
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List boxes = this.myBoxManager.listItems();
            List plugins = this.myPluginManager.listItems();
            UIUtil.invokeAndWaitIfNeeded(() -> {
                if (boxes == null) {
                    this.showError("Error: Can't run Vagrant executable");
                } else {
                    this.clearError();
                }
                UIUtil.setEnabled((Component)this.myBoxesPanel, (boxes != null ? 1 : 0) != 0, (boolean)true);
                UIUtil.setEnabled((Component)this.myPluginsPanel, (plugins != null ? 1 : 0) != 0, (boolean)true);
            });
        });
    }

    private void showError(String s) {
        this.myErrorLabel.setVisible(true);
        this.myErrorLabel.setText(s);
    }

    private void clearError() {
        this.myErrorLabel.setVisible(false);
    }

    public boolean isModified() {
        VagrantProjectSettings vagrantProjectSettings = VagrantProjectSettings.getInstance(this.myProject);
        VagrantSettings vagrantSettings = VagrantSettings.getInstance();
        return !this.getVagrantPath().equals(vagrantSettings.getVagrantExecutable()) || !this.getInstanceFolder().equals(vagrantProjectSettings.getInstanceFolder()) || !StringUtil.equals((CharSequence)this.getProvider(), (CharSequence)vagrantProjectSettings.getProvider()) || !this.myEnvsEditor.getEnvs().equals(vagrantProjectSettings.getEnvs());
    }

    private String getVagrantPath() {
        return this.myVagrantPathField.getText();
    }

    public void apply() {
        VagrantProjectSettings vagrantProjectSettings = VagrantProjectSettings.getInstance(this.myProject);
        VagrantSettings vagrantSettings = VagrantSettings.getInstance();
        vagrantSettings.setVagrantExecutable(this.getVagrantPath());
        vagrantProjectSettings.setInstanceFolder(this.getInstanceFolder());
        vagrantProjectSettings.setProvider(this.getProvider());
        vagrantProjectSettings.setEnvs(Maps.newHashMap((Map)this.myEnvsEditor.getEnvs()));
    }

    private String getInstanceFolder() {
        return this.myInstanceFolderField.getText();
    }

    public void reset() {
        VagrantProjectSettings vagrantProjectSettings = VagrantProjectSettings.getInstance(this.myProject);
        VagrantSettings vagrantSettings = VagrantSettings.getInstance();
        String vagrantPath = vagrantSettings.getVagrantExecutable();
        this.setVagrantPath(vagrantPath);
        String instanceFolder = vagrantProjectSettings.getInstanceFolder();
        this.setInstanceFolder(instanceFolder);
        String provider = vagrantProjectSettings.getProvider();
        this.setProvider(provider);
        this.myEnvsEditor.setEnvs((Map)Maps.newHashMap(vagrantProjectSettings.getEnvs()));
        if (StringUtil.isEmpty((String)vagrantPath) && (vagrantPath = VagrantService.getInstance().detectVagrantExecutable()) != null) {
            this.setVagrantPath(vagrantPath);
        }
        if (StringUtil.isEmpty((String)instanceFolder) && (instanceFolder = VagrantManager.getInstance(this.myProject).detectInstanceInCurrentProject()) != null) {
            this.setInstanceFolder(instanceFolder);
        }
    }

    private void setVagrantPath(String valueToUse) {
        this.myVagrantPathField.setText(valueToUse);
    }

    @NotNull
    public String getHelpTopic() {
        if (HELP_TOPIC == null) {
            VagrantConfigurable.$$$reportNull$$$0(2);
        }
        return HELP_TOPIC;
    }

    public void setInstanceFolder(String instanceFolder) {
        this.myInstanceFolderField.setText(instanceFolder);
    }

    public void setProvider(String provider) {
        this.myProviderField.getEditor().setItem(provider);
    }

    @Nullable
    public String getProvider() {
        return (String)this.myProviderField.getEditor().getItem();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/vagrant/VagrantConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/vagrant/VagrantConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JBLabel jBLabel;
        JPanel jPanel3;
        EnvironmentVariablesComponent environmentVariablesComponent;
        JPanel jPanel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel5;
        this.myMainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 2, 0, 3, 6, 3, new Dimension(400, -1), null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Vagrant executable:       ");
        jBLabel2.setDisplayedMnemonic('V');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Instance folder:");
        jBLabel3.setDisplayedMnemonic('F');
        jBLabel3.setDisplayedMnemonicIndex(9);
        jPanel6.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVagrantPathField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton2.setToolTipText("Enter here a path to vagrant executable");
        jPanel6.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myInstanceFolderField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setToolTipText("Enter here a path to the folder where Vagrantfile is(or will be) placed ");
        jPanel6.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Provider:");
        jBLabel4.setDisplayedMnemonic('P');
        jBLabel4.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProviderPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setToolTipText("");
        jPanel6.add((Component)jPanel4, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myEnvsEditor = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setLabelLocation("West");
        environmentVariablesComponent.setPassParentEnvs(false);
        environmentVariablesComponent.setText("&Environment variables");
        jPanel6.add((Component)environmentVariablesComponent, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myErrorPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myErrorLabel = jBLabel = new JBLabel();
        jBLabel.setForeground(Color.red);
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel5.add((Component)jTabbedPane, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        this.myBoxesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("Boxes", null, jPanel2, null);
        this.myPluginsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("Plugins", null, jPanel, null);
        environmentVariablesComponent.setAnchor((JComponent)jBLabel2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class VagrantPluginsPanel
    extends VagrantItemListPanel<VagrantPlugin> {
        private final VagrantPluginManager myPluginManager;

        VagrantPluginsPanel(@NotNull Project project, @NotNull VagrantPluginManager model) {
            if (project == null) {
                VagrantPluginsPanel.$$$reportNull$$$0(0);
            }
            if (model == null) {
                VagrantPluginsPanel.$$$reportNull$$$0(1);
            }
            super(project, model);
            this.myPluginManager = model;
            this.initPanel();
        }

        @Override
        protected String deleteConfirmationTitle() {
            return "Uninstall Plugin";
        }

        @Override
        protected String deleteConfirmation(VagrantPlugin plugin) {
            return "Do you really want to uninstall plugin '" + plugin.getName() + "'?";
        }

        @Override
        protected String firstColumn() {
            return "Name";
        }

        @Override
        protected String secondColumn() {
            return "Version";
        }

        @Override
        protected String emptyListText() {
            return "No plugins installed.";
        }

        @Override
        protected ToolbarDecorator createToolbarDecorator() {
            return super.createToolbarDecorator().addExtraAction((AnActionButton)new UpdateAction()).addExtraAction((AnActionButton)new AddLicenseAction());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/plugins/vagrant/VagrantConfigurable$VagrantPluginsPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class UpdateAction
        extends AnActionButton {
            private UpdateAction() {
                super("Update", AllIcons.Javaee.UpdateRunningApplication);
                this.addCustomUpdater(e -> VagrantPluginsPanel.this.getSelectedItem() != null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                VagrantPlugin plugin;
                if (e == null) {
                    UpdateAction.$$$reportNull$$$0(0);
                }
                if ((plugin = (VagrantPlugin)VagrantPluginsPanel.this.getSelectedItem()) != null) {
                    VagrantPluginsPanel.this.myPluginManager.update(plugin);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/vagrant/VagrantConfigurable$VagrantPluginsPanel$UpdateAction", "actionPerformed"));
            }
        }

        private class AddLicenseAction
        extends AnActionButton {
            private AddLicenseAction() {
                super("Attach License", AllIcons.Actions.Annotate);
                this.addCustomUpdater(e -> VagrantPluginsPanel.this.getSelectedItem() != null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                VagrantPlugin plugin;
                if (e == null) {
                    AddLicenseAction.$$$reportNull$$$0(0);
                }
                if ((plugin = (VagrantPlugin)VagrantPluginsPanel.this.getSelectedItem()) != null) {
                    VagrantPluginsPanel.this.myPluginManager.attachLicense(plugin);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/vagrant/VagrantConfigurable$VagrantPluginsPanel$AddLicenseAction", "actionPerformed"));
            }
        }
    }

    private static class VagrantBoxPanel
    extends VagrantItemListPanel<VagrantBox> {
        VagrantBoxPanel(@NotNull Project project, @NotNull VagrantItemsModel<VagrantBox> model) {
            if (project == null) {
                VagrantBoxPanel.$$$reportNull$$$0(0);
            }
            if (model == null) {
                VagrantBoxPanel.$$$reportNull$$$0(1);
            }
            super(project, model);
            this.initPanel();
        }

        @Override
        protected String deleteConfirmationTitle() {
            return "Delete Box";
        }

        @Override
        protected String deleteConfirmation(VagrantBox item) {
            return "Do you really want to delete box '" + item.getName() + "'?";
        }

        @Override
        protected String secondColumn() {
            return "Type";
        }

        @Override
        protected String firstColumn() {
            return "Name";
        }

        @Override
        protected String emptyListText() {
            return "There are no installed boxes";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/plugins/vagrant/VagrantConfigurable$VagrantBoxPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

