/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.sql.Connection;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

public class DerbyJdbcHelper
extends JdbcHelperImpl {
    private static final Set<String> DERBY_UNLIMITED_TYPES = ContainerUtilRt.newHashSet((Object[])new String[]{"integer", "smallint", "bigint", "date", "time", "xml", "timestamp", "boolean", "double", "real", "float", "long varchar", "long varchar for bit data"});

    public DerbyJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(Rdbms.of((String)"DERBY"), version, connection);
    }

    public DerbyJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return DerbyJdbcHelper.extractVersion(version);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            DerbyJdbcHelper.$$$reportNull$$$0(0);
        }
        if (e.typeName == null) {
            return;
        }
        String t = e.typeName.toLowerCase(Locale.ENGLISH);
        if (DERBY_UNLIMITED_TYPES.contains(t) || DEFAULT_UNLIMITED_TYPES.contains(t) && e.length == Integer.MAX_VALUE) {
            e.length = -1;
        }
        DerbyJdbcHelper.processForBitData(e);
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) {
        if (!JdbcNativeUtil.detectString(product, "derby")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return DerbyJdbcHelper.create(delegate, productVer);
    }

    @NotNull
    private static DerbyJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        DerbyJdbcHelper derbyJdbcHelper = new DerbyJdbcHelper(DerbyJdbcHelper.extractVersion(productVer), delegate);
        if (derbyJdbcHelper == null) {
            DerbyJdbcHelper.$$$reportNull$$$0(1);
        }
        return derbyJdbcHelper;
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/DerbyJdbcHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/DerbyJdbcHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

