/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.loop;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSMergeParallelForLoopsIntention
extends JSIntention {
    @NonNls
    private static final String FOR_STATEMENT_PREFIX = "for (";

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        MergeParallelForLoopsPredicate mergeParallelForLoopsPredicate = new MergeParallelForLoopsPredicate();
        if (mergeParallelForLoopsPredicate == null) {
            JSMergeParallelForLoopsIntention.$$$reportNull$$$0(0);
        }
        return mergeParallelForLoopsPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSMergeParallelForLoopsIntention.$$$reportNull$$$0(1);
        }
        PsiElement nextElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
        assert (nextElement != null);
        JSForStatement firstStatement = (JSForStatement)element;
        JSForStatement secondStatement = (JSForStatement)nextElement;
        StringBuilder statementBuffer = new StringBuilder();
        JSMergeParallelForLoopsIntention.mergeForStatements(statementBuffer, firstStatement, secondStatement);
        JSRefactoringUtil.replaceStatementAndReformat((JSStatement)firstStatement, (String)statementBuffer.toString());
        JSRefactoringUtil.removeElementWithLinebreak((PsiElement)secondStatement);
    }

    private static void mergeForStatements(StringBuilder statementBuffer, JSForStatement firstStatement, JSForStatement secondStatement) {
        JSExpression initialization = firstStatement.getInitialization();
        JSVarStatement varStatement = firstStatement.getVarDeclaration();
        JSExpression condition = firstStatement.getCondition();
        JSExpression update = firstStatement.getUpdate();
        JSStatement firstBody = firstStatement.getBody();
        JSStatement secondBody = secondStatement.getBody();
        statementBuffer.append(FOR_STATEMENT_PREFIX).append(initialization == null ? varStatement.getText() : initialization.getText()).append(';').append(condition.getText()).append(';').append(update.getText()).append(')');
        ControlFlowUtils.appendStatementsInSequence((StringBuilder)statementBuffer, (JSStatement)firstBody, (JSStatement)secondBody);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/loop/JSMergeParallelForLoopsIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/loop/JSMergeParallelForLoopsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MergeParallelForLoopsPredicate
    implements JSElementPredicate {
        private MergeParallelForLoopsPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                MergeParallelForLoopsPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSForStatement) || PsiUtilCore.hasErrorElementChild((PsiElement)element)) {
                return false;
            }
            PsiElement nextStatement = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
            if (!(nextStatement instanceof JSForStatement) || PsiUtilCore.hasErrorElementChild((PsiElement)nextStatement)) {
                return false;
            }
            return MergeParallelForLoopsPredicate.forStatementsCanBeMerged((JSForStatement)element, (JSForStatement)nextStatement);
        }

        public static boolean forStatementsCanBeMerged(JSForStatement statement1, JSForStatement statement2) {
            JSExpression secondUpdate;
            JSExpression secondCondition;
            JSVarStatement secondVarStatement;
            JSExpression secondInitialization;
            JSExpression firstInitialization = statement1.getInitialization();
            if (!EquivalenceChecker.expressionsAreEquivalent((JSExpression)firstInitialization, (JSExpression)(secondInitialization = statement2.getInitialization()))) {
                return false;
            }
            JSVarStatement firstVarStatement = statement1.getVarDeclaration();
            if (!EquivalenceChecker.statementsAreEquivalent((JSSourceElement)firstVarStatement, (JSSourceElement)(secondVarStatement = statement2.getVarDeclaration()))) {
                return false;
            }
            JSExpression firstCondition = statement1.getCondition();
            if (!EquivalenceChecker.expressionsAreEquivalent((JSExpression)firstCondition, (JSExpression)(secondCondition = statement2.getCondition()))) {
                return false;
            }
            JSExpression firstUpdate = statement1.getUpdate();
            if (!EquivalenceChecker.expressionsAreEquivalent((JSExpression)firstUpdate, (JSExpression)(secondUpdate = statement2.getUpdate()))) {
                return false;
            }
            JSStatement firstBody = statement1.getBody();
            JSStatement secondBody = statement2.getBody();
            return firstBody == null || secondBody == null || ControlFlowUtils.canBeMerged((JSStatement)firstBody, (JSStatement)secondBody);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/loop/JSMergeParallelForLoopsIntention$MergeParallelForLoopsPredicate", "satisfiedBy"));
        }
    }
}

