/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.application.options.CodeStyle;
import com.intellij.database.Dbms;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.JBIterable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlCodeStyles {
    private static final Map<Language, Class<? extends SqlCodeStyleSettings>> ourDialectSettingsClasses = new ConcurrentHashMap<Language, Class<? extends SqlCodeStyleSettings>>();
    private static SqlLanguageDialect ourGenericDialect = null;
    private static SqlLanguageDialect ourPreviewDialectForGeneric = null;
    @NotNull
    private static final Language ourDefaultDialect = SqlLanguage.INSTANCE;

    public static void registerDialectSettingsClass(@NotNull Language dialect, @NotNull Class<? extends SqlCodeStyleSettings> settingsClass) {
        if (dialect == null) {
            SqlCodeStyles.$$$reportNull$$$0(0);
        }
        if (settingsClass == null) {
            SqlCodeStyles.$$$reportNull$$$0(1);
        }
        ourDialectSettingsClasses.put(dialect, settingsClass);
    }

    public static void registerGenericDialect(@NotNull SqlLanguageDialect dialect, @NotNull SqlLanguageDialect previewDialect) {
        if (dialect == null) {
            SqlCodeStyles.$$$reportNull$$$0(2);
        }
        if (previewDialect == null) {
            SqlCodeStyles.$$$reportNull$$$0(3);
        }
        ourGenericDialect = dialect;
        ourPreviewDialectForGeneric = previewDialect;
    }

    public static JBIterable<SqlLanguageDialect> listSqlDialects() {
        return JBIterable.from(ourDialectSettingsClasses.keySet()).filter(SqlLanguageDialect.class);
    }

    public static SqlLanguageDialect getGenericDialect() {
        return ourGenericDialect;
    }

    public static SqlLanguageDialect getPreviewDialectFor(@Nullable Language language) {
        if (language == null || language == SqlLanguage.INSTANCE || language == SqlCodeStyles.getGenericDialect()) {
            return ourPreviewDialectForGeneric;
        }
        if (language instanceof SqlLanguageDialect) {
            return (SqlLanguageDialect)language;
        }
        return ourPreviewDialectForGeneric;
    }

    @NotNull
    public static Language getSettingsLanguage(@NotNull Language dialect) {
        if (dialect == null) {
            SqlCodeStyles.$$$reportNull$$$0(4);
        }
        if (ourDialectSettingsClasses.containsKey(dialect)) {
            Language language = dialect;
            if (language == null) {
                SqlCodeStyles.$$$reportNull$$$0(5);
            }
            return language;
        }
        if (dialect instanceof SqlLanguageDialect) {
            SqlLanguageDialect d = (SqlLanguageDialect)dialect;
            Dbms dbms = d.getDbms();
            if (dbms.isPostgres()) {
                Language language = SqlLanguageDialect.EP.forDbms(Dbms.POSTGRES);
                if (language == null) {
                    SqlCodeStyles.$$$reportNull$$$0(6);
                }
                return language;
            }
            if (dbms.isOracle()) {
                Language language = SqlLanguageDialect.EP.forDbms(Dbms.ORACLE);
                if (language == null) {
                    SqlCodeStyles.$$$reportNull$$$0(7);
                }
                return language;
            }
            if (dbms.isTransactSql()) {
                Language language = SqlLanguageDialect.EP.forDbms(Dbms.MSSQL);
                if (language == null) {
                    SqlCodeStyles.$$$reportNull$$$0(8);
                }
                return language;
            }
            if (dbms.isMysql()) {
                Language language = SqlLanguageDialect.EP.forDbms(Dbms.MYSQL);
                if (language == null) {
                    SqlCodeStyles.$$$reportNull$$$0(9);
                }
                return language;
            }
        }
        Language language = ourDefaultDialect;
        if (language == null) {
            SqlCodeStyles.$$$reportNull$$$0(10);
        }
        return language;
    }

    @NotNull
    public static Class<? extends SqlCodeStyleSettings> getSettingsClass(@NotNull Language dialect) {
        if (dialect == null) {
            SqlCodeStyles.$$$reportNull$$$0(11);
        }
        Language settingLanguage = SqlCodeStyles.getSettingsLanguage(dialect);
        Class<? extends SqlCodeStyleSettings> settingsClass = ourDialectSettingsClasses.get(settingLanguage);
        assert (settingsClass != null) : "The settings class for the dialect " + dialect.getID() + " is not registered";
        Class<? extends SqlCodeStyleSettings> clazz = settingsClass;
        if (clazz == null) {
            SqlCodeStyles.$$$reportNull$$$0(12);
        }
        return clazz;
    }

    @NotNull
    public static SqlCodeStyleSettings getSqlSettings(@NotNull PsiFile file) {
        if (file == null) {
            SqlCodeStyles.$$$reportNull$$$0(13);
        }
        Language dialect = file.getLanguage();
        CodeStyleSettings settingsContainer = CodeStyle.getSettings((PsiFile)file);
        SqlCodeStyleSettings sqlCodeStyleSettings = SqlCodeStyles.getSqlSettings(settingsContainer, dialect);
        if (sqlCodeStyleSettings == null) {
            SqlCodeStyles.$$$reportNull$$$0(14);
        }
        return sqlCodeStyleSettings;
    }

    @NotNull
    public static SqlCodeStyleSettings getSqlSettings(@Nullable Project project, @NotNull Language dialect) {
        if (dialect == null) {
            SqlCodeStyles.$$$reportNull$$$0(15);
        }
        SqlCodeStyleSettings sqlCodeStyleSettings = SqlCodeStyles.getSqlSettings(SqlCodeStyles.getSettings(project), dialect);
        if (sqlCodeStyleSettings == null) {
            SqlCodeStyles.$$$reportNull$$$0(16);
        }
        return sqlCodeStyleSettings;
    }

    @NotNull
    public static SqlCodeStyleSettings getSqlSettings(@NotNull CodeStyleSettings settingsContainer, @NotNull Language dialect) {
        if (settingsContainer == null) {
            SqlCodeStyles.$$$reportNull$$$0(17);
        }
        if (dialect == null) {
            SqlCodeStyles.$$$reportNull$$$0(18);
        }
        SqlCodeStyleSettings settings = SqlCodeStyles.pickSqlSettings(settingsContainer, dialect);
        if (settings.USE_GENERIC_STYLE) {
            settings = SqlCodeStyles.getGenericSqlSettings(settingsContainer);
        }
        SqlCodeStyleSettings sqlCodeStyleSettings = settings;
        if (sqlCodeStyleSettings == null) {
            SqlCodeStyles.$$$reportNull$$$0(19);
        }
        return sqlCodeStyleSettings;
    }

    @NotNull
    public static SqlCodeStyleSettings pickSqlSettings(@NotNull CodeStyleSettings settingsContainer, @NotNull Language dialect) {
        SqlCodeStyleSettings sqlCodeStyleSettings;
        if (settingsContainer == null) {
            SqlCodeStyles.$$$reportNull$$$0(20);
        }
        if (dialect == null) {
            SqlCodeStyles.$$$reportNull$$$0(21);
        }
        if (!(dialect instanceof SqlLanguageDialect) && !(dialect instanceof SqlLanguage)) {
            SqlCodeStyleSettings sqlCodeStyleSettings2 = SqlCodeStyles.getGenericSqlSettings(settingsContainer);
            if (sqlCodeStyleSettings2 == null) {
                SqlCodeStyles.$$$reportNull$$$0(22);
            }
            return sqlCodeStyleSettings2;
        }
        Language settingLanguage = SqlCodeStyles.getSettingsLanguage(dialect);
        Class<? extends SqlCodeStyleSettings> settingsClass = ourDialectSettingsClasses.get(settingLanguage);
        if (settingsClass == null) {
            throw new IllegalArgumentException("Dialect " + dialect.getID() + " and settings language " + settingLanguage.getID() + " have no corresponding settings class");
        }
        try {
            sqlCodeStyleSettings = (SqlCodeStyleSettings)settingsContainer.getCustomSettings(settingsClass);
        }
        catch (RuntimeException rte) {
            throw new RuntimeException("Failed to get setting " + settingsClass.getSimpleName() + " (dialect: " + dialect.getID() + ")", rte);
        }
        if (sqlCodeStyleSettings == null) {
            SqlCodeStyles.$$$reportNull$$$0(23);
        }
        return sqlCodeStyleSettings;
    }

    @NotNull
    public static SqlCodeStyleSettings getGenericSqlSettings(@Nullable Project project) {
        CodeStyleSettings settingsContainer = SqlCodeStyles.getSettings(project);
        SqlCodeStyleSettings sqlCodeStyleSettings = SqlCodeStyles.getGenericSqlSettings(settingsContainer);
        if (sqlCodeStyleSettings == null) {
            SqlCodeStyles.$$$reportNull$$$0(24);
        }
        return sqlCodeStyleSettings;
    }

    @NotNull
    public static SqlCodeStyleSettings getGenericSqlSettings(@NotNull CodeStyleSettings settingsContainer) {
        if (settingsContainer == null) {
            SqlCodeStyles.$$$reportNull$$$0(25);
        }
        SqlCodeStyleSettings sqlCodeStyleSettings = (SqlCodeStyleSettings)settingsContainer.getCustomSettings(SqlCodeStyleSettings.class);
        if (sqlCodeStyleSettings == null) {
            SqlCodeStyles.$$$reportNull$$$0(26);
        }
        return sqlCodeStyleSettings;
    }

    @NotNull
    public static CodeStyleSettings getSettings(@Nullable Project project) {
        CodeStyleSettings codeStyleSettings = project != null ? CodeStyle.getSettings((Project)project) : CodeStyle.getDefaultSettings();
        if (codeStyleSettings == null) {
            SqlCodeStyles.$$$reportNull$$$0(27);
        }
        return codeStyleSettings;
    }

    public static JBIterable<? extends Language> getSettingsDialects() {
        return JBIterable.of((Object)ourDefaultDialect).append((Iterable)JBIterable.from(ourDialectSettingsClasses.keySet()).filter(SqlLanguageDialect.class).filter(d -> d != ourDefaultDialect));
    }

    static void copySettings(@NotNull SqlCodeStyleSettings source, @NotNull SqlCodeStyleSettings target) {
        CommonCodeStyleSettings targetCommonSettings;
        if (source == null) {
            SqlCodeStyles.$$$reportNull$$$0(28);
        }
        if (target == null) {
            SqlCodeStyles.$$$reportNull$$$0(29);
        }
        if (source == target) {
            return;
        }
        CommonCodeStyleSettings sourceCommonSettings = source.getCorrespondedCommonSettings();
        if (sourceCommonSettings != (targetCommonSettings = target.getCorrespondedCommonSettings())) {
            targetCommonSettings.copyFrom(sourceCommonSettings);
        }
        Field[] fieldsToCopy = (Field[])JBIterable.of((Object[])SqlCodeStyleSettings.class.getDeclaredFields()).filter(f -> Modifier.isPublic(f.getModifiers()) && !Modifier.isStatic(f.getModifiers()) && Character.isUpperCase(f.getName().charAt(0)) && !f.isAnnotationPresent(Deprecated.class) && !target.isSettingHidden(f.getName())).toArray((Object[])new Field[0]);
        ReflectionUtil.copyFields((Field[])fieldsToCopy, (Object)source, (Object)target);
        target.myVersion = source.myVersion;
        target.myInitialized = source.myInitialized;
    }

    static {
        ourDialectSettingsClasses.put(ourDefaultDialect, SqlCodeStyleSettings.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDialect";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/settings/SqlCodeStyles";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsContainer";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/settings/SqlCodeStyles";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsLanguage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsClass";
                break;
            }
            case 14: 
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlSettings";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "pickSqlSettings";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericSqlSettings";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerDialectSettingsClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerGenericDialect";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsLanguage";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsClass";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSqlSettings";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "pickSqlSettings";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getGenericSqlSettings";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "copySettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

