/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.model.Image;
import com.intellij.docker.agent.DockerAgentApplicationBase;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.DockerAgentImpl;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.agent.progress.DockerProgressDetailsFormat;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DockerAgentImageImpl
extends DockerAgentApplicationBase {
    private final Image myImage;

    DockerAgentImageImpl(@NotNull DockerAgentContext agentContext, @NotNull Image image) {
        if (agentContext == null) {
            DockerAgentImageImpl.$$$reportNull$$$0(0);
        }
        if (image == null) {
            DockerAgentImageImpl.$$$reportNull$$$0(1);
        }
        super(agentContext);
        this.myImage = image;
    }

    @Nullable
    public String getPresentableName() {
        String[] repoTags = this.myImage.getRepoTags();
        if (repoTags != null && repoTags.length != 0 && !DockerAgentImageImpl.containsNone(repoTags)) {
            return DockerAgentImpl.appendAll(new StringBuilder(), this.myImage.getRepoTags()).toString();
        }
        return DockerUtil.shortedId((String)this.myImage.getId());
    }

    @NotNull
    public String getUniqueName() {
        String string = this.getImageId();
        if (string == null) {
            DockerAgentImageImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String getName() {
        return this.getUniqueName();
    }

    public String getContainerName() {
        return null;
    }

    public String getImageName() {
        return this.getName();
    }

    public String getImageId() {
        return this.myImage.getId();
    }

    public String[] getImageRepoTags() {
        String[] result = this.myImage.getRepoTags();
        return result == null ? new String[]{} : result;
    }

    public String[] getContainerNames() {
        return null;
    }

    public String getImageParentId() {
        return this.myImage.getParentId();
    }

    public String getAgentApplicationStatus() {
        String createdPiece = Optional.ofNullable(this.myImage.getCreated()).map(secondsSinceTimeStart -> DockerUtil.formatDuration((long)(System.currentTimeMillis() / 1000L - secondsSinceTimeStart))).orElse("");
        String sizePiece = Optional.ofNullable(this.myImage.getVirtualSize()).map(bytes -> DockerProgressDetailsFormat.humanSizeBytes((double)bytes.longValue())).orElse("");
        return Stream.of(createdPiece, sizePiece).filter(text -> !text.isEmpty()).collect(Collectors.joining(" / "));
    }

    private static boolean containsNone(String ... items) {
        for (String tag : items) {
            if (!tag.contains("<none>")) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/agent/DockerAgentImageImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/agent/DockerAgentImageImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

