/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.netty;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.async.ResultCallbackTemplate;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.InvocationBuilder;
import com.github.dockerjava.core.MediaType;
import com.github.dockerjava.netty.ChannelProvider;
import com.github.dockerjava.netty.NettyInvocationBuilder;
import com.github.dockerjava.netty.handler.FramedResponseStreamHandler;
import com.github.dockerjava.netty.handler.HttpRequestProvider;
import com.github.dockerjava.netty.handler.HttpResponseHandler;
import com.github.dockerjava.netty.handler.HttpResponseStreamHandler;
import com.github.dockerjava.netty.handler.JsonResponseCallbackHandler;
import com.intellij.docker.agent.fix.FixedHttpConnectionHijackHandler;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.socket.DuplexChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.json.JsonObjectDecoder;
import io.netty.handler.stream.ChunkedStream;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

class NettyInvocationBuilderCopy
extends NettyInvocationBuilder {
    private final ChannelProvider channelProvider;
    private final String resource;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final ObjectMapper objectMapper;

    @Deprecated
    public NettyInvocationBuilderCopy(ChannelProvider channelProvider, String resource) {
        this(DefaultDockerClientConfig.createDefaultConfigBuilder().build().getObjectMapper(), channelProvider, resource);
    }

    public NettyInvocationBuilderCopy(ObjectMapper objectMapper2, ChannelProvider channelProvider, String resource) {
        super(channelProvider, resource);
        this.objectMapper = objectMapper2;
        this.channelProvider = channelProvider;
        this.resource = resource;
    }

    public NettyInvocationBuilder accept(MediaType mediaType) {
        return this.header(HttpHeaderNames.ACCEPT.toString(), mediaType.getMediaType());
    }

    public NettyInvocationBuilder header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public void delete() {
        HttpRequestProvider requestProvider = this.httpDeleteRequestProvider();
        ResponseCallback callback = new ResponseCallback();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, callback);
        DuplexChannel channel = this.getChannel();
        channel.pipeline().addLast(new ChannelHandler[]{responseHandler});
        this.sendRequest(requestProvider, (Channel)channel);
        callback.awaitResult();
    }

    public void get(ResultCallback<Frame> resultCallback) {
        HttpRequestProvider requestProvider = this.httpGetRequestProvider();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        FramedResponseStreamHandler streamHandler = new FramedResponseStreamHandler(resultCallback);
        DuplexChannel channel = this.getChannel();
        channel.pipeline().addLast(new ChannelHandler[]{responseHandler});
        channel.pipeline().addLast(new ChannelHandler[]{streamHandler});
        this.sendRequest(requestProvider, (Channel)channel);
    }

    public <T> T get(TypeReference<T> typeReference) {
        ResponseCallback callback = new ResponseCallback();
        this.get(typeReference, (ResultCallback<T>)callback);
        return callback.awaitResult();
    }

    public <T> void get(TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
        HttpRequestProvider requestProvider = this.httpGetRequestProvider();
        DuplexChannel channel = this.getChannel();
        JsonResponseCallbackHandler jsonResponseHandler = new JsonResponseCallbackHandler(this.objectMapper, typeReference, resultCallback);
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        channel.pipeline().addLast(new ChannelHandler[]{responseHandler});
        channel.pipeline().addLast(new ChannelHandler[]{this.createJsonObjectDecoder()});
        channel.pipeline().addLast(new ChannelHandler[]{jsonResponseHandler});
        this.sendRequest(requestProvider, (Channel)channel);
    }

    protected ByteToMessageDecoder createJsonObjectDecoder() {
        return new JsonObjectDecoder(0x300000);
    }

    protected final DuplexChannel getChannel() {
        return this.channelProvider.getChannel();
    }

    protected final HttpRequestProvider httpDeleteRequestProvider() {
        return this::prepareDeleteRequest;
    }

    protected final HttpRequestProvider httpGetRequestProvider() {
        return this::prepareGetRequest;
    }

    protected final HttpRequestProvider httpPostRequestProvider(Object entity) {
        return uri -> this.preparePostRequest(uri, entity);
    }

    protected final HttpRequestProvider httpPutRequestProvider(Object entity) {
        return uri -> this.preparePutRequest(uri, entity);
    }

    public InputStream post(Object entity) {
        HttpRequestProvider requestProvider = this.httpPostRequestProvider(entity);
        DuplexChannel channel = this.getChannel();
        InvocationBuilder.AsyncResultCallback callback = new InvocationBuilder.AsyncResultCallback();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, (ResultCallback)callback);
        HttpResponseStreamHandler streamHandler = new HttpResponseStreamHandler((ResultCallback)callback);
        channel.pipeline().addLast(new ChannelHandler[]{responseHandler});
        channel.pipeline().addLast(new ChannelHandler[]{streamHandler});
        this.sendRequest(requestProvider, (Channel)channel);
        return (InputStream)callback.awaitResult();
    }

    public void post(Object entity, final InputStream stdin, ResultCallback<Frame> resultCallback) {
        HttpRequestProvider requestProvider = this.httpPostRequestProvider(entity);
        FramedResponseStreamHandler streamHandler = new FramedResponseStreamHandler(resultCallback);
        final DuplexChannel channel = this.getChannel();
        channel.closeFuture().addListener(future -> resultCallback.onComplete());
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        FixedHttpConnectionHijackHandler hijackHandler = new FixedHttpConnectionHijackHandler((ChannelInboundHandler)responseHandler);
        HttpClientCodec httpClientCodec = (HttpClientCodec)channel.pipeline().get(HttpClientCodec.class);
        channel.pipeline().addLast(new ChannelHandler[]{new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)httpClientCodec, (HttpClientUpgradeHandler.UpgradeCodec)hijackHandler, Integer.MAX_VALUE)});
        channel.pipeline().addLast(new ChannelHandler[]{streamHandler});
        this.sendRequest(requestProvider, (Channel)channel);
        hijackHandler.awaitUpgrade();
        if (stdin != null) {
            new Thread(new Runnable(){

                private int read(InputStream is, byte[] buf) {
                    try {
                        return is.read(buf);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void run() {
                    int read;
                    byte[] buffer = new byte[1024];
                    while ((read = this.read(stdin, buffer)) != -1) {
                        channel.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])buffer, (int)0, (int)read));
                    }
                    channel.shutdownOutput();
                }
            }, "NettyInvocationBuilderCopy " + entity).start();
        }
    }

    public <T> T post(Object entity, TypeReference<T> typeReference) {
        ResponseCallback callback = new ResponseCallback();
        this.post(entity, typeReference, (ResultCallback<T>)callback);
        return callback.awaitResult();
    }

    public <T> void post(Object entity, TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
        HttpRequestProvider requestProvider = this.httpPostRequestProvider(entity);
        DuplexChannel channel = this.getChannel();
        JsonResponseCallbackHandler jsonResponseHandler = new JsonResponseCallbackHandler(this.objectMapper, typeReference, resultCallback);
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        channel.pipeline().addLast(new ChannelHandler[]{responseHandler});
        channel.pipeline().addLast(new ChannelHandler[]{this.createJsonObjectDecoder()});
        channel.pipeline().addLast(new ChannelHandler[]{jsonResponseHandler});
        this.sendRequest(requestProvider, (Channel)channel);
    }

    private HttpRequest prepareDeleteRequest(String uri) {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.DELETE, uri);
        this.setDefaultHeaders((HttpRequest)request);
        return request;
    }

    private FullHttpRequest prepareGetRequest(String uri) {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri);
        this.setDefaultHeaders((HttpRequest)request);
        return request;
    }

    private HttpRequest preparePostRequest(String uri, Object entity) {
        return this.prepareEntityRequest(uri, entity, HttpMethod.POST);
    }

    private HttpRequest preparePutRequest(String uri, Object entity) {
        return this.prepareEntityRequest(uri, entity, HttpMethod.PUT);
    }

    private HttpRequest prepareEntityRequest(String uri, Object entity, HttpMethod httpMethod) {
        DefaultHttpRequest request = null;
        if (entity != null) {
            byte[] bytes;
            DefaultFullHttpRequest fullRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, httpMethod, uri);
            try {
                bytes = this.objectMapper.writeValueAsBytes(entity);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            fullRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
            fullRequest.content().clear().writeBytes(Unpooled.copiedBuffer((byte[])bytes));
            fullRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)bytes.length);
            request = fullRequest;
        } else {
            request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, httpMethod, uri);
            request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        }
        this.setDefaultHeaders((HttpRequest)request);
        return request;
    }

    protected void sendRequest(HttpRequestProvider requestProvider, Channel channel) {
        ChannelFuture channelFuture = channel.writeAndFlush((Object)requestProvider.getHttpRequest(this.resource));
        channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {}));
    }

    private void setDefaultHeaders(HttpRequest request) {
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)"");
        request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        request.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP);
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            request.headers().set((CharSequence)entry.getKey(), (Object)entry.getValue());
        }
    }

    public <T> T post(TypeReference<T> typeReference, InputStream body) {
        ResponseCallback callback = new ResponseCallback();
        this.post(typeReference, (ResultCallback<T>)callback, body);
        return callback.awaitResult();
    }

    public <T> void post(TypeReference<T> typeReference, ResultCallback<T> resultCallback, InputStream body) {
        HttpRequestProvider requestProvider = this.httpPostRequestProvider(null);
        DuplexChannel channel = this.getChannel();
        JsonResponseCallbackHandler jsonResponseHandler = new JsonResponseCallbackHandler(this.objectMapper, typeReference, resultCallback);
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        channel.pipeline().addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        channel.pipeline().addLast(new ChannelHandler[]{responseHandler});
        channel.pipeline().addLast(new ChannelHandler[]{this.createJsonObjectDecoder()});
        channel.pipeline().addLast(new ChannelHandler[]{jsonResponseHandler});
        this.postChunkedStreamRequest(requestProvider, (Channel)channel, body);
    }

    public void postStream(InputStream body) {
        SkipResultCallback resultCallback = new SkipResultCallback();
        HttpRequestProvider requestProvider = this.httpPostRequestProvider(null);
        DuplexChannel channel = this.getChannel();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, (ResultCallback)resultCallback);
        channel.pipeline().addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        channel.pipeline().addLast(new ChannelHandler[]{responseHandler});
        this.postChunkedStreamRequest(requestProvider, (Channel)channel, body);
        try {
            resultCallback.awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void postChunkedStreamRequest(HttpRequestProvider requestProvider, Channel channel, InputStream body) {
        HttpRequest request = requestProvider.getHttpRequest(this.resource);
        if (request instanceof FullHttpRequest) {
            throw new DockerClientException("fatal: request is instance of FullHttpRequest");
        }
        request.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        request.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        channel.write((Object)request);
        channel.write((Object)new ChunkedStream((InputStream)new BufferedInputStream(body, 0x100000), 0x100000));
        channel.write((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        channel.flush();
    }

    public InputStream get() {
        HttpRequestProvider requestProvider = this.httpGetRequestProvider();
        DuplexChannel channel = this.getChannel();
        InvocationBuilder.AsyncResultCallback resultCallback = new InvocationBuilder.AsyncResultCallback();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, (ResultCallback)resultCallback);
        HttpResponseStreamHandler streamHandler = new HttpResponseStreamHandler((ResultCallback)resultCallback);
        channel.pipeline().addLast(new ChannelHandler[]{responseHandler});
        channel.pipeline().addLast(new ChannelHandler[]{streamHandler});
        this.sendRequest(requestProvider, (Channel)channel);
        return (InputStream)resultCallback.awaitResult();
    }

    public void put(InputStream body, MediaType mediaType) {
        HttpRequestProvider requestProvider = this.httpPutRequestProvider(null);
        DuplexChannel channel = this.getChannel();
        ResponseCallback resultCallback = new ResponseCallback();
        HttpResponseHandler responseHandler = new HttpResponseHandler(requestProvider, resultCallback);
        channel.pipeline().addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        channel.pipeline().addLast(new ChannelHandler[]{responseHandler});
        HttpRequest request = requestProvider.getHttpRequest(this.resource);
        if (request instanceof FullHttpRequest) {
            throw new DockerClientException("fatal: request is instance of FullHttpRequest");
        }
        request.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        request.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mediaType.getMediaType());
        channel.write((Object)request);
        channel.write((Object)new ChunkedStream((InputStream)new BufferedInputStream(body, 0x100000)));
        channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        resultCallback.awaitResult();
    }

    protected final String getResource() {
        return this.resource;
    }

    public static class SkipResultCallback
    extends ResultCallbackTemplate<ResponseCallback<Void>, Void> {
        public void onNext(Void object) {
        }
    }

    public static class ResponseCallback<T>
    extends ResultCallbackTemplate<ResponseCallback<T>, T> {
        private T result = null;

        public T awaitResult() {
            try {
                this.awaitCompletion();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return this.result;
        }

        public void onNext(T object) {
            this.result = object;
        }
    }
}

