/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerBase;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class FindUsagesCommand
extends AbstractCommand {
    public static final String PREFIX = "%findUsages";
    private final Project myProject;

    public FindUsagesCommand(String text, int line, @NotNull Project project) {
        if (project == null) {
            FindUsagesCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
        this.myProject = project;
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
            if (editor != null) {
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
                if (psiFile != null) {
                    int offset = editor.getCaretModel().getOffset();
                    PsiElement[] elements = GotoDeclarationAction.findTargetElementsNoVS((Project)this.myProject, (Editor)editor, (int)offset, (boolean)true);
                    PsiElement element = elements != null && elements.length > 0 ? elements[0] : PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(offset), PsiNamedElement.class);
                    if (element != null) {
                        String elementText = element.getText().substring(0, element.getText().indexOf(")") + 1);
                        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)this.myProject)).getFindUsagesManager();
                        FindUsagesHandler handler = findUsagesManager.getFindUsagesHandler(element, FindUsagesHandlerFactory.OperationMode.USAGES_WITH_DEFAULT_OPTIONS);
                        if (handler != null) {
                            FindUsagesOptions findUsagesOptions = new FindUsagesOptions(this.myProject);
                            findUsagesOptions.isUsages = true;
                            findUsagesOptions.isSearchForTextOccurrences = false;
                            findUsagesOptions.searchScope = GlobalSearchScope.allScope((Project)this.myProject);
                            AtomicInteger totalUsages = new AtomicInteger();
                            Processor incrementTotal = __ -> {
                                totalUsages.incrementAndGet();
                                return true;
                            };
                            FindUsagesManager.startProcessUsages((FindUsagesHandlerBase)handler, (PsiElement[])handler.getPrimaryElements(), (PsiElement[])handler.getSecondaryElements(), (Processor)incrementTotal, (FindUsagesOptions)findUsagesOptions, () -> {
                                context.message("Total Usages for " + elementText + ": " + totalUsages.get(), this.getLine());
                                actionCallback.setDone();
                            });
                        } else {
                            actionCallback.reject("No find usage handler found for the element:" + element.getText());
                        }
                    } else {
                        actionCallback.reject("Can't find an element under " + offset + " offset.");
                    }
                } else {
                    actionCallback.reject("Psi File is not found");
                }
            } else {
                actionCallback.reject("The action invoked without editor");
            }
        });
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/performancePlugin/commands/FindUsagesCommand", "<init>"));
    }
}

