/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.actions.ExportHTMLAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class InspectionCommandEx
extends AbstractCommand {
    public static final String PREFIX = "%InspectCodeEx";
    private static final Logger LOGGER = Logger.getInstance(InspectionCommandEx.class);
    private final Project myProject;
    private final Options myOptions;

    public InspectionCommandEx(@NotNull String text, int line, @NotNull Project project) {
        if (text == null) {
            InspectionCommandEx.$$$reportNull$$$0(0);
        }
        if (project == null) {
            InspectionCommandEx.$$$reportNull$$$0(1);
        }
        super(text, line);
        this.myOptions = new Options();
        this.myProject = project;
        if (text.startsWith(PREFIX)) {
            Args.parse((Object)this.myOptions, (String[])text.substring(PREFIX.length()).trim().split(" "));
        }
    }

    @NotNull
    protected Promise<Object> _execute(final @NotNull PlaybackContext context) {
        PsiDirectory psiDirectory;
        VirtualFile directory;
        if (context == null) {
            InspectionCommandEx.$$$reportNull$$$0(2);
        }
        final ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        if (StringUtil.isNotEmpty((String)this.myOptions.downloadFileUrl)) {
            if (StringUtil.isEmpty((String)this.myOptions.toolShortName)) {
                LOGGER.error("myOptions.toolShortName cannot be null if you want to download file for test");
            }
            InspectionCommandEx.downloadTestRequiredFile(this.myOptions.toolShortName, this.myOptions.downloadFileUrl);
        }
        InspectionManagerEx inspectionManagerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)this.myProject);
        InspectionProfileManager profileManager = InspectionProfileManager.getInstance((Project)this.myProject);
        InspectionProfileImpl profile = profileManager.getCurrentProfile();
        if (StringUtil.isNotEmpty((String)this.myOptions.toolShortName)) {
            profile.disableAllTools(this.myProject);
            profile.enableTool(this.myOptions.toolShortName, this.myProject);
        }
        final List enabledInspectionTools = profile.getAllEnabledInspectionTools(this.myProject);
        if (!ArrayUtil.isEmpty((Object[])this.myOptions.inspectionTrueFields)) {
            InspectionCommandEx.setInspectionFields(enabledInspectionTools, this.myOptions.inspectionTrueFields, true);
        }
        if (!ArrayUtil.isEmpty((Object[])this.myOptions.inspectionFalseFields)) {
            InspectionCommandEx.setInspectionFields(enabledInspectionTools, this.myOptions.inspectionFalseFields, false);
        }
        NamedScope namedScope = NamedScopesHolder.getScope((Project)this.myProject, (String)this.myOptions.scopeName);
        AnalysisScope analysisScope = null;
        if (namedScope != null) {
            analysisScope = new AnalysisScope((SearchScope)GlobalSearchScopesCore.filterScope((Project)this.myProject, (NamedScope)namedScope), this.myProject);
        } else if (StringUtil.isNotEmpty((String)this.myOptions.directory) && (directory = VfsUtil.findRelativeFile((VirtualFile)ProjectUtil.guessProjectDir((Project)this.myProject), (String[])new String[]{this.myOptions.directory})) != null && (psiDirectory = (PsiDirectory)ReadAction.compute(() -> PsiManager.getInstance((Project)this.myProject).findDirectory(directory))) != null) {
            analysisScope = new AnalysisScope(psiDirectory);
        }
        if (analysisScope == null) {
            analysisScope = new AnalysisScope(this.myProject);
        }
        GlobalInspectionContextImpl inspectionContext = new GlobalInspectionContextImpl(this.myProject, inspectionManagerEx.getContentManager()){

            protected void notifyInspectionsFinished(@NotNull AnalysisScope scope) {
                if (scope == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.notifyInspectionsFinished(scope);
                context.message(PerformanceTestingBundle.message("command.inspection.finish", new Object[0]), InspectionCommandEx.this.getLine());
                if (enabledInspectionTools.size() == 1) {
                    try {
                        File tempDirectory = FileUtil.createTempDirectory((String)"inspection", (String)"result");
                        ExportHTMLAction.dumpToXml((Path)tempDirectory.toPath(), (InspectionResultsView)this.getView());
                        File[] files = tempDirectory.listFiles();
                        if (files != null) {
                            for (File file : files) {
                                if (file.isHidden()) continue;
                                String identifier = InspectionCommandEx.this.buildIdentifier(file.getName(), ((InspectionCommandEx)InspectionCommandEx.this).myOptions.inspectionTrueFields);
                                Path path = file.toPath();
                                long warningCount = Files.lines(path).filter(line -> line.contains("<problem>")).count();
                                InspectionCommandEx.reportStatisticsToTeamCity(identifier, String.valueOf(warningCount));
                                InspectionCommandEx.saveArtifact(path, identifier);
                            }
                        } else {
                            LOGGER.error("tempDirectory.listFiles() is null");
                        }
                    }
                    catch (IOException ex) {
                        LOGGER.error((Throwable)ex);
                    }
                }
                actionCallback.setDone();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/performancePlugin/commands/InspectionCommandEx$1", "notifyInspectionsFinished"));
            }
        };
        inspectionContext.setExternalProfile(profile);
        inspectionContext.doInspections(analysisScope);
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            InspectionCommandEx.$$$reportNull$$$0(3);
        }
        return promise;
    }

    private static void saveArtifact(@NotNull Path path, @NotNull String identifier) {
        File dest;
        File destDir;
        if (path == null) {
            InspectionCommandEx.$$$reportNull$$$0(4);
        }
        if (identifier == null) {
            InspectionCommandEx.$$$reportNull$$$0(5);
        }
        if (!(destDir = (dest = new File("../../../report/incorrect-resolves/" + identifier + ".xml")).getParentFile()).exists() && !destDir.mkdirs()) {
            LOGGER.error("Haven't managed to create directory: " + destDir.getAbsolutePath());
        }
        try {
            Files.move(path, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
            LOGGER.info("Incorrect resolve artifact saved to " + dest.getAbsolutePath());
        }
        catch (IOException e) {
            LOGGER.error("Cannot save artifact: " + identifier);
            LOGGER.error((Throwable)e);
        }
    }

    private static void setInspectionFields(@NotNull List<Tools> enabledInspectionTools, String @NotNull [] fieldNames, boolean flag) {
        if (enabledInspectionTools == null) {
            InspectionCommandEx.$$$reportNull$$$0(6);
        }
        if (fieldNames == null) {
            InspectionCommandEx.$$$reportNull$$$0(7);
        }
        if (enabledInspectionTools.size() == 1) {
            InspectionProfileEntry inspection = enabledInspectionTools.get(0).getTool().getTool();
            Class<?> inspectionClass = inspection.getClass();
            for (String inspectionFieldName : fieldNames) {
                try {
                    Field field = inspectionClass.getField(inspectionFieldName);
                    field.setBoolean(inspection, flag);
                }
                catch (NoSuchFieldException e) {
                    LOGGER.error((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LOGGER.error((Throwable)e);
                }
            }
        } else {
            LOGGER.error("Cannot set true flags for more than one inspection");
        }
    }

    private static void downloadTestRequiredFile(@NotNull String toolShortName, @NotNull String downloadUrl) {
        if (toolShortName == null) {
            InspectionCommandEx.$$$reportNull$$$0(8);
        }
        if (downloadUrl == null) {
            InspectionCommandEx.$$$reportNull$$$0(9);
        }
        String tempDirectory = FileUtil.getTempDirectory();
        String filename = toolShortName + ".txt";
        File prev = Paths.get(tempDirectory, filename).toFile();
        if (prev.exists()) {
            prev.delete();
        }
        DownloadableFileService service = DownloadableFileService.getInstance();
        DownloadableFileDescription description = service.createFileDescription(downloadUrl, filename);
        FileDownloader downloader = service.createDownloader(Collections.singletonList(description), "Download correct resolves file");
        try {
            downloader.download(new File(tempDirectory));
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
        if (!Paths.get(tempDirectory, filename).toFile().exists()) {
            LOGGER.error("Downloaded file doesn't exist");
        }
    }

    @NotNull
    private String buildIdentifier(@NotNull String inspectionResultFilename, String @Nullable [] inspectionTrueFields) {
        if (inspectionResultFilename == null) {
            InspectionCommandEx.$$$reportNull$$$0(10);
        }
        String string = ((StreamEx)StreamEx.of((Object[])new String[]{this.myProject.getName(), StringUtil.trimExtensions((String)inspectionResultFilename), ArrayUtil.isEmpty((Object[])inspectionTrueFields) ? null : StringUtil.join((String[])inspectionTrueFields, (String)"-"), "warning-count"}).filter(Objects::nonNull)).joining((CharSequence)"-");
        if (string == null) {
            InspectionCommandEx.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static void reportStatisticsToTeamCity(@NotNull String key, @NotNull String value) {
        if (key == null) {
            InspectionCommandEx.$$$reportNull$$$0(12);
        }
        if (value == null) {
            InspectionCommandEx.$$$reportNull$$$0(13);
        }
        System.out.println("Report statistics key = " + key + " value = " + value);
        System.out.println("##teamcity[buildStatisticValue key='" + key + "' value='" + value + "']");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/InspectionCommandEx";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledInspectionTools";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldNames";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolShortName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadUrl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionResultFilename";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/InspectionCommandEx";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 3: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveArtifact";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setInspectionFields";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "downloadTestRequiredFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildIdentifier";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reportStatisticsToTeamCity";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Options {
        @Argument
        @Nullable
        public String scopeName;
        @Argument
        @Nullable
        public String toolShortName;
        @Argument
        public String @Nullable [] inspectionTrueFields;
        @Argument
        public String @Nullable [] inspectionFalseFields;
        @Argument
        @Nullable
        public String downloadFileUrl;
        @Argument
        @Nullable
        public String directory;
    }
}

