/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.tracing.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableViewSpeedSearch;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.jetbrains.performancePlugin.tracing.ui.DataById;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataByIdTableModel<Data>
extends ListTableModel<String> {
    private final DataById<Data> myDataById;
    private final ColumnInfo<String, ?>[] myColumns;
    private final SpeedSearchComparator comparator = new SpeedSearchComparator(false);
    private String currentPattern = "";

    public DataByIdTableModel(DataById<Data> dataById, ColumnInfo<String, ?> ... columns) {
        super(columns);
        this.myDataById = dataById;
        this.myColumns = columns;
    }

    public void clear() {
        this.myDataById.clear();
        this.setItems(new ArrayList());
    }

    public void refresh(List<Data> newData) {
        String pattern = this.currentPattern;
        Predicate<String> currentFilter = text -> pattern.isEmpty() || this.comparator.matchingDegree(pattern, text) > 0;
        this.refresh(newData, currentFilter);
    }

    private void refresh(List<Data> newData, Predicate<String> filter) {
        this.myDataById.refresh(newData);
        for (int idx = this.getRowCount() - 1; idx >= 0; --idx) {
            String id2 = (String)this.getRowValue(idx);
            if (this.myDataById.getData(id2) != null && this.matches(filter, id2)) continue;
            this.removeRow(idx);
        }
        this.myDataById.forEachId(id -> {
            if (this.matches(filter, (String)id)) {
                int index = this.indexOf(id);
                if (index < 0) {
                    this.addRow(id);
                } else {
                    this.fireTableRowsUpdated(index, index);
                }
            }
        });
    }

    public TableView<String> createTable() {
        TableView tableView = new TableView((ListTableModel)this);
        this.registerSpeedSearch((TableView<String>)tableView);
        return tableView;
    }

    private void registerSpeedSearch(TableView<String> table) {
        TableViewSpeedSearch<String> search = new TableViewSpeedSearch<String>(table){

            @Nullable
            protected String getItemText(@NotNull String id) {
                if (id == null) {
                    1.$$$reportNull$$$0(0);
                }
                return DataByIdTableModel.this.getRowText(id);
            }

            protected void onSearchFieldUpdated(String pattern) {
                DataByIdTableModel.this.currentPattern = pattern;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/performancePlugin/tracing/ui/DataByIdTableModel$1", "getItemText"));
            }
        };
        table.addFocusListener(new FocusListener((TableViewSpeedSearch)search){
            final /* synthetic */ TableViewSpeedSearch val$search;
            {
                this.val$search = tableViewSpeedSearch;
            }

            @Override
            public void focusGained(FocusEvent e) {
                DataByIdTableModel.this.restorePopup((TableViewSpeedSearch<String>)this.val$search);
            }

            @Override
            public void focusLost(FocusEvent e) {
                DataByIdTableModel.this.restorePopup((TableViewSpeedSearch<String>)this.val$search);
            }
        });
    }

    private void restorePopup(TableViewSpeedSearch<String> speedSearch) {
        if (StringUtil.isNotEmpty((String)this.currentPattern)) {
            ApplicationManager.getApplication().invokeLater(() -> speedSearch.showPopup(this.currentPattern));
        }
    }

    private boolean matches(Predicate<String> predicate, String id) {
        return predicate.test(this.getRowText(id));
    }

    private String getRowText(String id) {
        return Arrays.stream(this.myColumns).map(c -> c.valueOf((Object)id).toString()).collect(Collectors.joining(""));
    }
}

