/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.application.Topics;
import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.dvcs.ui.CloneDvcsValidationUtils;
import com.intellij.dvcs.ui.DvcsCloneDialogComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogComponentStateListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.Alarm;
import com.intellij.util.messages.Topic;
import git4idea.checkout.GitCheckoutProvider;
import git4idea.commands.Git;
import git4idea.config.GitExecutableInlineComponent;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitExecutableProblemHandler;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitVersion;
import git4idea.config.InlineErrorNotifier;
import git4idea.i18n.GitBundle;
import git4idea.remote.GitRememberedInputs;
import git4idea.ui.GitCloneDialogComponent;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lgit4idea/ui/GitCloneDialogComponent;", "Lcom/intellij/dvcs/ui/DvcsCloneDialogComponent;", "project", "Lcom/intellij/openapi/project/Project;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/application/ModalityState;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "checkVersionAlarm", "Lcom/intellij/util/Alarm;", "errorNotifier", "Lgit4idea/config/InlineErrorNotifier;", "executableManager", "Lgit4idea/config/GitExecutableManager;", "kotlin.jvm.PlatformType", "getExecutableManager", "()Lgit4idea/config/GitExecutableManager;", "executableProblemHandler", "Lgit4idea/config/GitExecutableProblemHandler;", "inlineComponent", "Lgit4idea/config/GitExecutableInlineComponent;", "listenerInstalled", "", "checkGitVersion", "", "dialogStateListener", "Lcom/intellij/openapi/vcs/ui/cloneDialog/VcsCloneDialogComponentStateListener;", "doClone", "listener", "Lcom/intellij/openapi/vcs/CheckoutProvider$Listener;", "onComponentSelected", "intellij.vcs.git"})
public final class GitCloneDialogComponent
extends DvcsCloneDialogComponent {
    private final Logger LOG;
    private final GitExecutableInlineComponent inlineComponent;
    private final InlineErrorNotifier errorNotifier;
    private final GitExecutableProblemHandler executableProblemHandler;
    private final Alarm checkVersionAlarm;
    private boolean listenerInstalled;
    private final ModalityState modalityState;

    private final GitExecutableManager getExecutableManager() {
        return GitExecutableManager.getInstance();
    }

    public void doClone(@NotNull Project project, @NotNull CheckoutProvider.Listener listener) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Path path = Paths.get(this.getDirectory(), new String[0]).toAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(getDirectory()).toAbsolutePath()");
        Path parent = path.getParent();
        ValidationInfo destinationValidation = CloneDvcsValidationUtils.createDestination((String)((Object)parent).toString());
        if (destinationValidation != null) {
            this.LOG.error("Unable to create destination directory", new String[]{destinationValidation.message});
            VcsNotifier.getInstance((Project)project).notifyError(VcsBundle.getString((String)"clone.dialog.clone.button"), VcsBundle.getString((String)"clone.dialog.unable.create.destination.error"));
            return;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile destinationParent = lfs.findFileByIoFile(parent.toFile());
        if (destinationParent == null) {
            destinationParent = lfs.refreshAndFindFileByIoFile(parent.toFile());
        }
        if (destinationParent == null) {
            this.LOG.error("Clone Failed. Destination doesn't exist");
            VcsNotifier.getInstance((Project)project).notifyError(VcsBundle.getString((String)"clone.dialog.clone.button"), VcsBundle.getString((String)"clone.dialog.unable.create.destination.error"));
            return;
        }
        String sourceRepositoryURL = this.getUrl();
        Path path2 = Paths.get(this.getDirectory(), new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(getDirectory())");
        String directoryName = ((Object)path2.getFileName()).toString();
        String parentDirectory = ((Object)parent.toAbsolutePath()).toString();
        GitCheckoutProvider.clone(project, Git.getInstance(), listener, destinationParent, sourceRepositoryURL, directoryName, parentDirectory);
        DvcsRememberedInputs dvcsRememberedInputs = GitRememberedInputs.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)dvcsRememberedInputs, (String)"GitRememberedInputs.getInstance()");
        DvcsRememberedInputs rememberedInputs = dvcsRememberedInputs;
        rememberedInputs.addUrl(sourceRepositoryURL);
        rememberedInputs.setCloneParentDir(parentDirectory);
    }

    public void onComponentSelected(@NotNull VcsCloneDialogComponentStateListener dialogStateListener) {
        Intrinsics.checkParameterIsNotNull((Object)dialogStateListener, (String)"dialogStateListener");
        dialogStateListener.onOkActionEnabled(false);
        Function0 scheduleCheckVersion2 = (Function0)new Function0<Unit>(this, dialogStateListener){
            final /* synthetic */ GitCloneDialogComponent this$0;
            final /* synthetic */ VcsCloneDialogComponentStateListener $dialogStateListener;

            public final void invoke() {
                if (!GitCloneDialogComponent.access$getErrorNotifier$p(this.this$0).isTaskInProgress()) {
                    GitCloneDialogComponent.access$getCheckVersionAlarm$p(this.this$0).addRequest(new Runnable(this){
                        final /* synthetic */ onComponentSelected.scheduleCheckVersion.1 this$0;

                        public final void run() {
                            GitCloneDialogComponent.access$checkGitVersion(this.this$0.this$0, this.this$0.$dialogStateListener);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }, 0);
                }
            }
            {
                this.this$0 = gitCloneDialogComponent;
                this.$dialogStateListener = vcsCloneDialogComponentStateListener;
                super(0);
            }
        };
        if (!this.listenerInstalled) {
            this.listenerInstalled = true;
            scheduleCheckVersion2.invoke();
            Topic topic = ApplicationActivationListener.TOPIC;
            Intrinsics.checkExpressionValueIsNotNull((Object)topic, (String)"ApplicationActivationListener.TOPIC");
            Topics.subscribe((Topic)topic, (Disposable)((Disposable)this), (Object)new ApplicationActivationListener(scheduleCheckVersion2){
                final /* synthetic */ Function0 $scheduleCheckVersion;

                public void applicationActivated(@NotNull IdeFrame ideFrame) {
                    Intrinsics.checkParameterIsNotNull((Object)ideFrame, (String)"ideFrame");
                    this.$scheduleCheckVersion.invoke();
                }
                {
                    this.$scheduleCheckVersion = $captured_local_variable$0;
                }
            });
        }
    }

    private final void checkGitVersion(VcsCloneDialogComponentStateListener dialogStateListener) {
        ActionsKt.invokeAndWaitIfNeeded((ModalityState)this.modalityState, (Function0)((Function0)new Function0<ProgressIndicator>(this){
            final /* synthetic */ GitCloneDialogComponent this$0;

            @NotNull
            public final ProgressIndicator invoke() {
                GitExecutableInlineComponent gitExecutableInlineComponent = GitCloneDialogComponent.access$getInlineComponent$p(this.this$0);
                String string = GitBundle.message("clone.dialog.checking.git.version", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GitBundle.message(\"clone\u2026og.checking.git.version\")");
                return gitExecutableInlineComponent.showProgress(string);
            }
            {
                this.this$0 = gitCloneDialogComponent;
                super(0);
            }
        }));
        try {
            this.getExecutableManager().dropExecutableCache();
            GitExecutableManager gitExecutableManager = this.getExecutableManager();
            Intrinsics.checkExpressionValueIsNotNull((Object)gitExecutableManager, (String)"executableManager");
            String string = gitExecutableManager.getPathToGit();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"executableManager.pathToGit");
            String pathToGit = string;
            GitVersion gitVersion = this.getExecutableManager().identifyVersion(pathToGit);
            Intrinsics.checkExpressionValueIsNotNull((Object)gitVersion, (String)"executableManager.identifyVersion(pathToGit)");
            GitVersion gitVersion2 = gitVersion;
            ActionsKt.invokeAndWaitIfNeeded((ModalityState)this.modalityState, (Function0)((Function0)new Function0<Unit>(this, gitVersion2, dialogStateListener){
                final /* synthetic */ GitCloneDialogComponent this$0;
                final /* synthetic */ GitVersion $gitVersion;
                final /* synthetic */ VcsCloneDialogComponentStateListener $dialogStateListener;

                public final void invoke() {
                    if (!this.$gitVersion.isSupported()) {
                        GitExecutableProblemHandlersKt.showUnsupportedVersionError(this.this$0.getProject(), this.$gitVersion, GitCloneDialogComponent.access$getErrorNotifier$p(this.this$0));
                        this.$dialogStateListener.onOkActionEnabled(false);
                    } else {
                        GitCloneDialogComponent.access$getInlineComponent$p(this.this$0).hideProgress();
                        this.$dialogStateListener.onOkActionEnabled(true);
                    }
                }
                {
                    this.this$0 = gitCloneDialogComponent;
                    this.$gitVersion = gitVersion;
                    this.$dialogStateListener = vcsCloneDialogComponentStateListener;
                    super(0);
                }
            }));
        }
        catch (Throwable t) {
            ActionsKt.invokeAndWaitIfNeeded((ModalityState)this.modalityState, (Function0)((Function0)new Function0<Unit>(this, t, dialogStateListener){
                final /* synthetic */ GitCloneDialogComponent this$0;
                final /* synthetic */ Throwable $t;
                final /* synthetic */ VcsCloneDialogComponentStateListener $dialogStateListener;

                public final void invoke() {
                    GitCloneDialogComponent.access$getExecutableProblemHandler$p(this.this$0).showError(this.$t, GitCloneDialogComponent.access$getErrorNotifier$p(this.this$0), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ checkGitVersion.3 this$0;

                        public final void invoke() {
                            this.this$0.$dialogStateListener.onOkActionEnabled(true);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                    this.$dialogStateListener.onOkActionEnabled(false);
                }
                {
                    this.this$0 = gitCloneDialogComponent;
                    this.$t = throwable;
                    this.$dialogStateListener = vcsCloneDialogComponentStateListener;
                    super(0);
                }
            }));
        }
    }

    public GitCloneDialogComponent(@NotNull Project project, @NotNull ModalityState modalityState) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modalityState, (String)"modalityState");
        DvcsRememberedInputs dvcsRememberedInputs = GitRememberedInputs.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)dvcsRememberedInputs, (String)"GitRememberedInputs.getInstance()");
        super(project, ".git", dvcsRememberedInputs);
        this.modalityState = modalityState;
        Logger logger = Logger.getInstance(GitCloneDialogComponent.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(GitCl\u2026logComponent::class.java)");
        this.LOG = logger;
        this.inlineComponent = new GitExecutableInlineComponent(this.getErrorComponent(), this.modalityState, this.getMainPanel());
        this.errorNotifier = new InlineErrorNotifier(this.inlineComponent, this.modalityState, (Disposable)this);
        this.executableProblemHandler = GitExecutableProblemHandlersKt.findGitExecutableProblemHandler(project);
        this.checkVersionAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    }

    public static final /* synthetic */ InlineErrorNotifier access$getErrorNotifier$p(GitCloneDialogComponent $this) {
        return $this.errorNotifier;
    }

    public static final /* synthetic */ Alarm access$getCheckVersionAlarm$p(GitCloneDialogComponent $this) {
        return $this.checkVersionAlarm;
    }

    public static final /* synthetic */ void access$checkGitVersion(GitCloneDialogComponent $this, VcsCloneDialogComponentStateListener dialogStateListener) {
        $this.checkGitVersion(dialogStateListener);
    }

    public static final /* synthetic */ GitExecutableInlineComponent access$getInlineComponent$p(GitCloneDialogComponent $this) {
        return $this.inlineComponent;
    }

    public static final /* synthetic */ GitExecutableProblemHandler access$getExecutableProblemHandler$p(GitCloneDialogComponent $this) {
        return $this.executableProblemHandler;
    }
}

