/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.lang.lexer;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergeFunction;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.coffeescript.lang.lexer.CoffeeScriptTokenSets;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.coffeescript.lang.lexer._CoffeeScriptLexer;

public class CoffeeScriptFlexLexer
extends MergingLexerAdapter {
    private static final TokenSet TOKENS_TO_MERGE = TokenSet.create((IElementType[])new IElementType[]{CoffeeScriptTokenTypes.STRING_LITERAL, JSTokenTypes.XML_TAG_CONTENT});
    private static final MergeFunction MY_MERGE_FUNCTION = new MyMergeFunction();

    public CoffeeScriptFlexLexer() {
        super((Lexer)new FlexAdapter((FlexLexer)new _CoffeeScriptLexer(null, false)), TOKENS_TO_MERGE);
    }

    public CoffeeScriptFlexLexer(boolean highlightMode) {
        super((Lexer)new FlexAdapter((FlexLexer)new _CoffeeScriptLexer(null, highlightMode)), TOKENS_TO_MERGE);
    }

    public MergeFunction getMergeFunction() {
        return MY_MERGE_FUNCTION;
    }

    private static class MyMergeFunction
    implements MergeFunction {
        private MyMergeFunction() {
        }

        public IElementType merge(IElementType type, Lexer originalLexer) {
            if (CoffeeScriptTokenSets.JSX_START_BRACES.contains(type)) {
                IElementType tokenType;
                int braceBalance = 1;
                while (braceBalance > 0 && (tokenType = originalLexer.getTokenType()) != null) {
                    if (CoffeeScriptTokenSets.JSX_START_BRACES.contains(tokenType)) {
                        ++braceBalance;
                    }
                    if (tokenType == JSTokenTypes.XML_JS_SCRIPT_END) {
                        --braceBalance;
                    }
                    if (braceBalance == 0) {
                        originalLexer.advance();
                        break;
                    }
                    originalLexer.advance();
                }
                return type == CoffeeScriptTokenTypes.XML_ATTRIBUTES_SCRIPT_START ? CoffeeScriptTokenTypes.JSX_EMBEDDED_ATTRIBUTES : CoffeeScriptTokenTypes.JSX_EMBEDDED_CONTENT;
            }
            if (TOKENS_TO_MERGE.contains(type)) {
                while (originalLexer.getTokenType() == type) {
                    originalLexer.advance();
                }
            }
            return type;
        }
    }
}

