/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.JBDateFormat;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileAnnotation {
    private static final Logger LOG = Logger.getInstance(FileAnnotation.class);
    @NotNull
    private final Project myProject;
    private boolean myIsClosed;
    private Runnable myCloser;
    private Consumer<? super FileAnnotation> myReloader;

    protected FileAnnotation(@NotNull Project project) {
        if (project == null) {
            FileAnnotation.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FileAnnotation.$$$reportNull$$$0(1);
        }
        return project;
    }

    @Nullable
    public VcsKey getVcsKey() {
        return null;
    }

    @Nullable
    public VirtualFile getFile() {
        return null;
    }

    @Nullable
    public abstract String getAnnotatedContent();

    @Nullable
    public abstract VcsRevisionNumber getCurrentRevision();

    public boolean isBaseRevisionChanged(@NotNull VcsRevisionNumber number) {
        VcsRevisionNumber currentRevision;
        if (number == null) {
            FileAnnotation.$$$reportNull$$$0(2);
        }
        return (currentRevision = this.getCurrentRevision()) != null && !currentRevision.equals(number);
    }

    public abstract void dispose();

    public abstract LineAnnotationAspect @NotNull [] getAspects();

    public abstract int getLineCount();

    @Nullable
    public abstract String getToolTip(int var1);

    @Nullable
    public String getHtmlToolTip(int lineNumber) {
        String toolTip = this.getToolTip(lineNumber);
        return XmlStringUtil.escapeString((String)toolTip);
    }

    @Nullable
    public abstract VcsRevisionNumber getLineRevisionNumber(int var1);

    @Nullable
    public abstract Date getLineDate(int var1);

    @Nullable
    public abstract List<VcsFileRevision> getRevisions();

    @Nullable
    public AnnotationSourceSwitcher getAnnotationSourceSwitcher() {
        return null;
    }

    @Nullable
    public VcsRevisionNumber originalRevision(int lineNumber) {
        return this.getLineRevisionNumber(lineNumber);
    }

    public synchronized boolean isClosed() {
        return this.myIsClosed;
    }

    public final synchronized void close() {
        this.myIsClosed = true;
        if (this.myCloser != null) {
            this.myCloser.run();
            this.myCloser = null;
            this.myReloader = null;
        }
    }

    public final synchronized void reload(@Nullable FileAnnotation newFileAnnotation) {
        if (this.myReloader != null) {
            this.myReloader.consume((Object)newFileAnnotation);
        }
    }

    public final synchronized void setCloser(@NotNull Runnable closer) {
        if (closer == null) {
            FileAnnotation.$$$reportNull$$$0(3);
        }
        if (this.myIsClosed) {
            return;
        }
        this.myCloser = closer;
    }

    public final synchronized void setReloader(@Nullable Consumer<? super FileAnnotation> reloader) {
        if (this.myIsClosed) {
            return;
        }
        this.myReloader = reloader;
    }

    @Deprecated
    public boolean revisionsNotEmpty() {
        return true;
    }

    @Nullable
    public CurrentFileRevisionProvider getCurrentFileRevisionProvider() {
        return FileAnnotation.createDefaultCurrentFileRevisionProvider(this);
    }

    @Nullable
    public PreviousFileRevisionProvider getPreviousFileRevisionProvider() {
        return FileAnnotation.createDefaultPreviousFileRevisionProvider(this);
    }

    @Nullable
    public AuthorsMappingProvider getAuthorsMappingProvider() {
        return FileAnnotation.createDefaultAuthorsMappingProvider(this);
    }

    @Nullable
    public RevisionsOrderProvider getRevisionsOrderProvider() {
        return FileAnnotation.createDefaultRevisionsOrderProvider(this);
    }

    @Nullable
    public RevisionChangesProvider getRevisionsChangesProvider() {
        return FileAnnotation.createDefaultRevisionsChangesProvider(this);
    }

    @NotNull
    public static String formatDate(@NotNull Date date) {
        if (date == null) {
            FileAnnotation.$$$reportNull$$$0(4);
        }
        String string = JBDateFormat.getFormatter().formatPrettyDate(date);
        if (string == null) {
            FileAnnotation.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    private static CurrentFileRevisionProvider createDefaultCurrentFileRevisionProvider(@NotNull FileAnnotation annotation) {
        List<VcsFileRevision> revisions;
        if (annotation == null) {
            FileAnnotation.$$$reportNull$$$0(6);
        }
        if ((revisions = annotation.getRevisions()) == null) {
            return null;
        }
        HashMap<VcsRevisionNumber, VcsFileRevision> map = new HashMap<VcsRevisionNumber, VcsFileRevision>();
        for (VcsFileRevision revision : revisions) {
            map.put(revision.getRevisionNumber(), revision);
        }
        ArrayList lineToRevision = new ArrayList(annotation.getLineCount());
        for (int i = 0; i < annotation.getLineCount(); ++i) {
            lineToRevision.add(map.get(annotation.getLineRevisionNumber(i)));
        }
        return lineNumber -> {
            LOG.assertTrue(lineNumber >= 0 && lineNumber < lineToRevision.size());
            return (VcsFileRevision)lineToRevision.get(lineNumber);
        };
    }

    @Nullable
    private static PreviousFileRevisionProvider createDefaultPreviousFileRevisionProvider(@NotNull FileAnnotation annotation) {
        List<VcsFileRevision> revisions;
        if (annotation == null) {
            FileAnnotation.$$$reportNull$$$0(7);
        }
        if ((revisions = annotation.getRevisions()) == null) {
            return null;
        }
        HashMap<VcsRevisionNumber, VcsFileRevision> map = new HashMap<VcsRevisionNumber, VcsFileRevision>();
        for (int i = 0; i < revisions.size(); ++i) {
            VcsFileRevision revision = revisions.get(i);
            VcsFileRevision previousRevision = i + 1 < revisions.size() ? revisions.get(i + 1) : null;
            map.put(revision.getRevisionNumber(), previousRevision);
        }
        final ArrayList lineToRevision = new ArrayList(annotation.getLineCount());
        for (int i = 0; i < annotation.getLineCount(); ++i) {
            lineToRevision.add(map.get(annotation.getLineRevisionNumber(i)));
        }
        final VcsFileRevision lastRevision = (VcsFileRevision)ContainerUtil.getFirstItem(revisions);
        return new PreviousFileRevisionProvider(){

            @Override
            @Nullable
            public VcsFileRevision getPreviousRevision(int lineNumber) {
                LOG.assertTrue(lineNumber >= 0 && lineNumber < lineToRevision.size());
                return (VcsFileRevision)lineToRevision.get(lineNumber);
            }

            @Override
            @Nullable
            public VcsFileRevision getLastRevision() {
                return lastRevision;
            }
        };
    }

    @Nullable
    private static AuthorsMappingProvider createDefaultAuthorsMappingProvider(@NotNull FileAnnotation annotation) {
        List<VcsFileRevision> revisions;
        if (annotation == null) {
            FileAnnotation.$$$reportNull$$$0(8);
        }
        if ((revisions = annotation.getRevisions()) == null) {
            return null;
        }
        HashMap<VcsRevisionNumber, String> authorsMapping = new HashMap<VcsRevisionNumber, String>();
        for (VcsFileRevision revision : revisions) {
            String author = revision.getAuthor();
            if (author == null) continue;
            authorsMapping.put(revision.getRevisionNumber(), author);
        }
        return () -> authorsMapping;
    }

    @Nullable
    private static RevisionsOrderProvider createDefaultRevisionsOrderProvider(@NotNull FileAnnotation annotation) {
        List<VcsFileRevision> revisions;
        if (annotation == null) {
            FileAnnotation.$$$reportNull$$$0(9);
        }
        if ((revisions = annotation.getRevisions()) == null) {
            return null;
        }
        List orderedRevisions = ContainerUtil.map(revisions, revision -> Collections.singletonList(revision.getRevisionNumber()));
        return () -> orderedRevisions;
    }

    @Nullable
    private static RevisionChangesProvider createDefaultRevisionsChangesProvider(@NotNull FileAnnotation annotation) {
        VirtualFile file;
        if (annotation == null) {
            FileAnnotation.$$$reportNull$$$0(10);
        }
        if ((file = annotation.getFile()) == null) {
            return null;
        }
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance(annotation.getProject()).getVcsFor(file);
        if (vcs == null) {
            return null;
        }
        CommittedChangesProvider changesProvider = vcs.getCommittedChangesProvider();
        if (changesProvider == null) {
            return null;
        }
        return lineNumber -> {
            VcsRevisionNumber revisionNumber = annotation.getLineRevisionNumber(lineNumber);
            if (revisionNumber == null) {
                return null;
            }
            Pair pair = changesProvider.getOneList(file, revisionNumber);
            if (pair == null || pair.getFirst() == null) {
                return null;
            }
            if (pair.getSecond() == null) {
                return Pair.create((Object)pair.getFirst(), (Object)VcsUtil.getFilePath(file));
            }
            return pair;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/annotate/FileAnnotation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/annotate/FileAnnotation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isBaseRevisionChanged";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setCloser";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "formatDate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultCurrentFileRevisionProvider";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultPreviousFileRevisionProvider";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultAuthorsMappingProvider";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultRevisionsOrderProvider";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultRevisionsChangesProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface RevisionChangesProvider {
        @Nullable
        public Pair<? extends CommittedChangeList, FilePath> getChangesIn(int var1) throws VcsException;
    }

    public static interface RevisionsOrderProvider {
        @NotNull
        public List<List<VcsRevisionNumber>> getOrderedRevisions();
    }

    public static interface AuthorsMappingProvider {
        @NotNull
        public Map<VcsRevisionNumber, String> getAuthors();
    }

    public static interface PreviousFileRevisionProvider {
        @Nullable
        public VcsFileRevision getPreviousRevision(int var1);

        @Nullable
        public VcsFileRevision getLastRevision();
    }

    public static interface CurrentFileRevisionProvider {
        @Nullable
        public VcsFileRevision getRevision(int var1);
    }
}

