/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.nodes;

import com.google.common.collect.Collections2;
import com.intellij.codeInsight.template.emmet.CssEmmetUtil;
import com.intellij.codeInsight.template.emmet.configuration.CssEmmetOptions;
import com.intellij.codeInsight.template.emmet.configuration.CssPrefix;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.impl.util.table.CssElementDescriptorFactory;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CssEmmetNode
extends ZenCodingNode {
    protected final List<String> myValues;
    protected final Collection<CssPrefix> myPrefixes;
    protected final boolean myImportant;

    public CssEmmetNode(List<String> values, Collection<CssPrefix> prefixes, boolean isImportant) {
        this.myValues = values;
        this.myPrefixes = prefixes;
        this.myImportant = isImportant;
    }

    protected String createValue(String propertyName) {
        CssPropertyDescriptor descriptor = CssElementDescriptorFactory.getDescriptor(propertyName);
        boolean unitlessProperty = descriptor != null && descriptor.allowsIntegerWithoutSuffix();
        return StringUtil.join((Collection)Collections2.transform(this.myValues, input -> CssEmmetUtil.normalizeValue(input, unitlessProperty)), (String)" ").trim();
    }

    protected String createDeclarationsString(String propertyName, String value, @NotNull String declarationsTerminator, boolean insertTheLastTerminator) {
        Collection<CssPrefix> explicitlyEnabledPrefixes;
        if (declarationsTerminator == null) {
            CssEmmetNode.$$$reportNull$$$0(0);
        }
        Collection<CssPrefix> prefixes = this.myPrefixes;
        CssEmmetOptions cssEmmetOptions = CssEmmetOptions.getInstance();
        if ((prefixes.equals(CssEmmetUtil.ALL_PREFIXES) || prefixes.isEmpty() && cssEmmetOptions.isAutoInsertCssPrefixedEnabled()) && !(explicitlyEnabledPrefixes = cssEmmetOptions.getPrefixStateForProperty(propertyName).getEnabledPrefixes()).isEmpty()) {
            prefixes = explicitlyEnabledPrefixes;
        }
        prefixes = CssEmmetUtil.filterPrefixes(prefixes);
        StringBuilder declarations = new StringBuilder();
        if (!prefixes.isEmpty() && (value.isEmpty() || "$END$".equals(value))) {
            value = "$VAR_EMMET_VALUE$";
        }
        if (!StringUtil.startsWithChar((CharSequence)value, (char)' ')) {
            value = ' ' + value;
        }
        for (CssPrefix prefix : prefixes) {
            declarations.append(prefix.getText()).append("-").append(propertyName).append(":").append(value).append(declarationsTerminator.isEmpty() ? "\n" : declarationsTerminator);
        }
        declarations.append(propertyName).append(":").append(value).append(insertTheLastTerminator ? declarationsTerminator : "");
        return declarations.toString();
    }

    protected boolean isCaretAtDeclarationsTerminator(@NotNull Editor editor, @NotNull String declarationsTerminator) {
        if (editor == null) {
            CssEmmetNode.$$$reportNull$$$0(1);
        }
        if (declarationsTerminator == null) {
            CssEmmetNode.$$$reportNull$$$0(2);
        }
        CharSequence sequence = editor.getDocument().getCharsSequence();
        int offset = editor.getCaretModel().getOffset();
        return sequence.length() > offset + declarationsTerminator.length() && declarationsTerminator.equals(sequence.subSequence(offset, offset + declarationsTerminator.length()).toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationsTerminator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/emmet/nodes/CssEmmetNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createDeclarationsString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCaretAtDeclarationsTerminator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

