/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsagesCollectorConsumer;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class FUStateUsagesLogger
implements UsagesCollectorConsumer {
    public static final Object LOCK = new Object();

    public static FUStateUsagesLogger create() {
        return new FUStateUsagesLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logProjectStates(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(0);
        }
        if (indicator == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(1);
        }
        Object object = LOCK;
        synchronized (object) {
            for (ProjectUsagesCollector usagesCollector : ProjectUsagesCollector.getExtensions(this)) {
                EventLogGroup group = new EventLogGroup(usagesCollector.getGroupId(), usagesCollector.getVersion());
                try {
                    FUStateUsagesLogger.logUsagesAsStateEvents(project, group, usagesCollector.getData(project), usagesCollector.getMetrics(project, indicator));
                }
                catch (Throwable th) {
                    FUStateUsagesLogger.logCollectingUsageFailed(project, group, th);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logApplicationStates() {
        Object object = LOCK;
        synchronized (object) {
            for (ApplicationUsagesCollector usagesCollector : ApplicationUsagesCollector.getExtensions(this)) {
                EventLogGroup group = new EventLogGroup(usagesCollector.getGroupId(), usagesCollector.getVersion());
                try {
                    FUStateUsagesLogger.logUsagesAsStateEvents(null, group, usagesCollector.getData(), (Promise<? extends Set<MetricEvent>>)Promises.resolvedPromise(usagesCollector.getMetrics()));
                }
                catch (Throwable th) {
                    FUStateUsagesLogger.logCollectingUsageFailed(null, group, th);
                }
            }
        }
    }

    private static void logUsagesAsStateEvents(@Nullable Project project, @NotNull EventLogGroup group, @Nullable FeatureUsageData context, @NotNull Promise<? extends Set<MetricEvent>> metricsPromise) {
        if (group == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(2);
        }
        if (metricsPromise == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(3);
        }
        metricsPromise.onSuccess(metrics -> {
            if (project != null && project.isDisposed()) {
                return;
            }
            FeatureUsageLogger logger2 = FeatureUsageLogger.INSTANCE;
            if (!metrics.isEmpty()) {
                FeatureUsageData groupData = FUStateUsagesLogger.addProject(project, context);
                for (MetricEvent metric : metrics) {
                    FeatureUsageData data = FUStateUsagesLogger.mergeWithEventData(groupData, metric.getData());
                    Map<Object, Object> eventData = data != null ? data.build() : Collections.emptyMap();
                    logger2.logState(group, metric.getEventId(), eventData);
                }
            }
            logger2.logState(group, "invoked", new FeatureUsageData().addProject(project).build());
        });
    }

    private static void logCollectingUsageFailed(@Nullable Project project, @NotNull EventLogGroup group, @NotNull Throwable error) {
        if (group == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(4);
        }
        if (error == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(5);
        }
        if (project != null && project.isDisposed()) {
            return;
        }
        FeatureUsageLogger.INSTANCE.logState(group, "invocation.failed", new FeatureUsageData().addProject(project).build());
    }

    @Nullable
    private static FeatureUsageData addProject(@Nullable Project project, @Nullable FeatureUsageData context) {
        if (project == null && context == null) {
            return null;
        }
        return context != null ? context.addProject(project) : new FeatureUsageData().addProject(project);
    }

    @Nullable
    public static FeatureUsageData mergeWithEventData(@Nullable FeatureUsageData groupData, @Nullable FeatureUsageData data) {
        if (data == null) {
            return groupData;
        }
        FeatureUsageData newData = groupData == null ? new FeatureUsageData() : groupData.copy();
        newData.merge(data, "event_");
        return newData;
    }

    public static void logStateEvent(@NotNull EventLogGroup group, @NotNull String event, @NotNull FeatureUsageData data) {
        if (group == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(6);
        }
        if (event == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(7);
        }
        if (data == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(8);
        }
        FeatureUsageLogger.INSTANCE.logState(group, event, data.build());
        FeatureUsageLogger.INSTANCE.logState(group, "invoked");
    }

    public static void logStateEvents(@NotNull EventLogGroup group, @NotNull Collection<MetricEvent> events) {
        if (group == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(9);
        }
        if (events == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(10);
        }
        for (MetricEvent event : events) {
            FeatureUsageLogger.INSTANCE.logState(group, event.getEventId(), event.getData().build());
        }
        FeatureUsageLogger.INSTANCE.logState(group, "invoked");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metricsPromise";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/service/fus/collectors/FUStateUsagesLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "logProjectStates";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "logUsagesAsStateEvents";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "logCollectingUsageFailed";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "logStateEvent";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "logStateEvents";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

