/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc;

import com.intellij.database.remote.jdba.Rdbms;
import com.intellij.database.remote.jdba.exceptions.DBFactoryException;
import com.intellij.database.remote.jdba.intermediate.IntegralIntermediateFacade;
import com.intellij.database.remote.jdba.intermediate.IntegralIntermediateFederatedProvider;
import com.intellij.database.remote.jdba.intermediate.IntegralIntermediateRdbmsProvider;
import com.intellij.database.remote.jdba.intermediate.PrimeIntermediateRdbmsProvider;
import com.intellij.database.remote.jdba.util.Providers;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JdbcIntermediateFederatedProvider
implements IntegralIntermediateFederatedProvider {
    private final List<SpecificProvider> myRegisteredProviders = new CopyOnWriteArrayList<SpecificProvider>();
    private final ConcurrentMap<Rdbms, SpecificProvider> myBestProviders = new ConcurrentHashMap<Rdbms, SpecificProvider>();

    public JdbcIntermediateFederatedProvider() {
        Collection<IntegralIntermediateRdbmsProvider> rdbmsProviders = Providers.loadAllProviders(IntegralIntermediateRdbmsProvider.class, null);
        for (IntegralIntermediateRdbmsProvider rdbmsProvider : rdbmsProviders) {
            this.registerProvider(rdbmsProvider);
        }
    }

    public void registerProvider(@NotNull IntegralIntermediateRdbmsProvider provider) {
        if (provider == null) {
            JdbcIntermediateFederatedProvider.$$$reportNull$$$0(0);
        }
        Rdbms rdbms = provider.rdbms();
        byte specificity = provider.specificity();
        SpecificProvider sp = new SpecificProvider(rdbms, specificity, provider);
        this.myRegisteredProviders.add(sp);
        this.selectBestProvider(rdbms);
    }

    private void selectBestProvider(@NotNull Rdbms rdbms) {
        if (rdbms == null) {
            JdbcIntermediateFederatedProvider.$$$reportNull$$$0(1);
        }
        SpecificProvider theBest = null;
        for (SpecificProvider sp : this.myRegisteredProviders) {
            if (!sp.rdbms.equals(rdbms)) continue;
            if (theBest == null) {
                theBest = sp;
                continue;
            }
            if (sp.specificity >= theBest.specificity) continue;
            theBest = sp;
        }
        if (theBest != null) {
            this.myBestProviders.put(rdbms, theBest);
        } else {
            this.myBestProviders.remove(rdbms);
        }
    }

    public void deregisterProvider(@NotNull PrimeIntermediateRdbmsProvider provider) {
        if (provider == null) {
            JdbcIntermediateFederatedProvider.$$$reportNull$$$0(2);
        }
        Rdbms rdbms = provider.rdbms();
        for (int i = this.myRegisteredProviders.size() - 1; i >= 0; --i) {
            SpecificProvider sp = this.myRegisteredProviders.get(i);
            if (sp.provider != provider) continue;
            this.myRegisteredProviders.remove(i);
        }
        this.selectBestProvider(rdbms);
    }

    @Override
    @NotNull
    public Set<Rdbms> supportedRdbms() {
        Set<Rdbms> set = Collections.unmodifiableSet(this.myBestProviders.keySet());
        if (set == null) {
            JdbcIntermediateFederatedProvider.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    @NotNull
    public IntegralIntermediateFacade openFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, int connectionsLimit) {
        if (connectionString == null) {
            JdbcIntermediateFederatedProvider.$$$reportNull$$$0(4);
        }
        IntegralIntermediateRdbmsProvider provider = this.findTheBestFor(connectionString);
        IntegralIntermediateFacade integralIntermediateFacade = provider.openFacade(connectionString, connectionProperties, connectionsLimit);
        if (integralIntermediateFacade == null) {
            JdbcIntermediateFederatedProvider.$$$reportNull$$$0(5);
        }
        return integralIntermediateFacade;
    }

    private IntegralIntermediateRdbmsProvider findTheBestFor(String connectionString) {
        SpecificProvider theBest = null;
        for (SpecificProvider sp : this.myBestProviders.values()) {
            if (!JdbcIntermediateFederatedProvider.matches(connectionString, sp.provider.connectionStringPattern()) || theBest != null && sp.specificity >= theBest.specificity) continue;
            theBest = sp;
        }
        if (theBest != null) {
            return theBest.provider;
        }
        throw new DBFactoryException(String.format("No providers registered for connection string \"%s\"", connectionString));
    }

    @Override
    @Nullable
    public IntegralIntermediateRdbmsProvider getSpecificServiceProvider(@NotNull Rdbms rdbms) {
        SpecificProvider sp;
        if (rdbms == null) {
            JdbcIntermediateFederatedProvider.$$$reportNull$$$0(6);
        }
        return (sp = (SpecificProvider)this.myBestProviders.get(rdbms)) != null ? sp.provider : null;
    }

    private static boolean matches(@NotNull String string, @NotNull Pattern pattern) {
        if (string == null) {
            JdbcIntermediateFederatedProvider.$$$reportNull$$$0(7);
        }
        if (pattern == null) {
            JdbcIntermediateFederatedProvider.$$$reportNull$$$0(8);
        }
        return pattern.matcher(string).matches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rdbms";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/jdbc/JdbcIntermediateFederatedProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionString";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/JdbcIntermediateFederatedProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "supportedRdbms";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "openFacade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerProvider";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectBestProvider";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deregisterProvider";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "openFacade";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSpecificServiceProvider";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SpecificProvider {
        @NotNull
        final Rdbms rdbms;
        final byte specificity;
        @NotNull
        final IntegralIntermediateRdbmsProvider provider;

        private SpecificProvider(@NotNull Rdbms rdbms, byte specificity, @NotNull IntegralIntermediateRdbmsProvider provider) {
            if (rdbms == null) {
                SpecificProvider.$$$reportNull$$$0(0);
            }
            if (provider == null) {
                SpecificProvider.$$$reportNull$$$0(1);
            }
            this.rdbms = rdbms;
            this.specificity = specificity;
            this.provider = provider;
        }

        public String toString() {
            return this.rdbms + "/" + this.specificity + " -> " + this.provider.getClass().getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rdbms";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "provider";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/remote/jdba/jdbc/JdbcIntermediateFederatedProvider$SpecificProvider";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

