/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc.dialects;

import com.intellij.database.remote.jdba.Rdbms;
import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdba.intermediate.DBExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateSession;
import com.intellij.database.remote.jdba.jdbc.dialects.Mssql;
import com.intellij.database.remote.jdba.jdbc.dialects.MssqlIntermediateSession;
import com.intellij.database.remote.jdba.util.Version;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MssqlIntermediateFacade
extends JdbcIntermediateFacade {
    private static final String CONNECTION_INFO_QUERY = "select db_name(), schema_name(), original_login(), @@version";

    public MssqlIntermediateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, @NotNull Driver driver, int connectionsLimit, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        if (connectionString == null) {
            MssqlIntermediateFacade.$$$reportNull$$$0(0);
        }
        if (driver == null) {
            MssqlIntermediateFacade.$$$reportNull$$$0(1);
        }
        if (exceptionRecognizer == null) {
            MssqlIntermediateFacade.$$$reportNull$$$0(2);
        }
        super(connectionString, connectionProperties, driver, connectionsLimit, exceptionRecognizer);
    }

    public MssqlIntermediateFacade(@NotNull DataSource dataSource, int connectionsLimit, boolean ownConnections, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        if (dataSource == null) {
            MssqlIntermediateFacade.$$$reportNull$$$0(3);
        }
        if (exceptionRecognizer == null) {
            MssqlIntermediateFacade.$$$reportNull$$$0(4);
        }
        super(dataSource, connectionsLimit, ownConnections, exceptionRecognizer);
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        Rdbms rdbms = Mssql.RDBMS;
        if (rdbms == null) {
            MssqlIntermediateFacade.$$$reportNull$$$0(5);
        }
        return rdbms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionInfo obtainConnectionInfoNatively() {
        JdbcIntermediateSession session = this.openSession();
        try {
            String driverVersionStr;
            String serverVersionStr;
            String rdbmsName;
            String[] env = session.queryOneRow(CONNECTION_INFO_QUERY, 4, String.class);
            if (env == null) {
                env = new String[]{null, null, null, null};
            }
            try {
                DatabaseMetaData md = session.getConnection().getMetaData();
                if (env[3] != null && env[3].contains("Azure")) {
                    rdbmsName = "Azure";
                } else {
                    rdbmsName = md.getDatabaseProductName();
                    if (rdbmsName == null) {
                        rdbmsName = session.getConnection().getClass().getName();
                    }
                }
                serverVersionStr = md.getDatabaseProductVersion();
                driverVersionStr = md.getDriverVersion();
            }
            catch (SQLException sqle) {
                throw this.getExceptionRecognizer().recognizeException(sqle, "getting versions using JDBC metadata");
            }
            Version serverVersion = MssqlIntermediateFacade.extractVersion(serverVersionStr, SIMPLE_VERSION_PATTERN, 1);
            Version driverVersion = MssqlIntermediateFacade.extractVersion(driverVersionStr, SIMPLE_VERSION_PATTERN, 1);
            ConnectionInfo connectionInfo = new ConnectionInfo(rdbmsName, env[0], env[1], env[2], serverVersion, driverVersion);
            return connectionInfo;
        }
        finally {
            session.close();
        }
    }

    @Override
    @NotNull
    protected MssqlIntermediateSession instantiateSession(@NotNull Connection connection, boolean ownConnection) {
        if (connection == null) {
            MssqlIntermediateFacade.$$$reportNull$$$0(6);
        }
        return new MssqlIntermediateSession(this, this.myExceptionRecognizer, connection, ownConnection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionRecognizer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/jdbc/dialects/MssqlIntermediateFacade";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/dialects/MssqlIntermediateFacade";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "rdbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "instantiateSession";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

