/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.MsBaseJdbcHelper;
import java.sql.Connection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzureJdbcHelper
extends MsBaseJdbcHelper {
    public AzureJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("Azure", version, connection);
    }

    public AzureJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return AzureJdbcHelper.extractVersion(version);
    }

    @NotNull
    protected static AzureJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        return new AzureJdbcHelper(AzureJdbcHelper.extractVersion(productVer), delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }
}

