/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.dialects.base.generator.AbstractCodeGenerator;
import com.intellij.database.dialects.base.generator.AbstractCodeGenerator$WhenMappings;
import com.intellij.database.dialects.base.generator.AbstractCodeGeneratorKt;
import com.intellij.database.dialects.base.generator.Effect;
import com.intellij.database.dialects.base.generator.EffectType;
import com.intellij.database.dialects.base.generator.Node;
import com.intellij.database.dialects.base.generator.ObjectPathTrie;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.OperationType;
import com.intellij.database.dialects.base.generator.Producer;
import com.intellij.database.dialects.base.generator.RequiredEffect;
import com.intellij.database.dialects.base.generator.Scenario;
import com.intellij.database.dialects.base.generator.ScenarioOperations;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.SimpleProducer;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.script.generator.AutoNeverAlways;
import com.intellij.database.script.generator.CodeTextBuilder;
import com.intellij.database.script.generator.ScriptConsumer;
import com.intellij.database.script.generator.ScriptLocus;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.util.Function;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 V2\u00020\u0001:\u0003VWXB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018H\u0002J\u0016\u0010\u0019\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0016J,\u0010\u001d\u001a\u00020\u001b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\b\u0002\u0010 \u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\"H\u0004J*\u0010#\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u000e0\f\"\u0004\b\u0000\u0010$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H$0&H\u0002J\b\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0018H\u0002J\u0016\u0010*\u001a\u00020+2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018H\u0002J\u0006\u0010,\u001a\u00020\u001bJ\u0010\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.H\u0002J3\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u000e2\u0018\u00102\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001b03H\u0082\bJ\u000e\u00104\u001a\b\u0012\u0004\u0012\u0002050\u0018H\u0016J\u0006\u00106\u001a\u00020\u0012J\b\u00107\u001a\u00020\u0016H\u0014J\u0012\u00108\u001a\u0004\u0018\u00010\u000e2\u0006\u00109\u001a\u00020\rH\u0016J%\u0010:\u001a\u00020\u001b2\u001b\u0010!\u001a\u0017\u0012\b\u0012\u00060;R\u00020\u0003\u0012\u0004\u0012\u00020\u001b0\f\u00a2\u0006\u0002\b<H\u0004J\b\u0010=\u001a\u00020\u0016H\u0014J\b\u0010>\u001a\u00020\u001bH\u0002J\b\u0010?\u001a\u00020\u001bH&J\u0006\u0010@\u001a\u00020\u001bJ\u0010\u0010@\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u000eH\u0016J\u001c\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010D\u001a\u00020\r2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010CJ\b\u0010F\u001a\u00020\u001bH\u0016J\u000e\u0010G\u001a\u00020C2\u0006\u0010H\u001a\u00020IJ\b\u0010J\u001a\u00020\u001bH\u0016J\u0012\u0010K\u001a\u00020\u00162\b\u0010L\u001a\u0004\u0018\u00010CH\u0002J(\u0010M\u001a\u00060;R\u00020\u0003*\u00060;R\u00020\u00032\b\u0010N\u001a\u0004\u0018\u00010O2\b\u0010P\u001a\u0004\u0018\u00010CH\u0004J(\u0010Q\u001a\u00060;R\u00020\u0003*\u00060;R\u00020\u00032\b\u0010R\u001a\u0004\u0018\u00010S2\b\u0010P\u001a\u0004\u0018\u00010CH\u0004J\u0018\u0010T\u001a\u00020C*\u00020\r2\n\b\u0002\u0010U\u001a\u0004\u0018\u00010CH\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\u000b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006Y"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator;", "", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;)V", "builder", "Lcom/intellij/database/script/generator/CodeTextBuilder;", "getBuilder", "()Lcom/intellij/database/script/generator/CodeTextBuilder;", "getContext", "()Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "outputFactory", "Lkotlin/Function1;", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/dialects/base/generator/Operation;", "getOutputFactory", "()Lkotlin/jvm/functions/Function1;", "scenario", "Lcom/intellij/database/dialects/base/generator/Scenario;", "getScenario", "()Lcom/intellij/database/dialects/base/generator/Scenario;", "breakByEdge", "", "cycle", "", "breakCycle", "breakCycles", "", "clear", "coding", "locus", "Lcom/intellij/database/script/generator/ScriptLocus;", "indent", "block", "Lkotlin/Function0;", "createOutputFactory", "T", "consumer", "Lcom/intellij/database/script/generator/ScriptConsumer;", "createRootProducer", "Lcom/intellij/database/dialects/base/generator/Producer;", "findCycle", "findCycleMin", "", "flush", "statement", "Lcom/intellij/database/script/CompositeText;", "forEachEdge", "op1", "op2", "action", "Lkotlin/Function2;", "getEdgeFixers", "Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator$EdgeFixer;", "getInternalScenario", "isNewCodeGen", "makeOperation", "element", "newCoding", "Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "Lkotlin/ExtensionFunctionType;", "preferForward", "prepareOutput", "prepareScenario", "produce", "op", "quote", "", "e", "name", "resolve", "script", "d", "Lcom/intellij/database/model/DataType;", "transform", "useSchemaName", "schemaName", "alterColumn", "c", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "scrName", "alterTable", "table", "Lcom/intellij/database/model/basic/BasicLikeTable;", "currentScopeName", "renameScr", "Companion", "EdgeFixer", "SinkProducer", "intellij.database.dialects.base"})
public abstract class AbstractCodeGenerator {
    @NotNull
    private final Scenario scenario;
    @Nullable
    private final Function1<BasicElement, Operation> outputFactory;
    @NotNull
    private final CodeTextBuilder builder;
    @NotNull
    private final ScriptingContext context;
    @NotNull
    private static final OperationType ROOT;
    @NotNull
    private static final OperationType SINK;
    @NotNull
    private static final OperationType ERROR;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    protected final Scenario getScenario() {
        return this.scenario;
    }

    @Nullable
    protected final Function1<BasicElement, Operation> getOutputFactory() {
        return this.outputFactory;
    }

    @NotNull
    protected final CodeTextBuilder getBuilder() {
        return this.builder;
    }

    public abstract void prepareScenario();

    private final Producer createRootProducer() {
        return new SimpleProducer(ROOT, (Function1<? super Producer, Unit>)((Function1)new Function1<Producer, Unit>(this){
            final /* synthetic */ AbstractCodeGenerator this$0;

            public final void invoke(@NotNull Producer $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                AbstractCodeGeneratorKt.processOperations(this.this$0.getContext(), $receiver.getNestedOperations(), (Function1<? super Operation, Unit>)((Function1)new Function1<Operation, Unit>(this.this$0){

                    public final void invoke(@NotNull Operation p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        ((AbstractCodeGenerator)this.receiver).produce(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(AbstractCodeGenerator.class);
                    }

                    public final String getName() {
                        return "produce";
                    }

                    public final String getSignature() {
                        return "produce(Lcom/intellij/database/dialects/base/generator/Operation;)V";
                    }
                }));
            }
            {
                this.this$0 = abstractCodeGenerator;
                super(1);
            }
        }));
    }

    public void clear() {
    }

    @Nullable
    public Operation makeOperation(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void resolve() {
        HashMap effects = new HashMap();
        ObjectPathTrie trie = new ObjectPathTrie();
        JBIterable jBIterable = this.scenario.traverse().bfsTraversal();
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"scenario.traverse().bfsTraversal()");
        JBIterable operations = jBIterable;
        Iterable $this$forEach$iv = (Iterable)operations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Operation it = (Operation)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = it.getEffects();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                void $this$getOrPut$iv;
                Effect e = (Effect)element$iv2;
                boolean bl2 = false;
                Map map2 = effects;
                EffectType key$iv = e.getType();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get((Object)key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    LinkedHashMap answer$iv = new LinkedHashMap();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                Map map3 = (Map)object;
                ObjectPath objectPath = e.getTarget();
                Operation operation2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)operation2, (String)"it");
                Operation prev = map3.put(objectPath, operation2);
                if (prev != null && Intrinsics.areEqual((Object)e.getTarget().kind, (Object)ObjectKind.ARGUMENT) ^ true) {
                    LOG.error("Effect " + e + " provided by " + it + " (" + ScenarioOperations.element(it) + ") and " + prev + " (" + ScenarioOperations.element(prev) + ')');
                }
                trie.add(e.getTarget());
            }
        }
        $this$forEach$iv = (Iterable)operations;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JBIterable req;
            Operation op = (Operation)element$iv;
            boolean bl = false;
            op.unlinkAll();
            Intrinsics.checkExpressionValueIsNotNull((Object)JBIterable.from((Iterable)op.getRequires()).flatten(new Function<E, Iterable<? extends T>>(effects, trie){
                final /* synthetic */ HashMap $effects$inlined;
                final /* synthetic */ ObjectPathTrie $trie$inlined;
                {
                    this.$effects$inlined = hashMap;
                    this.$trie$inlined = objectPathTrie;
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Iterable<Operation> fun(RequiredEffect it) {
                    Iterable iterable;
                    Map map2 = (Map)this.$effects$inlined.get((Object)((Object)it.getType()));
                    if (map2 != null) {
                        void $this$mapNotNullTo$iv$iv;
                        Map map3 = map2;
                        boolean bl = false;
                        boolean bl2 = false;
                        Map ops = map3;
                        boolean bl3 = false;
                        RequiredEffect requiredEffect = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)requiredEffect, (String)"it");
                        Iterable $this$mapNotNull$iv = (Iterable)ScenarioOperations.expand(requiredEffect, this.$trie$inlined);
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable2 = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Operation operation2;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl4 = false;
                            ObjectPath p1 = (ObjectPath)element$iv$iv;
                            boolean bl5 = false;
                            if ((Operation)ops.get(p1) == null) continue;
                            boolean bl6 = false;
                            boolean bl7 = false;
                            Operation it$iv$iv = operation2;
                            boolean bl8 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        iterable = (List)destination$iv$iv;
                    } else {
                        JBIterable jBIterable = JBIterable.empty();
                        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.empty<Operation?>()");
                        iterable = (Iterable)jBIterable;
                    }
                    return iterable;
                }
            }), (String)"JBIterable.from(op.requi\u2026pty<Operation?>()\n      }");
            op.link((Iterable)req);
        }
    }

    public void transform() {
        this.prepareOutput();
        this.breakCycles();
    }

    private final void breakCycles() {
        List<Operation> cycle;
        do {
            if (this.findCycle() != null) continue;
            return;
        } while (this.breakCycle(cycle));
    }

    protected boolean breakCycle(@NotNull List<Operation> cycle) {
        Intrinsics.checkParameterIsNotNull(cycle, (String)"cycle");
        return this.breakByEdge(cycle);
    }

    protected boolean preferForward() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean breakByEdge(List<Operation> cycle) {
        int size;
        int s = this.findCycleMin(cycle);
        int i2 = size = cycle.size();
        Object t = ((Operation)CollectionsKt.first(cycle)).getParent();
        if (t == null) {
            Intrinsics.throwNpe();
        }
        Operation root2 = (Operation)t;
        List<EdgeFixer> fixers = this.getEdgeFixers();
        if (fixers.isEmpty()) {
            return false;
        }
        while (i2 >= 0) {
            int p = s + i2 + size;
            Operation cur = cycle.get(p % size);
            Operation next = cycle.get((p + 1) % size);
            boolean fwOnly = i2 == 0;
            boolean bkOnly = i2 == size;
            AbstractCodeGenerator this_$iv = this;
            boolean $i$f$forEachEdge = false;
            Collection collection = ScenarioOperations.traverse(cur).traverse().addAllTo((Collection)new HashSet());
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"op1.traverse().traverse().addAllTo(HashSet())");
            HashSet targets$iv = (HashSet)collection;
            Iterable $this$forEach$iv$iv = (Iterable)ScenarioOperations.traverse(next);
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Operation so2$iv = (Operation)element$iv$iv;
                boolean bl = false;
                Iterable $this$forEach$iv$iv2 = so2$iv.getPreceders();
                boolean $i$f$forEach2 = false;
                for (Object element$iv$iv2 : $this$forEach$iv$iv2) {
                    Operation so1$iv = (Operation)element$iv$iv2;
                    boolean bl2 = false;
                    if (!targets$iv.contains(so1$iv)) continue;
                    Intrinsics.checkExpressionValueIsNotNull((Object)so2$iv, (String)"so2");
                    Operation so1 = so1$iv;
                    boolean bl3 = false;
                    Iterable $this$forEach$iv = fixers;
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        void so2;
                        EdgeFixer it = (EdgeFixer)element$iv;
                        boolean bl4 = false;
                        if (fwOnly && it.isBackward() || bkOnly && !it.isBackward() || !it.fix(root2, so1, (Operation)so2, this.outputFactory)) continue;
                        if (it.requiresResolve()) {
                            this.resolve();
                        }
                        return true;
                    }
                }
            }
            --i2;
        }
        return false;
    }

    private final int findCycleMin(List<Operation> cycle) {
        Comparator cmp = AbstractCodeGeneratorKt.access$createPreOrderComparator(cycle);
        int mini = 0;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)1, (int)cycle.size());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            if (cmp.compare(cycle.get(mini), cycle.get(it)) <= 0) continue;
            mini = it;
        }
        return mini;
    }

    private final void forEachEdge(Operation op1, Operation op2, Function2<? super Operation, ? super Operation, Unit> action) {
        int $i$f$forEachEdge = 0;
        Collection collection = ScenarioOperations.traverse(op1).traverse().addAllTo((Collection)new HashSet());
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"op1.traverse().traverse().addAllTo(HashSet())");
        HashSet targets2 = (HashSet)collection;
        Iterable $this$forEach$iv = (Iterable)ScenarioOperations.traverse(op2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Operation so2 = (Operation)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = so2.getPreceders();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Operation so1 = (Operation)element$iv2;
                boolean bl2 = false;
                if (!targets2.contains(so1)) continue;
                Operation operation2 = so2;
                Intrinsics.checkExpressionValueIsNotNull((Object)operation2, (String)"so2");
                action.invoke((Object)so1, (Object)operation2);
            }
        }
    }

    @NotNull
    public List<EdgeFixer> getEdgeFixers() {
        return CollectionsKt.emptyList();
    }

    private final List<Operation> findCycle() {
        HashSet<Operation> visited = new HashSet<Operation>();
        FilteredTraverserBase filteredTraverserBase = ScenarioOperations.traversePreceders().expandAndFilter((Condition)new Condition<Operation>(visited){
            final /* synthetic */ HashSet $visited;

            public final boolean value(Operation it) {
                return !this.$visited.contains(it);
            }
            {
                this.$visited = hashSet;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)filteredTraverserBase, (String)"traversePreceders().expa\u2026Filter { it !in visited }");
        JBTreeTraverser traverser2 = (JBTreeTraverser)filteredTraverserBase;
        JBIterable jBIterable = this.scenario.traverse().bfsTraversal().filter((Condition)new Condition<Operation>(visited){
            final /* synthetic */ HashSet $visited;

            public final boolean value(Operation it) {
                return !this.$visited.contains(it);
            }
            {
                this.$visited = hashSet;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"scenario.traverse().bfsT\u2026.filter{ it !in visited }");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Operation root2 = (Operation)element$iv;
            boolean bl = false;
            Iterator iterator = ((JBTreeTraverser)traverser2.withRoot((Object)root2)).biOrderDfsTraversal().typedIterator();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"traverser.withRoot(root)\u2026l.TracingIt<Operation>>()");
            TreeTraversal.TracingIt it = (TreeTraversal.TracingIt)iterator;
            while (it.advance()) {
                Operation op;
                Operation operation2 = op = (Operation)it.current();
                operation2.setIncidence(operation2.getIncidence() + (it.isDescending() ? 1 : -1));
                if (!it.isDescending()) {
                    visited.add(op);
                }
                if (op.getIncidence() < 2) continue;
                LinkedList<Operation> res2 = new LinkedList<Operation>();
                boolean add = true;
                JBIterable jBIterable2 = it.backtrace();
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"it.backtrace()");
                Iterable $this$forEach$iv2 = (Iterable)jBIterable2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Operation it2 = (Operation)element$iv2;
                    boolean bl2 = false;
                    it2.setIncidence(0);
                    if (add) {
                        boolean bl3 = add = res2.isEmpty() || Intrinsics.areEqual((Object)it2, (Object)op) ^ true;
                    }
                    if (!add) continue;
                    res2.add(it2);
                }
                return res2;
            }
        }
        return null;
    }

    private final void prepareOutput() {
        Function1<BasicElement, Operation> outputFactory = this.outputFactory;
        if (outputFactory != null) {
            for (Operation op : CollectionsKt.toMutableList((Collection)this.scenario.getRoot().getNestedOperations())) {
                op.setParent((Node)outputFactory.invoke((Object)ScenarioOperations.element(op)));
            }
        } else {
            Operation sink = new Operation(new SinkProducer<Object>(this.context, null, null));
            sink.stealChildrenFrom((Node)this.scenario.getRoot());
            sink.setParent((Node)this.scenario.getRoot());
        }
    }

    private final <T> Function1<BasicElement, Operation> createOutputFactory(ScriptConsumer<T> consumer) {
        Map map2 = FactoryMap.create((Function)new Function<K, V>(this, consumer){
            final /* synthetic */ AbstractCodeGenerator this$0;
            final /* synthetic */ ScriptConsumer $consumer;

            @NotNull
            public final Operation fun(@Nullable T it) {
                Operation operation2 = new Operation(new SinkProducer<T>(this.this$0.getContext(), it, this.$consumer));
                boolean bl = false;
                boolean bl2 = false;
                Operation $this$apply = operation2;
                boolean bl3 = false;
                $this$apply.setParent((Node)this.this$0.getScenario().getRoot());
                return operation2;
            }
            {
                this.this$0 = abstractCodeGenerator;
                this.$consumer = scriptConsumer;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"FactoryMap.create<T?, Op\u2026enario.root\n      }\n    }");
        Map sinks2 = map2;
        return (Function1)new Function1<BasicElement, Operation>(sinks2, consumer){
            final /* synthetic */ Map $sinks;
            final /* synthetic */ ScriptConsumer $consumer;

            @NotNull
            public final Operation invoke(@Nullable BasicElement obj2) {
                Object object;
                Map map2 = this.$sinks;
                BasicElement basicElement = obj2;
                if (basicElement != null) {
                    BasicElement basicElement2 = basicElement;
                    Map map3 = map2;
                    boolean bl = false;
                    boolean bl2 = false;
                    BasicElement it = basicElement2;
                    boolean bl3 = false;
                    Object object2 = this.$consumer.distribute(it);
                    map2 = map3;
                    object = object2;
                } else {
                    object = null;
                }
                V v2 = map2.get(object);
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                return (Operation)v2;
            }
            {
                this.$sinks = map2;
                this.$consumer = scriptConsumer;
                super(1);
            }
        };
    }

    public void produce(@NotNull Operation op) {
        Intrinsics.checkParameterIsNotNull((Object)op, (String)"op");
        op.getProducer().produce();
    }

    public final void produce() {
        this.produce(this.scenario.getRoot());
    }

    protected boolean isNewCodeGen() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void coding(@Nullable ScriptLocus locus, boolean indent, @NotNull Function0<Unit> block) {
        boolean complete;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        ScriptLocus oldContext = this.context.getLocus();
        ScriptLocus scriptLocus = locus;
        if (scriptLocus == null) {
            scriptLocus = oldContext == ScriptLocus.OUTSIDE ? ScriptLocus.IN_STATEMENT : oldContext;
        }
        ScriptLocus newContext = scriptLocus;
        CodeTextBuilder.IndentationState savedIndentation = this.builder.getCurrentIndentationState();
        try {
            this.context.setLocus(newContext);
            if (indent) {
                CodeTextBuilder.indent$default((CodeTextBuilder)this.builder, null, (int)1, null);
            }
            block.invoke();
        }
        catch (Throwable throwable) {
            boolean complete2;
            this.builder.returnToIndentation(savedIndentation);
            this.context.setLocus(oldContext);
            boolean bl = complete2 = oldContext == ScriptLocus.OUTSIDE && newContext != ScriptLocus.OUTSIDE && this.builder.isNotEmpty();
            if (complete2) {
                this.flush();
            }
            throw throwable;
        }
        this.builder.returnToIndentation(savedIndentation);
        this.context.setLocus(oldContext);
        boolean bl = complete = oldContext == ScriptLocus.OUTSIDE && newContext != ScriptLocus.OUTSIDE && this.builder.isNotEmpty();
        if (complete) {
            this.flush();
        }
    }

    public static /* synthetic */ void coding$default(AbstractCodeGenerator abstractCodeGenerator, ScriptLocus scriptLocus, boolean bl, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: coding");
        }
        if ((n & 1) != 0) {
            scriptLocus = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        abstractCodeGenerator.coding(scriptLocus, bl, (Function0<Unit>)function0);
    }

    protected final void newCoding(@NotNull Function1<? super ScriptingContext.NewCodingAdapter, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, block){
            final /* synthetic */ AbstractCodeGenerator this$0;
            final /* synthetic */ Function1 $block;

            public final void invoke() {
                this.$block.invoke((Object)this.this$0.getContext().getAdapter());
                this.this$0.getContext().getAdapter().newLine();
            }
            {
                this.this$0 = abstractCodeGenerator;
                this.$block = function1;
                super(0);
            }
        }, 3, null);
    }

    public final void flush() {
        if (this.builder.isNotEmpty()) {
            this.flush((CompositeText)new SimpleCompositeText((CompositeText)this.builder));
        }
        this.builder.clearAll();
    }

    private final void flush(CompositeText statement) {
        this.context.getScript().add(statement);
    }

    @Nullable
    public final String quote(@NotNull BasicElement e, @Nullable String name2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        String string2 = name2;
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            string = this.context.getNaming().nameToScript(it, e instanceof BasicNamedElement && ((BasicNamedElement)e).isNameScripted() && !((BasicNamedElement)e).isNameQuoted(), ((SqlCodeStyleSettings)this.context.getOptions().get(ScriptingOptionStatic.CODE_STYLE)).getQuotesPriority());
        } else {
            string = null;
        }
        return string;
    }

    public static /* synthetic */ String quote$default(AbstractCodeGenerator abstractCodeGenerator, BasicElement basicElement, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: quote");
        }
        if ((n & 2) != 0) {
            string = basicElement.getRealName();
        }
        return abstractCodeGenerator.quote(basicElement, string);
    }

    @NotNull
    protected final String currentScopeName(@NotNull BasicElement $this$currentScopeName, @Nullable String renameScr) {
        String string;
        BasicElement q;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)$this$currentScopeName, (String)"$this$currentScopeName");
        String string3 = renameScr;
        if (string3 == null) {
            string3 = string2 = AbstractCodeGenerator.quote$default(this, $this$currentScopeName, null, 2, null);
        }
        if (string3 == null) {
            string2 = "???";
        }
        String name2 = string2;
        BasicElement basicElement = this.context.getHelper().qualifier($this$currentScopeName);
        if (basicElement == null) {
            return name2;
        }
        BasicElement basicElement2 = q = basicElement;
        if (basicElement2 instanceof BasicSchema) {
            String schemaName = ((BasicSchema)q).getRealName();
            String prefix = schemaName != null && this.useSchemaName(schemaName) ? Intrinsics.stringPlus((String)this.quote(q, schemaName), (Object)".") : "";
            string = prefix + name2;
        } else {
            string = AbstractCodeGenerator.currentScopeName$default(this, q, null, 1, null) + "." + name2;
        }
        return string;
    }

    public static /* synthetic */ String currentScopeName$default(AbstractCodeGenerator abstractCodeGenerator, BasicElement basicElement, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: currentScopeName");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return abstractCodeGenerator.currentScopeName(basicElement, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean useSchemaName(String schemaName) {
        boolean bl;
        if (schemaName == null) return false;
        switch (AbstractCodeGenerator$WhenMappings.$EnumSwitchMapping$0[((AutoNeverAlways)this.context.getOptions().get(ScriptingOptionStatic.CONSIDER_SCHEMA_NAME)).ordinal()]) {
            case 1: {
                bl = Intrinsics.areEqual((Object)schemaName, (Object)this.context.getCurrentSchemaName()) ^ true;
                break;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (!bl) return false;
        return true;
    }

    @NotNull
    public final String script(@NotNull DataType d) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        return this.context.getHelper().script(d, this.context);
    }

    @NotNull
    public final Scenario getInternalScenario() {
        return this.scenario;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final ScriptingContext.NewCodingAdapter alterTable(@NotNull ScriptingContext.NewCodingAdapter $this$alterTable, @Nullable BasicLikeTable table, @Nullable String scrName) {
        void text$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$alterTable, (String)"$this$alterTable");
        ScriptingContext.NewCodingAdapter newCodingAdapter = $this$alterTable;
        BasicLikeTable basicLikeTable = table;
        String string = basicLikeTable != null ? this.currentScopeName((BasicElement)basicLikeTable, scrName) : null;
        ScriptingContext.NewCodingAdapter newCodingAdapter2 = $this$alterTable.plus($this$alterTable.unaryPlus("alter"), this.context.getHelper().getTableTerm(table));
        ScriptingContext.NewCodingAdapter newCodingAdapter3 = $this$alterTable;
        boolean $i$f$orError = false;
        Function0 function0 = (Function0)new Function0<Unit>((ScriptingContext.NewCodingAdapter)this_$iv, (String)text$iv){
            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
            final /* synthetic */ String $text;
            {
                this.this$0 = newCodingAdapter;
                this.$text = string;
                super(0);
            }

            public final void invoke() {
                if (this.$text != null) {
                    ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                } else {
                    CompositeText.Kind kind = null;
                    CharSequence charSequence = "???";
                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                    boolean bl = false;
                    String string = "table is unknown";
                    ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                }
            }
        };
        return newCodingAdapter3.plus(newCodingAdapter2, (Function0<? extends Object>)function0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final ScriptingContext.NewCodingAdapter alterColumn(@NotNull ScriptingContext.NewCodingAdapter $this$alterColumn, @Nullable BasicLikeColumn c, @Nullable String scrName) {
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$alterColumn, (String)"$this$alterColumn");
        BasicLikeColumn basicLikeColumn = c;
        ScriptingContext.NewCodingAdapter newCodingAdapter = $this$alterColumn;
        ScriptingContext.NewCodingAdapter newCodingAdapter2 = $this$alterColumn.plus(this.alterTable($this$alterColumn, (BasicLikeTable)(basicLikeColumn != null ? basicLikeColumn.getLikeTable() : null), null), "alter column");
        ScriptingContext.NewCodingAdapter newCodingAdapter3 = $this$alterColumn;
        boolean $i$f$name = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$orError = false;
        Function0 function0 = (Function0)new Function0<Unit>((ScriptingContext.NewCodingAdapter)this_$iv$iv, scrName){
            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
            final /* synthetic */ String $text;
            {
                this.this$0 = newCodingAdapter;
                this.$text = string;
                super(0);
            }

            public final void invoke() {
                if (this.$text != null) {
                    ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                } else {
                    CompositeText.Kind kind = null;
                    CharSequence charSequence = "???";
                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                    boolean bl = false;
                    String string = "unknown name";
                    ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                }
            }
        };
        return newCodingAdapter3.plus(newCodingAdapter2, (Function0<? extends Object>)function0);
    }

    @NotNull
    public final ScriptingContext getContext() {
        return this.context;
    }

    public AbstractCodeGenerator(@NotNull ScriptingContext context) {
        Function1<BasicElement, Operation> function1;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.scenario = new Scenario(this.createRootProducer());
        AbstractCodeGenerator abstractCodeGenerator = this;
        ScriptConsumer scriptConsumer = this.context.getTask().getConsumer();
        if (scriptConsumer != null) {
            ScriptConsumer scriptConsumer2 = scriptConsumer;
            AbstractCodeGenerator abstractCodeGenerator2 = abstractCodeGenerator;
            boolean bl = false;
            boolean bl2 = false;
            ScriptConsumer it = scriptConsumer2;
            boolean bl3 = false;
            Function1<BasicElement, Operation> function12 = this.createOutputFactory(it);
            abstractCodeGenerator = abstractCodeGenerator2;
            function1 = function12;
        } else {
            function1 = null;
        }
        abstractCodeGenerator.outputFactory = function1;
        this.builder = this.context.getBuilder();
    }

    static {
        Companion = new Companion(null);
        ROOT = new OperationType("root");
        SINK = new OperationType("text sink");
        ERROR = new OperationType("error");
        Logger logger = Logger.getInstance(AbstractCodeGenerator.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Abstr\u2026odeGenerator::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0016\u0010\t\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\u0006\u0018\u00010\nH&J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator$EdgeFixer;", "", "()V", "fix", "", "root", "Lcom/intellij/database/dialects/base/generator/Operation;", "op1", "op2", "parent", "Lkotlin/Function1;", "Lcom/intellij/database/model/basic/BasicElement;", "isBackward", "requiresResolve", "intellij.database.dialects.base"})
    public static abstract class EdgeFixer {
        public abstract boolean fix(@NotNull Operation var1, @NotNull Operation var2, @NotNull Operation var3, @Nullable Function1<? super BasicElement, Operation> var4);

        public boolean isBackward() {
            return false;
        }

        public boolean requiresResolve() {
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator$SinkProducer;", "T", "Lcom/intellij/database/dialects/base/generator/Producer;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "tag", "consumer", "Lcom/intellij/database/script/generator/ScriptConsumer;", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Ljava/lang/Object;Lcom/intellij/database/script/generator/ScriptConsumer;)V", "getConsumer", "()Lcom/intellij/database/script/generator/ScriptConsumer;", "getContext", "()Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "getTag", "()Ljava/lang/Object;", "Ljava/lang/Object;", "ignoreDeps", "", "produce", "", "intellij.database.dialects.base"})
    public static final class SinkProducer<T>
    extends Producer {
        @NotNull
        private final ScriptingContext context;
        @Nullable
        private final T tag;
        @Nullable
        private final ScriptConsumer<T> consumer;

        public final boolean ignoreDeps() {
            return this.consumer != null && this.consumer.ignoreDependencies();
        }

        @Override
        public void produce() {
            AbstractCodeGeneratorKt.processOperations(this.context, this.getNestedOperations(), (Function1<? super Operation, Unit>)((Function1)produce.1.INSTANCE));
            if (this.tag != null && this.consumer != null) {
                this.consumer.consume(AbstractCodeGeneratorKt.createResult(this.context), this.tag);
            } else {
                this.context.setResult(AbstractCodeGeneratorKt.createResult(this.context));
            }
        }

        @NotNull
        public final ScriptingContext getContext() {
            return this.context;
        }

        @Nullable
        public final T getTag() {
            return this.tag;
        }

        @Nullable
        public final ScriptConsumer<T> getConsumer() {
            return this.consumer;
        }

        public SinkProducer(@NotNull ScriptingContext context, @Nullable T tag, @Nullable ScriptConsumer<T> consumer) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            super(Companion.getSINK());
            this.context = context;
            this.tag = tag;
            this.consumer = consumer;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006R\u0014\u0010\u000e\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/base/generator/AbstractCodeGenerator$Companion;", "", "()V", "ERROR", "Lcom/intellij/database/dialects/base/generator/OperationType;", "getERROR", "()Lcom/intellij/database/dialects/base/generator/OperationType;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "ROOT", "getROOT", "SINK", "getSINK", "intellij.database.dialects.base"})
    public static final class Companion {
        @NotNull
        protected final OperationType getROOT() {
            return ROOT;
        }

        @NotNull
        protected final OperationType getSINK() {
            return SINK;
        }

        @NotNull
        public final OperationType getERROR() {
            return ERROR;
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

