/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector.jdbc.wrappers;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceInfo;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.AseRoutineArgumentIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.AseRoutineIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ResultSetWrapper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.RoutineArgumentIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.RoutineIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.SchemaLoader;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableColumnIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableFKeyColumnIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableIndexColumnIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableKeyColumnIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableVersionColumnIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TypeIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.UserDefinedTypeAttributeIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.UserDefinedTypeIt;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.Casing;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseMetaDataWrapper {
    private static final Logger LOG = Logger.getInstance(DatabaseMetaDataWrapper.class);
    private final DatabaseConnection myConnection;
    private final RemoteDatabaseMetaData myMetaData;
    private String myQuote;
    private PairConsumer<String, Throwable> myErrorSink;

    @NotNull
    public DatabaseMetaDataWrapper withErrorSink(PairConsumer<String, Throwable> errorSink2) {
        this.myErrorSink = errorSink2;
        DatabaseMetaDataWrapper databaseMetaDataWrapper = this;
        if (databaseMetaDataWrapper == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(0);
        }
        return databaseMetaDataWrapper;
    }

    @Nullable
    public PairConsumer<String, Throwable> getErrorSink() {
        return this.myErrorSink;
    }

    public void onError(String title, Throwable e) {
        this.myErrorSink.consume((Object)title, (Object)e);
    }

    public DatabaseConnection getConnection() {
        return this.myConnection;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myConnection.getDbms();
        if (dbms == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @NotNull
    public static DatabaseMetaDataWrapper create(@NotNull DatabaseConnection connection, @NotNull RemoteDatabaseMetaData metaData) {
        Dbms dbms;
        if (connection == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(2);
        }
        if (metaData == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(3);
        }
        if ((dbms = connection.getDbms()).isSybase()) {
            return new AseMetadataWrapper(connection, metaData);
        }
        if (dbms.isPostgres()) {
            return new PgMetadataWrapper(connection, metaData);
        }
        if (dbms.isOracle()) {
            return new OraMetadataWrapper(connection, metaData);
        }
        return new DatabaseMetaDataWrapper(connection, metaData);
    }

    protected DatabaseMetaDataWrapper(@NotNull DatabaseConnection connection, @NotNull RemoteDatabaseMetaData data) {
        if (connection == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(4);
        }
        if (data == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(5);
        }
        this.myConnection = connection;
        this.myMetaData = data;
    }

    @NotNull
    public ClosableIt<String> databases() throws SQLException {
        ClosableIt<String> res2 = SchemaLoader.catalogs(this);
        res2.map(StringUtil::notNullize);
        ClosableIt<String> closableIt = res2;
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(6);
        }
        return closableIt;
    }

    @NotNull
    public ClosableIt<Schema> schemas(@NotNull JBIterable<String> databases) throws SQLException {
        if (databases == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(7);
        }
        final String current = (String)JdbcNativeUtil.computeRemote(() -> this.myConnection.getRemoteConnection().getCatalog());
        return new ClosableIt.DelegateIt<Schema, Schema>(SchemaLoader.schemas(databases, current, this)){

            @Override
            public void close() {
                try {
                    super.close();
                }
                finally {
                    if (current != null) {
                        JdbcNativeUtil.performSafe(() -> DatabaseMetaDataWrapper.this.myConnection.getRemoteConnection().setCatalog(current));
                    }
                }
            }

            @Override
            protected Schema calcValue(Schema cur) {
                return cur;
            }
        };
    }

    @NotNull
    public ClosableIt<? extends Table> tables(@NotNull Schema schema, @Nullable String namePattern, @Nullable String[] types) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(8);
        }
        ClosableIt<? extends Table> tableIt = this.tablesInner(schema, namePattern, types);
        tableIt.filter(tab -> tab.type == null || !StringUtil.containsIgnoreCase((String)tab.type, (String)"TEMPORARY"));
        ClosableIt<? extends Table> closableIt = tableIt;
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(9);
        }
        return closableIt;
    }

    @NotNull
    public ClosableIt<Routine> routines(@NotNull Schema schema, @Nullable String pkg, @Nullable String namePattern) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(10);
        }
        boolean noCatalog = StringUtil.isEmpty((String)((String)JdbcNativeUtil.computeRemote(() -> ((RemoteDatabaseMetaData)this.myMetaData).getCatalogTerm())));
        String requestCatalog = noCatalog ? pkg : StringUtil.notNullize((String)schema.database);
        ClosableIt<Routine> closableIt = this.append(this.getProceduresInner(requestCatalog, schema, namePattern, noCatalog), () -> this.getFunctionsInner(requestCatalog, schema, namePattern, noCatalog));
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(11);
        }
        return closableIt;
    }

    @NotNull
    private ClosableIt<Routine> getProceduresInner(@Nullable String requestCatalog, @NotNull Schema schema, @Nullable String namePattern, boolean noCatalog) throws SQLException {
        RemoteResultSet rs;
        block6: {
            if (schema == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(12);
            }
            rs = null;
            try {
                rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getProcedures(requestCatalog, schema.schema, namePattern));
            }
            catch (SQLException e) {
                if (this.isUnimplemented(e)) break block6;
                throw e;
            }
        }
        if (rs == null) {
            ClosableIt<Routine> closableIt = ClosableIt.empty();
            if (closableIt == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(13);
            }
            return closableIt;
        }
        ClosableIt closableIt = new RoutineIt(rs, this.getDbms(), schema, noCatalog, true).withErrorSink((PairConsumer)this.myErrorSink);
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(14);
        }
        return closableIt;
    }

    @Nullable
    private ClosableIt<Routine> getFunctionsInner(@Nullable String requestCatalog, @NotNull Schema schema, @Nullable String namePattern, boolean noCatalog) throws SQLException {
        RemoteResultSet rs;
        block4: {
            if (schema == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(15);
            }
            rs = null;
            try {
                rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getFunctions(requestCatalog, this.getDbms() == Dbms.HIVE ? "" : schema.schema, StringUtil.notNullize((String)namePattern, (String)"%")));
            }
            catch (SQLException e) {
                if (this.isUnimplemented(e)) break block4;
                throw e;
            }
        }
        if (rs == null) {
            return null;
        }
        return new RoutineIt(rs, this.getDbms(), schema, noCatalog, false).withErrorSink((PairConsumer)this.myErrorSink);
    }

    protected <T> ClosableIt<T> append(ClosableIt<T> head, ThrowableComputable<ClosableIt<T>, SQLException> ... tail) {
        ClosableIt<T> res2 = head;
        for (ThrowableComputable<ClosableIt<T>, SQLException> fac : tail) {
            if (fac == null) continue;
            res2 = ClosableIt.lazyAppend(res2, this.handleExceptions(fac));
        }
        return res2;
    }

    private <T> Factory<T> handleExceptions(ThrowableComputable<T, SQLException> fac) {
        return () -> {
            try {
                return fac.compute();
            }
            catch (SQLException e) {
                this.onError(null, e);
                return null;
            }
        };
    }

    @NotNull
    public ClosableIt.GroupingIt<TableKey, TableKeyColumn> tableKeys(@NotNull Table table) throws SQLException {
        if (table == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(16);
        }
        RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getPrimaryKeys(table.schema.database, table.schema.schema, table.name));
        return new TableKeyColumnIt.Grouping(new TableKeyColumnIt(rs, table).withErrorSink((PairConsumer)this.myErrorSink));
    }

    @NotNull
    public ClosableIt.GroupingIt<Table, TableColumn> tableColumns(@NotNull Schema schema, @Nullable String namePattern, @Nullable Iterable<String> expectedTables) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(17);
        }
        return new TableColumnIt.Grouping(this.getTableColumnsInner(schema, namePattern, expectedTables));
    }

    @NotNull
    protected ClosableIt<TableColumn> getTableColumnsInner(@NotNull Schema schema, @Nullable String namePattern, @Nullable Iterable<String> expectedTables) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(18);
        }
        if (namePattern != null || expectedTables == null) {
            assert (expectedTables == null);
            return this.getTableColumnsInner2(schema, namePattern);
        }
        ClosableIt<TableColumn> it = null;
        if (this.getDbms() != Dbms.GITBASE) {
            try {
                it = this.getTableColumnsInner2(schema, null);
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
        }
        Iterator<String> myTableIt = expectedTables.iterator();
        ClosableIt<TableColumn> closableIt = ClosableIt.lazyAppendIfEmpty(it != null ? it : ClosableIt.empty(), () -> ClosableIt.generate(() -> {
            while (myTableIt.hasNext()) {
                String table = (String)myTableIt.next();
                try {
                    return this.getTableColumnsInner2(schema, table);
                }
                catch (Exception e) {
                    this.onError("failed to retrieve columns for " + table, e);
                }
            }
            return null;
        }));
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(19);
        }
        return closableIt;
    }

    @NotNull
    private ClosableIt<TableColumn> getTableColumnsInner2(@NotNull Schema schema, @Nullable String namePattern) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(20);
        }
        RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getColumns(StringUtil.notNullize((String)schema.database), schema.schema, StringUtil.notNullize((String)namePattern, (String)"%"), "%"));
        ClosableIt closableIt = new TableColumnIt(rs, this.getDbms(), schema).withErrorSink((PairConsumer)this.myErrorSink);
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(21);
        }
        return closableIt;
    }

    @NotNull
    public ClosableIt.GroupingIt<Routine, RoutineArgument> routineArguments(@NotNull Schema schema, @Nullable String namePattern, @NotNull Function<Routine, DasRoutine.Kind> kindProvider) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(22);
        }
        if (kindProvider == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(23);
        }
        return new RoutineArgumentIt.Grouping(this.routineArgumentsInner(schema, namePattern, kindProvider));
    }

    @NotNull
    public ClosableIt<RoutineArgument> routineArgumentsInner(@NotNull Schema schema, @Nullable String namePattern, @NotNull Function<Routine, DasRoutine.Kind> kindProvider) throws SQLException {
        boolean noCatalog;
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(24);
        }
        if (kindProvider == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(25);
        }
        String requestCatalog = (noCatalog = StringUtil.isEmpty((String)((String)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getCatalogTerm())))) ? schema.database : StringUtil.notNullize((String)schema.database);
        ClosableIt<RoutineArgument> closableIt = this.append(this.getProcedureArgumentsInner(requestCatalog, schema, namePattern, kindProvider, noCatalog), () -> this.getFunctionArgumentsInner(requestCatalog, schema, namePattern, kindProvider, noCatalog));
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(26);
        }
        return closableIt;
    }

    @NotNull
    private ClosableIt<RoutineArgument> getProcedureArgumentsInner(String requestCatalog, @NotNull Schema schema, @Nullable String namePattern, @NotNull Function<Routine, DasRoutine.Kind> kindProvider, boolean noCatalog) throws SQLException {
        RemoteResultSet wrapper;
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(27);
        }
        if (kindProvider == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(28);
        }
        if ((wrapper = this.getRoutineArgumentsWrapper(new Schema(schema.schema, requestCatalog), namePattern)) == null) {
            ClosableIt<RoutineArgument> closableIt = ClosableIt.empty();
            if (closableIt == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(29);
            }
            return closableIt;
        }
        ClosableIt closableIt = new RoutineArgumentIt(wrapper, this.getDbms(), schema, noCatalog, kindProvider, true).withErrorSink((PairConsumer)this.myErrorSink);
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(30);
        }
        return closableIt;
    }

    @Nullable
    private ClosableIt<RoutineArgument> getFunctionArgumentsInner(String requestCatalog, @NotNull Schema schema, @Nullable String namePattern, @NotNull Function<Routine, DasRoutine.Kind> kindProvider, boolean noCatalog) throws SQLException {
        RemoteResultSet rs;
        block5: {
            if (schema == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(31);
            }
            if (kindProvider == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(32);
            }
            rs = null;
            try {
                rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getFunctionColumns(requestCatalog, schema.schema, namePattern, null));
            }
            catch (SQLException e) {
                if (this.isUnimplemented(e)) break block5;
                throw e;
            }
        }
        if (rs == null) {
            return null;
        }
        return new RoutineArgumentIt(rs, this.getDbms(), schema, noCatalog, kindProvider, false).withErrorSink((PairConsumer)this.myErrorSink);
    }

    private boolean isUnimplemented(SQLException e) {
        String message = e.getMessage();
        if (this.getDbms() == Dbms.COCKROACH && message != null && message.contains("pg_function_is_visible")) {
            return true;
        }
        if ((this.getDbms().isSqlite() || this.getDbms() == Dbms.SNOWFLAKE) && message == null && e.getCause() == null) {
            return true;
        }
        if (this.getDbms().isOracle() && this.getConnection().getVersion().eqCoarse(new int[]{10}) && message != null && message.contains("ORA-00904") && ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.warn((Throwable)e);
            return true;
        }
        return message != null && (StringUtil.containsIgnoreCase((String)message, (String)"implemented") || StringUtil.containsIgnoreCase((String)message, (String)"unsupported") || StringUtil.containsIgnoreCase((String)message, (String)"not supported"));
    }

    @NotNull
    public ClosableIt.GroupingIt<TableFKey, TableFKeyColumn> tableFKeyColumns(@NotNull Table table) throws SQLException {
        if (table == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(33);
        }
        RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getImportedKeys(table.schema.database, table.schema.schema, table.name));
        return new TableFKeyColumnIt.Grouping(new TableFKeyColumnIt(rs, table).withErrorSink((PairConsumer)this.myErrorSink));
    }

    @NotNull
    public ClosableIt.GroupingIt<TableIndex, TableIndexColumn> tableIndexColumns(@NotNull Table table) throws SQLException {
        if (table == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(34);
        }
        RemoteResultSet rs = this.getTableIndexColumnsWrapper(table);
        return new TableIndexColumnIt.Grouping(new TableIndexColumnIt(rs, table).withErrorSink((PairConsumer)this.myErrorSink));
    }

    @NotNull
    public ClosableIt<TableColumn> tableVersionColumns(@NotNull Table table) throws SQLException {
        if (table == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(35);
        }
        RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getVersionColumns(table.schema.database, table.schema.schema, table.name));
        ClosableIt closableIt = new TableVersionColumnIt(rs, table).withErrorSink((PairConsumer)this.myErrorSink);
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(36);
        }
        return closableIt;
    }

    @Nullable
    private RemoteResultSet getRoutineArgumentsWrapper(@NotNull Schema schema, @Nullable String namePattern) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(37);
        }
        try {
            return (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getProcedureColumns(schema.database, schema.schema, StringUtil.notNullize((String)namePattern, (String)"%"), null));
        }
        catch (NullPointerException e) {
            if (this.getDbms().isSqlite()) {
                LOG.debug((Throwable)e);
                return null;
            }
            throw e;
        }
        catch (SQLException e) {
            if (this.isUnimplemented(e)) {
                return null;
            }
            return (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getProcedureColumns(schema.database, schema.schema, "%", null));
        }
    }

    private RemoteResultSet getTableIndexColumnsWrapper(@NotNull Table table) throws SQLException {
        if (table == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(38);
        }
        try {
            return (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getIndexInfo(table.schema.database, table.schema.schema, table.name, false, true));
        }
        catch (SQLException ex) {
            try {
                String q = this.getQuote();
                return (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getIndexInfo(q + table.schema.database + q, q + table.schema.schema + q, q + table.name + q, false, true));
            }
            catch (SQLException ex2) {
                throw ex;
            }
        }
    }

    public String getQuote() {
        if (this.myQuote == null) {
            try {
                this.myQuote = (String)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getIdentifierQuoteString());
            }
            catch (SQLException e) {
                this.myQuote = "\"";
                this.onError(null, e);
            }
        }
        return this.myQuote;
    }

    public String[] getAllTableTypes() throws SQLException {
        RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getTableTypes());
        if (rs == null) {
            return null;
        }
        LinkedHashSet<Object> result2 = new LinkedHashSet<Object>();
        try {
            while (JdbcNativeUtil.getBooleanSafe(() -> rs.next())) {
                result2.add(JdbcNativeUtil.computeRemote(() -> rs.getString("TABLE_TYPE")));
            }
        }
        catch (SQLException sQLException) {
        }
        catch (Exception e) {
            this.myErrorSink.consume(null, (Object)e);
        }
        return result2.isEmpty() ? null : ArrayUtilRt.toStringArray(result2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected ClosableIt<? extends Table> tablesInner(@NotNull Schema schema, @Nullable String namePattern, @Nullable String[] types) throws SQLException {
        boolean hasNext;
        ResultSetWrapper rs;
        block10: {
            if (schema == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(39);
            }
            rs = null;
            try {
                try {
                    RemoteResultSet resultSet = this.myMetaData.getTables(schema.database, schema.schema, StringUtil.notNullize((String)namePattern, (String)"%"), types);
                    rs = new ResultSetWrapper(resultSet);
                    hasNext = rs.next();
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                    ClosableIt closableIt = types == null ? ClosableIt.empty() : this.tablesInner(schema, namePattern, null);
                    ResultSetWrapper.close(rs);
                    ClosableIt closableIt2 = closableIt;
                    if (closableIt2 == null) {
                        DatabaseMetaDataWrapper.$$$reportNull$$$0(40);
                    }
                    return closableIt2;
                }
            }
            catch (Throwable throwable) {
                ResultSetWrapper.close(rs);
                throw throwable;
            }
            if (hasNext || types == null || types.length == 1) break block10;
            ClosableIt<? extends Table> e = this.tablesInner(schema, namePattern, null);
            ResultSetWrapper.close(rs);
            ClosableIt<? extends Table> closableIt = e;
            if (closableIt == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(41);
            }
            return closableIt;
        }
        ClosableIt it = new TableIt(rs, this.getDbms(), hasNext, schema).withErrorSink((PairConsumer)this.myErrorSink);
        rs = null;
        ClosableIt closableIt = it;
        ResultSetWrapper.close(rs);
        ClosableIt closableIt3 = closableIt;
        if (closableIt3 == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(42);
        }
        return closableIt3;
    }

    @NotNull
    public ClosableIt<? extends UserDefinedType> userDefinedTypes(@NotNull Schema schema, @Nullable String namePattern) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(43);
        }
        RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getUDTs(schema.database, schema.schema, StringUtil.notNullize((String)namePattern, (String)"%"), null));
        return new UserDefinedTypeIt(rs, schema);
    }

    @NotNull
    public ClosableIt<? extends Type> types() throws SQLException {
        RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getTypeInfo());
        return new TypeIt(rs);
    }

    @NotNull
    public ClosableIt.GroupingIt<UserDefinedType, UserDefinedTypeAttribute> userDefinedTypeAttributes(@NotNull Schema schema, @Nullable String namePattern, @Nullable Set<String> types) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(44);
        }
        UserDefinedTypeAttributeIt.Grouping res2 = new UserDefinedTypeAttributeIt.Grouping(this.userDefinedTypeAttributesInner(schema, namePattern));
        ClosableIt.GroupingIt groupingIt = types != null ? (ClosableIt.GroupingIt)res2.filter(t -> types.contains(t.name)) : res2;
        if (groupingIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(45);
        }
        return groupingIt;
    }

    @NotNull
    protected ClosableIt<UserDefinedTypeAttribute> userDefinedTypeAttributesInner(@NotNull @NotNull @NotNull Schema schema, @Nullable String namePattern) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(46);
        }
        try {
            RemoteResultSet rs = (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> this.myMetaData.getAttributes(schema.database, schema.schema, "%", StringUtil.notNullize((String)namePattern, (String)"%")));
            return new UserDefinedTypeAttributeIt(rs, this.getDbms(), schema);
        }
        catch (SQLException e) {
            if (this.isUnimplemented(e)) {
                ClosableIt<UserDefinedTypeAttribute> closableIt = ClosableIt.empty();
                if (closableIt == null) {
                    DatabaseMetaDataWrapper.$$$reportNull$$$0(47);
                }
                return closableIt;
            }
            throw e;
        }
    }

    @NotNull
    public RemoteDatabaseMetaData getMetaData() {
        RemoteDatabaseMetaData remoteDatabaseMetaData = this.myMetaData;
        if (remoteDatabaseMetaData == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(48);
        }
        return remoteDatabaseMetaData;
    }

    @Nullable
    public Casing getCasing() {
        return DataSourceInfo.getCasing((Dbms)this.getDbms(), (RemoteDatabaseMetaData)this.myMetaData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 46: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 46: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databases";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 31: 
            case 37: 
            case 39: 
            case 43: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 16: 
            case 33: 
            case 34: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 23: 
            case 25: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kindProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "withErrorSink";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "databases";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "tables";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "routines";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProceduresInner";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableColumnsInner";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableColumnsInner2";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "routineArgumentsInner";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcedureArgumentsInner";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "tableVersionColumns";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "tablesInner";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "userDefinedTypeAttributes";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "userDefinedTypeAttributesInner";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaData";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "schemas";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tables";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "routines";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getProceduresInner";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionsInner";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "tableKeys";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tableColumns";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTableColumnsInner";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTableColumnsInner2";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "routineArguments";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "routineArgumentsInner";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getProcedureArgumentsInner";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionArgumentsInner";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "tableFKeyColumns";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "tableIndexColumns";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "tableVersionColumns";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getRoutineArgumentsWrapper";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getTableIndexColumnsWrapper";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "tablesInner";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "userDefinedTypes";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "userDefinedTypeAttributes";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "userDefinedTypeAttributesInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 46: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OraMetadataWrapper
    extends DatabaseMetaDataWrapper {
        public static final List<String> BAD_PREFIXES = ContainerUtil.immutableList((Object[])new String[]{"BIN$", "CREATE$", "JAVA$", "DR$", "XDB$", "DRV$", "RUPD$", "MLOG$"});

        OraMetadataWrapper(@NotNull DatabaseConnection connection, @NotNull RemoteDatabaseMetaData data) {
            if (connection == null) {
                OraMetadataWrapper.$$$reportNull$$$0(0);
            }
            if (data == null) {
                OraMetadataWrapper.$$$reportNull$$$0(1);
            }
            super(connection, data);
        }

        @Override
        @NotNull
        public ClosableIt<? extends Table> tables(@NotNull Schema schema, @Nullable String namePattern, @Nullable String[] types) throws SQLException {
            if (schema == null) {
                OraMetadataWrapper.$$$reportNull$$$0(2);
            }
            ClosableIt<? extends Table> tableIt = super.tables(schema, namePattern, types);
            tableIt.filter(OraMetadataWrapper::isValidTable);
            ClosableIt<? extends Table> closableIt = tableIt;
            if (closableIt == null) {
                OraMetadataWrapper.$$$reportNull$$$0(3);
            }
            return closableIt;
        }

        @Override
        @NotNull
        public ClosableIt<Routine> routines(@NotNull Schema schema, @Nullable String pkg, @Nullable String namePattern) throws SQLException {
            if (schema == null) {
                OraMetadataWrapper.$$$reportNull$$$0(4);
            }
            ClosableIt<Routine> routineIt = super.routines(schema, pkg, namePattern);
            routineIt.filter(OraMetadataWrapper::isValidRoutine);
            ClosableIt<Routine> closableIt = routineIt;
            if (closableIt == null) {
                OraMetadataWrapper.$$$reportNull$$$0(5);
            }
            return closableIt;
        }

        private static boolean startsWithBadPrefix(@Nullable String s) {
            if (s != null) {
                for (String prefix : BAD_PREFIXES) {
                    if (!StringUtil.startsWithIgnoreCase((String)s, (String)prefix)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isSys(@NotNull Schema schema) {
            if (schema == null) {
                OraMetadataWrapper.$$$reportNull$$$0(6);
            }
            return Comparing.equal((String)"sys", (String)schema.schema, (boolean)false) || Comparing.equal((String)"sys", (String)schema.schema, (boolean)true);
        }

        private static boolean isValidSysName(@Nullable String s) {
            return s == null || !s.contains("$");
        }

        private static boolean isValidRoutine(@NotNull Routine routine) {
            if (routine == null) {
                OraMetadataWrapper.$$$reportNull$$$0(7);
            }
            if (OraMetadataWrapper.isSys(routine.schema)) {
                return OraMetadataWrapper.isValidSysName(routine.pkg) && OraMetadataWrapper.isValidSysName(routine.name);
            }
            return !OraMetadataWrapper.startsWithBadPrefix(routine.pkg) && !OraMetadataWrapper.startsWithBadPrefix(routine.name);
        }

        private static boolean isValidTable(@NotNull Table table) {
            if (table == null) {
                OraMetadataWrapper.$$$reportNull$$$0(8);
            }
            if (OraMetadataWrapper.isSys(table.schema)) {
                return OraMetadataWrapper.isValidSysName(table.name);
            }
            return !OraMetadataWrapper.startsWithBadPrefix(table.name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schema";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$OraMetadataWrapper";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "routine";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$OraMetadataWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tables";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "routines";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "tables";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "routines";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isSys";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isValidRoutine";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isValidTable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AseMetadataWrapper
    extends DatabaseMetaDataWrapper {
        AseMetadataWrapper(@NotNull DatabaseConnection connection, @NotNull RemoteDatabaseMetaData data) {
            if (connection == null) {
                AseMetadataWrapper.$$$reportNull$$$0(0);
            }
            if (data == null) {
                AseMetadataWrapper.$$$reportNull$$$0(1);
            }
            super(connection, data);
        }

        @Override
        @NotNull
        public ClosableIt<? extends Table> tables(@NotNull Schema schema, @Nullable String namePattern, @Nullable String[] types) throws SQLException {
            if (schema == null) {
                AseMetadataWrapper.$$$reportNull$$$0(2);
            }
            ClosableIt<? extends Table> tableIt = super.tables(schema, namePattern, types);
            tableIt.filter(tab -> AseRoutineIt.isSybTableName(tab.name, tab.type));
            ClosableIt<? extends Table> closableIt = tableIt;
            if (closableIt == null) {
                AseMetadataWrapper.$$$reportNull$$$0(3);
            }
            return closableIt;
        }

        @Override
        @NotNull
        public ClosableIt<Routine> routines(@NotNull Schema schema, @Nullable String pkg, @Nullable String namePattern) throws SQLException {
            if (schema == null) {
                AseMetadataWrapper.$$$reportNull$$$0(4);
            }
            ClosableIt<Routine> routineIt = super.routines(schema, pkg, namePattern);
            ClosableIt<Routine> closableIt = this.append(routineIt, () -> this.sybaseTableRoutines(schema, namePattern));
            if (closableIt == null) {
                AseMetadataWrapper.$$$reportNull$$$0(5);
            }
            return closableIt;
        }

        @Override
        @NotNull
        public ClosableIt<RoutineArgument> routineArgumentsInner(@NotNull Schema schema, @Nullable String namePattern, @NotNull Function<Routine, DasRoutine.Kind> kindProvider) throws SQLException {
            if (schema == null) {
                AseMetadataWrapper.$$$reportNull$$$0(6);
            }
            if (kindProvider == null) {
                AseMetadataWrapper.$$$reportNull$$$0(7);
            }
            ClosableIt<RoutineArgument> argumentIt = super.routineArgumentsInner(schema, namePattern, kindProvider);
            ClosableIt<RoutineArgument> closableIt = this.append(argumentIt, () -> this.sybaseRoutineArguments(schema, namePattern));
            if (closableIt == null) {
                AseMetadataWrapper.$$$reportNull$$$0(8);
            }
            return closableIt;
        }

        @Nullable
        private ClosableIt<Routine> sybaseTableRoutines(@NotNull Schema schema, @Nullable String namePattern) throws SQLException {
            if (schema == null) {
                AseMetadataWrapper.$$$reportNull$$$0(9);
            }
            ClosableIt<? extends Table> tables = this.tablesInner(schema, namePattern, new String[]{"SYSTEM TABLE"});
            tables.filter(tab -> !AseRoutineIt.isSybTableName(tab.name, tab.type));
            return new AseRoutineIt(schema, (Iterator<? extends Table>)((Object)tables));
        }

        private ClosableIt<RoutineArgument> sybaseRoutineArguments(@NotNull Schema schema, @Nullable String namePattern) throws SQLException {
            if (schema == null) {
                AseMetadataWrapper.$$$reportNull$$$0(10);
            }
            return new AseRoutineArgumentIt(schema, (Iterator<? extends TableColumn>)((Object)this.getTableColumnsInner(schema, namePattern, null)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schema";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$AseMetadataWrapper";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kindProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$AseMetadataWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tables";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "routines";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "routineArgumentsInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "tables";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "routines";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "routineArgumentsInner";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "sybaseTableRoutines";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "sybaseRoutineArguments";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PgMetadataWrapper
    extends DatabaseMetaDataWrapper {
        PgMetadataWrapper(@NotNull DatabaseConnection connection, @NotNull RemoteDatabaseMetaData data) {
            if (connection == null) {
                PgMetadataWrapper.$$$reportNull$$$0(0);
            }
            if (data == null) {
                PgMetadataWrapper.$$$reportNull$$$0(1);
            }
            super(connection, data);
        }

        @Override
        @NotNull
        public ClosableIt<? extends Table> tables(@NotNull Schema schema, @Nullable String namePattern, @Nullable String[] types) throws SQLException {
            if (schema == null) {
                PgMetadataWrapper.$$$reportNull$$$0(2);
            }
            ClosableIt<? extends Table> tableIt = super.tables(schema, namePattern, types);
            tableIt.filter(tab -> !"INDEX".equals(tab.type));
            ClosableIt<? extends Table> closableIt = tableIt;
            if (closableIt == null) {
                PgMetadataWrapper.$$$reportNull$$$0(3);
            }
            return closableIt;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schema";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$PgMetadataWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$PgMetadataWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "tables";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RoutineArgument
    extends TypedElement {
        public final Routine routine;
        public int position;
        @Nullable
        public String name;
        @Nullable
        public String def;
        public ArgumentDirection direction;
        @Nullable
        public String comment;

        public RoutineArgument(@NotNull Routine routine) {
            if (routine == null) {
                RoutineArgument.$$$reportNull$$$0(0);
            }
            this.routine = routine;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$RoutineArgument", "<init>"));
        }
    }

    public static class Routine
    implements Assignable<Routine> {
        public final Schema schema;
        @Nullable
        public String pkg;
        @NotNull
        public String name;
        public short number;
        @NotNull
        public String specificName;
        @Nullable
        public String comment;
        @NotNull
        public DasRoutine.Kind kind;

        public Routine(@NotNull Schema schema, @Nullable String pkg, @NotNull String name2) {
            if (schema == null) {
                Routine.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                Routine.$$$reportNull$$$0(1);
            }
            this.name = "";
            this.number = 0;
            this.specificName = "";
            this.kind = DasRoutine.Kind.NONE;
            this.schema = schema;
            this.pkg = pkg;
            this.name = name2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "schema";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$Routine";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UserDefinedTypeAttribute
    implements Assignable<UserDefinedTypeAttribute> {
        public final UserDefinedType userDefinedType;
        @Nullable
        public String name;
        public int type;
        @Nullable
        public String typeName;
        @Nullable
        public String comment;
        public int length;
        public int scale;
        public boolean nullable;
        @Nullable
        public String def;
        public int position;

        public UserDefinedTypeAttribute(@NotNull UserDefinedType userDefinedType) {
            if (userDefinedType == null) {
                UserDefinedTypeAttribute.$$$reportNull$$$0(0);
            }
            this.userDefinedType = userDefinedType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userDefinedType", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$UserDefinedTypeAttribute", "<init>"));
        }
    }

    public static class UserDefinedType
    implements Assignable<UserDefinedType> {
        public final Schema schema;
        @Nullable
        public String name;
        @Nullable
        public String comment;

        public UserDefinedType(@NotNull Schema schema) {
            if (schema == null) {
                UserDefinedType.$$$reportNull$$$0(0);
            }
            this.schema = schema;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$UserDefinedType", "<init>"));
        }
    }

    public static class Type
    implements Assignable<Type> {
        @Nullable
        public String name;
    }

    public static class TableIndexColumn
    implements Assignable<TableIndexColumn> {
        public final TableIndex index;
        @Nullable
        public String name;
        public short position;
        public DasIndex.Sorting sorting;

        public TableIndexColumn(@NotNull TableIndex index2) {
            if (index2 == null) {
                TableIndexColumn.$$$reportNull$$$0(0);
            }
            this.index = index2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableIndexColumn", "<init>"));
        }
    }

    public static class TableFKeyColumn
    implements Assignable<TableFKeyColumn> {
        public final TableFKey fk;
        @Nullable
        public String name;
        @Nullable
        public String targetName;
        public short position;

        public TableFKeyColumn(@NotNull TableFKey fk) {
            if (fk == null) {
                TableFKeyColumn.$$$reportNull$$$0(0);
            }
            this.fk = fk;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fk", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableFKeyColumn", "<init>"));
        }
    }

    public static class TableKeyColumn
    implements Assignable<TableKeyColumn> {
        public final TableKey key;
        @Nullable
        public String name;
        public short position;

        public TableKeyColumn(@NotNull TableKey key2) {
            if (key2 == null) {
                TableKeyColumn.$$$reportNull$$$0(0);
            }
            this.key = key2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableKeyColumn", "<init>"));
        }
    }

    public static class TableIndex
    implements Assignable<TableIndex> {
        public final Table table;
        @Nullable
        public String name;
        public boolean nonUnique;
        @Nullable
        public String qualifier;
        public short type;

        public TableIndex(@NotNull Table table, @Nullable String name2) {
            if (table == null) {
                TableIndex.$$$reportNull$$$0(0);
            }
            this.table = table;
            this.name = name2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableIndex", "<init>"));
        }
    }

    public static class TableFKey
    implements Assignable<TableFKey> {
        public final Table table;
        public final Table targetTable;
        @Nullable
        public String name;
        public boolean surrogateName;
        public short updateRule;
        public short deleteRule;
        public short deferrability;

        public TableFKey(@NotNull Table table, @NotNull Table targetTable, @Nullable String name2) {
            if (table == null) {
                TableFKey.$$$reportNull$$$0(0);
            }
            if (targetTable == null) {
                TableFKey.$$$reportNull$$$0(1);
            }
            this.table = table;
            this.targetTable = targetTable;
            this.name = name2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "table";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetTable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableFKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TableKey
    implements Assignable<TableKey> {
        public final Table table;
        @Nullable
        public String name;
        public boolean primary;

        public TableKey(@NotNull Table table, @Nullable String name2) {
            if (table == null) {
                TableKey.$$$reportNull$$$0(0);
            }
            this.table = table;
            this.name = name2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableKey", "<init>"));
        }
    }

    public static class TableColumn
    extends TypedElement {
        public final Table table;
        public int position;
        @Nullable
        public String name;
        @Nullable
        public String def;
        public boolean autoIncrement;
        @Nullable
        public String comment;

        public TableColumn(@NotNull Table table) {
            if (table == null) {
                TableColumn.$$$reportNull$$$0(0);
            }
            this.table = table;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$TableColumn", "<init>"));
        }
    }

    public static class Table
    implements Assignable<Table> {
        public final Schema schema;
        @NotNull
        public String name;
        @Nullable
        public String type;
        @Nullable
        public String comment;

        public Table(@NotNull Schema schema, @NotNull String name2) {
            if (schema == null) {
                Table.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                Table.$$$reportNull$$$0(1);
            }
            this.name = "";
            this.schema = schema;
            this.name = name2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "schema";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$Table";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TypedElement
    extends JdbcHelper.Type
    implements Assignable<TypedElement> {
    }

    public static class Schema
    implements Assignable<Schema> {
        @NotNull
        public String schema;
        @Nullable
        public String database;

        public Schema(@NotNull String schema, @Nullable String database) {
            if (schema == null) {
                Schema.$$$reportNull$$$0(0);
            }
            this.schema = schema;
            this.database = database;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$Schema", "<init>"));
        }
    }

    public static interface Assignable<T extends Assignable> {
        default public void assign(T val) {
            try {
                for (Field field : this.getClass().getFields()) {
                    if (Modifier.isFinal(field.getModifiers())) continue;
                    Object o = field.get(val);
                    if (Assignable.class.isAssignableFrom(field.getType())) {
                        ((Assignable)field.get(this)).assign((Assignable)o);
                        continue;
                    }
                    field.set(this, o);
                }
            }
            catch (IllegalAccessException e) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
            }
        }
    }
}

