/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.clickhouse;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConvertor;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CHouseDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public CHouseDialect() {
        super(new TypeHelper.CHouseTypeHelper(), Casing.create((Case)Case.EXACT, (Case)Case.EXACT));
    }

    @NotNull
    public String getDisplayName() {
        return "ClickHouse";
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.CLICKHOUSE;
        if (dbms == null) {
            CHouseDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(1);
        }
        if (view == null) {
            CHouseDialect.$$$reportNull$$$0(2);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL((DdlBuilder)builder, (DasTable)view, (Boolean)cascade);
        if (ddlBuilder == null) {
            CHouseDialect.$$$reportNull$$$0(3);
        }
        return ddlBuilder;
    }

    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            CHouseDialect.$$$reportNull$$$0(4);
        }
        String schema = DasUtil.getSchema((DasObject)element);
        NamingService namingService = this.getNamingService();
        String quotes = this.getCodeStyle().getQuotesPriority();
        return Pair.create((Object)("SHOW CREATE TABLE " + (schema.isEmpty() ? "" : namingService.nameToScript(schema, false, quotes) + ".") + namingService.nameToScript(element.getName(), false, quotes)), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return false;
    }

    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            CHouseDialect.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException();
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public boolean supportsSystemViewDefinition() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(6);
        }
        if (procedure == null) {
            CHouseDialect.$$$reportNull$$$0(7);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            CHouseDialect.$$$reportNull$$$0(8);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                CHouseDialect.$$$reportNull$$$0(9);
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if ("DOUBLE".equals(typeName) && jdbcType == 8 && precision == 22 && scale == 0) {
            return "double";
        }
        if ("MEDIUMINT".equals(typeName) && jdbcType == 4 && precision == 7 && scale == 0) {
            return "mediumint";
        }
        if ("MEDIUMINT UNSIGNED".equals(typeName) && jdbcType == 4 && precision == 7 && scale == 0) {
            return "mediumint unsigned";
        }
        if ("MEDIUMBLOB".equals(typeName) && jdbcType == -4 && precision == 0xFFFFFF && scale == 0) {
            return "mediumblob";
        }
        if ("TINYBLOB".equals(typeName) && jdbcType == -2 && precision == 255 && scale == 0) {
            return "tinyblob";
        }
        if ("DATETIME".equals(typeName) && jdbcType == 93 && precision == 19 && scale == 0) {
            return "datetime";
        }
        String name2 = super.getTypeName(dataType);
        String unsigned = "unsigned";
        String string = StringUtil.endsWithIgnoreCase((String)typeName, (String)unsigned) && !StringUtil.endsWithIgnoreCase((String)name2, (String)unsigned) ? name2 + " " + unsigned : name2;
        if (string == null) {
            CHouseDialect.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(11);
        }
        if (sequence == null) {
            CHouseDialect.$$$reportNull$$$0(12);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    public boolean supportsTableDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element) {
        if (element == null) {
            CHouseDialect.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsTableInfo() {
        return false;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) {
        if (element == null) {
            CHouseDialect.$$$reportNull$$$0(14);
        }
        if (connection == null) {
            CHouseDialect.$$$reportNull$$$0(15);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) {
        if (table == null) {
            CHouseDialect.$$$reportNull$$$0(16);
        }
        if (connection == null) {
            CHouseDialect.$$$reportNull$$$0(17);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) throws SQLException {
        Dbms dbms;
        String s;
        if (system == null) {
            CHouseDialect.$$$reportNull$$$0(18);
        }
        if (connection == null) {
            CHouseDialect.$$$reportNull$$$0(19);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults((DatabaseConnection)connection, (Dbms)(dbms = connection.getDbms()), (String)"select currentDatabase()", (int)1, (DbImplUtil.ConcatenationProps)DbImplUtil.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            CHouseDialect.$$$reportNull$$$0(20);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("use %s", this.getNamingService().nameToScript(current.getDisplayName(), false, this.getCodeStyle().getQuotesPriority()));
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Nullable
    private static DasObject getDB(@NotNull DasObject qualifier) {
        DasObject schema;
        if (qualifier == null) {
            CHouseDialect.$$$reportNull$$$0(21);
        }
        return (schema = DasUtil.getSchemaObject((DasObject)qualifier)) != null && !StringUtil.isEmpty((String)schema.getName()) ? schema : DasUtil.getCatalogObject((DasObject)qualifier);
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            CHouseDialect.$$$reportNull$$$0(22);
        }
        if (qualifier == null) {
            CHouseDialect.$$$reportNull$$$0(23);
        }
        DasObject db = CHouseDialect.getDB(qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, db, DasUtil.getName((DasObject)db), null, null, null, null);
        if (ddlBuilder == null) {
            CHouseDialect.$$$reportNull$$$0(24);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            CHouseDialect.$$$reportNull$$$0(25);
        }
        String string = "0x" + DialectUtils.toHexString((byte[])binaryData);
        if (string == null) {
            CHouseDialect.$$$reportNull$$$0(26);
        }
        return string;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection) throws SQLException {
        if (connection == null) {
            CHouseDialect.$$$reportNull$$$0(27);
        }
        List list = (List)DbImplUtil.executeAndGetResult((DatabaseConnection)connection, (String)"SHOW DATABASES", (ThrowableConvertor)DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            CHouseDialect.$$$reportNull$$$0(28);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/clickhouse/CHouseDialect";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 4: 
            case 5: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/clickhouse/CHouseDialect";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryLiteralString";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropProcedure";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sqlTableDefinition";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDB";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

