/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.statements.CallableSmartStatement;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.dialects.db2.model.Db2DefType;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.properties.Db2DataTypeSubKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import java.sql.SQLException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Db2BaseDialect
extends AbstractDatabaseDialect {
    private final Dbms myDbms;

    public Db2BaseDialect(@NotNull Dbms dbms) {
        if (dbms == null) {
            Db2BaseDialect.$$$reportNull$$$0(0);
        }
        super(new TypeHelper.DB2TypeHelper(), Casing.create((Case)Case.UPPER, (Case)Case.EXACT));
        this.myDbms = dbms;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            Db2BaseDialect.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            Db2BaseDialect.$$$reportNull$$$0(2);
        }
        Dbms dbms = connection.getDbms();
        Map map2 = DbImplUtil.resultRowAsMap((DatabaseConnection)connection, (String)String.format("SELECT tabname, card, collationname, create_time FROM syscat.tables WHERE owner = '%s' AND tabname LIKE '%s' ESCAPE '#'", DbImplUtil.escapeStr((String)DasUtil.getSchema((DasObject)element)), DbImplUtil.escapeSql((Object)element.getName(), (boolean)true, (Dbms)dbms)), (String[])new String[]{"CARD", "rows", "COLLATIONNAME", "collation", "CREATE_TIME", "created"});
        if (map2 == null) {
            Db2BaseDialect.$$$reportNull$$$0(3);
        }
        return map2;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myDbms;
        if (dbms == null) {
            Db2BaseDialect.$$$reportNull$$$0(4);
        }
        return dbms;
    }

    @NotNull
    public String getDisplayName() {
        String string = StringUtil.trimStart((String)this.myDbms.getDisplayName(), (String)"IBM ");
        if (string == null) {
            Db2BaseDialect.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            Db2BaseDialect.$$$reportNull$$$0(6);
        }
        if (qualifier == null) {
            Db2BaseDialect.$$$reportNull$$$0(7);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DasObject catalog = DasUtil.getCatalogObject((DasObject)qualifier);
        String pkgName = qualifier instanceof DasRoutine ? ((DasRoutine)qualifier).getPackageName() : null;
        DasObject pkg = pkgName == null ? null : qualifier.getDasParent();
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), catalog, DasUtil.getName((DasObject)catalog), pkg, pkgName);
        if (ddlBuilder == null) {
            Db2BaseDialect.$$$reportNull$$$0(8);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            Db2BaseDialect.$$$reportNull$$$0(9);
        }
        String string = "BLOB(x'" + DialectUtils.toHexString((byte[])binaryData) + "')";
        if (string == null) {
            Db2BaseDialect.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private static String sysCat(@NotNull DasObject element) {
        if (element == null) {
            Db2BaseDialect.$$$reportNull$$$0(11);
        }
        Object dataSource = element instanceof DbElement ? ((DbElement)element).getDataSource() : (element instanceof BasicElement ? Db2BaseDialect.findDataSource(element) : null);
        LocalDataSource localDataSource = dataSource == null ? null : DbImplUtil.getLocalDataSource((DasDataSource)dataSource);
        String url = localDataSource == null ? null : localDataSource.getUrl();
        boolean as400 = url != null && url.contains(":as400:");
        return as400 ? "SYSIBM" : "SYSCAT";
    }

    private static DbDataSource findDataSource(@NotNull DasObject element) {
        if (element == null) {
            Db2BaseDialect.$$$reportNull$$$0(12);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            DbDataSource dataSource;
            if (project.isDefault() || !project.isOpen() || (dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(element)) == null) continue;
            return dataSource;
        }
        return null;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) throws SQLException {
        Dbms dbms;
        String s;
        if (system == null) {
            Db2BaseDialect.$$$reportNull$$$0(13);
        }
        if (connection == null) {
            Db2BaseDialect.$$$reportNull$$$0(14);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults((DatabaseConnection)connection, (Dbms)(dbms = connection.getDbms()), (String)"select current_schema from sysibm.sysdummy1", (int)1, (DbImplUtil.ConcatenationProps)DbImplUtil.ConcatenationProps.LINES))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            Db2BaseDialect.$$$reportNull$$$0(15);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("set schema %s", current.getName());
    }

    @NotNull
    public DdlBuilder generated(@NotNull DdlBuilder builder) {
        if (builder == null) {
            Db2BaseDialect.$$$reportNull$$$0(16);
        }
        DdlBuilder ddlBuilder = builder.space().keywords(new String[]{"GENERATED", "ALWAYS", "AS", "IDENTITY"}).plain("(").keywords(new String[]{"START", "WITH"}).space().literal("1").space().keywords(new String[]{"INCREMENT", "BY"}).space().literal("1").plain(")");
        if (ddlBuilder == null) {
            Db2BaseDialect.$$$reportNull$$$0(17);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            Db2BaseDialect.$$$reportNull$$$0(18);
        }
        if (sequence == null) {
            Db2BaseDialect.$$$reportNull$$$0(19);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropSequenceSQL((DdlBuilder)builder, (DasObject)sequence, (Boolean)false);
        if (ddlBuilder == null) {
            Db2BaseDialect.$$$reportNull$$$0(20);
        }
        return ddlBuilder;
    }

    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        String catalog;
        if (element == null) {
            Db2BaseDialect.$$$reportNull$$$0(21);
        }
        String query = (catalog = Db2BaseDialect.sysCat(element)).equals("SYSIBM") ? "SELECT 'CREATE VIEW ' || TABLE_NAME || ' AS ' || VIEW_DEFINITION FROM QSYS2.SYSVIEWS WHERE TABLE_SCHEMA = '" + DasUtil.getSchema((DasObject)element) + "' AND UPPER(TABLE_NAME) = '" + StringUtil.toUpperCase((String)element.getName()) + "'" : "SELECT TEXT FROM " + catalog + ".VIEWS WHERE VIEWSCHEMA = '" + DasUtil.getSchema((DasObject)element) + "' AND UPPER(VIEWNAME) = '" + StringUtil.toUpperCase((String)element.getName()) + "'";
        return Pair.create((Object)query, (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            Db2BaseDialect.$$$reportNull$$$0(22);
        }
        String catalog = Db2BaseDialect.sysCat((DasObject)element);
        DasRoutine.Kind type = element.getRoutineKind();
        String query = catalog.equals("SYSIBM") ? "SELECT ROUTINE_DEFINITION FROM QSYS2.SYSROUTINES  WHERE ROUTINE_SCHEMA='" + DasUtil.getSchema((DasObject)element) + "' AND UPPER(ROUTINE_NAME) = '" + StringUtil.toUpperCase((String)element.getName()) + "' AND ROUTINE_TYPE = '" + (type == DasRoutine.Kind.FUNCTION ? "FUNCTION" : "PROCEDURE") + "'" : "SELECT TEXT FROM " + catalog + ".ROUTINES WHERE ROUTINESCHEMA='" + DasUtil.getSchema((DasObject)element) + "' AND UPPER(ROUTINENAME) = '" + StringUtil.toUpperCase((String)element.getName()) + "' AND ROUTINETYPE = '" + (type == DasRoutine.Kind.FUNCTION ? "F" : "P") + "'";
        Pair pair = Pair.create((Object)query, (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            Db2BaseDialect.$$$reportNull$$$0(23);
        }
        return pair;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean supportsInsertDefaultIntoAutoVal() {
        return true;
    }

    @Nullable
    public SqlType getSqlType(@Nullable PsiElement refElement, @NotNull DbElement resolved) {
        Object delegate;
        if (resolved == null) {
            Db2BaseDialect.$$$reportNull$$$0(24);
        }
        if ((delegate = resolved.getDelegate()) instanceof Db2DefType) {
            Db2DataTypeSubKind subKind = ((Db2DefType)delegate).getSubKind();
            return SqlTableTypeBase.createObjectTypeType((DasObject)resolved, (PsiElement)resolved, (PsiElement)refElement, (subKind == Db2DataTypeSubKind.ROW ? 1 : 0) != 0);
        }
        return null;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            Db2BaseDialect.$$$reportNull$$$0(25);
        }
        if (connection == null) {
            Db2BaseDialect.$$$reportNull$$$0(26);
        }
        CallableSmartStatement statement = SmartStatements.poweredBy((DatabaseConnection)connection).call();
        CallableStatementData data = new StatementParameters().text(QNameUtil.getQualifiedName((DasObject)table)).parameter(2, 4).asCallData("CALL SYSPROC.DB2LK_GENERATE_DDL('-e -td ; -t ' || ?, ?)");
        Either token = statement.execute((Object)data, (ExecutionMode)StandardExecutionMode.UPDATE, StandardResultsProcessors.parameterRetriever((int)2));
        Dbms dbms = connection.getDbms();
        String string = token.isLeft() ? "Failed to load table definition" : StringUtil.trimEnd((String)DbImplUtil.concatStringResults((DatabaseConnection)connection, (Dbms)dbms, (String)("SELECT SQL_STMT FROM SYSTOOLS.DB2LOOK_INFO WHERE OP_TOKEN = " + token.tryGet()), (int)1, (DbImplUtil.ConcatenationProps)DbImplUtil.ConcatenationProps.NO_CONCAT), (String)";");
        if (string == null) {
            Db2BaseDialect.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Override
    public boolean hasRowId(@Nullable DasDataSource system) {
        Version version = system == null ? null : system.getVersion();
        return version == null || version.isOrGreater(new int[]{9, 4});
    }

    @Override
    public boolean similarTo(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            Db2BaseDialect.$$$reportNull$$$0(28);
        }
        return dialect instanceof Db2BaseDialect;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 17: 
            case 20: 
            case 23: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 17: 
            case 20: 
            case 23: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 11: 
            case 12: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 17: 
            case 20: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/db2/Db2BaseDialect";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/db2/Db2BaseDialect";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryLiteralString";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "generated";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSequence";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 17: 
            case 20: 
            case 23: 
            case 27: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sysCat";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findDataSource";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "generated";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSqlType";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "similarTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 17: 
            case 20: 
            case 23: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

