/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SimpleSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dialects.base.BaseExecutionEnvironmentHelper;
import com.intellij.database.dialects.mssql.MsExecutionEnvironmentHelper;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlSelectIntoClause;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.impl.SqlSequenceValueExpressionImpl;
import com.intellij.util.ThreeState;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.FilteredTraverserBase;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J<\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0014j\u0002`\u00150\u0013H\u0016J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dialects/mssql/MsExecutionEnvironmentHelper;", "Lcom/intellij/database/dialects/base/BaseExecutionEnvironmentHelper;", "()V", "getSslState", "Lcom/intellij/util/ThreeState;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "isSafeToLimitRowCount", "", "text", "", "project", "Lcom/intellij/openapi/project/Project;", "runInSpecificEnvironment", "", "sql", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "execution", "Lcom/intellij/util/ThrowableRunnable;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "setRowcount", "maxRows", "", "intellij.database.dialects.mssql"})
public final class MsExecutionEnvironmentHelper
extends BaseExecutionEnvironmentHelper {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public ThreeState getSslState(@NotNull DatabaseConnection connection) {
        ThreeState threeState;
        String encryption;
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        ExecutionMode executionMode = (ExecutionMode)StandardExecutionMode.QUERY;
        String string = "select encrypt_option from sys.dm_exec_connections where session_id = @@spid";
        SimpleSmartStatement simpleSmartStatement = SmartStatements.Companion.poweredBy(connection).simple();
        boolean $i$f$first = false;
        ResultsProducer.VoidReadyProcessor voidReadyProcessor = (ResultsProducer.VoidReadyProcessor)new ResultsProducer.VoidReadyProcessor<String>(){

            public String empty() {
                RemoteResultSet rs = null;
                boolean bl = false;
                return null;
            }

            public String results(@NotNull RemoteResultSet resultSet, int index2) {
                Intrinsics.checkParameterIsNotNull((Object)resultSet, (String)"resultSet");
                RemoteResultSet rs = resultSet.next() ? resultSet : null;
                boolean bl = false;
                RemoteResultSet remoteResultSet = rs;
                return remoteResultSet != null ? remoteResultSet.getString(1) : null;
            }

            public String parameterResults(@NotNull List<? extends OutParameter<?>> parameters2, @NotNull Function1<? super OutParameter<?>, ? extends Object> retriever, int index2) {
                Intrinsics.checkParameterIsNotNull(parameters2, (String)"parameters");
                Intrinsics.checkParameterIsNotNull(retriever, (String)"retriever");
                RemoteResultSet rs = null;
                boolean bl = false;
                return null;
            }

            public String updateCount(int count, int index2) {
                RemoteResultSet rs = null;
                boolean bl = false;
                return null;
            }
        };
        String string2 = encryption = (String)simpleSmartStatement.execute((Object)string, executionMode, voidReadyProcessor).rightOr(null);
        if (string2 != null) {
            switch (string2) {
                case "TRUE": {
                    threeState = ThreeState.YES;
                    return threeState;
                }
                case "FALSE": {
                    threeState = ThreeState.NO;
                    return threeState;
                }
            }
        }
        threeState = ThreeState.UNSURE;
        return threeState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runInSpecificEnvironment(@NotNull String sql, @NotNull Configuration configuration, @NotNull DatabaseConnection connection, @Nullable Project project, @NotNull ThrowableRunnable<Exception> execution) {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull(execution, (String)"execution");
        Integer maxRows = configuration.getMaxRows();
        boolean patch = false;
        if (maxRows != null && !DbImplUtil.isPageSizeUnlimited((int)maxRows) && this.isSafeToLimitRowCount(sql, project)) {
            this.setRowcount(maxRows, connection);
            patch = true;
        }
        try {
            execution.run();
        }
        finally {
            if (patch) {
                this.setRowcount(0, connection);
            }
        }
    }

    private final void setRowcount(int maxRows, DatabaseConnection connection) {
        SmartStatements.Companion.poweredBy(connection).simple(Configuration.Companion.sourced(SmartStatements.Source.SYSTEM)).execute((Object)("SET ROWCOUNT " + maxRows), (Function1)setRowcount.1.INSTANCE);
    }

    private final boolean isSafeToLimitRowCount(String text, Project project) {
        boolean bl;
        block4: {
            if (project == null) {
                return false;
            }
            SqlPsiFacade sqlPsiFacade = SqlPsiFacade.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlPsiFacade, (String)"SqlPsiFacade.getInstance(project)");
            SqlPsiFacade psiFacade = sqlPsiFacade;
            SqlFile sqlFile = psiFacade.createROFile(DbSqlUtil.getSqlDialect((Dbms)Dbms.MSSQL), (CharSequence)text, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlFile, (String)"psiFacade.createROFile(D\u2026(Dbms.MSSQL), text, null)");
            SqlFile sql = sqlFile;
            FilteredTraverserBase filteredTraverserBase = SyntaxTraverser.psiTraverser().withRoot((Object)sql);
            Intrinsics.checkExpressionValueIsNotNull((Object)filteredTraverserBase, (String)"SyntaxTraverser.psiTraverser().withRoot(sql)");
            SyntaxTraverser traverser2 = (SyntaxTraverser)filteredTraverserBase;
            FilteredTraverserBase filteredTraverserBase2 = traverser2.expandAndSkip((Condition)isSafeToLimitRowCount.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)filteredTraverserBase2, (String)"traverser\n      .expandA\u2026e || e is SqlBatchBlock }");
            Iterable $this$all$iv = (Iterable)filteredTraverserBase2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PsiElement statement = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(statement instanceof SqlCompositeElement) ? true : statement instanceof SqlSelectStatement && PsiTreeUtil.findChildOfType((PsiElement)statement, SqlFunctionCallExpression.class) == null && PsiTreeUtil.findChildOfType((PsiElement)statement, SqlSelectIntoClause.class) == null && PsiTreeUtil.findChildOfType((PsiElement)statement, SqlSequenceValueExpressionImpl.class) == null) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }
}

