/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.model;

import com.intellij.database.dialects.mssql.model.MsAliasType;
import com.intellij.database.dialects.mssql.model.MsDatabase;
import com.intellij.database.dialects.mssql.model.MsExtendedPropertiesHolder;
import com.intellij.database.dialects.mssql.model.MsRoutine;
import com.intellij.database.dialects.mssql.model.MsRule;
import com.intellij.database.dialects.mssql.model.MsSequence;
import com.intellij.database.dialects.mssql.model.MsSynonym;
import com.intellij.database.dialects.mssql.model.MsTable;
import com.intellij.database.dialects.mssql.model.MsTableType;
import com.intellij.database.dialects.mssql.model.MsView;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.NameValueType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.PropertyConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MsSchema
extends MsExtendedPropertiesHolder,
BasicModSchema,
BasicModIdentifiedElement {
    public static final BasicMetaProperty<Date> INTROSPECTION_TIMESTAMP = BasicMetaProperty.create((String)"IntrospectionTimestamp", (BasicMetaType)BasicMetaType.Types.DATE, null, MsSchema.class, (boolean)true);
    public static final BasicMetaProperty<Boolean> CURRENT = BasicMetaProperty.create((String)"Current", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)false, MsSchema.class, (boolean)true);
    public static final BasicMetaProperty<Long> ALIAS_TYPES_CHECK_SUM = BasicMetaProperty.create((String)"AliasTypesCheckSum", (BasicMetaType)BasicMetaType.Types.LONG, (Object)0L, MsSchema.class, (boolean)true);
    public static final BasicMetaProperty<Long> TABLE_TYPES_CHECK_SUM = BasicMetaProperty.create((String)"TableTypesCheckSum", (BasicMetaType)BasicMetaType.Types.LONG, (Object)0L, MsSchema.class, (boolean)true);
    public static final BasicMetaProperty<Long> DESCRIPTIONS_CHECK_SUM = BasicMetaProperty.create((String)"DescriptionsCheckSum", (BasicMetaType)BasicMetaType.Types.LONG, (Object)0L, MsSchema.class, (boolean)true);

    @Nullable
    default public MsDatabase getDatabase() {
        return this.getParent();
    }

    @Nullable
    public MsDatabase getParent();

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends MsSchema> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends MsAliasType> getAliasTypes();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends MsTableType> getTableTypes();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends MsTable> getTables();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends MsView> getViews();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends MsRoutine> getRoutines();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends MsSynonym> getSynonyms();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends MsSequence> getSequences();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends MsRule> getRules();

    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.ALIAS_TYPE, ObjectKind.TABLE_TYPE, ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.ROUTINE, ObjectKind.SYNONYM, ObjectKind.SEQUENCE, ObjectKind.RULE);
        if (list == null) {
            MsSchema.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getAliasTypes(), this.getTableTypes(), this.getTables(), this.getViews(), this.getRoutines(), this.getSynonyms(), this.getSequences(), this.getRules());
        if (list == null) {
            MsSchema.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public String getComment();

    @Override
    @NotNull
    public List<NameValueType> getExtendedProperties();

    public long getAliasTypesCheckSum();

    public long getTableTypesCheckSum();

    public long getDescriptionsCheckSum();

    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        long descriptionsCheckSum;
        long tableTypesCheckSum;
        long aliasTypesCheckSum;
        boolean current;
        Date introspectionTimestamp;
        List<NameValueType> extendedProperties;
        boolean outdated;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name2;
        long objectId;
        if (consumer == null) {
            MsSchema.$$$reportNull$$$0(2);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", (Object)PropertyConverter.export((long)objectId));
        }
        if ((name2 = this.getName()) != null && name2 != ModelConsts.NO_NAME) {
            consumer.accept("Name", (Object)PropertyConverter.export((String)name2));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", (Object)PropertyConverter.export((boolean)nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", (Object)PropertyConverter.export((boolean)nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", (Object)PropertyConverter.export((boolean)nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", (Object)PropertyConverter.export((String)comment));
        }
        if (outdated = this.isOutdated()) {
            consumer.accept("Outdated", (Object)PropertyConverter.export((boolean)outdated));
        }
        if (!(extendedProperties = this.getExtendedProperties()).isEmpty()) {
            consumer.accept("ExtendedProperties", (Object)PropertyConverter.exportListOfNameValueType(extendedProperties));
        }
        if ((introspectionTimestamp = this.getIntrospectionTimestamp()) != null) {
            consumer.accept("IntrospectionTimestamp", (Object)PropertyConverter.export((Date)introspectionTimestamp));
        }
        if (current = this.isCurrent()) {
            consumer.accept("Current", (Object)PropertyConverter.export((boolean)current));
        }
        if ((aliasTypesCheckSum = this.getAliasTypesCheckSum()) != 0L) {
            consumer.accept("AliasTypesCheckSum", (Object)PropertyConverter.export((long)aliasTypesCheckSum));
        }
        if ((tableTypesCheckSum = this.getTableTypesCheckSum()) != 0L) {
            consumer.accept("TableTypesCheckSum", (Object)PropertyConverter.export((long)tableTypesCheckSum));
        }
        if ((descriptionsCheckSum = this.getDescriptionsCheckSum()) != 0L) {
            consumer.accept("DescriptionsCheckSum", (Object)PropertyConverter.export((long)descriptionsCheckSum));
        }
    }

    @Override
    public void setExtendedProperties(@NotNull List<NameValueType> var1);

    @Override
    default public void setExtendedProperties(NameValueType ... extendedProperties) {
        this.setExtendedProperties(Arrays.asList(extendedProperties));
    }

    public void setAliasTypesCheckSum(long var1);

    public void setTableTypesCheckSum(long var1);

    public void setDescriptionsCheckSum(long var1);

    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            MsSchema.$$$reportNull$$$0(3);
        }
        String objectId = _properties.get("ObjectId");
        String name2 = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String outdated = _properties.get("Outdated");
        String extendedProperties = _properties.get("ExtendedProperties");
        String introspectionTimestamp = _properties.get("IntrospectionTimestamp");
        String current = _properties.get("Current");
        String aliasTypesCheckSum = _properties.get("AliasTypesCheckSum");
        String tableTypesCheckSum = _properties.get("TableTypesCheckSum");
        String descriptionsCheckSum = _properties.get("DescriptionsCheckSum");
        this.setObjectId(objectId != null ? PropertyConverter.importLong((String)objectId) : Long.MIN_VALUE);
        this.setName(name2 != null ? PropertyConverter.importString((String)name2) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean((String)nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean((String)nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean((String)nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString((String)comment) : null);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean((String)outdated) : false);
        this.setExtendedProperties(extendedProperties != null ? PropertyConverter.importListOfNameValueType((String)extendedProperties) : Collections.emptyList());
        this.setIntrospectionTimestamp(introspectionTimestamp != null ? PropertyConverter.importDate((String)introspectionTimestamp) : null);
        this.setCurrent(current != null ? PropertyConverter.importBoolean((String)current) : false);
        this.setAliasTypesCheckSum(aliasTypesCheckSum != null ? PropertyConverter.importLong((String)aliasTypesCheckSum) : 0L);
        this.setTableTypesCheckSum(tableTypesCheckSum != null ? PropertyConverter.importLong((String)tableTypesCheckSum) : 0L);
        this.setDescriptionsCheckSum(descriptionsCheckSum != null ? PropertyConverter.importLong((String)descriptionsCheckSum) : 0L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/model/MsSchema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/model/MsSchema";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

