/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.base.GeneratedModelUtil;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraMixinBody;
import com.intellij.database.dialects.oracle.model.OraMixinMatLog;
import com.intellij.database.dialects.oracle.model.OraMixinSourceAware;
import com.intellij.database.dialects.oracle.model.OraMixinTable;
import com.intellij.database.dialects.oracle.model.OraMixinTableColumn;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraSequence;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.basic.BasicColumniation;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.properties.OraTableType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;

public class OraGeneratedModelUtil
extends GeneratedModelUtil {
    public static void setSubstituted(@NotNull OraSchema nsp) {
        if (nsp == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(0);
        }
        OraGeneratedModelUtil.setSubstituted(nsp);
        nsp.setIntrospectionTimestamp(null);
        nsp.setCommentsHash(0L);
    }

    @NotNull
    public static Iterable<? extends BasicElement> getPredecessors(@NotNull OraMixinSourceAware element) {
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(1);
        }
        BasicDatabase database = (BasicDatabase)BasicElement.parent((BasicElement)element, BasicDatabase.class);
        JBIterable jBIterable = JBIterable.from(element.getDependsOnIds()).map(objectId -> database.findIdentifiedElement(objectId.longValue())).filter(e -> e != null);
        if (jBIterable == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @NotNull
    public static Iterable<? extends BasicElement> getPredecessors(@NotNull OraTrigger element) {
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(3);
        }
        JBIterable jBIterable = JBIterable.from(OraGeneratedModelUtil.getPredecessors((OraMixinSourceAware)element)).append(OraGeneratedModelUtil.getPredecessors((BasicColumniation)element));
        if (jBIterable == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    public static boolean isElementSurrogate(@NotNull OraMixinTableColumn element) {
        OraTable table;
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(5);
        }
        return (table = element.getTable()) != null && table.getTableType() == OraTableType.MAT_LOG && element.getName().endsWith("$$");
    }

    public static boolean isElementSurrogate(@NotNull OraSequence sequence) {
        if (sequence == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(6);
        }
        return sequence.isBelongsToColumn();
    }

    @NotNull
    public static String calculateDisplayOrder(@NotNull OraMixinBody element) {
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(7);
        }
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String calculateDisplayOrder(@NotNull OraMixinTable element) {
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(9);
        }
        String string = element.identity(false);
        if (string == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static boolean getAutoCreated(@NotNull OraTable element) {
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(11);
        }
        switch (element.getTableType()) {
            case MAT_LOG: {
                return true;
            }
            case MAT_VIEW: {
                OraSchema schema = element.getSchema();
                if (schema == null) {
                    return false;
                }
                OraMatView mv = (OraMatView)schema.getMatViews().get(element.getName());
                if (mv == null) {
                    return false;
                }
                return !mv.isPrebuilt();
            }
            case BASIC: {
                return element.isSecondary();
            }
        }
        return false;
    }

    @NotNull
    public static String identity(@NotNull OraMixinBody element, boolean includingSurrogate) {
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(12);
        }
        return "#BODY";
    }

    @NotNull
    public static String identity(@NotNull OraMixinMatLog element, boolean includingSurrogate) {
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(13);
        }
        return includingSurrogate ? OraGeneratedModelUtil.identity((BasicElement)element, true) : "#ML";
    }

    @NotNull
    public static String identity(@NotNull OraMixinTable element, boolean includingSurrogate) {
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(14);
        }
        if (element.getTableType() == OraTableType.MAT_LOG) {
            if (includingSurrogate) {
                String string = element.getName();
                if (string == null) {
                    OraGeneratedModelUtil.$$$reportNull$$$0(15);
                }
                return string;
            }
            String masterTableName = StringUtil.notNullize((String)element.getMasterTableName(), (String)"???");
            String string = masterTableName + "'ML";
            if (string == null) {
                OraGeneratedModelUtil.$$$reportNull$$$0(16);
            }
            return string;
        }
        String string = OraGeneratedModelUtil.identity((BasicElement)element, includingSurrogate);
        if (string == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nsp";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/model/OraGeneratedModelUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/model/OraGeneratedModelUtil";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredecessors";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateDisplayOrder";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "identity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSubstituted";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPredecessors";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isElementSurrogate";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calculateDisplayOrder";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAutoCreated";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "identity";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

