/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraCheck;
import com.intellij.database.dialects.oracle.model.OraForeignKey;
import com.intellij.database.dialects.oracle.model.OraIndex;
import com.intellij.database.dialects.oracle.model.OraKey;
import com.intellij.database.dialects.oracle.model.OraMajorObject;
import com.intellij.database.dialects.oracle.model.OraMatLog;
import com.intellij.database.dialects.oracle.model.OraMixinTable;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraStoredSchemaObject;
import com.intellij.database.dialects.oracle.model.OraTableColumn;
import com.intellij.database.dialects.oracle.model.OraTableTrigger;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModTable;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.OraTableType;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.TableOrganization;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraTable
extends BasicModTable,
OraMajorObject,
OraMixinTable,
OraStoredSchemaObject {
    public static final BasicMetaProperty<OraTableType> TABLE_TYPE = BasicMetaProperty.create((String)"TableType", (BasicMetaType)BasicMetaType.Types.ORA_TABLE_TYPE, (Object)OraTableType.BASIC, OraTable.class, (boolean)false);
    public static final BasicMetaProperty<String> MASTER_TABLE_NAME = BasicMetaProperty.create((String)"MasterTableName", (BasicMetaType)BasicMetaType.Types.STRING, null, OraTable.class, (boolean)false);
    public static final BasicMetaProperty<Boolean> SECONDARY = BasicMetaProperty.create((String)"Secondary", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)false, OraTable.class, (boolean)false);
    public static final BasicMetaProperty<Boolean> TEMPORARY = BasicMetaProperty.create((String)"Temporary", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)false, OraTable.class, (boolean)false);
    public static final BasicMetaProperty<Boolean> TEMPORARY_PRESERVE = BasicMetaProperty.create((String)"TemporaryPreserve", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)false, OraTable.class, (boolean)false);
    public static final BasicMetaProperty<TableOrganization> ORGANIZATION = BasicMetaProperty.create((String)"Organization", (BasicMetaType)BasicMetaType.Types.TABLE_ORGANIZATION, (Object)TableOrganization.DEFAULT, OraTable.class, (boolean)false);
    public static final BasicMetaProperty<String> CLUSTER_NAME = BasicMetaProperty.create((String)"ClusterName", (BasicMetaType)BasicMetaType.Types.STRING, null, OraTable.class, (boolean)false);
    public static final BasicMetaProperty<List<String>> CLUSTER_COL_NAMES = BasicMetaProperty.create((String)"ClusterColNames", (BasicMetaType)BasicMetaType.Types.LIST_OF_STRING, Collections.emptyList(), OraTable.class, (boolean)false);

    @Nullable
    default public OraSchema getSchema() {
        return this.getParent();
    }

    @Nullable
    public OraSchema getParent();

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends OraTable> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull ModPositioningNamingFamily<@NotNull ? extends OraTableColumn> getColumns();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends OraIndex> getIndices();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends OraKey> getKeys();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends OraForeignKey> getForeignKeys();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends OraCheck> getChecks();

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends OraTableTrigger> getTriggers();

    @NotNull
    public @NotNull ModSingletonFamily<@NotNull ? extends OraMatLog> getMatLogs();

    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.COLUMN, ObjectKind.INDEX, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK, ObjectKind.TRIGGER, ObjectKind.MAT_LOG);
        if (list == null) {
            OraTable.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getColumns(), this.getIndices(), this.getKeys(), this.getForeignKeys(), this.getChecks(), this.getTriggers(), this.getMatLogs());
        if (list == null) {
            OraTable.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @Nullable
    public String getComment();

    public boolean isSecondary();

    public boolean isTemporaryPreserve();

    @NotNull
    public TableOrganization getOrganization();

    @Nullable
    public String getClusterName();

    @NotNull
    public List<String> getClusterColNames();

    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        List<String> clusterColNames;
        String clusterName;
        TableOrganization organization;
        boolean temporaryPreserve;
        boolean temporary;
        boolean secondary;
        String masterTableName;
        OraTableType tableType;
        String tablespaceName;
        Date modifiedTimestamp;
        Date createdTimestamp;
        boolean system;
        String rowTypeObjectName;
        String rowTypeSchemaName;
        boolean outdated;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name2;
        long objectId;
        if (consumer == null) {
            OraTable.$$$reportNull$$$0(2);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", (Object)PropertyConverter.export((long)objectId));
        }
        if ((name2 = this.getName()) != null && name2 != ModelConsts.NO_NAME) {
            consumer.accept("Name", (Object)PropertyConverter.export((String)name2));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", (Object)PropertyConverter.export((boolean)nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", (Object)PropertyConverter.export((boolean)nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", (Object)PropertyConverter.export((boolean)nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", (Object)PropertyConverter.export((String)comment));
        }
        if (outdated = this.isOutdated()) {
            consumer.accept("Outdated", (Object)PropertyConverter.export((boolean)outdated));
        }
        if ((rowTypeSchemaName = this.getRowTypeSchemaName()) != null) {
            consumer.accept("RowTypeSchemaName", (Object)PropertyConverter.export((String)rowTypeSchemaName));
        }
        if ((rowTypeObjectName = this.getRowTypeObjectName()) != null) {
            consumer.accept("RowTypeObjectName", (Object)PropertyConverter.export((String)rowTypeObjectName));
        }
        if (system = this.isSystem()) {
            consumer.accept("System", (Object)PropertyConverter.export((boolean)system));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer.accept("CreatedTimestamp", (Object)PropertyConverter.export((Date)createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer.accept("ModifiedTimestamp", (Object)PropertyConverter.export((Date)modifiedTimestamp));
        }
        if ((tablespaceName = this.getTablespaceName()) != null) {
            consumer.accept("TablespaceName", (Object)PropertyConverter.export((String)tablespaceName));
        }
        if ((tableType = this.getTableType()) != null && tableType != OraTableType.BASIC) {
            consumer.accept("TableType", (Object)PropertyConverter.export((Enum)tableType));
        }
        if ((masterTableName = this.getMasterTableName()) != null) {
            consumer.accept("MasterTableName", (Object)PropertyConverter.export((String)masterTableName));
        }
        if (secondary = this.isSecondary()) {
            consumer.accept("Secondary", (Object)PropertyConverter.export((boolean)secondary));
        }
        if (temporary = this.isTemporary()) {
            consumer.accept("Temporary", (Object)PropertyConverter.export((boolean)temporary));
        }
        if (temporaryPreserve = this.isTemporaryPreserve()) {
            consumer.accept("TemporaryPreserve", (Object)PropertyConverter.export((boolean)temporaryPreserve));
        }
        if ((organization = this.getOrganization()) != null && organization != TableOrganization.DEFAULT) {
            consumer.accept("Organization", (Object)PropertyConverter.export((TableOrganization)organization));
        }
        if ((clusterName = this.getClusterName()) != null) {
            consumer.accept("ClusterName", (Object)PropertyConverter.export((String)clusterName));
        }
        if (!(clusterColNames = this.getClusterColNames()).isEmpty()) {
            consumer.accept("ClusterColNames", (Object)PropertyConverter.exportListOfString(clusterColNames));
        }
    }

    public void setTableType(@NotNull OraTableType var1);

    public void setMasterTableName(@Nullable String var1);

    public void setSecondary(boolean var1);

    public void setTemporary(boolean var1);

    public void setTemporaryPreserve(boolean var1);

    public void setOrganization(@NotNull TableOrganization var1);

    public void setClusterName(@Nullable String var1);

    public void setClusterColNames(@NotNull List<String> var1);

    default public void setClusterColNames(String ... clusterColNames) {
        this.setClusterColNames(Arrays.asList(clusterColNames));
    }

    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            OraTable.$$$reportNull$$$0(3);
        }
        String objectId = _properties.get("ObjectId");
        String name2 = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String outdated = _properties.get("Outdated");
        String rowTypeSchemaName = _properties.get("RowTypeSchemaName");
        String rowTypeObjectName = _properties.get("RowTypeObjectName");
        String system = _properties.get("System");
        String createdTimestamp = _properties.get("CreatedTimestamp");
        String modifiedTimestamp = _properties.get("ModifiedTimestamp");
        String tablespaceName = _properties.get("TablespaceName");
        String tableType = _properties.get("TableType");
        String masterTableName = _properties.get("MasterTableName");
        String secondary = _properties.get("Secondary");
        String temporary = _properties.get("Temporary");
        String temporaryPreserve = _properties.get("TemporaryPreserve");
        String organization = _properties.get("Organization");
        String clusterName = _properties.get("ClusterName");
        String clusterColNames = _properties.get("ClusterColNames");
        this.setObjectId(objectId != null ? PropertyConverter.importLong((String)objectId) : Long.MIN_VALUE);
        this.setName(name2 != null ? PropertyConverter.importString((String)name2) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean((String)nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean((String)nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean((String)nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString((String)comment) : null);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean((String)outdated) : false);
        this.setRowTypeSchemaName(rowTypeSchemaName != null ? PropertyConverter.importString((String)rowTypeSchemaName) : null);
        this.setRowTypeObjectName(rowTypeObjectName != null ? PropertyConverter.importString((String)rowTypeObjectName) : null);
        this.setSystem(system != null ? PropertyConverter.importBoolean((String)system) : false);
        this.setCreatedTimestamp(createdTimestamp != null ? PropertyConverter.importDate((String)createdTimestamp) : null);
        this.setModifiedTimestamp(modifiedTimestamp != null ? PropertyConverter.importDate((String)modifiedTimestamp) : null);
        this.setTablespaceName(tablespaceName != null ? PropertyConverter.importString((String)tablespaceName) : null);
        this.setTableType(tableType != null ? PropertyConverter.importOraTableType((String)tableType) : OraTableType.BASIC);
        this.setMasterTableName(masterTableName != null ? PropertyConverter.importString((String)masterTableName) : null);
        this.setSecondary(secondary != null ? PropertyConverter.importBoolean((String)secondary) : false);
        this.setTemporary(temporary != null ? PropertyConverter.importBoolean((String)temporary) : false);
        this.setTemporaryPreserve(temporaryPreserve != null ? PropertyConverter.importBoolean((String)temporaryPreserve) : false);
        this.setOrganization(organization != null ? PropertyConverter.importTableOrganization((String)organization) : TableOrganization.DEFAULT);
        this.setClusterName(clusterName != null ? PropertyConverter.importString((String)clusterName) : null);
        this.setClusterColNames(clusterColNames != null ? PropertyConverter.importListOfString((String)clusterColNames) : Collections.emptyList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/model/OraTable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/model/OraTable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

