/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.model;

import com.intellij.database.dialects.postgres.model.PgRoutineArgument;
import com.intellij.database.dialects.postgres.model.PgSchema;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRoutine;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.PgRoutineConcurrencyKind;
import com.intellij.database.model.properties.PgVolatilityKind;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PgRoutine
extends PgGPlumBaseRoutine {
    public static final BasicMetaProperty<Float> ROWS = BasicMetaProperty.create((String)"Rows", (BasicMetaType)BasicMetaType.Types.FLOAT, (Object)Float.valueOf(0.0f), PgRoutine.class, (boolean)false);
    public static final BasicMetaProperty<PgRoutineConcurrencyKind> CONCURRENCY_KIND = BasicMetaProperty.create((String)"ConcurrencyKind", (BasicMetaType)BasicMetaType.Types.PG_ROUTINE_CONCURRENCY_KIND, (Object)PgRoutineConcurrencyKind.UNSAFE, PgRoutine.class, (boolean)false);
    public static final BasicMetaProperty<Boolean> WINDOW = BasicMetaProperty.create((String)"Window", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)false, PgRoutine.class, (boolean)false);

    @Override
    @Nullable
    default public PgSchema getSchema() {
        return this.getParent();
    }

    @Override
    @Nullable
    public PgSchema getParent();

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends PgRoutine> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull ModPositioningNamingFamily<@NotNull ? extends PgRoutineArgument> getArguments();

    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.singletonList(ObjectKind.ARGUMENT);
        if (list == null) {
            PgRoutine.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModPositioningNamingFamily<? extends PgRoutineArgument>> list = Collections.singletonList(this.getArguments());
        if (list == null) {
            PgRoutine.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SourceError> getErrors();

    @Override
    @NotNull
    public List<String> getConfigurationParameters();

    public float getRows();

    @NotNull
    public PgRoutineConcurrencyKind getConcurrencyKind();

    public boolean isWindow();

    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean window;
        PgRoutineConcurrencyKind concurrencyKind;
        float rows;
        float cost;
        boolean leakproof;
        boolean securityDefiner;
        boolean strict;
        boolean returnsSet;
        DasRoutine.Kind routineKind;
        List<String> configurationParameters;
        String languageName;
        String resultsDefinition;
        String argumentsDefinition;
        PgVolatilityKind volatilityKind;
        long stateNumber;
        boolean invalid;
        List<SourceError> errors;
        int sourceTextLength;
        boolean faceless;
        String owner;
        boolean outdated;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name2;
        long objectId;
        if (consumer == null) {
            PgRoutine.$$$reportNull$$$0(2);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", (Object)PropertyConverter.export((long)objectId));
        }
        if ((name2 = this.getName()) != null && name2 != ModelConsts.NO_NAME) {
            consumer.accept("Name", (Object)PropertyConverter.export((String)name2));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", (Object)PropertyConverter.export((boolean)nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", (Object)PropertyConverter.export((boolean)nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", (Object)PropertyConverter.export((boolean)nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", (Object)PropertyConverter.export((String)comment));
        }
        if (outdated = this.isOutdated()) {
            consumer.accept("Outdated", (Object)PropertyConverter.export((boolean)outdated));
        }
        if ((owner = this.getOwner()) != null) {
            consumer.accept("Owner", (Object)PropertyConverter.export((String)owner));
        }
        if (faceless = this.isFaceless()) {
            consumer.accept("Faceless", (Object)PropertyConverter.export((boolean)faceless));
        }
        if ((sourceTextLength = this.getSourceTextLength()) != 0) {
            consumer.accept("SourceTextLength", (Object)PropertyConverter.export((int)sourceTextLength));
        }
        if (!(errors = this.getErrors()).isEmpty()) {
            consumer.accept("Errors", (Object)PropertyConverter.exportListOfSourceError(errors));
        }
        if (invalid = this.isInvalid()) {
            consumer.accept("Invalid", (Object)PropertyConverter.export((boolean)invalid));
        }
        if ((stateNumber = this.getStateNumber()) != 0L) {
            consumer.accept("StateNumber", (Object)PropertyConverter.export((long)stateNumber));
        }
        if ((volatilityKind = this.getVolatilityKind()) != null) {
            consumer.accept("VolatilityKind", (Object)PropertyConverter.export((Enum)volatilityKind));
        }
        if ((argumentsDefinition = this.getArgumentsDefinition()) != null) {
            consumer.accept("ArgumentsDefinition", (Object)PropertyConverter.export((String)argumentsDefinition));
        }
        if ((resultsDefinition = this.getResultsDefinition()) != null) {
            consumer.accept("ResultsDefinition", (Object)PropertyConverter.export((String)resultsDefinition));
        }
        if ((languageName = this.getLanguageName()) != null) {
            consumer.accept("LanguageName", (Object)PropertyConverter.export((String)languageName));
        }
        if (!(configurationParameters = this.getConfigurationParameters()).isEmpty()) {
            consumer.accept("ConfigurationParameters", (Object)PropertyConverter.exportListOfString(configurationParameters));
        }
        if ((routineKind = this.getRoutineKind()) != null && routineKind != DasRoutine.Kind.NONE) {
            consumer.accept("RoutineKind", (Object)PropertyConverter.export((Enum)routineKind));
        }
        if (returnsSet = this.isReturnsSet()) {
            consumer.accept("ReturnsSet", (Object)PropertyConverter.export((boolean)returnsSet));
        }
        if (strict = this.isStrict()) {
            consumer.accept("Strict", (Object)PropertyConverter.export((boolean)strict));
        }
        if (securityDefiner = this.isSecurityDefiner()) {
            consumer.accept("SecurityDefiner", (Object)PropertyConverter.export((boolean)securityDefiner));
        }
        if (leakproof = this.isLeakproof()) {
            consumer.accept("Leakproof", (Object)PropertyConverter.export((boolean)leakproof));
        }
        if ((cost = this.getCost()) != 0.0f) {
            consumer.accept("Cost", (Object)PropertyConverter.export((float)cost));
        }
        if ((rows = this.getRows()) != 0.0f) {
            consumer.accept("Rows", (Object)PropertyConverter.export((float)rows));
        }
        if ((concurrencyKind = this.getConcurrencyKind()) != null && concurrencyKind != PgRoutineConcurrencyKind.UNSAFE) {
            consumer.accept("ConcurrencyKind", (Object)PropertyConverter.export((Enum)concurrencyKind));
        }
        if (window = this.isWindow()) {
            consumer.accept("Window", (Object)PropertyConverter.export((boolean)window));
        }
    }

    @Override
    public void setErrors(@NotNull List<SourceError> var1);

    @Override
    default public void setErrors(SourceError ... errors) {
        this.setErrors(Arrays.asList(errors));
    }

    @Override
    public void setConfigurationParameters(@NotNull List<String> var1);

    @Override
    default public void setConfigurationParameters(String ... configurationParameters) {
        this.setConfigurationParameters(Arrays.asList(configurationParameters));
    }

    public void setRows(float var1);

    public void setConcurrencyKind(@NotNull PgRoutineConcurrencyKind var1);

    public void setWindow(boolean var1);

    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            PgRoutine.$$$reportNull$$$0(3);
        }
        String objectId = _properties.get("ObjectId");
        String name2 = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String outdated = _properties.get("Outdated");
        String owner = _properties.get("Owner");
        String faceless = _properties.get("Faceless");
        String sourceTextLength = _properties.get("SourceTextLength");
        String errors = _properties.get("Errors");
        String invalid = _properties.get("Invalid");
        String stateNumber = _properties.get("StateNumber");
        String volatilityKind = _properties.get("VolatilityKind");
        String argumentsDefinition = _properties.get("ArgumentsDefinition");
        String resultsDefinition = _properties.get("ResultsDefinition");
        String languageName = _properties.get("LanguageName");
        String configurationParameters = _properties.get("ConfigurationParameters");
        String routineKind = _properties.get("RoutineKind");
        String returnsSet = _properties.get("ReturnsSet");
        String strict = _properties.get("Strict");
        String securityDefiner = _properties.get("SecurityDefiner");
        String leakproof = _properties.get("Leakproof");
        String cost = _properties.get("Cost");
        String rows = _properties.get("Rows");
        String concurrencyKind = _properties.get("ConcurrencyKind");
        String window = _properties.get("Window");
        this.setObjectId(objectId != null ? PropertyConverter.importLong((String)objectId) : Long.MIN_VALUE);
        this.setName(name2 != null ? PropertyConverter.importString((String)name2) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean((String)nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean((String)nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean((String)nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString((String)comment) : null);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean((String)outdated) : false);
        this.setOwner(owner != null ? PropertyConverter.importString((String)owner) : null);
        this.setFaceless(faceless != null ? PropertyConverter.importBoolean((String)faceless) : false);
        this.setSourceTextLength(sourceTextLength != null ? PropertyConverter.importInt((String)sourceTextLength) : 0);
        this.setErrors(errors != null ? PropertyConverter.importListOfSourceError((String)errors) : Collections.emptyList());
        this.setInvalid(invalid != null ? PropertyConverter.importBoolean((String)invalid) : false);
        this.setStateNumber(stateNumber != null ? PropertyConverter.importLong((String)stateNumber) : 0L);
        this.setVolatilityKind(volatilityKind != null ? PropertyConverter.importPgVolatilityKind((String)volatilityKind) : null);
        this.setArgumentsDefinition(argumentsDefinition != null ? PropertyConverter.importString((String)argumentsDefinition) : null);
        this.setResultsDefinition(resultsDefinition != null ? PropertyConverter.importString((String)resultsDefinition) : null);
        this.setLanguageName(languageName != null ? PropertyConverter.importString((String)languageName) : null);
        this.setConfigurationParameters(configurationParameters != null ? PropertyConverter.importListOfString((String)configurationParameters) : Collections.emptyList());
        this.setRoutineKind(routineKind != null ? PropertyConverter.importDasRoutineKind((String)routineKind) : DasRoutine.Kind.NONE);
        this.setReturnsSet(returnsSet != null ? PropertyConverter.importBoolean((String)returnsSet) : false);
        this.setStrict(strict != null ? PropertyConverter.importBoolean((String)strict) : false);
        this.setSecurityDefiner(securityDefiner != null ? PropertyConverter.importBoolean((String)securityDefiner) : false);
        this.setLeakproof(leakproof != null ? PropertyConverter.importBoolean((String)leakproof) : false);
        this.setCost(cost != null ? PropertyConverter.importFloat((String)cost) : 0.0f);
        this.setRows(rows != null ? PropertyConverter.importFloat((String)rows) : 0.0f);
        this.setConcurrencyKind(concurrencyKind != null ? PropertyConverter.importPgRoutineConcurrencyKind((String)concurrencyKind) : PgRoutineConcurrencyKind.UNSAFE);
        this.setWindow(window != null ? PropertyConverter.importBoolean((String)window) : false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgres/model/PgRoutine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgres/model/PgRoutine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

