/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sybase.plan;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SimpleSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dialects.base.plan.RawPlanData;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.remote.jdbc.RemoteClob;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.util.ThrowableConsumer;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

class AseRawPlanData
extends RawPlanData {
    public String xml;

    AseRawPlanData() {
    }

    @Override
    public void load(final @NotNull DatabaseConnection connection, final @NotNull String statement, final boolean run) {
        if (connection == null) {
            AseRawPlanData.$$$reportNull$$$0(0);
        }
        if (statement == null) {
            AseRawPlanData.$$$reportNull$$$0(1);
        }
        this.xml = null;
        AseRawPlanData.useStatementWithPreserved(connection, (RawPlanData.ResourceUser<? super ReusableSmartStatement<String>>)new RawPlanData.ResourceUser<ReusableSmartStatement<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void use(ReusableSmartStatement<String> s) throws PlanRetrievalException, SQLException {
                SimpleSmartStatement ignoreErrors = SmartStatements.poweredBy((DatabaseConnection)connection).simple(Configuration.sourced((SmartStatements.Source)SmartStatements.Source.SYSTEM));
                String option = run ? "show_execio_xml" : "show_exec_xml";
                try {
                    s.barren().execute((Object)("SET NOEXEC OFF\nSET PLAN FOR " + option + " OFF"));
                    ignoreErrors.execute((Object)"SET STATEMENT_CACHE OFF", (ExecutionMode)StandardExecutionMode.GENERIC);
                    AseRawPlanData.commit(connection);
                    s.barren().execute((Object)("SET PLAN FOR " + option + " TO MESSAGE ON\n" + (run ? "" : "SET NOEXEC ON\n")));
                    s.barren().execute((Object)(statement + (run ? "" : "\nSET NOEXEC OFF")));
                    s.noisy().execute((Object)"SELECT showplan_in_xml(0)", AseRawPlanData.processing((ThrowableConsumer<? super RemoteResultSet, ? extends Exception>)rs -> {
                        String xml;
                        if (!rs.next()) {
                            AseRawPlanData.failWithEmptyResultSetError();
                        }
                        if (rs.getMetaData().getColumnCount() != 1) {
                            throw new PlanRetrievalException("Database returned data in unknown format");
                        }
                        RemoteClob res2 = rs.getClob(1);
                        if (res2 == null) {
                            throw new PlanRetrievalException("Database returned null plan");
                        }
                        try {
                            xml = res2.getSubString(1L, (int)res2.length());
                            if (!xml.startsWith("<?xml") || !xml.endsWith(run ? "</query>\n" : "</Emit>\n")) {
                                throw new PlanRetrievalException("Result is trimmed");
                            }
                        }
                        catch (Throwable throwable) {
                            JdbcNativeUtil.performRemote(() -> ((RemoteClob)res2).free());
                            throw throwable;
                        }
                        JdbcNativeUtil.performRemote(() -> ((RemoteClob)res2).free());
                        if (rs.next()) {
                            throw new PlanRetrievalException("Database returned too many data");
                        }
                        AseRawPlanData.this.xml = xml;
                    }));
                }
                finally {
                    try {
                        Either result2 = s.barren().quiet().execute((Object)("SET NOEXEC OFF\nSET SHOWPLAN OFF\nSET PLAN FOR " + option + " OFF"));
                        ignoreErrors.execute((Object)"SET STATEMENT_CACHE ON", (ExecutionMode)StandardExecutionMode.GENERIC);
                        if (result2.isRight()) {
                            AseRawPlanData.commit(connection);
                        }
                    }
                    catch (PlanRetrievalException planRetrievalException) {}
                }
            }
        }, AseRawPlanData.setAutoCommit(false));
    }

    @Override
    public void load(@NotNull String dump) {
        if (dump == null) {
            AseRawPlanData.$$$reportNull$$$0(2);
        }
        this.xml = dump;
    }

    private static void commit(@NotNull DatabaseConnection connection) {
        if (connection == null) {
            AseRawPlanData.$$$reportNull$$$0(3);
        }
        try {
            connection.commit();
        }
        catch (SQLException e) {
            throw new PlanRetrievalException("Failed to commit transaction", (Throwable)e);
        }
    }

    @Override
    public String dump() {
        return this.xml;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dump";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/sybase/plan/AseRawPlanData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "load";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "commit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

