/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.derby;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.derby.DerbyTokens;
import com.intellij.sql.dialects.derby.DerbyTypeSystem;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DerbyDialect
extends SqlLanguageDialectEx {
    public static final DerbyDialect INSTANCE = new DerbyDialect();

    public DerbyDialect() {
        super("Derby");
    }

    @NotNull
    public SqlTypeSystem getTypeSystem() {
        DerbyTypeSystem derbyTypeSystem = DerbyTypeSystem.INSTANCE;
        if (derbyTypeSystem == null) {
            DerbyDialect.$$$reportNull$$$0(0);
        }
        return derbyTypeSystem;
    }

    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"xml", (String)"XML", (SqlLanguageDialectEx)this);
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.DERBY;
        if (dbms == null) {
            DerbyDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            DerbyDialect.$$$reportNull$$$0(2);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            DerbyDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            DerbyDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            DerbyDialect.$$$reportNull$$$0(5);
        }
        return set;
    }

    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            DerbyDialect.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            DerbyDialect.$$$reportNull$$$0(7);
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue((String)name2, (String)LazyData.RE_SESSION.name, (boolean)resolve) && !processor.executeTarget((DasObject)LazyData.RE_SESSION, element, SqlTypeFactory.REFERENCE, Boolean.valueOf(false), ResolveState.initial())) {
            return false;
        }
        return super.processReservedEntitiesWithType(name2, element, resolve, processor);
    }

    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        ProblemDescriptor result2 = this.checkIdentifierStartsWithLetter(o, manager, onTheFly);
        return result2 != null ? result2 : super.checkIdentifierText(o, manager, onTheFly);
    }

    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        if (identifier == null) {
            DerbyDialect.$$$reportNull$$$0(8);
        }
        return 128;
    }

    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        DasNamespace namespace = DerbyDialect.getDefaultNamespace((DbDataSource)dataSource, null);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern((ObjectName[])dsNames, (DasObject)namespace, (TreePatternNode.Group[])new TreePatternNode.Group[0]);
            if (treePattern == null) {
                DerbyDialect.$$$reportNull$$$0(9);
            }
            return treePattern;
        }
        String schema = (String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtil.getUserName((RawConnectionConfig)SqlImportUtil.getConnectionConfig((DbDataSource)dataSource)), (Object)"APP");
        return new TreePattern(SqlImportUtil.createDataSources((ObjectName[])dsNames, (TreePatternNode.Group[])new TreePatternNode.Group[]{TreePatternUtils.create((ObjectName)ObjectName.plain((String)schema), (ObjectKind)ObjectKind.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])}));
    }

    public boolean supportsJoinUsing() {
        return true;
    }

    public boolean supportsNaturalJoin() {
        return true;
    }

    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            DerbyDialect.$$$reportNull$$$0(10);
        }
        return super.isTableAliasAllowedAt(element) || PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlDeleteStatement.class, SqlUpdateStatement.class}) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/derby/DerbyDialect";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/derby/DerbyDialect";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(DerbyTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = new SqlLanguageDialectEx.BuiltinFunctionsMap(SqlFunctionsUtil.loadFunctionDefinition((SqlLanguageDialectEx)INSTANCE));
        static final Set<String> ourSystemVars;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final Set<IElementType> ourSupportedOperators;
        static ReservedEntity RE_SESSION;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars((SqlLanguageDialect)INSTANCE));
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_EQEQ});
            RE_SESSION = new ReservedEntity("session", ObjectKind.NONE);
        }
    }
}

