/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.mongo.js.ES6Parser;
import com.intellij.sql.dialects.mongo.js.FunctionParser;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.JavaScriptParser;

public class MongoJSParser
extends JavaScriptParser {
    public MongoJSParser(PsiBuilder builder) {
        super(builder);
        this.myExpressionParser = new MongoJSExpressionParser(this);
        this.myFunctionParser = new MongoJSFunctionParser(this);
    }

    static class MongoJSExpressionParser
    extends ES6Parser.ES6ExpressionParser {
        protected MongoJSExpressionParser(MongoJSParser parser) {
            super(parser);
        }

        @Override
        public void parseArgumentList() {
            LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.LPAR);
            PsiBuilder.Marker arglist = this.builder.mark();
            this.parseArgumentListNoMarker();
            if (this.builder.getTokenType() == JSElementTypes.LBRACE) {
                this.parseObjectLiteralExpression(false);
            }
            arglist.done(JSElementTypes.ARGUMENT_LIST);
        }

        @Override
        protected boolean parseDialectSpecificMemberExpressionPart(Ref<PsiBuilder.Marker> markerRef) {
            if (this.builder.getTokenType() == JSElementTypes.LBRACE) {
                PsiBuilder.Marker arglist = this.builder.mark();
                this.parseObjectLiteralExpression(false);
                arglist.done(JSElementTypes.ARGUMENT_LIST);
            }
            return false;
        }

        @Override
        public boolean parsePrimaryExpression() {
            IElementType firstToken = this.builder.getTokenType();
            if (firstToken == JSElementTypes.HEREDOC_BOUND) {
                PsiBuilder.Marker marker = this.builder.mark();
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSElementTypes.HEREDOC_BODY) {
                    this.builder.advanceLexer();
                }
                MongoJSExpressionParser.checkMatches(this.builder, JSElementTypes.HEREDOC_BOUND, "heredoc closing identifier expected");
                marker.done(JSElementTypes.HEREDOC);
                return true;
            }
            return super.parsePrimaryExpression();
        }

        @Override
        public boolean isPropertyNameStart(IElementType elementType) {
            return super.isPropertyNameStart(elementType) || elementType == JSElementTypes.BACKQUOTE;
        }

        @Override
        protected boolean parsePropertyNoMarker(PsiBuilder.Marker property) {
            if (this.builder.getTokenType() == JSElementTypes.BACKQUOTE) {
                this.parseStringTemplate();
                this.parsePropertyInitializer(false);
                property.done((IElementType)JSElementTypes.PROPERTY);
                property.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
                return true;
            }
            return super.parsePropertyNoMarker(property);
        }
    }

    static class MongoJSFunctionParser
    extends ES6Parser.ES6FunctionParser {
        protected MongoJSFunctionParser(MongoJSParser parser) {
            super(parser);
        }

        @Override
        public boolean parseFunctionName(boolean functionKeywordWasOmitted, FunctionParser.Context context) {
            super.parseFunctionName(functionKeywordWasOmitted, context);
            return true;
        }
    }
}

