/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.dialects.postgres.PgDialectBase;
import com.intellij.sql.psi.SqlType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PgBaseTypeSystem
extends SqlTypeSystem {
    protected PgBaseTypeSystem(PgDialectBase dialect) {
        super((SqlLanguageDialectEx)dialect);
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            PgBaseTypeSystem.$$$reportNull$$$0(0);
        }
        if ((name2 = super.getNormalizedTypeName(name2)).endsWith("[]")) {
            String string = this.getNormalizedTypeName(name2.substring(0, name2.length() - 2)) + "[]";
            if (string == null) {
                PgBaseTypeSystem.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (name2.equals("int8")) {
            return "bigint";
        }
        if (name2.equals("serial8")) {
            return "bigserial";
        }
        if (name2.equals("bool")) {
            return "boolean";
        }
        if (name2.equals("character varying")) {
            return "varchar";
        }
        if (name2.equals("float8")) {
            return "double precision";
        }
        if (name2.equals("int4")) {
            return "integer";
        }
        if (name2.equals("int")) {
            return "integer";
        }
        if (name2.equals("decimal")) {
            return "numeric";
        }
        if (name2.equals("float4")) {
            return "real";
        }
        if (name2.equals("int2")) {
            return "smallint";
        }
        if (name2.equals("serial4")) {
            return "serial";
        }
        if (name2.equals("serial2")) {
            return "smallserial";
        }
        String string = name2;
        if (string == null) {
            PgBaseTypeSystem.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            PgBaseTypeSystem.$$$reportNull$$$0(3);
        }
        switch (cat) {
            case INTEGER: {
                return "integer";
            }
            case REAL: {
                return "numeric";
            }
            case STRING: {
                return "text";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "date";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "interval";
            }
            case BYTES: {
                return "bytea";
            }
            case ARRAY: {
                return "anyarray";
            }
            case TABLE: {
                return "anyarray";
            }
            case RECORD: {
                return "record";
            }
        }
        return null;
    }

    @NotNull
    public DataType normalizeType(@NotNull DataType type) {
        if (type == null) {
            PgBaseTypeSystem.$$$reportNull$$$0(4);
        }
        if ("without time zone".equalsIgnoreCase(type.suffix)) {
            DataType dataType = DataTypeFactory.of((String)type.schemaName, (String)this.getNormalizedTypeName(type.typeName), (int)type.size, (int)type.scale, (LengthUnit)type.sizeUnit, null, (boolean)type.sizeUnitExplicit, (boolean)type.custom, (int)type.jdbcType);
            if (dataType == null) {
                PgBaseTypeSystem.$$$reportNull$$$0(5);
            }
            return dataType;
        }
        DataType dataType = super.normalizeType(type);
        if (dataType == null) {
            PgBaseTypeSystem.$$$reportNull$$$0(6);
        }
        return dataType;
    }

    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            PgBaseTypeSystem.$$$reportNull$$$0(7);
        }
        if (typeName.equals("record")) {
            SqlType.Category category = SqlType.Category.RECORD;
            if (category == null) {
                PgBaseTypeSystem.$$$reportNull$$$0(8);
            }
            return category;
        }
        if (typeName.equals("setof")) {
            SqlType.Category category = SqlType.Category.SETOF;
            if (category == null) {
                PgBaseTypeSystem.$$$reportNull$$$0(9);
            }
            return category;
        }
        if (typeName.endsWith("[]")) {
            SqlType.Category category = SqlType.Category.ARRAY;
            if (category == null) {
                PgBaseTypeSystem.$$$reportNull$$$0(10);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            PgBaseTypeSystem.$$$reportNull$$$0(11);
        }
        return category;
    }

    public boolean isTriggerFunctionType(@NotNull DataType returnType) {
        String typeName;
        if (returnType == null) {
            PgBaseTypeSystem.$$$reportNull$$$0(12);
        }
        return "trigger".equalsIgnoreCase(typeName = returnType.typeName) || "event_trigger".equalsIgnoreCase(typeName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/postgres/PgBaseTypeSystem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/postgres/PgBaseTypeSystem";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "normalizeType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isTriggerFunctionType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

