/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.snowflake;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.dialects.snowflake.SFlakeDialect;
import com.intellij.sql.psi.SqlType;
import org.jetbrains.annotations.NotNull;

public class SFlakeTypeSystem
extends SqlTypeSystem {
    public static final SFlakeTypeSystem INSTANCE = new SFlakeTypeSystem();

    private SFlakeTypeSystem() {
        super((SqlLanguageDialectEx)SFlakeDialect.INSTANCE);
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            SFlakeTypeSystem.$$$reportNull$$$0(0);
        }
        String string = super.getNormalizedTypeName(this.getDefaultTypeName(this.getTypeCategoryByName(name2)));
        if (string == null) {
            SFlakeTypeSystem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            SFlakeTypeSystem.$$$reportNull$$$0(2);
        }
        switch (cat) {
            case INTEGER: {
                return "integer";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case REAL: {
                return "float";
            }
            case STRING: {
                return "varchar";
            }
            case BYTES: {
                return "binary";
            }
            case ARRAY: {
                return "array";
            }
            case DATE_TIME: 
            case TIMESTAMP: {
                return "timestamp";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case COLLECTION: {
                return "array";
            }
            case RECORD: {
                return "object";
            }
        }
        return "variant";
    }

    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            SFlakeTypeSystem.$$$reportNull$$$0(3);
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"string")) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                SFlakeTypeSystem.$$$reportNull$$$0(4);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"bit")) {
            SqlType.Category category = SqlType.Category.BYTES;
            if (category == null) {
                SFlakeTypeSystem.$$$reportNull$$$0(5);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"dec")) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                SFlakeTypeSystem.$$$reportNull$$$0(6);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"numeric")) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                SFlakeTypeSystem.$$$reportNull$$$0(7);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"timestamp")) {
            SqlType.Category category = SqlType.Category.TIMESTAMP;
            if (category == null) {
                SFlakeTypeSystem.$$$reportNull$$$0(8);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"array")) {
            SqlType.Category category = SqlType.Category.ARRAY;
            if (category == null) {
                SFlakeTypeSystem.$$$reportNull$$$0(9);
            }
            return category;
        }
        if (StringUtil.containsIgnoreCase((String)typeName, (String)"object")) {
            SqlType.Category category = SqlType.Category.RECORD;
            if (category == null) {
                SFlakeTypeSystem.$$$reportNull$$$0(10);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            SFlakeTypeSystem.$$$reportNull$$$0(11);
        }
        return category;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/snowflake/SFlakeTypeSystem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/snowflake/SFlakeTypeSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

