/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.ImplementationViewElement;
import com.intellij.codeInsight.hint.ImplementationViewSession;
import com.intellij.codeInsight.hint.ImplementationViewSessionFactory;
import com.intellij.codeInsight.hint.PsiImplementationSessionViewFactory;
import com.intellij.codeInsight.hint.PsiImplementationViewElement;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiImplementationViewSession
implements ImplementationViewSession {
    private static final Logger LOG = Logger.getInstance(PsiImplementationViewSession.class);
    @NotNull
    private final Project myProject;
    @Nullable
    private final PsiElement myElement;
    private final PsiElement[] myImpls;
    private final String myText;
    @Nullable
    private final Editor myEditor;
    @Nullable
    private final VirtualFile myFile;
    private final boolean myIsSearchDeep;
    private final boolean myAlwaysIncludeSelf;

    public PsiImplementationViewSession(@NotNull Project project, @Nullable PsiElement element2, PsiElement[] impls, String text2, @Nullable Editor editor, @Nullable VirtualFile file2, boolean isSearchDeep, boolean alwaysIncludeSelf) {
        if (project == null) {
            PsiImplementationViewSession.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myElement = element2;
        this.myImpls = impls;
        this.myText = text2;
        this.myEditor = editor;
        this.myFile = file2;
        this.myIsSearchDeep = isSearchDeep;
        this.myAlwaysIncludeSelf = alwaysIncludeSelf;
    }

    @Override
    @NotNull
    public ImplementationViewSessionFactory getFactory() {
        ImplementationViewSessionFactory implementationViewSessionFactory = (ImplementationViewSessionFactory)ImplementationViewSessionFactory.EP_NAME.findExtensionOrFail(PsiImplementationSessionViewFactory.class);
        if (implementationViewSessionFactory == null) {
            PsiImplementationViewSession.$$$reportNull$$$0(1);
        }
        return implementationViewSessionFactory;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            PsiImplementationViewSession.$$$reportNull$$$0(2);
        }
        return project;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement;
    }

    @Override
    @NotNull
    public List<ImplementationViewElement> getImplementationElements() {
        List list2 = ContainerUtil.map((Object[])this.myImpls, PsiImplementationViewElement::new);
        if (list2 == null) {
            PsiImplementationViewSession.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    @Override
    @Nullable
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Override
    public boolean elementRequiresIncludeSelf() {
        return !(this.myElement instanceof PomTargetPsiElement);
    }

    @Override
    public boolean needUpdateInBackground() {
        return this.myElement != null;
    }

    public void dispose() {
    }

    static PsiElement @NotNull [] filterElements(PsiElement @NotNull [] targetElements) {
        if (targetElements == null) {
            PsiImplementationViewSession.$$$reportNull$$$0(4);
        }
        LinkedHashSet<PsiElement> unique = new LinkedHashSet<PsiElement>(Arrays.asList(targetElements));
        for (PsiElement elt : targetElements) {
            ApplicationManager.getApplication().runReadAction(() -> {
                PsiFile containingFile = elt.getContainingFile();
                LOG.assertTrue(containingFile != null, (Object)elt);
                PsiFile psiFile = containingFile.getOriginalFile();
                if (psiFile.getVirtualFile() == null) {
                    unique.remove(elt);
                }
            });
        }
        for (int i = 1; i < targetElements.length; ++i) {
            PsiElement targetElement = targetElements[i];
            if (!((Boolean)ReadAction.compute(() -> PsiTreeUtil.isAncestor((PsiElement)targetElement, (PsiElement)targetElements[0], (boolean)true))).booleanValue()) continue;
            unique.remove(targetElements[0]);
            break;
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(unique);
        if (psiElementArray == null) {
            PsiImplementationViewSession.$$$reportNull$$$0(5);
        }
        return psiElementArray;
    }

    @NotNull
    public static ImplementationSearcher createImplementationsSearcher(final boolean searchDeep) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new ImplementationSearcher(){

                @Override
                protected PsiElement[] filterElements(PsiElement element2, PsiElement[] targetElements) {
                    return PsiImplementationViewSession.filterElements(targetElements);
                }
            };
        }
        return new ImplementationSearcher.FirstImplementationsSearcher(){

            @Override
            protected PsiElement[] filterElements(PsiElement element2, PsiElement[] targetElements) {
                return PsiImplementationViewSession.filterElements(targetElements);
            }

            @Override
            protected boolean isSearchDeep() {
                return searchDeep;
            }
        };
    }

    static PsiElement @NotNull [] getSelfAndImplementations(Editor editor, @NotNull PsiElement element2, @NotNull ImplementationSearcher handler2) {
        if (element2 == null) {
            PsiImplementationViewSession.$$$reportNull$$$0(6);
        }
        if (handler2 == null) {
            PsiImplementationViewSession.$$$reportNull$$$0(7);
        }
        return PsiImplementationViewSession.getSelfAndImplementations(editor, element2, handler2, !(element2 instanceof PomTargetPsiElement));
    }

    public static PsiElement @NotNull [] getSelfAndImplementations(Editor editor, @NotNull PsiElement element2, @NotNull ImplementationSearcher handler2, boolean includeSelfAlways) {
        PsiElement[] handlerImplementations;
        if (element2 == null) {
            PsiImplementationViewSession.$$$reportNull$$$0(8);
        }
        if (handler2 == null) {
            PsiImplementationViewSession.$$$reportNull$$$0(9);
        }
        if ((handlerImplementations = handler2.searchImplementations(element2, editor, includeSelfAlways, true)).length > 0) {
            if (handlerImplementations == null) {
                PsiImplementationViewSession.$$$reportNull$$$0(10);
            }
            return handlerImplementations;
        }
        PsiElement[] psiElementArray = (PsiElement[])ReadAction.compute(() -> {
            PsiElement psiElement = element2;
            PsiFile psiFile = psiElement.getContainingFile();
            if (psiFile == null && (psiFile = (psiElement = psiElement.getNavigationElement()).getContainingFile()) == null) {
                return PsiElement.EMPTY_ARRAY;
            }
            if (psiFile.getVirtualFile() != null && (psiElement.getTextRange() != null || psiElement instanceof PsiFile)) {
                return new PsiElement[]{psiElement};
            }
            return PsiElement.EMPTY_ARRAY;
        });
        if (psiElementArray == null) {
            PsiImplementationViewSession.$$$reportNull$$$0(11);
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public List<ImplementationViewElement> searchImplementationsInBackground(final @NotNull ProgressIndicator indicator, final @NotNull Processor<? super ImplementationViewElement> processor2) {
        if (indicator == null) {
            PsiImplementationViewSession.$$$reportNull$$$0(12);
        }
        if (processor2 == null) {
            PsiImplementationViewSession.$$$reportNull$$$0(13);
        }
        ImplementationSearcher.BackgroundableImplementationSearcher implementationSearcher = new ImplementationSearcher.BackgroundableImplementationSearcher(){

            @Override
            protected boolean isSearchDeep() {
                return PsiImplementationViewSession.this.myIsSearchDeep;
            }

            @Override
            protected void processElement(PsiElement element2) {
                if (!processor2.process((Object)new PsiImplementationViewElement(element2))) {
                    indicator.cancel();
                }
                indicator.checkCanceled();
            }

            @Override
            protected PsiElement[] filterElements(PsiElement element2, PsiElement[] targetElements) {
                return PsiImplementationViewSession.filterElements(targetElements);
            }
        };
        Object[] psiElements = !this.myAlwaysIncludeSelf ? PsiImplementationViewSession.getSelfAndImplementations(this.myEditor, this.myElement, implementationSearcher, false) : PsiImplementationViewSession.getSelfAndImplementations(this.myEditor, this.myElement, implementationSearcher);
        List list2 = ContainerUtil.map((Object[])psiElements, PsiImplementationViewElement::new);
        if (list2 == null) {
            PsiImplementationViewSession.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @Nullable
    public static Editor getEditor(@NotNull DataContext dataContext) {
        FileEditor fileEditor;
        VirtualFile virtualFile;
        PsiFile file2;
        Editor editor;
        if (dataContext == null) {
            PsiImplementationViewSession.$$$reportNull$$$0(15);
        }
        if ((editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) == null && (file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext)) != null && (virtualFile = file2.getVirtualFile()) != null && (fileEditor = FileEditorManager.getInstance((Project)file2.getProject()).getSelectedEditor(virtualFile)) instanceof TextEditor) {
            editor = ((TextEditor)fileEditor).getEditor();
        }
        return editor;
    }

    @Nullable
    public static PsiImplementationViewSession create(@NotNull DataContext dataContext, @NotNull Project project, boolean searchDeep, boolean alwaysIncludeSelf) {
        Editor editor;
        PsiFile file2;
        Pair<PsiElement, PsiReference> pair;
        if (dataContext == null) {
            PsiImplementationViewSession.$$$reportNull$$$0(16);
        }
        if (project == null) {
            PsiImplementationViewSession.$$$reportNull$$$0(17);
        }
        if ((pair = PsiImplementationViewSession.getElementAndReference(dataContext, project, file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext), editor = PsiImplementationViewSession.getEditor(dataContext))) == null) {
            return null;
        }
        PsiElement element2 = (PsiElement)pair.first;
        PsiReference ref = (PsiReference)pair.second;
        String text2 = "";
        PsiElement[] impls = PsiElement.EMPTY_ARRAY;
        if (element2 != null) {
            impls = PsiImplementationViewSession.getSelfAndImplementations(editor, element2, PsiImplementationViewSession.createImplementationsSearcher(searchDeep));
            text2 = SymbolPresentationUtil.getSymbolPresentableText(element2);
        }
        if (impls.length == 0 && ref instanceof PsiPolyVariantReference) {
            PsiPolyVariantReference polyReference = (PsiPolyVariantReference)ref;
            PsiElement refElement = polyReference.getElement();
            TextRange rangeInElement = polyReference.getRangeInElement();
            String refElementText = refElement.getText();
            LOG.assertTrue(rangeInElement.getEndOffset() <= refElementText.length(), (Object)("Ref:" + polyReference + "; refElement: " + refElement + "; refText:" + refElementText));
            text2 = rangeInElement.substring(refElementText);
            ResolveResult[] results = polyReference.multiResolve(false);
            ArrayList<PsiElement> implsList = new ArrayList<PsiElement>(results.length);
            for (ResolveResult result2 : results) {
                PsiElement resolvedElement = result2.getElement();
                if (resolvedElement == null || !resolvedElement.isPhysical()) continue;
                implsList.add(resolvedElement);
            }
            if (!implsList.isEmpty()) {
                impls = implsList.toArray(PsiElement.EMPTY_ARRAY);
            }
        }
        return new PsiImplementationViewSession(project, element2, impls, text2, editor, file2 != null ? file2.getVirtualFile() : null, searchDeep, alwaysIncludeSelf);
    }

    @Nullable
    public static Pair<PsiElement, PsiReference> getElementAndReference(@NotNull DataContext dataContext, @NotNull Project project, @Nullable PsiFile file2, @Nullable Editor editor) {
        PsiFile containingFile;
        if (dataContext == null) {
            PsiImplementationViewSession.$$$reportNull$$$0(18);
        }
        if (project == null) {
            PsiImplementationViewSession.$$$reportNull$$$0(19);
        }
        PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if ((element2 = PsiImplementationViewSession.getElement(project, file2, editor, element2)) == null && file2 == null) {
            return null;
        }
        PsiFile psiFile = containingFile = element2 != null ? element2.getContainingFile() : file2;
        if (containingFile == null || !containingFile.getViewProvider().isPhysical()) {
            return null;
        }
        PsiReference ref = null;
        if (editor != null) {
            ref = TargetElementUtil.findReference(editor, editor.getCaretModel().getOffset());
            if (element2 == null && ref != null) {
                element2 = TargetElementUtil.getInstance().adjustReference(ref);
            }
        }
        if (element2 instanceof PsiCompiledElement) {
            element2 = element2.getNavigationElement();
        }
        return Pair.pair((Object)element2, (Object)ref);
    }

    public static PsiElement getElement(@NotNull Project project, PsiFile file2, Editor editor, PsiElement element2) {
        if (project == null) {
            PsiImplementationViewSession.$$$reportNull$$$0(20);
        }
        if (editor != null) {
            if (element2 == null) {
                element2 = TargetElementUtil.findTargetElement(editor, TargetElementUtil.getInstance().getAllAccepted());
                PsiElement adjustedElement = TargetElementUtil.getInstance().adjustElement(editor, TargetElementUtil.getInstance().getAllAccepted(), element2, null);
                if (adjustedElement != null) {
                    element2 = adjustedElement;
                } else if (file2 != null) {
                    element2 = DocumentationManager.getInstance(project).getElementFromLookup(editor, file2);
                }
            } else {
                PsiElement adjustedElement = TargetElementUtil.getInstance().adjustElement(editor, TargetElementUtil.getInstance().getAllAccepted(), element2, null);
                if (adjustedElement != null) {
                    return adjustedElement;
                }
            }
        }
        return element2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/PsiImplementationViewSession";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElements";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/PsiImplementationViewSession";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementationElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "filterElements";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelfAndImplementations";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "searchImplementationsInBackground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "filterElements";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSelfAndImplementations";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "searchImplementationsInBackground";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getElementAndReference";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

