/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.problems;

import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.problems.ProblemImpl;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.problems.Problem;
import com.intellij.problems.ProblemListener;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WolfTheProblemSolverImpl
extends WolfTheProblemSolver {
    private final Map<VirtualFile, ProblemFileInfo> myProblems;
    private final Map<VirtualFile, Set<Object>> myProblemsFromExternalSources;
    private final Collection<VirtualFile> myCheckingQueue;
    private final Project myProject;

    protected WolfTheProblemSolverImpl(@NotNull Project project) {
        if (project == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(0);
        }
        this.myProblems = new THashMap();
        this.myProblemsFromExternalSources = new THashMap();
        this.myCheckingQueue = new THashSet(10);
        this.myProject = project;
        PsiTreeChangeAdapter changeListener = new PsiTreeChangeAdapter(){

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.childrenChanged(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.childrenChanged(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.childrenChanged(event);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.childrenChanged(event);
            }

            public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.childrenChanged(event);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(5);
                }
                WolfTheProblemSolverImpl.this.clearSyntaxErrorFlag(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/codeInsight/problems/WolfTheProblemSolverImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childReplaced";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childMoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)changeListener);
        MessageBusConnection busConnection = project.getMessageBus().connect();
        busConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                boolean dirChanged = false;
                THashSet toRemove2 = new THashSet();
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileDeleteEvent) && !(vFileEvent instanceof VFileMoveEvent)) continue;
                    VirtualFile file2 = vFileEvent.getFile();
                    if (file2.isDirectory()) {
                        dirChanged = true;
                        continue;
                    }
                    toRemove2.add(file2);
                }
                if (dirChanged) {
                    WolfTheProblemSolverImpl.this.clearInvalidFiles();
                }
                for (VirtualFile virtualFile : toRemove2) {
                    WolfTheProblemSolverImpl.this.doRemove(virtualFile);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/codeInsight/problems/WolfTheProblemSolverImpl$2", "after"));
            }
        });
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        if (fileStatusManager != null) {
            fileStatusManager.addFileStatusListener(new FileStatusListener(){

                public void fileStatusesChanged() {
                    WolfTheProblemSolverImpl.this.clearInvalidFiles();
                }

                public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
                    if (virtualFile == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    this.fileStatusesChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/codeInsight/problems/WolfTheProblemSolverImpl$3", "fileStatusChanged"));
                }
            });
        }
        busConnection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(0);
                }
                HashSet allFiles = new HashSet(WolfTheProblemSolverImpl.this.myProblems.keySet());
                for (VirtualFile file2 : allFiles) {
                    WolfTheProblemSolverImpl.this.doRemove(file2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/codeInsight/problems/WolfTheProblemSolverImpl$4", "beforePluginUnload"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemove(@NotNull VirtualFile problemFile) {
        ProblemFileInfo old;
        if (problemFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(1);
        }
        Object object = this.myProblems;
        synchronized (object) {
            old = this.myProblems.remove(problemFile);
        }
        object = this.myCheckingQueue;
        synchronized (object) {
            this.myCheckingQueue.remove(problemFile);
        }
        if (old != null) {
            if (this.hasProblemsFromExternalSources(problemFile)) {
                this.fireProblemsChanged(problemFile);
            } else {
                this.fireProblemsDisappeared(problemFile);
            }
        }
    }

    private void clearInvalidFiles() {
        this.clearInvalidFilesFrom(this.myProblems);
        this.clearInvalidFilesFrom(this.myProblemsFromExternalSources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInvalidFilesFrom(Map<VirtualFile, ?> problems) {
        VirtualFile[] virtualFileArray = problems;
        synchronized (problems) {
            VirtualFile[] files2 = VfsUtilCore.toVirtualFileArray(problems.keySet());
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (VirtualFile problemFile : files2) {
                if (problemFile.isValid() && this.isToBeHighlighted(problemFile)) continue;
                this.doRemove(problemFile);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSyntaxErrorFlag(@NotNull PsiTreeChangeEvent event) {
        PsiFile file2;
        if (event == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(2);
        }
        if ((file2 = event.getFile()) == null) {
            return;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Map<VirtualFile, ProblemFileInfo> map2 = this.myProblems;
        synchronized (map2) {
            ProblemFileInfo info = this.myProblems.get(virtualFile);
            if (info != null) {
                info.hasSyntaxErrors = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCheckingIfVincentSolvedProblemsYet(@NotNull ProgressIndicator progress2, @NotNull ProgressableTextEditorHighlightingPass pass) throws ProcessCanceledException {
        ArrayList<VirtualFile> files2;
        if (progress2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(3);
        }
        if (pass == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(4);
        }
        if (!this.myProject.isOpen()) {
            return;
        }
        Collection<VirtualFile> collection = this.myCheckingQueue;
        synchronized (collection) {
            files2 = new ArrayList<VirtualFile>(this.myCheckingQueue);
        }
        long progressLimit = files2.stream().filter(VirtualFile::isValid).mapToLong(VirtualFile::getLength).sum();
        pass.setProgressLimit(progressLimit);
        for (VirtualFile virtualFile : files2) {
            progress2.checkCanceled();
            if (virtualFile == null) break;
            if (!virtualFile.isValid() || this.orderVincentToCleanTheCar(virtualFile, progress2)) {
                this.doRemove(virtualFile);
            }
            if (!virtualFile.isValid()) continue;
            pass.advanceProgress(virtualFile.getLength());
        }
    }

    private boolean orderVincentToCleanTheCar(@NotNull VirtualFile file2, @NotNull ProgressIndicator progressIndicator2) throws ProcessCanceledException {
        if (file2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(5);
        }
        if (progressIndicator2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(6);
        }
        if (!this.isToBeHighlighted(file2)) {
            this.clearProblems(file2);
            return true;
        }
        if (this.hasSyntaxErrors(file2)) {
            return false;
        }
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (this.willBeHighlightedAnyway(file2)) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (psiFile == null) {
            return false;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            return false;
        }
        final AtomicReference error = new AtomicReference();
        final AtomicBoolean hasErrorElement = new AtomicBoolean();
        try {
            GeneralHighlightingPass pass = new GeneralHighlightingPass(this.myProject, psiFile, document, 0, document.getTextLength(), false, new ProperTextRange(0, document.getTextLength()), null, HighlightInfoProcessor.getEmpty()){

                @Override
                @NotNull
                protected HighlightInfoHolder createInfoHolder(@NotNull PsiFile file2) {
                    if (file2 == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return new HighlightInfoHolder(file2, new HighlightInfoFilter[0]){

                        @Override
                        public boolean add(@Nullable HighlightInfo info) {
                            if (info != null && info.getSeverity() == HighlightSeverity.ERROR) {
                                error.set(info);
                                hasErrorElement.set(myHasErrorElement);
                                throw new ProcessCanceledException();
                            }
                            return super.add(info);
                        }
                    };
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/problems/WolfTheProblemSolverImpl$5", "createInfoHolder"));
                }
            };
            pass.collectInformation(progressIndicator2);
        }
        catch (ProcessCanceledException e) {
            if (error.get() != null) {
                ProblemImpl problem = new ProblemImpl(file2, (HighlightInfo)error.get(), hasErrorElement.get());
                this.reportProblems(file2, Collections.singleton(problem));
            }
            return false;
        }
        this.clearProblems(file2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSyntaxErrors(VirtualFile file2) {
        Map<VirtualFile, ProblemFileInfo> map2 = this.myProblems;
        synchronized (map2) {
            ProblemFileInfo info = this.myProblems.get(file2);
            return info != null && info.hasSyntaxErrors;
        }
    }

    private boolean willBeHighlightedAnyway(VirtualFile file2) {
        FileEditor[] selectedEditors;
        for (FileEditor editor : selectedEditors = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors()) {
            if (!(editor instanceof TextEditor)) continue;
            Document document = ((TextEditor)editor).getEditor().getDocument();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getCachedPsiFile(document);
            if (psiFile == null || !Comparing.equal((Object)file2, (Object)psiFile.getVirtualFile())) continue;
            return true;
        }
        return false;
    }

    public boolean hasProblemFilesBeneath(@NotNull Condition<? super VirtualFile> condition) {
        if (condition == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(7);
        }
        if (!this.myProject.isOpen()) {
            return false;
        }
        return WolfTheProblemSolverImpl.checkProblemFilesInMap(condition, this.myProblems) || WolfTheProblemSolverImpl.checkProblemFilesInMap(condition, this.myProblemsFromExternalSources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkProblemFilesInMap(@NotNull Condition<? super VirtualFile> condition, Map<VirtualFile, ?> map2) {
        if (condition == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(8);
        }
        Map<VirtualFile, ?> map3 = map2;
        synchronized (map3) {
            if (!map2.isEmpty()) {
                for (VirtualFile problemFile : map2.keySet()) {
                    if (!problemFile.isValid() || !condition.value((Object)problemFile)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public boolean hasProblemFilesBeneath(@NotNull Module scope) {
        if (scope == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(9);
        }
        return this.hasProblemFilesBeneath((Condition<? super VirtualFile>)((Condition)virtualFile -> ModuleUtilCore.moduleContainsFile((Module)scope, (VirtualFile)virtualFile, (boolean)false)));
    }

    public void addProblemListener(@NotNull WolfTheProblemSolver.ProblemListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(10);
        }
        if (parentDisposable == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(11);
        }
        this.myProject.getMessageBus().connect(parentDisposable).subscribe(ProblemListener.TOPIC, (Object)listener2);
    }

    public void queue(VirtualFile suspiciousFile) {
        if (!this.isToBeHighlighted(suspiciousFile)) {
            return;
        }
        this.doQueue(suspiciousFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQueue(@NotNull VirtualFile suspiciousFile) {
        if (suspiciousFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(12);
        }
        Collection<VirtualFile> collection = this.myCheckingQueue;
        synchronized (collection) {
            this.myCheckingQueue.add(suspiciousFile);
        }
    }

    public boolean isProblemFile(VirtualFile virtualFile) {
        return this.hasRegularProblems(virtualFile) || this.hasProblemsFromExternalSources(virtualFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasRegularProblems(VirtualFile virtualFile) {
        Map<VirtualFile, ProblemFileInfo> map2 = this.myProblems;
        synchronized (map2) {
            if (this.myProblems.containsKey(virtualFile)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasProblemsFromExternalSources(VirtualFile virtualFile) {
        Map<VirtualFile, Set<Object>> map2 = this.myProblemsFromExternalSources;
        synchronized (map2) {
            if (this.myProblemsFromExternalSources.containsKey(virtualFile)) {
                return true;
            }
        }
        return false;
    }

    private boolean isToBeHighlighted(@Nullable VirtualFile virtualFile) {
        if (virtualFile == null) {
            return false;
        }
        for (Condition filter2 : (Condition[])FILTER_EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            ProgressManager.checkCanceled();
            if (!filter2.value((Object)virtualFile)) continue;
            return true;
        }
        return false;
    }

    public void weHaveGotProblems(@NotNull VirtualFile virtualFile, @NotNull List<? extends Problem> problems) {
        if (virtualFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(13);
        }
        if (problems == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(14);
        }
        if (problems.isEmpty()) {
            return;
        }
        if (!this.isToBeHighlighted(virtualFile)) {
            return;
        }
        this.weHaveGotNonIgnorableProblems(virtualFile, problems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void weHaveGotNonIgnorableProblems(@NotNull VirtualFile virtualFile, @NotNull List<? extends Problem> problems) {
        if (virtualFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(15);
        }
        if (problems == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(16);
        }
        if (problems.isEmpty()) {
            return;
        }
        boolean fireListener = false;
        Map<VirtualFile, ProblemFileInfo> map2 = this.myProblems;
        synchronized (map2) {
            ProblemFileInfo storedProblems = this.myProblems.get(virtualFile);
            if (storedProblems == null) {
                storedProblems = new ProblemFileInfo();
                this.myProblems.put(virtualFile, storedProblems);
                fireListener = true;
            }
            storedProblems.problems.addAll(problems);
        }
        this.doQueue(virtualFile);
        if (fireListener) {
            if (this.hasProblemsFromExternalSources(virtualFile)) {
                this.fireProblemsChanged(virtualFile);
            } else {
                this.fireProblemsAppeared(virtualFile);
            }
        }
    }

    private void fireProblemsAppeared(@NotNull VirtualFile file2) {
        if (file2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(17);
        }
        ((ProblemListener)this.myProject.getMessageBus().syncPublisher(ProblemListener.TOPIC)).problemsAppeared(file2);
    }

    private void fireProblemsChanged(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(18);
        }
        ((ProblemListener)this.myProject.getMessageBus().syncPublisher(ProblemListener.TOPIC)).problemsChanged(virtualFile);
    }

    private void fireProblemsDisappeared(@NotNull VirtualFile problemFile) {
        if (problemFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(19);
        }
        ((ProblemListener)this.myProject.getMessageBus().syncPublisher(ProblemListener.TOPIC)).problemsDisappeared(problemFile);
    }

    public void clearProblems(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(20);
        }
        this.doRemove(virtualFile);
    }

    public Problem convertToProblem(@Nullable VirtualFile virtualFile, int line, int column, String @NotNull [] message) {
        if (message == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(21);
        }
        if (virtualFile == null || virtualFile.isDirectory() || virtualFile.getFileType().isBinary()) {
            return null;
        }
        HighlightInfo info = (HighlightInfo)ReadAction.compute(() -> {
            TextRange textRange = WolfTheProblemSolverImpl.getTextRange(virtualFile, line, column);
            String description = StringUtil.join((String[])message, (String)"\n");
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        });
        if (info == null) {
            return null;
        }
        return new ProblemImpl(virtualFile, info, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportProblems(@NotNull VirtualFile file2, @NotNull Collection<? extends Problem> problems) {
        boolean fireChanged;
        boolean hasProblemsBefore;
        if (file2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(22);
        }
        if (problems == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(23);
        }
        if (problems.isEmpty()) {
            this.clearProblems(file2);
            return;
        }
        if (!this.isToBeHighlighted(file2)) {
            return;
        }
        Map<VirtualFile, ProblemFileInfo> map2 = this.myProblems;
        synchronized (map2) {
            ProblemFileInfo oldInfo = this.myProblems.remove(file2);
            hasProblemsBefore = oldInfo != null;
            ProblemFileInfo newInfo = new ProblemFileInfo();
            this.myProblems.put(file2, newInfo);
            for (Problem problem : problems) {
                newInfo.problems.add(problem);
                ProblemFileInfo problemFileInfo = newInfo;
                problemFileInfo.hasSyntaxErrors = problemFileInfo.hasSyntaxErrors | ((ProblemImpl)problem).isSyntaxOnly();
            }
            fireChanged = hasProblemsBefore && !oldInfo.equals(newInfo);
        }
        this.doQueue(file2);
        boolean hasExternal = this.hasProblemsFromExternalSources(file2);
        if (!hasProblemsBefore && !hasExternal) {
            this.fireProblemsAppeared(file2);
        } else if (fireChanged || hasExternal) {
            this.fireProblemsChanged(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportProblemsFromExternalSource(@NotNull VirtualFile file2, @NotNull Object source) {
        boolean isNewFileForExternalSource;
        if (file2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(24);
        }
        if (source == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(25);
        }
        if (!this.isToBeHighlighted(file2)) {
            return;
        }
        Map<VirtualFile, Set<Object>> map2 = this.myProblemsFromExternalSources;
        synchronized (map2) {
            if (this.myProblemsFromExternalSources.containsKey(file2)) {
                isNewFileForExternalSource = false;
                this.myProblemsFromExternalSources.get(file2).add(source);
            } else {
                this.myProblemsFromExternalSources.put(file2, ContainerUtil.newHashSet((Object[])new Object[]{source}));
                isNewFileForExternalSource = true;
            }
        }
        Map<VirtualFile, ProblemFileInfo> map3 = this.myProblems;
        synchronized (map3) {
            boolean hasRegularProblems = this.myProblems.containsKey(file2);
        }
        if (isNewFileForExternalSource && !this.hasRegularProblems(file2)) {
            this.fireProblemsAppeared(file2);
        } else {
            this.fireProblemsChanged(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProblemsFromExternalSource(@NotNull VirtualFile file2, @NotNull Object source) {
        if (file2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(26);
        }
        if (source == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(27);
        }
        boolean isLastExternalSource = false;
        Map<VirtualFile, Set<Object>> map2 = this.myProblemsFromExternalSources;
        synchronized (map2) {
            Set<Object> sources = this.myProblemsFromExternalSources.get(file2);
            if (sources == null) {
                return;
            }
            sources.remove(source);
            if (sources.isEmpty()) {
                isLastExternalSource = true;
                this.myProblemsFromExternalSources.remove(file2);
            }
        }
        if (isLastExternalSource && !this.hasRegularProblems(file2)) {
            this.fireProblemsDisappeared(file2);
        } else {
            this.fireProblemsChanged(file2);
        }
    }

    @NotNull
    private static TextRange getTextRange(@NotNull VirtualFile virtualFile, int line, int column) {
        Document document;
        if (virtualFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(28);
        }
        if (line > (document = FileDocumentManager.getInstance().getDocument(virtualFile)).getLineCount()) {
            line = document.getLineCount();
        }
        line = line <= 0 ? 0 : line - 1;
        int offset = document.getLineStartOffset(line) + (column <= 0 ? 0 : column - 1);
        return new TextRange(offset, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pass";
                break;
            }
            case 5: 
            case 17: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspiciousFile";
                break;
            }
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 14: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/problems/WolfTheProblemSolverImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doRemove";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "clearSyntaxErrorFlag";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "startCheckingIfVincentSolvedProblemsYet";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "orderVincentToCleanTheCar";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "hasProblemFilesBeneath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkProblemFilesInMap";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addProblemListener";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "doQueue";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "weHaveGotProblems";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "weHaveGotNonIgnorableProblems";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "fireProblemsAppeared";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "fireProblemsChanged";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "fireProblemsDisappeared";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "clearProblems";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "convertToProblem";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "reportProblems";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "reportProblemsFromExternalSource";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "clearProblemsFromExternalSource";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ProblemFileInfo {
        private final Collection<Problem> problems = new THashSet();
        private boolean hasSyntaxErrors;

        private ProblemFileInfo() {
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProblemFileInfo that = (ProblemFileInfo)o;
            return this.hasSyntaxErrors == that.hasSyntaxErrors && this.problems.equals(that.problems);
        }

        public int hashCode() {
            int result2 = this.problems.hashCode();
            result2 = 31 * result2 + (this.hasSyntaxErrors ? 1 : 0);
            return result2;
        }
    }
}

