/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;

public class UrlUtil {
    private static final String JAR_SEPARATOR = "!/";
    private static final String URL_PATH_SEPARATOR = "/";
    private static final String FILE_PROTOCOL = "file";
    private static final String FILE_PROTOCOL_PREFIX = "file:";

    @NotNull
    public static String loadText(@NotNull URL url) throws IOException {
        String string;
        if (url == null) {
            UrlUtil.$$$reportNull$$$0(0);
        }
        try (BufferedInputStream stream = new BufferedInputStream(URLUtil.openStream((URL)url));){
            String string2 = new String(FileUtil.loadBytes((InputStream)stream), "UTF-8");
            string = string2;
        }
        if (string == null) {
            UrlUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static List<String> getChildrenRelativePaths(@NotNull URL root) throws IOException {
        String protocol;
        if (root == null) {
            UrlUtil.$$$reportNull$$$0(2);
        }
        if ("jar".equalsIgnoreCase(protocol = root.getProtocol())) {
            return UrlUtil.getChildPathsFromJar(root);
        }
        if (FILE_PROTOCOL.equalsIgnoreCase(protocol)) {
            return UrlUtil.getChildPathsFromFile(root);
        }
        List<String> list2 = Collections.emptyList();
        if (list2 == null) {
            UrlUtil.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    private static List<String> getChildPathsFromFile(@NotNull URL root) {
        if (root == null) {
            UrlUtil.$$$reportNull$$$0(4);
        }
        final ArrayList<String> paths = new ArrayList<String>();
        File rootFile = new File(FileUtil.unquote((String)root.getPath()));
        new Object(){

            void collectFiles(File fromFile, String prefix) {
                File[] list2 = fromFile.listFiles();
                if (list2 != null) {
                    for (File file2 : list2) {
                        String childRelativePath;
                        String string = childRelativePath = prefix.isEmpty() ? file2.getName() : prefix + UrlUtil.URL_PATH_SEPARATOR + file2.getName();
                        if (file2.isDirectory()) {
                            this.collectFiles(file2, childRelativePath);
                            continue;
                        }
                        paths.add(childRelativePath);
                    }
                }
            }
        }.collectFiles(rootFile, "");
        ArrayList<String> arrayList = paths;
        if (arrayList == null) {
            UrlUtil.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> getChildPathsFromJar(@NotNull URL root) throws IOException {
        ArrayList<String> arrayList;
        if (root == null) {
            UrlUtil.$$$reportNull$$$0(6);
        }
        String file2 = root.getFile();
        file2 = StringUtil.trimStart((String)file2, (String)FILE_PROTOCOL_PREFIX);
        int jarSeparatorIndex = file2.indexOf(JAR_SEPARATOR);
        assert (jarSeparatorIndex > 0);
        String rootDirName = file2.substring(jarSeparatorIndex + 2);
        if (!rootDirName.endsWith(URL_PATH_SEPARATOR)) {
            rootDirName = rootDirName + URL_PATH_SEPARATOR;
        }
        try (ZipFile zipFile = new ZipFile(FileUtil.unquote((String)file2.substring(0, jarSeparatorIndex)));){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            ArrayList<String> paths = new ArrayList<String>();
            while (entries.hasMoreElements()) {
                String relPath;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(relPath = entry.getName()).startsWith(rootDirName)) continue;
                paths.add(relPath.substring(rootDirName.length()));
            }
            ArrayList<String> arrayList2 = paths;
            arrayList = arrayList2;
        }
        if (arrayList == null) {
            UrlUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/UrlUtil";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/UrlUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenRelativePaths";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildPathsFromFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildPathsFromJar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenRelativePaths";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChildPathsFromFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChildPathsFromJar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

